/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.machine;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.list.AEListGridWidget;
import com.gregtechceu.gtceu.integration.ae2.machine.MEHatchPartMachine;
import com.gregtechceu.gtceu.integration.ae2.utils.KeyStorage;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.FluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MEOutputHatchPartMachine
extends MEHatchPartMachine
implements IMachineLife {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MEOutputHatchPartMachine.class, MEHatchPartMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    private KeyStorage internalBuffer;

    public MEOutputHatchPartMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, IO.IN, args);
    }

    @Override
    protected NotifiableFluidTank createTank(long initialCapacity, int slots, Object ... args) {
        this.internalBuffer = new KeyStorage();
        return new InaccessibleInfiniteTank(this);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.isRemote()) {
            return;
        }
    }

    @Override
    public void onMachineRemoved() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid != null && !this.internalBuffer.isEmpty()) {
            for (Object2LongMap.Entry<AEKey> entry : this.internalBuffer) {
                grid.getStorageService().getInventory().insert((AEKey)entry.getKey(), entry.getLongValue(), Actionable.MODULATE, this.actionSource);
            }
        }
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    protected boolean shouldSubscribe() {
        return super.shouldSubscribe() && !this.internalBuffer.storage.isEmpty();
    }

    @Override
    protected void autoIO() {
        if (!this.shouldSyncME()) {
            return;
        }
        if (this.updateMEStatus()) {
            IGrid grid = this.getMainNode().getGrid();
            if (grid != null && !this.internalBuffer.isEmpty()) {
                this.internalBuffer.insertInventory(grid.getStorageService().getInventory(), this.actionSource);
            }
            this.updateTankSubscription();
        }
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 170, 65);
        group.addWidget((Widget)new LabelWidget(5, 0, () -> this.isOnline ? "gtceu.gui.me_network.online" : "gtceu.gui.me_network.offline"));
        group.addWidget((Widget)new LabelWidget(5, 10, "gtceu.gui.waiting_list"));
        group.addWidget((Widget)new AEListGridWidget.Fluid(5, 20, 3, this.internalBuffer));
        return group;
    }

    private class InaccessibleInfiniteTank
    extends NotifiableFluidTank {
        FluidStorage storage;

        public InaccessibleInfiniteTank(MetaMachine holder) {
            super(holder, List.of(new FluidStorageDelegate()), IO.OUT, IO.NONE);
            MEOutputHatchPartMachine.this.internalBuffer.setOnContentsChanged(this::onContentsChanged);
            this.storage = this.getStorages()[0];
        }

        @Override
        public int getTanks() {
            return 128;
        }

        @Override
        public FluidStack getFluidInTank(int tank) {
            return this.storage.getFluid();
        }

        @Override
        public long getTankCapacity(int tank) {
            return this.storage.getCapacity();
        }

        @Override
        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return this.storage.isFluidValid(stack);
        }
    }

    private class FluidStorageDelegate
    extends FluidStorage {
        public FluidStorageDelegate() {
            super(0L);
        }

        public long getCapacity() {
            return Long.MAX_VALUE;
        }

        public void setFluid(FluidStack fluid) {
        }

        public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
            AEFluidKey key = AEFluidKey.of((Fluid)resource.getFluid(), (CompoundTag)resource.getTag());
            long amount = resource.getAmount();
            long oldValue = MEOutputHatchPartMachine.this.internalBuffer.storage.getOrDefault((Object)key, 0L);
            long changeValue = Math.min(Long.MAX_VALUE - oldValue, amount);
            if (changeValue > 0L && !simulate) {
                MEOutputHatchPartMachine.this.internalBuffer.storage.put((Object)key, oldValue + changeValue);
                MEOutputHatchPartMachine.this.internalBuffer.onChanged();
            }
            return changeValue;
        }

        public boolean supportsFill(int tank) {
            return false;
        }

        public boolean supportsDrain(int tank) {
            return false;
        }

        public FluidStorage copy() {
            return new FluidStorageDelegate(){

                @Override
                public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
                    return super.fill(tank, resource, true, notifyChanges);
                }
            };
        }
    }
}

