/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.gui.widget.slot;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.misc.IGhostItemTarget;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.ConfigWidget;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.slot.AEConfigSlotWidget;
import com.gregtechceu.gtceu.integration.ae2.slot.ExportOnlyAESlot;
import com.gregtechceu.gtceu.integration.ae2.slot.IConfigurableSlot;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.util.TextFormattingUtil;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class AEItemConfigSlotWidget
extends AEConfigSlotWidget
implements IGhostItemTarget {
    public AEItemConfigSlotWidget(int x, int y, ConfigWidget widget, int index) {
        super(new Position(x, y), new Size(18, 36), widget, index);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        String amountStr;
        ItemStack stack;
        AEItemKey key;
        AEKey aEKey;
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        Position position = this.getPosition();
        IConfigurableSlot slot = this.parentWidget.getDisplay(this.index);
        GenericStack config = slot.getConfig();
        GenericStack stock = slot.getStock();
        this.drawSlots(graphics, mouseX, mouseY, position.x, position.y, this.parentWidget.isAutoPull());
        if (this.select) {
            GuiTextures.SELECT_BOX.draw(graphics, mouseX, mouseY, (float)position.x, (float)position.y, 18, 18);
        }
        int stackX = position.x + 1;
        int stackY = position.y + 1;
        if (config != null) {
            ItemStack itemStack;
            aEKey = config.what();
            if (aEKey instanceof AEItemKey) {
                key = (AEItemKey)aEKey;
                itemStack = new ItemStack((ItemLike)key.getItem(), (int)config.amount());
            } else {
                itemStack = ItemStack.f_41583_;
            }
            stack = itemStack;
            stack.m_41764_(1);
            DrawerHelper.drawItemStack((GuiGraphics)graphics, (ItemStack)stack, (int)stackX, (int)stackY, (int)-1, null);
            if (!this.parentWidget.isStocking()) {
                amountStr = TextFormattingUtil.formatLongToCompactString((long)config.amount(), (int)4);
                DrawerHelper.drawStringFixedCorner((GuiGraphics)graphics, (String)amountStr, (float)(stackX + 17), (float)(stackY + 17), (int)0xFFFFFF, (boolean)true, (float)0.5f);
            }
        }
        if (stock != null) {
            ItemStack itemStack;
            aEKey = stock.what();
            if (aEKey instanceof AEItemKey) {
                key = (AEItemKey)aEKey;
                itemStack = new ItemStack((ItemLike)key.getItem(), (int)stock.amount());
            } else {
                itemStack = ItemStack.f_41583_;
            }
            stack = itemStack;
            stack.m_41764_(1);
            DrawerHelper.drawItemStack((GuiGraphics)graphics, (ItemStack)stack, (int)stackX, (int)(stackY + 18), (int)-1, null);
            amountStr = TextFormattingUtil.formatLongToCompactString((long)stock.amount(), (int)4);
            DrawerHelper.drawStringFixedCorner((GuiGraphics)graphics, (String)amountStr, (float)(stackX + 17), (float)(stackY + 18 + 17), (int)0xFFFFFF, (boolean)true, (float)0.5f);
        }
        if (this.mouseOverConfig(mouseX, mouseY)) {
            AEItemConfigSlotWidget.drawSelectionOverlay(graphics, stackX, stackY, 16, 16);
        } else if (this.mouseOverStock(mouseX, mouseY)) {
            AEItemConfigSlotWidget.drawSelectionOverlay(graphics, stackX, stackY + 18, 16, 16);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void drawSlots(GuiGraphics graphics, int mouseX, int mouseY, int x, int y, boolean autoPull) {
        if (autoPull) {
            GuiTextures.SLOT_DARK.draw(graphics, mouseX, mouseY, (float)x, (float)y, 18, 18);
            GuiTextures.CONFIG_ARROW.draw(graphics, mouseX, mouseY, (float)x, (float)y, 18, 18);
        } else {
            GuiTextures.SLOT.draw(graphics, mouseX, mouseY, (float)x, (float)y, 18, 18);
            GuiTextures.CONFIG_ARROW_DARK.draw(graphics, mouseX, mouseY, (float)x, (float)y, 18, 18);
        }
        GuiTextures.SLOT_DARK.draw(graphics, mouseX, mouseY, (float)x, (float)(y + 18), 18, 18);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInForeground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
        GenericStack item = null;
        IConfigurableSlot slot = this.parentWidget.getDisplay(this.index);
        if (this.mouseOverConfig(mouseX, mouseY)) {
            item = slot.getConfig();
        } else if (this.mouseOverStock(mouseX, mouseY)) {
            item = slot.getStock();
        }
        if (item != null) {
            graphics.m_280153_(Minecraft.m_91087_().f_91062_, GenericStack.wrapInItemStack((GenericStack)item), mouseX, mouseY);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.mouseOverConfig(mouseX, mouseY)) {
            if (this.parentWidget.isAutoPull()) {
                return false;
            }
            if (button == 1) {
                this.writeClientAction(1000, buf -> {});
                if (!this.parentWidget.isStocking()) {
                    this.parentWidget.disableAmount();
                }
            } else if (button == 0) {
                ItemStack item = this.gui.getModularUIContainer().m_142621_();
                if (!item.m_41619_()) {
                    this.writeClientAction(1001, buf -> buf.m_130055_(item));
                }
                if (!this.parentWidget.isStocking()) {
                    this.parentWidget.enableAmount(this.index);
                    this.select = true;
                }
            }
            return true;
        }
        if (this.mouseOverStock(mouseX, mouseY) && button == 0) {
            if (this.parentWidget.isStocking()) {
                return false;
            }
            GenericStack stack = this.parentWidget.getDisplay(this.index).getStock();
            if (stack != null) {
                this.writeClientAction(1003, buf -> {});
            }
            return true;
        }
        return false;
    }

    public void handleClientAction(int id, FriendlyByteBuf buffer) {
        GenericStack stack;
        super.handleClientAction(id, buffer);
        IConfigurableSlot slot = this.parentWidget.getConfig(this.index);
        if (id == 1000) {
            slot.setConfig(null);
            this.parentWidget.disableAmount();
            this.writeUpdateInfo(1000, buf -> {});
        }
        if (id == 1001) {
            ItemStack item = buffer.m_130267_();
            stack = GenericStack.fromItemStack((ItemStack)item);
            if (!this.isStackValidForSlot(stack)) {
                return;
            }
            slot.setConfig(stack);
            this.parentWidget.enableAmount(this.index);
            if (!item.m_41619_()) {
                this.writeUpdateInfo(1001, buf -> buf.m_130055_(item));
            }
        }
        if (id == 1002 && slot.getConfig() != null) {
            long amt = buffer.m_130258_();
            slot.setConfig(new GenericStack(slot.getConfig().what(), amt));
            this.writeUpdateInfo(1002, buf -> buf.m_130103_(amt));
        }
        if (id == 1003 && slot.getStock() != null && this.gui.getModularUIContainer().m_142621_() == ItemStack.f_41583_ && (stack = slot.getStock().what()) instanceof AEItemKey) {
            AEItemKey key = (AEItemKey)stack;
            stack = new ItemStack((ItemLike)key.getItem(), Math.min((int)slot.getStock().amount(), key.getItem().m_41459_()));
            if (key.hasTag()) {
                stack.m_41751_(key.getTag().m_6426_());
            }
            this.gui.getModularUIContainer().m_142503_((ItemStack)stack);
            GenericStack stack1 = ExportOnlyAESlot.copy(slot.getStock(), Math.max(0L, slot.getStock().amount() - (long)stack.m_41613_()));
            slot.setStock(stack1.amount() == 0L ? null : stack1);
            this.writeUpdateInfo(1003, buf -> {});
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
        AEKey aEKey;
        super.readUpdateInfo(id, buffer);
        IConfigurableSlot slot = this.parentWidget.getDisplay(this.index);
        if (id == 1000) {
            slot.setConfig(null);
        }
        if (id == 1001) {
            ItemStack item = buffer.m_130267_();
            slot.setConfig(new GenericStack((AEKey)AEItemKey.of((ItemLike)item.m_41720_(), (CompoundTag)item.m_41783_()), (long)item.m_41613_()));
        }
        if (id == 1002 && slot.getConfig() != null) {
            long amt = buffer.m_130258_();
            slot.setConfig(new GenericStack(slot.getConfig().what(), amt));
        }
        if (id == 1003 && slot.getStock() != null && (aEKey = slot.getStock().what()) instanceof AEItemKey) {
            AEItemKey key = (AEItemKey)aEKey;
            ItemStack stack = new ItemStack((ItemLike)key.getItem(), Math.min((int)slot.getStock().amount(), key.getItem().m_41459_()));
            if (key.hasTag()) {
                stack.m_41751_(key.getTag().m_6426_());
            }
            this.gui.getModularUIContainer().m_142503_(stack);
            GenericStack stack1 = ExportOnlyAESlot.copy(slot.getStock(), Math.max(0L, slot.getStock().amount() - (long)stack.m_41613_()));
            slot.setStock(stack1.amount() == 0L ? null : stack1);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Rect2i getRectangleBox() {
        Rect2i rectangle = this.toRectangleBox();
        rectangle.m_173058_(rectangle.m_110091_() / 2);
        return rectangle;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void acceptItem(ItemStack itemStack) {
        this.writeClientAction(1001, buf -> buf.m_130055_(itemStack));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseWheelMove(double mouseX, double mouseY, double wheelDelta) {
        long amt;
        if (this.parentWidget.isStocking()) {
            return false;
        }
        IConfigurableSlot slot = this.parentWidget.getDisplay(this.index);
        Rect2i rectangle = this.toRectangleBox();
        rectangle.m_173058_(rectangle.m_110091_() / 2);
        if (slot.getConfig() == null || wheelDelta == 0.0 || !rectangle.m_110087_((int)mouseX, (int)mouseY)) {
            return false;
        }
        GenericStack stack = slot.getConfig();
        if (AEItemConfigSlotWidget.isCtrlDown()) {
            amt = wheelDelta > 0.0 ? stack.amount() * 2L : stack.amount() / 2L;
        } else {
            long l = amt = wheelDelta > 0.0 ? stack.amount() + 1L : stack.amount() - 1L;
        }
        if (amt > 0L && amt < 0x80000000L) {
            this.writeClientAction(1002, buf -> buf.m_130103_(amt));
            return true;
        }
        return false;
    }
}

