/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.gui.widget.slot;

import appeng.api.stacks.GenericStack;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.ConfigWidget;
import com.gregtechceu.gtceu.integration.ae2.slot.IConfigurableSlot;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class AEConfigSlotWidget
extends Widget {
    protected ConfigWidget parentWidget;
    protected int index;
    protected static final int REMOVE_ID = 1000;
    protected static final int UPDATE_ID = 1001;
    protected static final int AMOUNT_CHANGE_ID = 1002;
    protected static final int PICK_UP_ID = 1003;
    protected boolean select = false;

    public AEConfigSlotWidget(Position pos, Size size, ConfigWidget widget, int index) {
        super(pos, size);
        this.parentWidget = widget;
        this.index = index;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInForeground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
        IConfigurableSlot slot = this.parentWidget.getDisplay(this.index);
        if (slot.getConfig() == null && this.mouseOverConfig(mouseX, mouseY)) {
            ArrayList<MutableComponent> hoverStringList = new ArrayList<MutableComponent>();
            hoverStringList.add(Component.m_237115_((String)"gtceu.gui.config_slot"));
            if (this.parentWidget.isAutoPull()) {
                hoverStringList.add(Component.m_237115_((String)"gtceu.gui.config_slot.auto_pull_managed"));
            } else {
                if (!this.parentWidget.isStocking()) {
                    hoverStringList.add(Component.m_237115_((String)"gtceu.gui.config_slot.set"));
                    hoverStringList.add(Component.m_237115_((String)"gtceu.gui.config_slot.scroll"));
                } else {
                    hoverStringList.add(Component.m_237115_((String)"gtceu.gui.config_slot.set_only"));
                }
                hoverStringList.add(Component.m_237115_((String)"gtceu.gui.config_slot.remove"));
            }
            graphics.m_280677_(Minecraft.m_91087_().f_91062_, hoverStringList, Optional.empty(), mouseX, mouseY);
        }
    }

    public void setSelect(boolean val) {
        this.select = val;
    }

    protected boolean mouseOverConfig(double mouseX, double mouseY) {
        Position position = this.getPosition();
        return AEConfigSlotWidget.isMouseOver((int)position.x, (int)position.y, (int)18, (int)18, (double)mouseX, (double)mouseY);
    }

    protected boolean mouseOverStock(double mouseX, double mouseY) {
        Position position = this.getPosition();
        return AEConfigSlotWidget.isMouseOver((int)position.x, (int)(position.y + 18), (int)18, (int)18, (double)mouseX, (double)mouseY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawSelectionOverlay(GuiGraphics graphics, int x, int y, int width, int height) {
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        DrawerHelper.drawGradientRect((GuiGraphics)graphics, (int)x, (int)y, (int)width, (int)height, (int)-2130706433, (int)-2130706433);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
    }

    protected boolean isStackValidForSlot(GenericStack stack) {
        if (stack == null || stack.amount() < 0L) {
            return true;
        }
        if (!this.parentWidget.isStocking()) {
            return true;
        }
        return !this.parentWidget.hasStackInConfig(stack);
    }
}

