/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration;

import com.google.common.collect.ImmutableList;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.OreProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.recipe.chance.logic.ChanceLogic;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;

public class GTOreByProduct {
    private static final List<TagPrefix> ORES = new ArrayList<TagPrefix>();
    private static ImmutableList<TagPrefix> IN_PROCESSING_STEPS;
    private static ImmutableList<ItemStack> ALWAYS_MACHINES;
    private final Int2ObjectMap<Content> chances = new Int2ObjectOpenHashMap();
    protected final List<Either<List<Pair<TagKey<Item>, Integer>>, List<ItemStack>>> itemInputs = new ArrayList<Either<List<Pair<TagKey<Item>, Integer>>, List<ItemStack>>>();
    protected final NonNullList<ItemStack> itemOutputs = NonNullList.m_122779_();
    protected final List<Either<List<Pair<TagKey<Fluid>, Long>>, List<FluidStack>>> fluidInputs = new ArrayList<Either<List<Pair<TagKey<Fluid>, Long>>, List<FluidStack>>>();
    private boolean hasDirectSmelt = false;
    private boolean hasChemBath = false;
    private boolean hasSeparator = false;
    private boolean hasSifter = false;
    private int currentSlot;

    public static void addOreByProductPrefix(TagPrefix orePrefix) {
        if (!ORES.contains(orePrefix)) {
            ORES.add(orePrefix);
        }
    }

    public GTOreByProduct(Material material) {
        if (IN_PROCESSING_STEPS == null) {
            IN_PROCESSING_STEPS = ImmutableList.of((Object)TagPrefix.crushed, (Object)TagPrefix.crushedPurified, (Object)TagPrefix.dustImpure, (Object)TagPrefix.dustPure, (Object)TagPrefix.crushedRefined);
        }
        if (ALWAYS_MACHINES == null) {
            ALWAYS_MACHINES = ImmutableList.of((Object)GTMachines.MACERATOR[1].asStack(), (Object)GTMachines.MACERATOR[1].asStack(), (Object)GTMachines.CENTRIFUGE[1].asStack(), (Object)GTMachines.ORE_WASHER[1].asStack(), (Object)GTMachines.THERMAL_CENTRIFUGE[1].asStack(), (Object)GTMachines.MACERATOR[1].asStack(), (Object)GTMachines.MACERATOR[1].asStack(), (Object)GTMachines.CENTRIFUGE[1].asStack());
        }
        OreProperty property = material.getProperty(PropertyKey.ORE);
        int oreMultiplier = property.getOreMultiplier();
        int byproductMultiplier = property.getByProductMultiplier();
        this.currentSlot = 0;
        Material[] byproducts = new Material[]{property.getOreByProduct(0, material), property.getOreByProduct(1, material), property.getOreByProduct(2, material), property.getOreByProduct(3, material)};
        Pair<Material, Integer> washedIn = property.getWashedIn();
        List<Material> separatedInto = property.getSeparatedInto();
        ArrayList<Pair> oreStacks = new ArrayList<Pair>();
        for (TagPrefix prefix : ORES) {
            oreStacks.add(Pair.of(ChemicalHelper.getTag(prefix, material), (Object)1));
        }
        this.itemInputs.add((Either<List<Pair<TagKey<Item>, Integer>>, List<ItemStack>>)Either.left(oreStacks));
        ArrayList<ItemStack> simpleWashers = new ArrayList<ItemStack>();
        simpleWashers.add(new ItemStack((ItemLike)Items.f_42544_));
        simpleWashers.add(GTMachines.ORE_WASHER[1].asStack());
        if (!material.hasProperty(PropertyKey.BLAST)) {
            this.addToInputs(new ItemStack((ItemLike)Blocks.f_50094_));
            this.hasDirectSmelt = true;
        } else {
            this.addToInputs(ItemStack.f_41583_);
        }
        for (ItemStack stack : ALWAYS_MACHINES) {
            this.addToInputs(stack);
        }
        this.itemInputs.add((Either<List<Pair<TagKey<Item>, Integer>>, List<ItemStack>>)Either.right(simpleWashers));
        this.itemInputs.add((Either<List<Pair<TagKey<Item>, Integer>>, List<ItemStack>>)Either.right(simpleWashers));
        this.itemInputs.add((Either<List<Pair<TagKey<Item>, Integer>>, List<ItemStack>>)Either.right(simpleWashers));
        if (washedIn != null && washedIn.getFirst() != null) {
            this.hasChemBath = true;
            this.addToInputs(GTMachines.CHEMICAL_BATH[1].asStack());
        } else {
            this.addToInputs(ItemStack.f_41583_);
        }
        if (separatedInto != null && !separatedInto.isEmpty()) {
            this.hasSeparator = true;
            this.addToInputs(GTMachines.ELECTROMAGNETIC_SEPARATOR[1].asStack());
        } else {
            this.addToInputs(ItemStack.f_41583_);
        }
        if (material.hasProperty(PropertyKey.GEM)) {
            this.hasSifter = true;
            this.addToInputs(GTMachines.SIFTER[1].asStack());
        } else {
            this.addToInputs(ItemStack.f_41583_);
        }
        for (TagPrefix prefix : IN_PROCESSING_STEPS) {
            ArrayList<Pair> tempList = new ArrayList<Pair>();
            tempList.add(Pair.of(ChemicalHelper.getTag(prefix, material), (Object)1));
            this.itemInputs.add((Either<List<Pair<TagKey<Item>, Integer>>, List<ItemStack>>)Either.left(tempList));
        }
        this.currentSlot += 21;
        if (this.hasDirectSmelt) {
            Material smeltingMaterial;
            Material material2 = smeltingMaterial = property.getDirectSmeltResult() == null ? material : property.getDirectSmeltResult();
            ItemStack smeltingResult = smeltingMaterial.hasProperty(PropertyKey.INGOT) ? ChemicalHelper.get(TagPrefix.ingot, smeltingMaterial) : (smeltingMaterial.hasProperty(PropertyKey.GEM) ? ChemicalHelper.get(TagPrefix.gem, smeltingMaterial) : ChemicalHelper.get(TagPrefix.dust, smeltingMaterial));
            smeltingResult.m_41764_(smeltingResult.m_41613_() * oreMultiplier);
            this.addToOutputs(smeltingResult);
        } else {
            this.addEmptyOutputs(1);
        }
        this.addToOutputs(material, TagPrefix.crushed, 2 * oreMultiplier);
        if (!ChemicalHelper.get(TagPrefix.gem, byproducts[0]).m_41619_()) {
            this.addToOutputs(byproducts[0], TagPrefix.gem, 1);
        } else {
            this.addToOutputs(byproducts[0], TagPrefix.dust, 1);
        }
        this.addChance(1400, 850);
        this.addToOutputs(material, TagPrefix.dustImpure, 1);
        this.addToOutputs(byproducts[0], TagPrefix.dust, byproductMultiplier);
        this.addChance(1400, 850);
        this.addToOutputs(material, TagPrefix.dust, 1);
        this.addToOutputs(byproducts[0], TagPrefix.dust, 1);
        this.addChance(1111, 0);
        this.addToOutputs(material, TagPrefix.crushedPurified, 1);
        this.addToOutputs(byproducts[0], TagPrefix.dust, 1);
        this.addChance(3333, 0);
        ArrayList<Pair> fluidStacks = new ArrayList<Pair>();
        fluidStacks.add(Pair.of(GTMaterials.Water.getFluidTag(), (Object)1000L));
        fluidStacks.add(Pair.of(GTMaterials.DistilledWater.getFluidTag(), (Object)100L));
        this.fluidInputs.add((Either<List<Pair<TagKey<Fluid>, Long>>, List<FluidStack>>)Either.left(fluidStacks));
        this.addToOutputs(material, TagPrefix.crushedRefined, 1);
        this.addToOutputs(byproducts[1], TagPrefix.dust, byproductMultiplier);
        this.addChance(3333, 0);
        this.addToOutputs(material, TagPrefix.dust, 1);
        this.addToOutputs(byproducts[2], TagPrefix.dust, 1);
        this.addChance(1400, 850);
        this.addToOutputs(material, TagPrefix.dustPure, 1);
        this.addToOutputs(byproducts[1], TagPrefix.dust, 1);
        this.addChance(1400, 850);
        this.addToOutputs(material, TagPrefix.dust, 1);
        this.addToOutputs(byproducts[1], TagPrefix.dust, 1);
        this.addChance(1111, 0);
        this.addToOutputs(material, TagPrefix.crushed, 1);
        this.addToOutputs(material, TagPrefix.crushedPurified, 1);
        this.addToOutputs(material, TagPrefix.dustImpure, 1);
        this.addToOutputs(material, TagPrefix.dust, 1);
        this.addToOutputs(material, TagPrefix.dustPure, 1);
        this.addToOutputs(material, TagPrefix.dust, 1);
        if (this.hasChemBath) {
            this.addToOutputs(material, TagPrefix.crushedPurified, 1);
            this.addToOutputs(byproducts[3], TagPrefix.dust, byproductMultiplier);
            this.addChance(7000, 580);
            washedFluid = new ArrayList();
            washedFluid.add(Pair.of(((Material)washedIn.getFirst()).getFluidTag(), (Object)((Integer)washedIn.getSecond())));
            this.fluidInputs.add((Either<List<Pair<TagKey<Fluid>, Long>>, List<FluidStack>>)Either.left(washedFluid));
        } else {
            this.addEmptyOutputs(2);
            washedFluid = new ArrayList<Pair>();
            this.fluidInputs.add((Either<List<Pair<TagKey<Fluid>, Long>>, List<FluidStack>>)Either.right(washedFluid));
        }
        if (this.hasSeparator) {
            TagPrefix prefix;
            prefix = separatedInto.get(separatedInto.size() - 1).getBlastTemperature() == 0 && separatedInto.get(separatedInto.size() - 1).hasProperty(PropertyKey.INGOT) ? TagPrefix.nugget : TagPrefix.dust;
            ItemStack separatedStack2 = ChemicalHelper.get(prefix, separatedInto.get(separatedInto.size() - 1), prefix == TagPrefix.nugget ? 2 : 1);
            this.addToOutputs(material, TagPrefix.dust, 1);
            this.addToOutputs(separatedInto.get(0), TagPrefix.dust, 1);
            this.addChance(1000, 250);
            this.addToOutputs(separatedStack2);
            this.addChance(prefix == TagPrefix.dust ? 500 : 2000, prefix == TagPrefix.dust ? 150 : 600);
        } else {
            this.addEmptyOutputs(3);
        }
        if (this.hasSifter) {
            boolean highOutput = material.hasFlag(MaterialFlags.HIGH_SIFTER_OUTPUT);
            ItemStack flawedStack = ChemicalHelper.get(TagPrefix.gemFlawed, material);
            ItemStack chippedStack = ChemicalHelper.get(TagPrefix.gemChipped, material);
            this.addToOutputs(material, TagPrefix.gemExquisite, 1);
            this.addGemChance(300, 100, 500, 150, highOutput);
            this.addToOutputs(material, TagPrefix.gemFlawless, 1);
            this.addGemChance(1000, 150, 1500, 200, highOutput);
            this.addToOutputs(material, TagPrefix.gem, 1);
            this.addGemChance(3500, 500, 5000, 1000, highOutput);
            this.addToOutputs(material, TagPrefix.dustPure, 1);
            this.addGemChance(5000, 750, 2500, 500, highOutput);
            if (!flawedStack.m_41619_()) {
                this.addToOutputs(flawedStack);
                this.addGemChance(2500, 300, 2000, 500, highOutput);
            } else {
                this.addEmptyOutputs(1);
            }
            if (!chippedStack.m_41619_()) {
                this.addToOutputs(chippedStack);
                this.addGemChance(3500, 400, 3000, 350, highOutput);
            } else {
                this.addEmptyOutputs(1);
            }
        } else {
            this.addEmptyOutputs(6);
        }
    }

    public void getTooltip(int slotIndex, List<Component> tooltips) {
        if (this.chances.containsKey(slotIndex)) {
            Content entry = (Content)this.chances.get(slotIndex);
            float chance = 100.0f * (float)entry.chance / (float)entry.maxChance;
            float boost = (float)entry.tierChanceBoost / 100.0f;
            tooltips.add(FormattingUtil.formatPercentage2Places("gtceu.gui.content.chance_1", chance));
            tooltips.add(FormattingUtil.formatPercentage2Places("gtceu.gui.content.tier_boost", boost));
        }
    }

    public Content getChance(int slot) {
        return (Content)this.chances.get(slot);
    }

    public boolean hasSifter() {
        return this.hasSifter;
    }

    public boolean hasSeparator() {
        return this.hasSeparator;
    }

    public boolean hasChemBath() {
        return this.hasChemBath;
    }

    public boolean hasDirectSmelt() {
        return this.hasDirectSmelt;
    }

    private void addToOutputs(Material material, TagPrefix prefix, int size) {
        this.addToOutputs(ChemicalHelper.get(prefix, material, size));
    }

    private void addToOutputs(ItemStack stack) {
        this.itemOutputs.add((Object)stack);
        ++this.currentSlot;
    }

    private void addEmptyOutputs(int amount) {
        for (int i = 0; i < amount; ++i) {
            this.addToOutputs(ItemStack.f_41583_);
        }
    }

    private void addToInputs(ItemStack stack) {
        ArrayList<ItemStack> tempList = new ArrayList<ItemStack>();
        tempList.add(stack);
        this.itemInputs.add((Either<List<Pair<TagKey<Item>, Integer>>, List<ItemStack>>)Either.right(tempList));
    }

    private void addChance(int base, int tier) {
        this.chances.put(this.currentSlot - 1, (Object)new Content(ItemStack.f_41583_, base, ChanceLogic.getMaxChancedValue(), tier, null, null));
    }

    private void addGemChance(int baseLow, int tierLow, int baseHigh, int tierHigh, boolean high) {
        if (high) {
            this.addChance(baseHigh, tierHigh);
        } else {
            this.addChance(baseLow, tierLow);
        }
    }
}

