/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.recipe;

import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.common.machine.kinetic.IKineticMachine;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;

public class RPMCondition
extends RecipeCondition {
    public static final RPMCondition INSTANCE = new RPMCondition();
    private float rpm;

    public RPMCondition(float rpm) {
        this.rpm = rpm;
    }

    @Override
    public String getType() {
        return "rpm";
    }

    @Override
    public Component getTooltips() {
        return Component.m_237110_((String)"recipe.condition.rpm.tooltip", (Object[])new Object[]{Float.valueOf(this.rpm)});
    }

    public float getRpm() {
        return this.rpm;
    }

    @Override
    public boolean test(@NotNull GTRecipe recipe, @NotNull RecipeLogic recipeLogic) {
        IKineticMachine kineticMachine;
        Object object = recipeLogic.machine;
        if (object instanceof IKineticMachine && Math.abs((kineticMachine = (IKineticMachine)object).getKineticHolder().getSpeed()) >= this.rpm) {
            return true;
        }
        object = recipeLogic.machine;
        if (object instanceof IMultiController) {
            IMultiController controller = (IMultiController)object;
            for (IMultiPart part : controller.getParts()) {
                IKineticMachine kineticMachine2;
                if (!(part instanceof IKineticMachine) || !(Math.abs((kineticMachine2 = (IKineticMachine)((Object)part)).getKineticHolder().getSpeed()) >= this.rpm)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public RecipeCondition createTemplate() {
        return new RPMCondition();
    }

    @Override
    @NotNull
    public JsonObject serialize() {
        JsonObject config = super.serialize();
        config.addProperty("rpm", (Number)Float.valueOf(this.rpm));
        return config;
    }

    @Override
    public RecipeCondition deserialize(@NotNull JsonObject config) {
        super.deserialize(config);
        this.rpm = GsonHelper.m_13820_((JsonObject)config, (String)"rpm", (float)0.0f);
        return this;
    }

    @Override
    public RecipeCondition fromNetwork(FriendlyByteBuf buf) {
        super.fromNetwork(buf);
        this.rpm = buf.readFloat();
        return this;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        super.toNetwork(buf);
        buf.writeFloat(this.rpm);
    }

    public RPMCondition() {
    }
}

