/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.trait.miner;

import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.IMiner;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.misc.IgnoreEnergyRecipeHandler;
import com.gregtechceu.gtceu.api.misc.ItemRecipeHandler;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.misc.ItemTransferList;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinerLogic
extends RecipeLogic
implements IRecipeCapabilityHolder {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MinerLogic.class, RecipeLogic.MANAGED_FIELD_HOLDER);
    private static final short MAX_SPEED = Short.MAX_VALUE;
    private static final byte POWER = 5;
    private static final byte TICK_TOLERANCE = 20;
    private static final double DIVIDEND = 32767.0 * Math.pow(20.0, 5.0);
    protected final IMiner miner;
    @Nullable
    private ItemTransferList cachedItemTransfer = null;
    private final int fortune;
    private final int speed;
    private final int maximumRadius;
    public ItemStack pickaxeTool;
    private final LinkedList<BlockPos> blocksToMine = new LinkedList();
    @Persisted
    protected int x = Integer.MAX_VALUE;
    @Persisted
    protected int y = Integer.MAX_VALUE;
    @Persisted
    protected int z = Integer.MAX_VALUE;
    @Persisted
    protected int startX = Integer.MAX_VALUE;
    @Persisted
    protected int startZ = Integer.MAX_VALUE;
    @Persisted
    protected int startY = Integer.MAX_VALUE;
    @Persisted
    protected int pipeY = Integer.MAX_VALUE;
    @Persisted
    protected int mineX = Integer.MAX_VALUE;
    @Persisted
    protected int mineZ = Integer.MAX_VALUE;
    @Persisted
    protected int mineY = Integer.MAX_VALUE;
    private int minBuildHeight = Integer.MAX_VALUE;
    @Persisted
    private int pipeLength = 0;
    @Persisted
    private int currentRadius;
    @Persisted
    private boolean isDone;
    private boolean isInventoryFull;
    private final Table<IO, RecipeCapability<?>, List<IRecipeHandler<?>>> capabilitiesProxy;
    private final ItemRecipeHandler inputItemHandler;
    private final ItemRecipeHandler outputItemHandler;
    private final IgnoreEnergyRecipeHandler inputEnergyHandler;

    public MinerLogic(@NotNull IRecipeLogicMachine machine, int fortune, int speed, int maximumRadius) {
        super(machine);
        this.miner = (IMiner)machine;
        this.fortune = fortune;
        this.speed = speed;
        this.currentRadius = maximumRadius;
        this.maximumRadius = maximumRadius;
        this.isDone = false;
        this.pickaxeTool = ((IGTTool)((ItemProviderEntry)GTItems.TOOL_ITEMS.get((Object)GTMaterials.Neutronium, (Object)GTToolType.PICKAXE)).get()).get();
        this.pickaxeTool.m_41663_(Enchantments.f_44987_, fortune);
        this.capabilitiesProxy = Tables.newCustomTable(new EnumMap(IO.class), IdentityHashMap::new);
        this.inputItemHandler = new ItemRecipeHandler(IO.IN, machine.getRecipeType().getMaxInputs(ItemRecipeCapability.CAP));
        this.outputItemHandler = new ItemRecipeHandler(IO.OUT, machine.getRecipeType().getMaxOutputs(ItemRecipeCapability.CAP));
        this.inputEnergyHandler = new IgnoreEnergyRecipeHandler();
        this.capabilitiesProxy.put((Object)IO.IN, this.inputItemHandler.getCapability(), List.of(this.inputItemHandler));
        this.capabilitiesProxy.put((Object)IO.IN, this.inputEnergyHandler.getCapability(), List.of(this.inputEnergyHandler));
        this.capabilitiesProxy.put((Object)IO.OUT, this.outputItemHandler.getCapability(), List.of(this.outputItemHandler));
    }

    @Override
    public void resetRecipeLogic() {
        super.resetRecipeLogic();
        this.resetArea(false);
        this.cachedItemTransfer = null;
        this.pipeLength = 0;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void inValid() {
        super.inValid();
        this.cachedItemTransfer = null;
        this.pipeLength = 0;
    }

    private static BlockState findMiningReplacementBlock(Level level) {
        try {
            return BlockStateParser.m_245437_((HolderLookup)level.m_246945_(Registries.f_256747_), (String)ConfigHolder.INSTANCE.machines.replaceMinedBlocksWith, (boolean)false).f_234748_();
        }
        catch (CommandSyntaxException ignored) {
            GTCEu.LOGGER.error("failed to parse replaceMinedBlocksWith, invalid BlockState: {}", (Object)ConfigHolder.INSTANCE.machines.replaceMinedBlocksWith);
            return Blocks.f_50652_.m_49966_();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void serverTick() {
        block10: {
            BlockState blockState;
            NonNullList blockDrops;
            ServerLevel serverLevel;
            block11: {
                block9: {
                    Level level;
                    if (this.isSuspend() || !((level = this.getMachine().getLevel()) instanceof ServerLevel)) break block9;
                    serverLevel = (ServerLevel)level;
                    if (!this.checkCanMine()) break block9;
                    if (!this.isInventoryFull()) {
                        this.miner.drainInput(false);
                        this.setStatus(RecipeLogic.Status.WORKING);
                    } else if (this.isWorking()) {
                        this.setWaiting((Component)Component.m_237115_((String)"gtceu.recipe_logic.insufficient_out").m_130946_(": ").m_7220_(ItemRecipeCapability.CAP.getName()));
                    }
                    if (this.mineY < this.pipeY) {
                        BlockPos miningPos = this.getMiningPos();
                        serverLevel.m_46961_(new BlockPos(miningPos.m_123341_(), this.pipeY, miningPos.m_123343_()), false);
                        --this.pipeY;
                        this.incrementPipeLength();
                    }
                    this.checkBlocksToMine();
                    if (this.getMachine().getOffsetTimer() % (long)this.speed != 0L || this.blocksToMine.isEmpty()) break block10;
                    blockDrops = NonNullList.m_122779_();
                    blockState = serverLevel.m_8055_(this.blocksToMine.getFirst());
                    break block11;
                }
                this.setStatus(RecipeLogic.Status.IDLE);
                if (this.subscription == null) return;
                this.subscription.unsubscribe();
                this.subscription = null;
                return;
            }
            while (!blockState.m_204336_(Tags.Blocks.ORES)) {
                this.blocksToMine.removeFirst();
                if (this.blocksToMine.isEmpty()) break;
                blockState = serverLevel.m_8055_(this.blocksToMine.getFirst());
            }
            if (!this.blocksToMine.isEmpty() & blockState.m_204336_(Tags.Blocks.ORES)) {
                LootParams.Builder builder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81461_, (Object)blockState).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82528_((Vec3i)((Vec3i)this.blocksToMine.getFirst()))).m_287286_(LootContextParams.f_81463_, (Object)this.getPickaxeTool());
                this.getSmallOreBlockDrops((NonNullList<ItemStack>)blockDrops, blockState, builder);
                if (this.isSilkTouchMode()) {
                    this.getSilkTouchDrops((NonNullList<ItemStack>)blockDrops, blockState, builder);
                } else {
                    this.getRegularBlockDrops((NonNullList<ItemStack>)blockDrops, blockState, builder);
                }
                if (this.hasPostProcessing()) {
                    this.doPostProcessing((NonNullList<ItemStack>)blockDrops, blockState, builder);
                }
                this.mineAndInsertItems((NonNullList<ItemStack>)blockDrops, serverLevel);
            }
        }
        if (!this.blocksToMine.isEmpty()) return;
        this.x = this.mineX;
        this.y = this.mineY;
        this.z = this.mineZ;
        this.blocksToMine.addAll(this.getBlocksToMine());
        if (!this.blocksToMine.isEmpty()) return;
        this.isDone = true;
        this.setStatus(RecipeLogic.Status.IDLE);
    }

    protected boolean checkCanMine() {
        if (!this.isDone && this.checkCoordinatesInvalid()) {
            this.initPos(this.getMiningPos(), this.currentRadius);
        }
        return !this.isDone && this.miner.drainInput(true);
    }

    protected void onMineOperation() {
    }

    protected void getSmallOreBlockDrops(NonNullList<ItemStack> blockDrops, BlockState blockState, LootParams.Builder builder) {
    }

    protected boolean hasPostProcessing() {
        return false;
    }

    protected boolean isSilkTouchMode() {
        return false;
    }

    protected void getRegularBlockDrops(NonNullList<ItemStack> blockDrops, BlockState blockState, LootParams.Builder builder) {
        blockDrops.addAll((Collection)blockState.m_287290_(builder));
    }

    protected int getVoltageTier() {
        return 0;
    }

    protected boolean doPostProcessing(NonNullList<ItemStack> blockDrops, BlockState blockState, LootParams.Builder builder) {
        ItemStack oreDrop = (ItemStack)blockDrops.get(0);
        this.inputItemHandler.storage.setStackInSlot(0, oreDrop);
        this.inputItemHandler.storage.onContentsChanged(0);
        for (int i = 0; i < this.outputItemHandler.storage.getSlots(); ++i) {
            this.outputItemHandler.storage.setStackInSlot(i, ItemStack.f_41583_);
        }
        this.outputItemHandler.storage.onContentsChanged(0);
        Iterator<GTRecipe> matches = this.machine.getRecipeType().searchRecipe(this);
        while (matches != null && matches.hasNext()) {
            long eut;
            GTRecipe match = matches.next();
            if (match == null || GTUtil.getTierByVoltage(eut = RecipeHelper.getInputEUt(match)) > this.getVoltageTier() || !match.handleRecipeIO(IO.OUT, this, this.chanceCaches)) continue;
            blockDrops.clear();
            ArrayList<ItemStack> result = new ArrayList<ItemStack>();
            for (int i = 0; i < this.outputItemHandler.storage.getSlots(); ++i) {
                ItemStack stack = this.outputItemHandler.storage.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                result.add(stack);
            }
            this.dropPostProcessing(blockDrops, result, blockState, builder);
            return true;
        }
        return false;
    }

    protected void dropPostProcessing(NonNullList<ItemStack> blockDrops, List<ItemStack> outputs, BlockState blockState, LootParams.Builder builder) {
        blockDrops.addAll(outputs);
    }

    protected void getSilkTouchDrops(NonNullList<ItemStack> blockDrops, BlockState blockState, LootParams.Builder builder) {
        blockDrops.add((Object)new ItemStack((ItemLike)blockState.m_60734_()));
    }

    protected ItemTransferList getCachedItemTransfer() {
        if (this.cachedItemTransfer == null) {
            this.cachedItemTransfer = new ItemTransferList(((List)this.machine.getCapabilitiesProxy().get((Object)IO.OUT, (Object)ItemRecipeCapability.CAP)).stream().map(IItemTransfer.class::cast).toList());
        }
        return this.cachedItemTransfer;
    }

    private void mineAndInsertItems(NonNullList<ItemStack> blockDrops, ServerLevel world) {
        ItemTransferList transfer = this.getCachedItemTransfer();
        if (transfer != null) {
            if (GTTransferUtils.addItemsToItemHandler((IItemTransfer)transfer, true, blockDrops)) {
                GTTransferUtils.addItemsToItemHandler((IItemTransfer)transfer, false, blockDrops);
                world.m_7731_(this.blocksToMine.getFirst(), MinerLogic.findMiningReplacementBlock((Level)world), 3);
                this.mineX = this.blocksToMine.getFirst().m_123341_();
                this.mineZ = this.blocksToMine.getFirst().m_123343_();
                this.mineY = this.blocksToMine.getFirst().m_123342_();
                this.blocksToMine.removeFirst();
                this.onMineOperation();
                this.isInventoryFull = false;
            } else {
                this.isInventoryFull = true;
            }
        }
    }

    public void initPos(@NotNull BlockPos pos, int currentRadius) {
        this.x = pos.m_123341_() - currentRadius;
        this.z = pos.m_123343_() - currentRadius;
        this.y = pos.m_123342_() - 1;
        this.startX = pos.m_123341_() - currentRadius;
        this.startZ = pos.m_123343_() - currentRadius;
        this.startY = pos.m_123342_();
        this.pipeY = pos.m_123342_() - 1;
        this.mineX = pos.m_123341_() - currentRadius;
        this.mineZ = pos.m_123343_() - currentRadius;
        this.mineY = pos.m_123342_() - 1;
        this.onRemove();
    }

    private boolean checkCoordinatesInvalid() {
        return this.x == Integer.MAX_VALUE && this.y == Integer.MAX_VALUE && this.z == Integer.MAX_VALUE;
    }

    public void checkBlocksToMine() {
        if (this.blocksToMine.isEmpty()) {
            this.blocksToMine.addAll(this.getBlocksToMine());
        }
    }

    public void resetArea(boolean checkToMine) {
        this.initPos(this.getMiningPos(), this.currentRadius);
        if (this.isDone) {
            this.setWorkingEnabled(false);
        }
        this.isDone = false;
        if (checkToMine) {
            this.blocksToMine.clear();
            this.checkBlocksToMine();
        }
    }

    private LinkedList<BlockPos> getBlocksToMine() {
        LinkedList<BlockPos> blocks = new LinkedList<BlockPos>();
        double quotient = MinerLogic.getQuotient(MinerLogic.getMeanTickTime(this.getMachine().getLevel()));
        int calcAmount = quotient < 1.0 ? 1 : (int)Math.min(quotient, 32767.0);
        int calculated = 0;
        if (this.minBuildHeight == Integer.MAX_VALUE) {
            this.minBuildHeight = this.getMachine().getLevel().m_141937_();
        }
        while (calculated < calcAmount) {
            if (this.y > this.minBuildHeight) {
                if (this.z <= this.startZ + this.currentRadius * 2) {
                    if (this.x <= this.startX + this.currentRadius * 2) {
                        BlockPos blockPos = new BlockPos(this.x, this.y, this.z);
                        BlockState state = this.getMachine().getLevel().m_8055_(blockPos);
                        if (state.m_60734_().m_155943_() >= 0.0f && this.getMachine().getLevel().m_7702_(blockPos) == null && state.m_204336_(Tags.Blocks.ORES)) {
                            blocks.addLast(blockPos);
                        }
                        ++this.x;
                    } else {
                        this.x = this.startX;
                        ++this.z;
                    }
                } else {
                    this.z = this.startZ;
                    --this.y;
                }
            } else {
                return blocks;
            }
            if (blocks.isEmpty()) continue;
            ++calculated;
        }
        return blocks;
    }

    private static long mean(@NotNull long[] values) {
        if ((long)values.length == 0L) {
            return 0L;
        }
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }

    private static double getMeanTickTime(@NotNull Level world) {
        return (double)MinerLogic.mean(Objects.requireNonNull(world.m_7654_()).f_129748_) * 1.0E-6;
    }

    private static double getQuotient(double base) {
        return DIVIDEND / Math.pow(base, 5.0);
    }

    private void incrementPipeLength() {
        ++this.pipeLength;
        Level level = this.getMachine().getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = this.getMiningPos().m_5484_(Direction.DOWN, this.pipeLength);
            serverLevel.m_46597_(pos, GTBlocks.MINER_PIPE.getDefaultState());
        }
    }

    public BlockPos getMiningPos() {
        return this.getMachine().getPos();
    }

    public void onRemove() {
        this.pipeLength = 0;
        Level level = this.getMachine().getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = this.getMiningPos().m_121945_(Direction.DOWN);
            while (serverLevel.m_8055_(pos).m_60713_((Block)GTBlocks.MINER_PIPE.get())) {
                serverLevel.m_7471_(pos, false);
                pos = pos.m_121945_(Direction.DOWN);
            }
        }
    }

    public int getFortune() {
        return this.fortune;
    }

    public int getSpeed() {
        return this.speed;
    }

    public int getMaximumRadius() {
        return this.maximumRadius;
    }

    public ItemStack getPickaxeTool() {
        return this.pickaxeTool;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int getStartX() {
        return this.startX;
    }

    public int getStartZ() {
        return this.startZ;
    }

    public int getStartY() {
        return this.startY;
    }

    public int getPipeY() {
        return this.pipeY;
    }

    public int getMineX() {
        return this.mineX;
    }

    public int getMineZ() {
        return this.mineZ;
    }

    public int getMineY() {
        return this.mineY;
    }

    public int getMinBuildHeight() {
        return this.minBuildHeight;
    }

    public int getPipeLength() {
        return this.pipeLength;
    }

    public int getCurrentRadius() {
        return this.currentRadius;
    }

    public void setCurrentRadius(int currentRadius) {
        this.currentRadius = currentRadius;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public boolean isInventoryFull() {
        return this.isInventoryFull;
    }

    @Override
    public Table<IO, RecipeCapability<?>, List<IRecipeHandler<?>>> getCapabilitiesProxy() {
        return this.capabilitiesProxy;
    }
}

