/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.steam;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IExplosionMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IDisplayUIMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.recipe.logic.OCParams;
import com.gregtechceu.gtceu.api.recipe.logic.OCResult;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LargeBoilerMachine
extends WorkableMultiblockMachine
implements IExplosionMachine,
IDisplayUIMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(LargeBoilerMachine.class, WorkableMultiblockMachine.MANAGED_FIELD_HOLDER);
    public static final int TICKS_PER_STEAM_GENERATION = 5;
    public final int maxTemperature;
    public final int heatSpeed;
    @Persisted
    private int currentTemperature;
    @Persisted
    private int throttle;
    private boolean hasNoWater;
    @Nullable
    protected TickableSubscription temperatureSubs;
    private long steamGenerated;

    public LargeBoilerMachine(IMachineBlockEntity holder, int maxTemperature, int heatSpeed, Object ... args) {
        super(holder, args);
        this.maxTemperature = maxTemperature;
        this.heatSpeed = heatSpeed;
        this.throttle = 100;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, this::updateSteamSubscription));
        }
    }

    protected void updateSteamSubscription() {
        if (this.currentTemperature > 0) {
            this.temperatureSubs = this.subscribeServerTick(this.temperatureSubs, this::updateCurrentTemperature);
        } else if (this.temperatureSubs != null) {
            this.temperatureSubs.unsubscribe();
            this.temperatureSubs = null;
        }
    }

    protected void updateCurrentTemperature() {
        if (this.recipeLogic.isWorking()) {
            if (this.getOffsetTimer() % 10L == 0L && this.currentTemperature < this.getMaxTemperature()) {
                this.currentTemperature = Mth.m_14045_((int)(this.currentTemperature + this.heatSpeed * 10), (int)0, (int)this.getMaxTemperature());
            }
        } else if (this.currentTemperature > 0) {
            this.currentTemperature -= this.getCoolDownRate();
        }
        if (this.currentTemperature >= 100 && this.getOffsetTimer() % 5L == 0L) {
            IRecipeHandler tank;
            long maxDrain = (long)(this.currentTemperature * this.throttle * 5) * FluidHelper.getBucket() / ((long)ConfigHolder.INSTANCE.machines.largeBoilers.steamPerWater * 100000L);
            List<FluidIngredient> drainWater = List.of(FluidIngredient.of(maxDrain, new Fluid[]{Fluids.f_76193_}));
            ArrayList inputTanks = new ArrayList();
            if (this.getCapabilitiesProxy().contains((Object)IO.IN, (Object)FluidRecipeCapability.CAP)) {
                inputTanks.addAll(Objects.requireNonNull((List)this.getCapabilitiesProxy().get((Object)IO.IN, (Object)FluidRecipeCapability.CAP)));
            }
            if (this.getCapabilitiesProxy().contains((Object)IO.BOTH, (Object)FluidRecipeCapability.CAP)) {
                inputTanks.addAll(Objects.requireNonNull((List)this.getCapabilitiesProxy().get((Object)IO.BOTH, (Object)FluidRecipeCapability.CAP)));
            }
            Iterator iterator = inputTanks.iterator();
            while (iterator.hasNext() && (drainWater = (tank = (IRecipeHandler)iterator.next()).handleRecipe(IO.IN, null, drainWater, null, false)) != null) {
            }
            long drained = drainWater == null || drainWater.isEmpty() ? maxDrain : maxDrain - drainWater.get(0).getAmount();
            boolean hasDrainedWater = drained > 0L;
            this.steamGenerated = drained * (long)ConfigHolder.INSTANCE.machines.largeBoilers.steamPerWater;
            if (hasDrainedWater) {
                IRecipeHandler tank2;
                List<FluidIngredient> fillSteam = List.of(FluidIngredient.of(GTMaterials.Steam.getFluid(this.steamGenerated)));
                ArrayList outputTanks = new ArrayList();
                if (this.getCapabilitiesProxy().contains((Object)IO.OUT, (Object)FluidRecipeCapability.CAP)) {
                    outputTanks.addAll(Objects.requireNonNull((List)this.getCapabilitiesProxy().get((Object)IO.OUT, (Object)FluidRecipeCapability.CAP)));
                }
                if (this.getCapabilitiesProxy().contains((Object)IO.BOTH, (Object)FluidRecipeCapability.CAP)) {
                    outputTanks.addAll(Objects.requireNonNull((List)this.getCapabilitiesProxy().get((Object)IO.BOTH, (Object)FluidRecipeCapability.CAP)));
                }
                Iterator iterator2 = outputTanks.iterator();
                while (iterator2.hasNext() && (fillSteam = (tank2 = (IRecipeHandler)iterator2.next()).handleRecipe(IO.OUT, null, fillSteam, null, false)) != null) {
                }
            }
            if (this.hasNoWater && hasDrainedWater) {
                this.doExplosion(2.0f);
                BlockPos center = this.getPos().m_7495_().m_121945_(this.getFrontFacing().m_122424_());
                if (GTValues.RNG.m_188503_(100) > 80) {
                    this.doExplosion(center, 2.0f);
                }
                for (Direction x : Direction.Plane.HORIZONTAL) {
                    for (Direction y : Direction.Plane.HORIZONTAL) {
                        if (GTValues.RNG.m_188503_(100) <= 80) continue;
                        this.doExplosion(center.m_121945_(x).m_121945_(y), 2.0f);
                    }
                }
            } else {
                this.hasNoWater = !hasDrainedWater;
            }
        } else {
            if (this.currentTemperature < 100) {
                this.steamGenerated = 0L;
            }
            this.hasNoWater = false;
        }
        this.updateSteamSubscription();
    }

    protected int getCoolDownRate() {
        return 1;
    }

    @Override
    public boolean onWorking() {
        boolean value = super.onWorking();
        if (this.currentTemperature < this.getMaxTemperature()) {
            this.currentTemperature = Math.max(1, this.currentTemperature);
            this.updateSteamSubscription();
        }
        return value;
    }

    @Nullable
    public static GTRecipe recipeModifier(MetaMachine machine, @NotNull GTRecipe recipe, @NotNull OCParams params, @NotNull OCResult result) {
        if (machine instanceof LargeBoilerMachine) {
            LargeBoilerMachine largeBoilerMachine = (LargeBoilerMachine)machine;
            if (largeBoilerMachine.throttle < 100) {
                GTRecipe copied = recipe.copy();
                result.setDuration(recipe.duration * 100 / largeBoilerMachine.throttle);
                return copied;
            }
            return recipe;
        }
        return null;
    }

    @Override
    public void addDisplayText(List<Component> textList) {
        IDisplayUIMachine.super.addDisplayText(textList);
        if (this.isFormed()) {
            textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.large_boiler.temperature", (Object[])new Object[]{(int)((double)this.currentTemperature + 274.15), (int)((double)this.maxTemperature + 274.15)}));
            textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.large_boiler.steam_output", (Object[])new Object[]{this.steamGenerated / 5L}));
            MutableComponent throttleText = Component.m_237110_((String)"gtceu.multiblock.large_boiler.throttle", (Object[])new Object[]{ChatFormatting.AQUA.toString() + this.getThrottle() + "%"}).m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"gtceu.multiblock.large_boiler.throttle.tooltip"))));
            textList.add((Component)throttleText);
            MutableComponent buttonText = Component.m_237115_((String)"gtceu.multiblock.large_boiler.throttle_modify");
            buttonText.m_130946_(" ");
            buttonText.m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[-]"), (String)"sub"));
            buttonText.m_130946_(" ");
            buttonText.m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[+]"), (String)"add"));
            textList.add((Component)buttonText);
        }
    }

    @Override
    public void handleDisplayClick(String componentData, ClickData clickData) {
        if (!clickData.isRemote) {
            int result = componentData.equals("add") ? 5 : -5;
            this.throttle = Mth.m_14045_((int)(this.throttle + result), (int)25, (int)100);
        }
    }

    @Override
    public IGuiTexture getScreenTexture() {
        return GuiTextures.DISPLAY_STEAM.get(this.maxTemperature > 800);
    }

    public int getMaxTemperature() {
        return this.maxTemperature;
    }

    public int getHeatSpeed() {
        return this.heatSpeed;
    }

    public int getCurrentTemperature() {
        return this.currentTemperature;
    }

    public int getThrottle() {
        return this.throttle;
    }

    public boolean isHasNoWater() {
        return this.hasNoWater;
    }
}

