/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.primitive;

import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.IEnvironmentalHazardEmitter;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PrimitiveWorkableMachine
extends WorkableMultiblockMachine
implements IMachineLife,
IEnvironmentalHazardEmitter {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(PrimitiveWorkableMachine.class, WorkableMultiblockMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    public final NotifiableItemStackHandler importItems;
    @Persisted
    public final NotifiableItemStackHandler exportItems;
    @Persisted
    public final NotifiableFluidTank importFluids;
    @Persisted
    public final NotifiableFluidTank exportFluids;

    public PrimitiveWorkableMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, args);
        this.importItems = this.createImportItemHandler(args);
        this.exportItems = this.createExportItemHandler(args);
        this.importFluids = this.createImportFluidHandler(args);
        this.exportFluids = this.createExportFluidHandler(args);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected NotifiableItemStackHandler createImportItemHandler(Object ... args) {
        return new NotifiableItemStackHandler(this, this.getRecipeType().getMaxInputs(ItemRecipeCapability.CAP), IO.IN, IO.NONE);
    }

    protected NotifiableItemStackHandler createExportItemHandler(Object ... args) {
        return new NotifiableItemStackHandler(this, this.getRecipeType().getMaxOutputs(ItemRecipeCapability.CAP), IO.OUT, IO.NONE);
    }

    protected NotifiableFluidTank createImportFluidHandler(Object ... args) {
        return new NotifiableFluidTank(this, this.getRecipeType().getMaxInputs(FluidRecipeCapability.CAP), 32L * FluidHelper.getBucket(), IO.IN, IO.NONE);
    }

    protected NotifiableFluidTank createExportFluidHandler(Object ... args) {
        return new NotifiableFluidTank(this, this.getRecipeType().getMaxOutputs(FluidRecipeCapability.CAP), 32L * FluidHelper.getBucket(), IO.OUT, IO.NONE);
    }

    @Override
    public void onMachineRemoved() {
        this.clearInventory((IItemTransfer)this.importItems.storage);
        this.clearInventory((IItemTransfer)this.exportItems.storage);
    }

    @Override
    public float getHazardStrengthPerOperation() {
        return 0.1f;
    }

    @Override
    public void afterWorking() {
        super.afterWorking();
        this.spreadEnvironmentalHazard();
    }
}

