/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.primitive;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.IUIMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.primitive.PrimitiveWorkableMachine;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PrimitiveBlastFurnaceMachine
extends PrimitiveWorkableMachine
implements IUIMachine {
    public PrimitiveBlastFurnaceMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, args);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        super.clientTick();
        if (this.recipeLogic.isWorking()) {
            BlockPos pos = this.getPos();
            Direction facing = this.getFrontFacing().m_122424_();
            float xPos = (float)facing.m_122429_() * 0.76f + (float)pos.m_123341_() + 0.5f;
            float yPos = (float)facing.m_122430_() * 0.76f + (float)pos.m_123342_() + 0.25f;
            float zPos = (float)facing.m_122431_() * 0.76f + (float)pos.m_123343_() + 0.5f;
            float ySpd = (float)facing.m_122430_() * 0.1f + 0.2f + 0.1f * GTValues.RNG.m_188501_();
            this.getLevel().m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)xPos, (double)yPos, (double)zPos, 0.0, (double)ySpd, 0.0);
        }
    }

    public ModularUI createUI(Player entityPlayer) {
        return new ModularUI(176, 166, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.PRIMITIVE_BACKGROUND}).widget((Widget)new LabelWidget(5, 5, this.getBlockState().m_60734_().m_7705_())).widget((Widget)new SlotWidget((IItemTransfer)this.importItems.storage, 0, 52, 20, true, true).setBackgroundTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.PRIMITIVE_SLOT, GuiTextures.PRIMITIVE_INGOT_OVERLAY}))).widget((Widget)new SlotWidget((IItemTransfer)this.importItems.storage, 1, 52, 38, true, true).setBackgroundTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.PRIMITIVE_SLOT, GuiTextures.PRIMITIVE_DUST_OVERLAY}))).widget((Widget)new SlotWidget((IItemTransfer)this.importItems.storage, 2, 52, 56, true, true).setBackgroundTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.PRIMITIVE_SLOT, GuiTextures.PRIMITIVE_FURNACE_OVERLAY}))).widget((Widget)new ProgressWidget(this.recipeLogic::getProgressPercent, 77, 39, 20, 15, GuiTextures.PRIMITIVE_BLAST_FURNACE_PROGRESS_BAR)).widget((Widget)new SlotWidget((IItemTransfer)this.exportItems.storage, 0, 104, 38, true, false).setBackgroundTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.PRIMITIVE_SLOT, GuiTextures.PRIMITIVE_INGOT_OVERLAY}))).widget((Widget)new SlotWidget((IItemTransfer)this.exportItems.storage, 1, 122, 38, true, false).setBackgroundTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.PRIMITIVE_SLOT, GuiTextures.PRIMITIVE_DUST_OVERLAY}))).widget((Widget)new SlotWidget((IItemTransfer)this.exportItems.storage, 2, 140, 38, true, false).setBackgroundTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.PRIMITIVE_SLOT, GuiTextures.PRIMITIVE_DUST_OVERLAY}))).widget((Widget)UITemplate.bindPlayerInventory(entityPlayer.m_150109_(), (IGuiTexture)GuiTextures.PRIMITIVE_SLOT, 7, 84, true));
    }

    @Override
    public void animateTick(RandomSource random) {
        if (this.isActive()) {
            BlockPos pos = this.getPos();
            float x = (float)pos.m_123341_() + 0.5f;
            float z = (float)pos.m_123343_() + 0.5f;
            Direction facing = this.getFrontFacing();
            float horizontalOffset = GTValues.RNG.m_188501_() * 0.6f - 0.3f;
            float y = (float)pos.m_123342_() + GTValues.RNG.m_188501_() * 0.375f + 0.3f;
            if (facing.m_122434_() == Direction.Axis.X) {
                x = facing.m_122421_() == Direction.AxisDirection.POSITIVE ? (x += 0.52f) : (x -= 0.52f);
                z += horizontalOffset;
            } else if (facing.m_122434_() == Direction.Axis.Z) {
                z = facing.m_122421_() == Direction.AxisDirection.POSITIVE ? (z += 0.52f) : (z -= 0.52f);
                x += horizontalOffset;
            }
            if (ConfigHolder.INSTANCE.machines.machineSounds && GTValues.RNG.m_188500_() < 0.1) {
                this.getLevel().m_7785_((double)x, (double)y, (double)z, SoundEvents.f_11907_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            this.getLevel().m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
            this.getLevel().m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
        }
    }
}

