/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.common.machine.multiblock.part.ItemBusPartMachine;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DualHatchPartMachine
extends ItemBusPartMachine {
    public static final long INITIAL_TANK_CAPACITY = 16L * FluidHelper.getBucket();
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(DualHatchPartMachine.class, ItemBusPartMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    public final NotifiableFluidTank tank;
    @Nullable
    protected ISubscription tankSubs;
    private boolean hasFluidTransfer;
    private boolean hasItemTransfer;

    public DualHatchPartMachine(IMachineBlockEntity holder, int tier, IO io, Object ... args) {
        super(holder, tier, io, new Object[0]);
        this.tank = this.createTank(INITIAL_TANK_CAPACITY, (int)Math.sqrt(this.getInventorySize()), args);
    }

    public static long getTankCapacity(long initialCapacity, int tier) {
        return initialCapacity * (1L << tier - 6);
    }

    @Override
    public int getInventorySize() {
        return (int)Math.pow(this.getTier() - 4, 2.0);
    }

    protected NotifiableFluidTank createTank(long initialCapacity, int slots, Object ... args) {
        return new NotifiableFluidTank((MetaMachine)this, slots, DualHatchPartMachine.getTankCapacity(initialCapacity, this.getTier()), this.io);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.tankSubs = this.tank.addChangedListener(this::updateInventorySubscription);
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.tankSubs != null) {
            this.tankSubs.unsubscribe();
            this.tankSubs = null;
        }
    }

    @Override
    protected void updateInventorySubscription() {
        boolean canOutput = this.io == IO.OUT && (!this.tank.isEmpty() || !this.getInventory().isEmpty());
        Level level = this.getLevel();
        if (level != null) {
            this.hasItemTransfer = ItemTransferHelper.getItemTransfer((Level)level, (BlockPos)this.getPos().m_121945_(this.getFrontFacing()), (Direction)this.getFrontFacing().m_122424_()) != null;
            this.hasFluidTransfer = FluidTransferHelper.getFluidTransfer((Level)level, (BlockPos)this.getPos().m_121945_(this.getFrontFacing()), (Direction)this.getFrontFacing().m_122424_()) != null;
        } else {
            this.hasItemTransfer = false;
            this.hasFluidTransfer = false;
        }
        if (this.isWorkingEnabled() && (canOutput || this.io == IO.IN) && (this.hasItemTransfer || this.hasFluidTransfer)) {
            this.autoIOSubs = this.subscribeServerTick(this.autoIOSubs, this::autoIO);
        } else if (this.autoIOSubs != null) {
            this.autoIOSubs.unsubscribe();
            this.autoIOSubs = null;
        }
    }

    @Override
    protected void autoIO() {
        if (this.getOffsetTimer() % 5L == 0L) {
            if (this.isWorkingEnabled()) {
                if (this.io == IO.OUT) {
                    if (this.hasItemTransfer) {
                        this.getInventory().exportToNearby(this.getFrontFacing());
                    }
                    if (this.hasFluidTransfer) {
                        this.tank.exportToNearby(this.getFrontFacing());
                    }
                } else if (this.io == IO.IN) {
                    if (this.hasItemTransfer) {
                        this.getInventory().importFromNearby(this.getFrontFacing());
                    }
                    if (this.hasFluidTransfer) {
                        this.tank.importFromNearby(this.getFrontFacing());
                    }
                }
            }
            this.updateInventorySubscription();
        }
    }

    @Override
    public Widget createUIWidget() {
        int y;
        int slots = this.getInventorySize();
        int tanks = (int)Math.sqrt(slots);
        WidgetGroup group = new WidgetGroup(0, 0, 18 * (tanks + 1) + 16, 18 * tanks + 16);
        WidgetGroup container = new WidgetGroup(4, 4, 18 * (tanks + 1) + 8, 18 * tanks + 8);
        int index = 0;
        for (y = 0; y < tanks; ++y) {
            for (int x = 0; x < tanks; ++x) {
                container.addWidget((Widget)new SlotWidget((IItemTransfer)this.getInventory().storage, index++, 4 + x * 18, 4 + y * 18, true, this.io.support(IO.IN)).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT).setIngredientIO(this.io == IO.IN ? IngredientIO.INPUT : IngredientIO.OUTPUT));
            }
        }
        index = 0;
        for (y = 0; y < tanks; ++y) {
            container.addWidget((Widget)new TankWidget((IFluidStorage)this.tank.getStorages()[index++], 4 + tanks * 18, 4 + y * 18, true, this.io.support(IO.IN)).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT));
        }
        container.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        group.addWidget((Widget)container);
        return group;
    }

    @Override
    public boolean isDistinct() {
        return super.isDistinct() && this.tank.isDistinct();
    }

    @Override
    public void setDistinct(boolean isDistinct) {
        super.setDistinct(isDistinct);
        this.tank.setDistinct(isDistinct);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }
}

