/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.generator;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.ITieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IRotorHolderMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.logic.OCParams;
import com.gregtechceu.gtceu.api.recipe.logic.OCResult;
import com.gregtechceu.gtceu.common.data.GTRecipeModifiers;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LargeTurbineMachine
extends WorkableElectricMultiblockMachine
implements ITieredMachine {
    public static final int MIN_DURABILITY_TO_WARN = 10;
    private final int BASE_EU_OUTPUT;
    private final int tier;
    private int excessVoltage;

    public LargeTurbineMachine(IMachineBlockEntity holder, int tier) {
        super(holder, new Object[0]);
        this.tier = tier;
        this.BASE_EU_OUTPUT = (int)GTValues.V[tier] * 2;
    }

    @Nullable
    private IRotorHolderMachine getRotorHolder() {
        for (IMultiPart part : this.getParts()) {
            if (!(part instanceof IRotorHolderMachine)) continue;
            IRotorHolderMachine rotorHolder = (IRotorHolderMachine)part;
            return rotorHolder;
        }
        return null;
    }

    @Override
    public long getOverclockVoltage() {
        IRotorHolderMachine rotorHolder = this.getRotorHolder();
        if (rotorHolder != null && rotorHolder.hasRotor()) {
            return (long)this.BASE_EU_OUTPUT * (long)rotorHolder.getTotalPower() / 100L;
        }
        return 0L;
    }

    protected long boostProduction(long production) {
        IRotorHolderMachine rotorHolder = this.getRotorHolder();
        if (rotorHolder != null && rotorHolder.hasRotor()) {
            int maxSpeed = rotorHolder.getMaxRotorHolderSpeed();
            int currentSpeed = rotorHolder.getRotorSpeed();
            if (currentSpeed >= maxSpeed) {
                return production;
            }
            return (long)((double)production * Math.pow(1.0 * (double)currentSpeed / (double)maxSpeed, 2.0));
        }
        return 0L;
    }

    @Nullable
    public static GTRecipe recipeModifier(MetaMachine machine, @NotNull GTRecipe recipe, @NotNull OCParams params, @NotNull OCResult result) {
        if (!(machine instanceof LargeTurbineMachine)) {
            return null;
        }
        LargeTurbineMachine turbineMachine = (LargeTurbineMachine)machine;
        IRotorHolderMachine rotorHolder = turbineMachine.getRotorHolder();
        long EUt = RecipeHelper.getOutputEUt(recipe);
        if (rotorHolder == null || EUt <= 0L) {
            return null;
        }
        int turbineMaxVoltage = (int)turbineMachine.getOverclockVoltage();
        if (turbineMachine.excessVoltage >= turbineMaxVoltage) {
            turbineMachine.excessVoltage -= turbineMaxVoltage;
            return null;
        }
        double holderEfficiency = (double)rotorHolder.getTotalEfficiency() / 100.0;
        int maxParallel = (int)((double)(turbineMaxVoltage - turbineMachine.excessVoltage) / ((double)EUt * holderEfficiency));
        turbineMachine.excessVoltage += (int)((double)((long)maxParallel * EUt) * holderEfficiency - (double)turbineMaxVoltage);
        Pair<GTRecipe, Integer> parallelResult = GTRecipeModifiers.fastParallel(turbineMachine, recipe, Math.max(1, maxParallel), false);
        long eut = turbineMachine.boostProduction((long)((double)EUt * holderEfficiency * (double)((Integer)parallelResult.getSecond()).intValue()));
        result.init(-eut, recipe.duration, (Integer)parallelResult.getSecond(), params.getOcAmount());
        return recipe;
    }

    @Override
    public boolean dampingWhenWaiting() {
        return false;
    }

    @Override
    public boolean canVoidRecipeOutputs(RecipeCapability<?> capability) {
        return capability != EURecipeCapability.CAP;
    }

    @Override
    public void addDisplayText(List<Component> textList) {
        IRotorHolderMachine rotorHolder;
        super.addDisplayText(textList);
        if (this.isFormed() && (rotorHolder = this.getRotorHolder()) != null && rotorHolder.getRotorEfficiency() > 0) {
            int rotorDurability;
            textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.turbine.rotor_speed", (Object[])new Object[]{FormattingUtil.formatNumbers(rotorHolder.getRotorSpeed()), FormattingUtil.formatNumbers(rotorHolder.getMaxRotorHolderSpeed())}));
            textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.turbine.efficiency", (Object[])new Object[]{rotorHolder.getTotalEfficiency()}));
            long maxProduction = this.getOverclockVoltage();
            long currentProduction = this.isActive() ? this.boostProduction((int)maxProduction) : 0L;
            String voltageName = GTValues.VNF[GTUtil.getTierByVoltage(currentProduction)];
            if (this.isActive()) {
                textList.add(3, (Component)Component.m_237110_((String)"gtceu.multiblock.turbine.energy_per_tick", (Object[])new Object[]{FormattingUtil.formatNumbers(currentProduction), voltageName}));
            }
            if ((rotorDurability = rotorHolder.getRotorDurabilityPercent()) > 10) {
                textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.turbine.rotor_durability", (Object[])new Object[]{rotorDurability}));
            } else {
                textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.turbine.rotor_durability", (Object[])new Object[]{rotorDurability}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            }
        }
    }

    @Override
    public int getTier() {
        return this.tier;
    }
}

