/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric;

import com.google.common.annotations.VisibleForTesting;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.IEnergyInfoProvider;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.FancyMachineUIWidget;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyUIProvider;
import com.gregtechceu.gtceu.api.gui.fancy.TooltipsPanel;
import com.gregtechceu.gtceu.api.machine.ConditionalSubscriptionHandler;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IDisplayUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMaintenanceMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.IBatteryData;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.IRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.machine.trait.MachineTrait;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.misc.EnergyContainerList;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import java.math.BigInteger;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class PowerSubstationMachine
extends WorkableMultiblockMachine
implements IEnergyInfoProvider,
IFancyUIMachine,
IDisplayUIMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(PowerSubstationMachine.class, WorkableMultiblockMachine.MANAGED_FIELD_HOLDER);
    public static final int MAX_BATTERY_LAYERS = 18;
    public static final int MIN_CASINGS = 14;
    public static final long PASSIVE_DRAIN_DIVISOR = 172800000L;
    public static final long PASSIVE_DRAIN_MAX_PER_STORAGE = 100000L;
    public static final String PMC_BATTERY_HEADER = "PSSBattery_";
    private static final BigInteger BIG_INTEGER_MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    private IMaintenanceMachine maintenance;
    private PowerStationEnergyBank energyBank;
    private EnergyContainerList inputHatches;
    private EnergyContainerList outputHatches;
    private long passiveDrain;
    private long netInLastSec;
    private long averageInLastSec;
    private long netOutLastSec;
    private long averageOutLastSec;
    protected ConditionalSubscriptionHandler tickSubscription = new ConditionalSubscriptionHandler(this, this::transferEnergyTick, this::isFormed);

    public PowerSubstationMachine(IMachineBlockEntity holder) {
        super(holder, new Object[0]);
        this.energyBank = new PowerStationEnergyBank(this, List.of());
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        ArrayList<IEnergyContainer> inputs = new ArrayList<IEnergyContainer>();
        ArrayList<IEnergyContainer> outputs = new ArrayList<IEnergyContainer>();
        Map ioMap = (Map)this.getMultiblockState().getMatchContext().getOrCreate("ioMap", Long2ObjectMaps::emptyMap);
        for (IMultiPart part : this.getParts()) {
            Object maintenanceMachine;
            IO io = ioMap.getOrDefault(part.self().getPos().m_121878_(), IO.BOTH);
            if (io == IO.NONE) continue;
            if (part instanceof IMaintenanceMachine) {
                this.maintenance = maintenanceMachine = (IMaintenanceMachine)part;
            }
            maintenanceMachine = part.getRecipeHandlers().iterator();
            while (maintenanceMachine.hasNext()) {
                IRecipeHandlerTrait handler = (IRecipeHandlerTrait)maintenanceMachine.next();
                IO handlerIO = handler.getHandlerIO();
                if (io != IO.BOTH && handlerIO != IO.BOTH && io != handlerIO || handler.getCapability() != EURecipeCapability.CAP || !(handler instanceof IEnergyContainer)) continue;
                IEnergyContainer container = (IEnergyContainer)((Object)handler);
                if (handlerIO == IO.IN) {
                    inputs.add(container);
                } else if (handlerIO == IO.OUT) {
                    outputs.add(container);
                }
                this.traitSubscriptions.add(handler.addChangedListener(this.tickSubscription::updateSubscription));
            }
        }
        this.inputHatches = new EnergyContainerList(inputs);
        this.outputHatches = new EnergyContainerList(outputs);
        ArrayList<IBatteryData> batteries = new ArrayList<IBatteryData>();
        for (Map.Entry<String, Object> battery : this.getMultiblockState().getMatchContext().entrySet()) {
            Object handler;
            if (!battery.getKey().startsWith(PMC_BATTERY_HEADER) || !((handler = battery.getValue()) instanceof BatteryMatchWrapper)) continue;
            BatteryMatchWrapper wrapper = (BatteryMatchWrapper)handler;
            for (int i = 0; i < wrapper.amount; ++i) {
                batteries.add(wrapper.partType);
            }
        }
        if (batteries.isEmpty()) {
            this.onStructureInvalid();
            return;
        }
        this.energyBank = this.energyBank == null ? new PowerStationEnergyBank(this, batteries) : this.energyBank.rebuild(batteries);
        this.passiveDrain = this.energyBank.getPassiveDrainPerTick();
    }

    @Override
    public void onStructureInvalid() {
        this.inputHatches = null;
        this.outputHatches = null;
        this.passiveDrain = 0L;
        this.netInLastSec = 0L;
        this.averageInLastSec = 0L;
        this.netOutLastSec = 0L;
        this.averageOutLastSec = 0L;
        super.onStructureInvalid();
    }

    protected void transferEnergyTick() {
        if (!this.getLevel().f_46443_) {
            if (this.getOffsetTimer() % 20L == 0L) {
                this.getRecipeLogic().setStatus(this.energyBank.hasEnergy() ? RecipeLogic.Status.WORKING : RecipeLogic.Status.IDLE);
                this.averageInLastSec = this.netInLastSec / 20L;
                this.averageOutLastSec = this.netOutLastSec / 20L;
                this.netInLastSec = 0L;
                this.netOutLastSec = 0L;
            }
            if (this.isWorkingEnabled() && this.isFormed()) {
                long energyBanked = this.energyBank.fill(this.inputHatches.getEnergyStored());
                this.inputHatches.changeEnergy(-energyBanked);
                this.netInLastSec += energyBanked;
                long energyPassiveDrained = this.energyBank.drain(this.getPassiveDrain());
                this.netOutLastSec -= energyPassiveDrained;
                long energyDebanked = this.energyBank.drain(this.outputHatches.getEnergyCapacity() - this.outputHatches.getEnergyStored());
                this.outputHatches.changeEnergy(energyDebanked);
                this.netOutLastSec += energyDebanked;
            }
        }
    }

    @Override
    public void addDisplayText(List<Component> textList) {
        IDisplayUIMachine.super.addDisplayText(textList);
        if (this.isFormed()) {
            if (!this.isWorkingEnabled()) {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.work_paused"));
            } else if (this.isActive()) {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.running"));
                int currentProgress = (int)(this.recipeLogic.getProgressPercent() * 100.0);
                textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.progress", (Object[])new Object[]{currentProgress}));
            } else {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.idling"));
            }
            if (this.recipeLogic.isWaiting()) {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.waiting").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            }
            if (this.energyBank != null) {
                BigInteger energyStored = this.energyBank.getStored();
                BigInteger energyCapacity = this.energyBank.getCapacity();
                textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.power_substation.stored", (Object[])new Object[]{FormattingUtil.formatNumbers(energyStored)}));
                textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.power_substation.capacity", (Object[])new Object[]{FormattingUtil.formatNumbers(energyCapacity)}));
                textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.power_substation.passive_drain", (Object[])new Object[]{FormattingUtil.formatNumbers(this.getPassiveDrain())}));
                textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.power_substation.average_in", (Object[])new Object[]{FormattingUtil.formatNumbers(this.averageInLastSec)}).m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"gtceu.multiblock.power_substation.average_in_hover")))));
                textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.power_substation.average_out", (Object[])new Object[]{FormattingUtil.formatNumbers(Math.abs(this.averageOutLastSec))}).m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"gtceu.multiblock.power_substation.average_out_hover")))));
                if (this.averageInLastSec > this.averageOutLastSec) {
                    BigInteger timeToFillSeconds = energyCapacity.subtract(energyStored).divide(BigInteger.valueOf((this.averageInLastSec - this.averageOutLastSec) * 20L));
                    textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.power_substation.time_to_fill", (Object[])new Object[]{PowerSubstationMachine.getTimeToFillDrainText(timeToFillSeconds)}));
                } else if (this.averageInLastSec < this.averageOutLastSec) {
                    BigInteger timeToDrainSeconds = energyStored.divide(BigInteger.valueOf((this.averageOutLastSec - this.averageInLastSec) * 20L));
                    textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.power_substation.time_to_drain", (Object[])new Object[]{PowerSubstationMachine.getTimeToFillDrainText(timeToDrainSeconds)}));
                }
            }
        }
        this.getDefinition().getAdditionalDisplay().accept(this, textList);
    }

    private static Component getTimeToFillDrainText(BigInteger timeToFillSeconds) {
        String key;
        long fillTime;
        Duration duration;
        if (timeToFillSeconds.compareTo(BIG_INTEGER_MAX_LONG) > 0) {
            timeToFillSeconds = BIG_INTEGER_MAX_LONG;
        }
        if ((duration = Duration.ofSeconds(timeToFillSeconds.longValue())).getSeconds() <= 180L) {
            fillTime = duration.getSeconds();
            key = "gtceu.multiblock.power_substation.time_seconds";
        } else if (duration.toMinutes() <= 180L) {
            fillTime = duration.toMinutes();
            key = "gtceu.multiblock.power_substation.time_minutes";
        } else if (duration.toHours() <= 72L) {
            fillTime = duration.toHours();
            key = "gtceu.multiblock.power_substation.time_hours";
        } else if (duration.toDays() <= 730L) {
            fillTime = duration.toDays();
            key = "gtceu.multiblock.power_substation.time_days";
        } else if (duration.toDays() / 365L < 1000000L) {
            fillTime = duration.toDays() / 365L;
            key = "gtceu.multiblock.power_substation.time_years";
        } else {
            return Component.m_237115_((String)"gtceu.multiblock.power_substation.time_forever");
        }
        return Component.m_237110_((String)key, (Object[])new Object[]{FormattingUtil.formatNumbers(fillTime)});
    }

    public long getPassiveDrain() {
        if (ConfigHolder.INSTANCE.machines.enableMaintenance) {
            if (this.maintenance == null) {
                for (IMultiPart part : this.getParts()) {
                    IMaintenanceMachine maintenanceMachine;
                    if (!(part instanceof IMaintenanceMachine)) continue;
                    this.maintenance = maintenanceMachine = (IMaintenanceMachine)part;
                    break;
                }
            }
            int multiplier = 1 + this.maintenance.getNumMaintenanceProblems();
            double modifier = this.maintenance.getDurationMultiplier();
            return (long)((double)(this.passiveDrain * (long)multiplier) * modifier);
        }
        return this.passiveDrain;
    }

    public String getStored() {
        if (this.energyBank == null) {
            return "0";
        }
        return FormattingUtil.formatNumbers(this.energyBank.getStored());
    }

    public String getCapacity() {
        if (this.energyBank == null) {
            return "0";
        }
        return FormattingUtil.formatNumbers(this.energyBank.getCapacity());
    }

    @Override
    public IEnergyInfoProvider.EnergyInfo getEnergyInfo() {
        return new IEnergyInfoProvider.EnergyInfo(this.energyBank.getCapacity(), this.energyBank.getStored());
    }

    @Override
    public boolean supportsBigIntEnergyValues() {
        return true;
    }

    @Override
    @NotNull
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 190, 125);
        group.addWidget((Widget)new DraggableScrollableWidgetGroup(4, 4, 182, 117).setBackground(this.getScreenTexture()).addWidget((Widget)new LabelWidget(4, 5, this.self().getBlockState().m_60734_().m_7705_())).addWidget((Widget)new ComponentPanelWidget(4, 17, this::addDisplayText).setMaxWidthLimit(150).clickHandler(this::handleDisplayClick)));
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return group;
    }

    @Override
    public ModularUI createUI(Player entityPlayer) {
        return new ModularUI(198, 208, (IUIHolder)this, entityPlayer).widget((Widget)new FancyMachineUIWidget(this, 198, 208));
    }

    @Override
    public List<IFancyUIProvider> getSubTabs() {
        return this.getParts().stream().filter(IFancyUIProvider.class::isInstance).map(IFancyUIProvider.class::cast).toList();
    }

    @Override
    public void attachTooltips(TooltipsPanel tooltipsPanel) {
        for (IMultiPart part : this.getParts()) {
            part.attachFancyTooltipsToController(this, tooltipsPanel);
        }
    }

    @Override
    public void saveCustomPersistedData(@NotNull CompoundTag tag, boolean forDrop) {
        super.saveCustomPersistedData(tag, forDrop);
        CompoundTag bankTag = this.energyBank.writeToNBT(new CompoundTag());
        tag.m_128365_("energyBank", (Tag)bankTag);
    }

    @Override
    public void loadCustomPersistedData(@NotNull CompoundTag tag) {
        super.loadCustomPersistedData(tag);
        this.energyBank.readFromNBT(tag.m_128469_("energyBank"));
    }

    public static class PowerStationEnergyBank
    extends MachineTrait {
        protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(PowerStationEnergyBank.class);
        private static final String NBT_SIZE = "Size";
        private static final String NBT_STORED = "Stored";
        private static final String NBT_MAX = "Max";
        private long[] storage;
        private long[] maximums;
        private BigInteger capacity;
        private int index;

        public PowerStationEnergyBank(MetaMachine machine, List<IBatteryData> batteries) {
            super(machine);
            this.storage = new long[batteries.size()];
            this.maximums = new long[batteries.size()];
            for (int i = 0; i < batteries.size(); ++i) {
                this.maximums[i] = batteries.get(i).getCapacity();
            }
            this.capacity = PowerStationEnergyBank.summarize(this.maximums);
        }

        public void readFromNBT(CompoundTag storageTag) {
            int size = storageTag.m_128451_(NBT_SIZE);
            this.storage = new long[size];
            this.maximums = new long[size];
            for (int i = 0; i < size; ++i) {
                CompoundTag subtag = storageTag.m_128469_(String.valueOf(i));
                if (subtag.m_128441_(NBT_STORED)) {
                    this.storage[i] = subtag.m_128454_(NBT_STORED);
                }
                this.maximums[i] = subtag.m_128454_(NBT_MAX);
            }
            this.capacity = PowerStationEnergyBank.summarize(this.maximums);
        }

        public CompoundTag writeToNBT(CompoundTag compound) {
            compound.m_128405_(NBT_SIZE, this.storage.length);
            for (int i = 0; i < this.storage.length; ++i) {
                CompoundTag subtag = new CompoundTag();
                if (this.storage[i] > 0L) {
                    subtag.m_128356_(NBT_STORED, this.storage[i]);
                }
                subtag.m_128356_(NBT_MAX, this.maximums[i]);
                compound.m_128365_(String.valueOf(i), (Tag)subtag);
            }
            return compound;
        }

        public PowerStationEnergyBank rebuild(@NotNull List<IBatteryData> batteries) {
            if (batteries.isEmpty()) {
                throw new IllegalArgumentException("Cannot rebuild Power Substation power bank with no batteries!");
            }
            PowerStationEnergyBank newStorage = new PowerStationEnergyBank(this.machine, batteries);
            for (long stored : this.storage) {
                newStorage.fill(stored);
            }
            return newStorage;
        }

        public long fill(long amount) {
            long maxFill;
            if (amount < 0L) {
                throw new IllegalArgumentException("Amount cannot be negative!");
            }
            if (this.index != this.storage.length - 1 && this.storage[this.index] == this.maximums[this.index]) {
                ++this.index;
            }
            if ((maxFill = Math.min(this.maximums[this.index] - this.storage[this.index], amount)) == 0L && this.index == this.storage.length - 1) {
                return 0L;
            }
            int n = this.index;
            this.storage[n] = this.storage[n] + maxFill;
            if ((amount -= maxFill) > 0L && this.index != this.storage.length - 1) {
                return maxFill + this.fill(amount);
            }
            return maxFill;
        }

        public long drain(long amount) {
            long maxDrain;
            if (amount < 0L) {
                throw new IllegalArgumentException("Amount cannot be negative!");
            }
            if (this.index != 0 && this.storage[this.index] == 0L) {
                --this.index;
            }
            if ((maxDrain = Math.min(this.storage[this.index], amount)) == 0L && this.index == 0) {
                return 0L;
            }
            int n = this.index;
            this.storage[n] = this.storage[n] - maxDrain;
            if ((amount -= maxDrain) > 0L && this.index != 0) {
                --this.index;
                return maxDrain + this.drain(amount);
            }
            return maxDrain;
        }

        public BigInteger getStored() {
            return PowerStationEnergyBank.summarize(this.storage);
        }

        public boolean hasEnergy() {
            for (long l : this.storage) {
                if (l <= 0L) continue;
                return true;
            }
            return false;
        }

        private static BigInteger summarize(long[] values) {
            BigInteger retVal = BigInteger.ZERO;
            long currentSum = 0L;
            for (long value : values) {
                if (currentSum != 0L && value > Long.MAX_VALUE - currentSum) {
                    retVal = retVal.add(BigInteger.valueOf(currentSum));
                    currentSum = 0L;
                }
                currentSum += value;
            }
            if (currentSum != 0L) {
                retVal = retVal.add(BigInteger.valueOf(currentSum));
            }
            return retVal;
        }

        @VisibleForTesting
        public long getPassiveDrainPerTick() {
            long[] maximumsExcl = new long[this.maximums.length];
            int index = 0;
            int numExcl = 0;
            for (long maximum : this.maximums) {
                if (maximum / 172800000L >= 100000L) {
                    ++numExcl;
                    continue;
                }
                maximumsExcl[index++] = maximum;
            }
            maximumsExcl = Arrays.copyOf(maximumsExcl, index);
            BigInteger capacityExcl = PowerStationEnergyBank.summarize(maximumsExcl);
            return capacityExcl.divide(BigInteger.valueOf(172800000L)).add(BigInteger.valueOf(100000L * (long)numExcl)).longValue();
        }

        public ManagedFieldHolder getFieldHolder() {
            return MANAGED_FIELD_HOLDER;
        }

        public BigInteger getCapacity() {
            return this.capacity;
        }
    }

    public static class BatteryMatchWrapper {
        private final IBatteryData partType;
        private int amount;

        public BatteryMatchWrapper(IBatteryData partType) {
            this.partType = partType;
        }

        public BatteryMatchWrapper increment() {
            ++this.amount;
            return this;
        }
    }
}

