/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.electric;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.IWorkable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.cover.filter.ItemFilter;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.WidgetUtils;
import com.gregtechceu.gtceu.api.gui.editor.EditableMachineUI;
import com.gregtechceu.gtceu.api.gui.editor.EditableUI;
import com.gregtechceu.gtceu.api.gui.widget.IntInputWidget;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.TieredEnergyMachine;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputItem;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ItemCollectorMachine
extends TieredEnergyMachine
implements IAutoOutputItem,
IFancyUIMachine,
IMachineLife,
IWorkable {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ItemCollectorMachine.class, TieredEnergyMachine.MANAGED_FIELD_HOLDER);
    private static final int[] INVENTORY_SIZES = new int[]{4, 9, 16, 25, 25};
    private static final double MOTION_MULTIPLIER = 0.04;
    private static final int BASE_EU_CONSUMPTION = 6;
    @Persisted
    @DescSynced
    @RequireRerender
    protected Direction outputFacingItems;
    @Persisted
    @DescSynced
    @RequireRerender
    protected boolean autoOutputItems;
    @Persisted
    protected final NotifiableItemStackHandler output;
    @Persisted
    protected final ItemStackTransfer chargerInventory;
    @Persisted
    protected final ItemStackTransfer filterInventory;
    @Nullable
    protected TickableSubscription autoOutputSubs;
    @Nullable
    protected TickableSubscription batterySubs;
    @Nullable
    protected TickableSubscription collectionSubs;
    @Nullable
    protected ISubscription exportItemSubs;
    @Nullable
    protected ISubscription energySubs;
    private final long energyPerTick;
    private final int inventorySize = INVENTORY_SIZES[Mth.m_14045_((int)this.getTier(), (int)0, (int)(INVENTORY_SIZES.length - 1))];
    private AABB aabb;
    @Persisted
    @DescSynced
    private int range;
    private boolean rangeDirty = false;
    private final int maxRange;
    @Persisted
    @DescSynced
    private boolean isWorkingEnabled = true;
    @DescSynced
    @Persisted
    @RequireRerender
    private boolean active = false;
    public static BiFunction<ResourceLocation, Integer, EditableMachineUI> EDITABLE_UI_CREATOR = Util.m_143821_((path, inventorySize) -> new EditableMachineUI("misc", (ResourceLocation)path, () -> {
        WidgetGroup template = ItemCollectorMachine.createTemplate(inventorySize).createDefault();
        ProgressWidget energyBar = ItemCollectorMachine.createEnergyBar().createDefault();
        SlotWidget batterySlot = ItemCollectorMachine.createBatterySlot().createDefault();
        WidgetGroup energyGroup = new WidgetGroup(0, 0, energyBar.getSize().width, energyBar.getSize().height + 20);
        batterySlot.setSelfPosition(new Position((energyBar.getSize().width - 18) / 2, energyBar.getSize().height + 1));
        energyGroup.addWidget((Widget)energyBar);
        energyGroup.addWidget((Widget)batterySlot);
        WidgetGroup group = new WidgetGroup(0, 0, Math.max(energyGroup.getSize().width + template.getSize().width + 4 + 8, 172), Math.max(template.getSize().height + 8 + 30, energyGroup.getSize().height + 8));
        Size size = group.getSize();
        energyGroup.setSelfPosition(new Position(3, (size.height - energyGroup.getSize().height) / 2));
        template.setSelfPosition(new Position((size.width - energyGroup.getSize().width - 4 - template.getSize().width) / 2 + 2 + energyGroup.getSize().width + 2, (size.height - template.getSize().height) / 2 + 15));
        group.addWidget((Widget)energyGroup);
        group.addWidget((Widget)template);
        return group;
    }, (template, machine) -> {
        if (machine instanceof ItemCollectorMachine) {
            ItemCollectorMachine itemCollectorMachine = (ItemCollectorMachine)machine;
            ItemCollectorMachine.createTemplate(inventorySize).setupUI((WidgetGroup)template, itemCollectorMachine);
            ItemCollectorMachine.createEnergyBar().setupUI((WidgetGroup)template, itemCollectorMachine);
            ItemCollectorMachine.createBatterySlot().setupUI((WidgetGroup)template, itemCollectorMachine);
            IntInputWidget rangeSelector = new IntInputWidget((template.getSize().width - 80) / 2, 5, 80, 20, itemCollectorMachine::getRange, itemCollectorMachine::setRange);
            rangeSelector.setMin(1);
            rangeSelector.setMax(itemCollectorMachine.maxRange);
            template.addWidget((Widget)rangeSelector);
        }
    }));

    public ItemCollectorMachine(IMachineBlockEntity holder, int tier, Object ... ignoredArgs) {
        super(holder, tier, new Object[0]);
        this.energyPerTick = 6L * (1L << tier - 1);
        this.output = this.createOutputItemHandler();
        this.chargerInventory = this.createChargerItemHandler();
        this.filterInventory = this.createFilterItemHandler();
        this.range = this.maxRange = (int)Math.pow(2.0, tier + 2);
        this.setOutputFacingItems(this.getFrontFacing());
    }

    protected ItemStackTransfer createChargerItemHandler() {
        ItemStackTransfer transfer = new ItemStackTransfer();
        transfer.setFilter(item -> GTCapabilityHelper.getElectricItem(item) != null || ConfigHolder.INSTANCE.compat.energy.nativeEUToPlatformNative && GTCapabilityHelper.getForgeEnergyItem(item) != null);
        return transfer;
    }

    protected ItemStackTransfer createFilterItemHandler() {
        ItemStackTransfer transfer = new ItemStackTransfer();
        transfer.setFilter(item -> item.m_150930_(GTItems.ITEM_FILTER.m_5456_()) || item.m_150930_(GTItems.ORE_DICTIONARY_FILTER.m_5456_()));
        return transfer;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected NotifiableItemStackHandler createOutputItemHandler() {
        return new NotifiableItemStackHandler(this, this.inventorySize, IO.BOTH, IO.OUT);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.isRemote()) {
            return;
        }
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, () -> {
                this.updateAutoOutputSubscription();
                this.updateCollectionSubscription();
            }));
        }
        this.exportItemSubs = this.output.addChangedListener(this::updateAutoOutputSubscription);
        this.energySubs = this.energyContainer.addChangedListener(() -> {
            this.updateBatterySubscription();
            this.updateCollectionSubscription();
        });
        this.chargerInventory.setOnContentsChanged(this::updateBatterySubscription);
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.energySubs != null) {
            this.energySubs.unsubscribe();
            this.energySubs = null;
        }
        if (this.exportItemSubs != null) {
            this.exportItemSubs.unsubscribe();
            this.exportItemSubs = null;
        }
    }

    @Override
    public boolean shouldWeatherOrTerrainExplosion() {
        return false;
    }

    @Override
    public void onMachineRemoved() {
        this.clearInventory((IItemTransfer)this.chargerInventory);
        this.clearInventory((IItemTransfer)this.output.storage);
    }

    public void updateCollectionSubscription() {
        if (this.drainEnergy(true) && this.isWorkingEnabled) {
            this.collectionSubs = this.subscribeServerTick(this.collectionSubs, this::update);
            this.active = true;
        } else if (this.collectionSubs != null) {
            this.collectionSubs.unsubscribe();
            this.collectionSubs = null;
            this.active = false;
        }
    }

    public void update() {
        if (this.drainEnergy(false)) {
            if (this.aabb == null || this.rangeDirty) {
                this.rangeDirty = false;
                BlockPos pos1 = this.getPos().m_7918_(-this.range, 0, -this.range);
                BlockPos pos2 = this.getPos().m_7918_(this.range, 2, this.range);
                this.aabb = AABB.m_82321_((BoundingBox)BoundingBox.m_162375_((Vec3i)pos1, (Vec3i)pos2));
            }
            this.moveItemsInRange();
            this.updateCollectionSubscription();
        }
    }

    public void moveItemsInRange() {
        ItemFilter filter = null;
        if (!this.filterInventory.getStackInSlot(0).m_41619_()) {
            filter = ItemFilter.loadFilter(this.filterInventory.getStackInSlot(0));
        }
        BlockPos centerPos = this.self().getPos().m_7494_();
        List itemEntities = this.getLevel().m_45976_(ItemEntity.class, this.aabb);
        for (ItemEntity itemEntity : itemEntities) {
            if (!itemEntity.m_6084_() || filter != null && !filter.test(itemEntity.m_32055_())) continue;
            double distX = (double)centerPos.m_123341_() + 0.5 - itemEntity.m_20182_().f_82479_;
            double distZ = (double)centerPos.m_123343_() + 0.5 - itemEntity.m_20182_().f_82481_;
            double dist = Math.sqrt(Math.pow(distX, 2.0) + Math.pow(distZ, 2.0));
            if (dist >= (double)0.7f) {
                if (itemEntity.f_31986_ == Short.MAX_VALUE) continue;
                double dirX = distX / dist;
                double dirZ = distZ / dist;
                Vec3 delta = itemEntity.m_20184_();
                itemEntity.m_20334_(dirX * 0.04 * (double)this.tier, delta.f_82480_, dirZ * 0.04 * (double)this.tier);
                itemEntity.m_32010_(1);
                continue;
            }
            ItemStack stack = itemEntity.m_32055_();
            if (!this.canFillOutput(stack)) continue;
            ItemStack remainder = this.fillOutput(stack);
            if (remainder.m_41619_()) {
                itemEntity.m_6074_();
                continue;
            }
            if (stack.m_41613_() <= remainder.m_41613_()) continue;
            itemEntity.m_32045_(remainder);
        }
    }

    private boolean canFillOutput(ItemStack stack) {
        for (int i = 0; i < this.output.getSlots(); ++i) {
            if (this.output.insertItemInternal(i, stack, true).m_41613_() >= stack.m_41613_()) continue;
            return true;
        }
        return false;
    }

    private ItemStack fillOutput(ItemStack stack) {
        for (int i = 0; i < this.output.getSlots(); ++i) {
            if (this.output.insertItemInternal(i, stack, true).m_41613_() >= stack.m_41613_()) continue;
            return this.output.insertItemInternal(i, stack, false);
        }
        return ItemStack.f_41583_;
    }

    public boolean drainEnergy(boolean simulate) {
        long resultEnergy = this.energyContainer.getEnergyStored() - this.energyPerTick;
        if (resultEnergy >= 0L && resultEnergy <= this.energyContainer.getEnergyCapacity()) {
            if (!simulate) {
                this.energyContainer.removeEnergy(this.energyPerTick);
            }
            return true;
        }
        return false;
    }

    @Override
    public void setAutoOutputItems(boolean allow) {
        this.autoOutputItems = allow;
        this.updateAutoOutputSubscription();
    }

    @Override
    public boolean isAllowInputFromOutputSideItems() {
        return false;
    }

    @Override
    public void setAllowInputFromOutputSideItems(boolean allow) {
    }

    @Override
    public void setOutputFacingItems(@Nullable Direction outputFacing) {
        this.outputFacingItems = outputFacing;
        this.updateAutoOutputSubscription();
    }

    protected void updateBatterySubscription() {
        if (this.energyContainer.dischargeOrRechargeEnergyContainers((IItemTransfer)this.chargerInventory, 0, true)) {
            this.batterySubs = this.subscribeServerTick(this.batterySubs, this::chargeBattery);
        } else if (this.batterySubs != null) {
            this.batterySubs.unsubscribe();
            this.batterySubs = null;
        }
    }

    protected void updateAutoOutputSubscription() {
        Direction outputFacing = this.getOutputFacingItems();
        if (this.isAutoOutputItems() && !this.output.isEmpty() && outputFacing != null && ItemTransferHelper.getItemTransfer((Level)this.getLevel(), (BlockPos)this.getPos().m_121945_(outputFacing), (Direction)outputFacing.m_122424_()) != null) {
            this.autoOutputSubs = this.subscribeServerTick(this.autoOutputSubs, this::autoOutput);
        } else if (this.autoOutputSubs != null) {
            this.autoOutputSubs.unsubscribe();
            this.autoOutputSubs = null;
        }
    }

    protected void autoOutput() {
        if (this.getOffsetTimer() % 5L == 0L) {
            if (this.isAutoOutputItems() && this.getOutputFacingItems() != null) {
                this.output.exportToNearby(this.getOutputFacingItems());
            }
            this.updateAutoOutputSubscription();
        }
    }

    protected void chargeBattery() {
        if (!this.energyContainer.dischargeOrRechargeEnergyContainers((IItemTransfer)this.chargerInventory, 0, false)) {
            this.updateBatterySubscription();
        }
    }

    @Override
    public boolean isFacingValid(Direction facing) {
        if (facing == this.getOutputFacingItems()) {
            return false;
        }
        return super.isFacingValid(facing);
    }

    @Override
    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateAutoOutputSubscription();
    }

    @Override
    public int getProgress() {
        return 0;
    }

    @Override
    public int getMaxProgress() {
        return 0;
    }

    public void setRange(int range) {
        this.range = range;
        this.rangeDirty = true;
    }

    @Override
    public void setWorkingEnabled(boolean workingEnabled) {
        this.isWorkingEnabled = workingEnabled;
        this.updateCollectionSubscription();
    }

    protected static EditableUI<SlotWidget, ItemCollectorMachine> createBatterySlot() {
        return new EditableUI<SlotWidget, ItemCollectorMachine>("battery_slot", SlotWidget.class, () -> {
            SlotWidget slotWidget = new SlotWidget();
            slotWidget.setBackground(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.CHARGER_OVERLAY});
            return slotWidget;
        }, (slotWidget, machine) -> {
            slotWidget.setHandlerSlot((IItemTransfer)machine.chargerInventory, 0);
            slotWidget.setCanPutItems(true);
            slotWidget.setCanTakeItems(true);
            slotWidget.setHoverTooltips((Component[])LangHandler.getMultiLang("gtceu.gui.charger_slot.tooltip", GTValues.VNF[machine.getTier()], GTValues.VNF[machine.getTier()]).toArray(new MutableComponent[0]));
        });
    }

    protected static EditableUI<WidgetGroup, ItemCollectorMachine> createTemplate(int inventorySize) {
        return new EditableUI<WidgetGroup, ItemCollectorMachine>("functional_container", WidgetGroup.class, () -> {
            int rowSize = (int)Math.sqrt(inventorySize);
            WidgetGroup main = new WidgetGroup(0, 0, rowSize * 18 + 8 + 25, rowSize * 18 + 8);
            for (int y = 0; y < rowSize; ++y) {
                for (int x = 0; x < rowSize; ++x) {
                    int index = y * rowSize + x;
                    SlotWidget slotWidget = new SlotWidget();
                    slotWidget.initTemplate();
                    slotWidget.setSelfPosition(new Position(24 + x * 18, 4 + y * 18));
                    slotWidget.setBackground(new IGuiTexture[]{GuiTextures.SLOT});
                    slotWidget.setId("slot_" + index);
                    main.addWidget((Widget)slotWidget);
                }
            }
            SlotWidget filterSlotWidget = new SlotWidget();
            filterSlotWidget.initTemplate();
            filterSlotWidget.setSelfPosition(new Position(4, (main.getSize().height - filterSlotWidget.getSize().height) / 2));
            filterSlotWidget.setBackground(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.FILTER_SLOT_OVERLAY});
            filterSlotWidget.setId("filter_slot");
            main.addWidget((Widget)filterSlotWidget);
            main.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
            return main;
        }, (group, machine) -> {
            WidgetUtils.widgetByIdForEach(group, "^slot_[0-9]+$", SlotWidget.class, slot -> {
                int index = WidgetUtils.widgetIdIndex((Widget)slot);
                if (index >= 0 && index < machine.output.getSlots()) {
                    slot.setHandlerSlot((IItemTransfer)machine.output, index);
                    slot.setCanTakeItems(true);
                    slot.setCanPutItems(false);
                }
            });
            WidgetUtils.widgetByIdForEach(group, "^filter_slot$", SlotWidget.class, slot -> {
                slot.setHandlerSlot((IItemTransfer)machine.filterInventory, 0);
                slot.setCanTakeItems(true);
                slot.setCanPutItems(true);
            });
        });
    }

    @Override
    public ResourceTexture sideTips(Player player, BlockPos pos, BlockState state, Set<GTToolType> toolTypes, Direction side) {
        if (toolTypes.contains(GTToolType.WRENCH)) {
            if (!(player.m_6144_() || this.hasFrontFacing() && side == this.getFrontFacing())) {
                return GuiTextures.TOOL_IO_FACING_ROTATION;
            }
        } else if (toolTypes.contains(GTToolType.SCREWDRIVER)) {
            if (side == this.getOutputFacingItems()) {
                return GuiTextures.TOOL_ALLOW_INPUT;
            }
        } else if (toolTypes.contains(GTToolType.SOFT_MALLET)) {
            return this.isWorkingEnabled ? GuiTextures.TOOL_PAUSE : GuiTextures.TOOL_START;
        }
        return super.sideTips(player, pos, state, toolTypes, side);
    }

    @Override
    protected InteractionResult onWrenchClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        if (!playerIn.m_6144_() && !this.isRemote()) {
            ItemStack tool = playerIn.m_21120_(hand);
            if (tool.m_41773_() >= tool.m_41776_()) {
                return InteractionResult.PASS;
            }
            if (this.hasFrontFacing() && gridSide == this.getFrontFacing()) {
                return InteractionResult.PASS;
            }
            Direction itemFacing = this.outputFacingItems;
            if (gridSide != itemFacing) {
                this.setOutputFacingItems(gridSide);
            } else {
                this.setOutputFacingItems(null);
            }
            return InteractionResult.CONSUME;
        }
        return super.onWrenchClick(playerIn, hand, gridSide, hitResult);
    }

    @Override
    protected InteractionResult onSoftMalletClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        IControllable controllable = GTCapabilityHelper.getControllable(this.getLevel(), this.getPos(), gridSide);
        if (controllable != null) {
            if (!this.isRemote()) {
                controllable.setWorkingEnabled(!controllable.isWorkingEnabled());
                playerIn.m_213846_((Component)Component.m_237115_((String)(controllable.isWorkingEnabled() ? "behaviour.soft_hammer.enabled" : "behaviour.soft_hammer.disabled")));
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public static int[] getINVENTORY_SIZES() {
        return INVENTORY_SIZES;
    }

    @Override
    public Direction getOutputFacingItems() {
        return this.outputFacingItems;
    }

    @Override
    public boolean isAutoOutputItems() {
        return this.autoOutputItems;
    }

    public ItemStackTransfer getChargerInventory() {
        return this.chargerInventory;
    }

    public int getRange() {
        return this.range;
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }
}

