/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.rotation;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.common.item.tool.rotation.ICustomRotationBehavior;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.ApiStatus;

public class CustomBlockRotations {
    private static final Map<Block, ICustomRotationBehavior> CUSTOM_BEHAVIOR_MAP = new Object2ObjectOpenHashMap();
    public static final ICustomRotationBehavior BLOCK_HORIZONTAL_BEHAVIOR = new ICustomRotationBehavior(){

        @Override
        public boolean customRotate(BlockState state, Level world, BlockPos pos, BlockHitResult hitResult) {
            Direction gridSide = ICoverable.determineGridSideHit(hitResult);
            if (gridSide == null) {
                return false;
            }
            if (gridSide.m_122434_() == Direction.Axis.Y) {
                return false;
            }
            if (gridSide != state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)) {
                state = (BlockState)state.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)gridSide);
                world.m_46597_(pos, state);
                return true;
            }
            return false;
        }

        @Override
        public boolean showXOnSide(BlockState state, Direction facing) {
            return state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == facing;
        }
    };
    public static final ICustomRotationBehavior BLOCK_DIRECTIONAL_BEHAVIOR = new ICustomRotationBehavior(){

        @Override
        public boolean customRotate(BlockState state, Level world, BlockPos pos, BlockHitResult hitResult) {
            Direction gridSide = ICoverable.determineGridSideHit(hitResult);
            if (gridSide == null) {
                return false;
            }
            if (gridSide != state.m_61143_((Property)DirectionalBlock.f_52588_)) {
                state = (BlockState)state.m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)gridSide);
                world.m_46597_(pos, state);
                return true;
            }
            return false;
        }

        @Override
        public boolean showXOnSide(BlockState state, Direction facing) {
            return state.m_61143_((Property)DirectionalBlock.f_52588_) == facing;
        }
    };

    @ApiStatus.Internal
    public static void init() {
        CustomRotations.init();
    }

    public static void registerCustomRotation(Block block, ICustomRotationBehavior behavior) {
        CUSTOM_BEHAVIOR_MAP.put(block, behavior);
    }

    public static ICustomRotationBehavior getCustomRotation(Block block) {
        return CUSTOM_BEHAVIOR_MAP.get(block);
    }

    private static enum CustomRotations {
        PISTON(Blocks.f_50039_, BLOCK_DIRECTIONAL_BEHAVIOR),
        STICKY_PISTON(Blocks.f_50032_, BLOCK_DIRECTIONAL_BEHAVIOR),
        DROPPER(Blocks.f_50286_, BLOCK_DIRECTIONAL_BEHAVIOR),
        DISPENSER(Blocks.f_50061_, BLOCK_DIRECTIONAL_BEHAVIOR),
        OBSERVER(Blocks.f_50455_, BLOCK_DIRECTIONAL_BEHAVIOR),
        FURNACE(Blocks.f_50094_, BLOCK_HORIZONTAL_BEHAVIOR),
        PUMPKIN(Blocks.f_50143_, BLOCK_HORIZONTAL_BEHAVIOR),
        LIT_PUMPKIN(Blocks.f_50144_, BLOCK_HORIZONTAL_BEHAVIOR),
        CHEST(Blocks.f_50087_, BLOCK_HORIZONTAL_BEHAVIOR),
        TRAPPED_CHEST(Blocks.f_50325_, BLOCK_HORIZONTAL_BEHAVIOR),
        ENDER_CHEST(Blocks.f_50265_, BLOCK_HORIZONTAL_BEHAVIOR),
        HOPPER(Blocks.f_50332_, new ICustomRotationBehavior(){

            @Override
            public boolean customRotate(BlockState state, Level world, BlockPos pos, BlockHitResult hitResult) {
                Direction gridSide = ICoverable.determineGridSideHit(hitResult);
                if (gridSide == null || gridSide == Direction.UP) {
                    return false;
                }
                if (gridSide != state.m_61143_((Property)HopperBlock.f_54021_)) {
                    state = (BlockState)state.m_61124_((Property)HopperBlock.f_54021_, (Comparable)gridSide);
                    world.m_46597_(pos, state);
                    return true;
                }
                return false;
            }

            @Override
            public boolean showXOnSide(BlockState state, Direction facing) {
                return state.m_61143_((Property)HopperBlock.f_54021_) == facing;
            }
        });


        private CustomRotations(Block block, ICustomRotationBehavior behavior) {
            CustomBlockRotations.registerCustomRotation(block, behavior);
        }

        private static void init() {
        }
    }
}

