/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.armor;

import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.item.armor.ArmorComponentItem;
import com.gregtechceu.gtceu.api.item.armor.ArmorUtils;
import com.gregtechceu.gtceu.api.item.armor.IArmorLogic;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.IDurabilityBar;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.api.item.component.IItemHUDProvider;
import com.gregtechceu.gtceu.api.item.component.ISubItemHandler;
import com.gregtechceu.gtceu.api.item.component.forge.IComponentCapability;
import com.gregtechceu.gtceu.api.misc.FluidRecipeHandler;
import com.gregtechceu.gtceu.api.misc.IgnoreEnergyRecipeHandler;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.item.armor.IJetpack;
import com.gregtechceu.gtceu.utils.GradientUtil;
import com.gregtechceu.gtceu.utils.input.KeyBind;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.fluid.forge.FluidHelperImpl;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import java.util.Collections;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PowerlessJetpack
implements IArmorLogic,
IJetpack,
IItemHUDProvider {
    public static final int tankCapacity = 16000;
    private GTRecipe previousRecipe = null;
    private GTRecipe currentRecipe = null;
    private int burnTimer = 0;
    @OnlyIn(value=Dist.CLIENT)
    private ArmorUtils.ModularHUD HUD;

    public PowerlessJetpack() {
        if (Platform.isClient()) {
            this.HUD = new ArmorUtils.ModularHUD();
        }
    }

    @Override
    public void onArmorTick(Level world, Player player, @NotNull ItemStack stack) {
        IFluidTransfer internalTank = FluidTransferHelper.getFluidTransfer((IItemTransfer)new ItemStackTransfer(stack), (int)0);
        if (internalTank == null) {
            return;
        }
        CompoundTag data = stack.m_41784_();
        if (data.m_128441_("burnTimer")) {
            this.burnTimer = data.m_128448_("burnTimer");
        }
        if (!data.m_128441_("enabled")) {
            data.m_128379_("enabled", true);
            data.m_128379_("hover", false);
            data.m_128344_("toggleTimer", (byte)0);
        }
        boolean jetpackEnabled = data.m_128471_("enabled");
        boolean hoverMode = data.m_128471_("hover");
        int toggleTimer = data.m_128445_("toggleTimer");
        String messageKey = null;
        if (toggleTimer == 0) {
            if (KeyBind.JETPACK_ENABLE.isKeyDown(player)) {
                jetpackEnabled = !jetpackEnabled;
                messageKey = "metaarmor.jetpack.flight." + (jetpackEnabled ? "enable" : "disable");
                data.m_128379_("enabled", jetpackEnabled);
            } else if (KeyBind.ARMOR_HOVER.isKeyDown(player)) {
                hoverMode = !hoverMode;
                messageKey = "metaarmor.jetpack.hover." + (hoverMode ? "enable" : "disable");
                data.m_128379_("hover", hoverMode);
            }
            if (messageKey != null) {
                toggleTimer = 5;
                if (!world.f_46443_) {
                    player.m_5661_((Component)Component.m_237115_((String)messageKey), true);
                }
            }
        }
        if (toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
        }
        data.m_128344_("toggleTimer", (byte)toggleTimer);
        if (this.currentRecipe == null) {
            this.findNewRecipe(stack);
        }
        this.performFlying(player, jetpackEnabled, hoverMode, stack);
        data.m_128376_("burnTimer", (short)this.burnTimer);
    }

    @Override
    public ArmorItem.Type getArmorType() {
        return ArmorItem.Type.CHESTPLATE;
    }

    @Override
    public int getArmorDisplay(Player player, @NotNull ItemStack armor, EquipmentSlot slot) {
        return 0;
    }

    @Override
    public void addToolComponents(@NotNull ArmorComponentItem item) {
        item.attachComponents(new Behaviour(16000));
    }

    @Override
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return GTCEu.id("textures/armor/liquid_fuel_jetpack.png");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawHUD(@NotNull ItemStack item, GuiGraphics guiGraphics) {
        IFluidTransfer tank = FluidTransferHelper.getFluidTransfer((IItemTransfer)new ItemStackTransfer(item), (int)0);
        if (tank != null) {
            if (tank.getFluidInTank(0).getAmount() == 0L) {
                return;
            }
            String formated = String.format("%.1f", Float.valueOf((float)tank.getFluidInTank(0).getAmount() * 100.0f / (float)tank.getTankCapacity(0)));
            this.HUD.newString((Component)Component.m_237110_((String)"metaarmor.hud.fuel_lvl", (Object[])new Object[]{formated + "%"}));
            CompoundTag data = item.m_41783_();
            if (data != null) {
                MutableComponent result;
                MutableComponent status;
                if (data.m_128441_("enabled")) {
                    status = data.m_128471_("enabled") ? Component.m_237115_((String)"metaarmor.hud.status.enabled") : Component.m_237115_((String)"metaarmor.hud.status.disabled");
                    result = Component.m_237110_((String)"metaarmor.hud.engine_enabled", (Object[])new Object[]{status});
                    this.HUD.newString((Component)result);
                }
                if (data.m_128441_("hover")) {
                    status = data.m_128471_("hover") ? Component.m_237115_((String)"metaarmor.hud.status.enabled") : Component.m_237115_((String)"metaarmor.hud.status.disabled");
                    result = Component.m_237110_((String)"metaarmor.hud.hover_mode", (Object[])new Object[]{status});
                    this.HUD.newString((Component)result);
                }
            }
        }
        this.HUD.draw(guiGraphics);
        this.HUD.reset();
    }

    @Override
    public int getEnergyPerUse() {
        return 1;
    }

    @Override
    public boolean canUseEnergy(ItemStack stack, int amount) {
        FluidStack fuel = this.getFuel();
        if (fuel == null) {
            return false;
        }
        IFluidTransfer fluidHandlerItem = PowerlessJetpack.getIFluidHandlerItem(stack);
        if (fluidHandlerItem == null) {
            return false;
        }
        FluidStack fluidStack = fluidHandlerItem.drain(fuel, false);
        if (fluidStack.isEmpty()) {
            return false;
        }
        return fluidStack.getAmount() >= fuel.getAmount();
    }

    @Override
    public void drainEnergy(ItemStack stack, int amount) {
        if (this.burnTimer == 0) {
            FluidStack fuel = this.getFuel();
            if (fuel == null) {
                return;
            }
            PowerlessJetpack.getIFluidHandlerItem(stack).drain(fuel, true);
            this.burnTimer = this.currentRecipe.duration;
        }
        --this.burnTimer;
    }

    @Override
    public boolean hasEnergy(ItemStack stack) {
        return this.burnTimer > 0 || this.currentRecipe != null;
    }

    private static IFluidTransfer getIFluidHandlerItem(@NotNull ItemStack stack) {
        return FluidTransferHelper.getFluidTransfer((IItemTransfer)new ItemStackTransfer(stack), (int)0);
    }

    public void findNewRecipe(@NotNull ItemStack stack) {
        IFluidTransfer internalTank = PowerlessJetpack.getIFluidHandlerItem(stack);
        if (internalTank != null) {
            FluidStack fluidStack = internalTank.drain(1L, false);
            if (this.previousRecipe != null && !fluidStack.isEmpty() && ((FluidIngredient)FluidRecipeCapability.CAP.of(this.previousRecipe.getInputContents(FluidRecipeCapability.CAP).get(0))).test(fluidStack) && fluidStack.getAmount() > 0L) {
                this.currentRecipe = this.previousRecipe;
                return;
            }
            if (!fluidStack.isEmpty()) {
                final Table table = Tables.newCustomTable(new EnumMap(IO.class), IdentityHashMap::new);
                FluidRecipeHandler handler = new FluidRecipeHandler(IO.IN, 1, Long.MAX_VALUE);
                handler.getStorages()[0].setFluid(fluidStack);
                table.put((Object)IO.IN, (Object)FluidRecipeCapability.CAP, Collections.singletonList(handler));
                table.put((Object)IO.OUT, (Object)EURecipeCapability.CAP, Collections.singletonList(new IgnoreEnergyRecipeHandler()));
                IRecipeCapabilityHolder holder = new IRecipeCapabilityHolder(){

                    @Override
                    @NotNull
                    public Table<IO, RecipeCapability<?>, List<IRecipeHandler<?>>> getCapabilitiesProxy() {
                        return table;
                    }
                };
                Iterator<GTRecipe> iterator = GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.searchRecipe(holder);
                if (iterator.hasNext()) {
                    GTRecipe nextRecipe = iterator.next();
                    if (nextRecipe == null) {
                        return;
                    }
                    this.currentRecipe = this.previousRecipe = nextRecipe;
                    return;
                }
            }
        }
        this.currentRecipe = null;
    }

    public void resetRecipe() {
        this.currentRecipe = null;
        this.previousRecipe = null;
    }

    public FluidStack getFuel() {
        if (this.currentRecipe != null) {
            List<Content> recipeInputs = this.currentRecipe.inputs.get(FluidRecipeCapability.CAP);
            FluidIngredient fluid = (FluidIngredient)FluidRecipeCapability.CAP.of(recipeInputs.get((int)0).content);
            return fluid.getStacks()[0];
        }
        return FluidStack.empty();
    }

    public static class Behaviour
    implements IDurabilityBar,
    IItemComponent,
    ISubItemHandler,
    IAddInformation,
    IInteractionItem,
    IComponentCapability {
        private static final Predicate<FluidStack> JETPACK_FUEL_FILTER = fluidStack -> {
            final Table table = Tables.newCustomTable(new EnumMap(IO.class), IdentityHashMap::new);
            FluidRecipeHandler handler = new FluidRecipeHandler(IO.IN, 1, Long.MAX_VALUE);
            handler.getStorages()[0].setFluid(fluidStack);
            table.put((Object)IO.IN, (Object)FluidRecipeCapability.CAP, Collections.singletonList(handler));
            table.put((Object)IO.OUT, (Object)EURecipeCapability.CAP, Collections.singletonList(new IgnoreEnergyRecipeHandler()));
            IRecipeCapabilityHolder holder = new IRecipeCapabilityHolder(){

                @Override
                @NotNull
                public Table<IO, RecipeCapability<?>, List<IRecipeHandler<?>>> getCapabilitiesProxy() {
                    return table;
                }
            };
            Iterator<GTRecipe> iterator = GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.searchRecipe(holder);
            return iterator.hasNext() && iterator.next() != null;
        };
        public final int maxCapacity;
        private final Pair<Integer, Integer> durabilityBarColors;

        public Behaviour(int internalCapacity) {
            this.maxCapacity = internalCapacity;
            this.durabilityBarColors = GradientUtil.getGradient(12037896, 10);
        }

        @Override
        public float getDurabilityForDisplay(@NotNull ItemStack itemStack) {
            IFluidTransfer fluidHandlerItem = FluidTransferHelper.getFluidTransfer((IItemTransfer)new ItemStackTransfer(itemStack), (int)0);
            if (fluidHandlerItem == null) {
                return 0.0f;
            }
            FluidStack fluidStack = fluidHandlerItem.getFluidInTank(0);
            return fluidStack.isEmpty() ? 0.0f : (float)fluidStack.getAmount() / (float)fluidHandlerItem.getTankCapacity(0);
        }

        @Override
        @Nullable
        public Pair<Integer, Integer> getDurabilityColorsForDisplay(ItemStack itemStack) {
            return this.durabilityBarColors;
        }

        @Override
        @NotNull
        public <T> LazyOptional<T> getCapability(ItemStack itemStack, @NotNull Capability<T> cap) {
            return ForgeCapabilities.FLUID_HANDLER_ITEM.orEmpty(cap, LazyOptional.of(() -> new FluidHandlerItemStack(itemStack, this.maxCapacity){

                public boolean canFillFluidType(net.minecraftforge.fluids.FluidStack fluid) {
                    return JETPACK_FUEL_FILTER.test(FluidHelperImpl.toFluidStack((net.minecraftforge.fluids.FluidStack)fluid));
                }
            }));
        }

        @Override
        public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
            CompoundTag data = stack.m_41784_();
            boolean enabled = !data.m_128441_("enabled") || data.m_128471_("enabled");
            MutableComponent state = enabled ? Component.m_237115_((String)"metaarmor.hud.status.enabled") : Component.m_237115_((String)"metaarmor.hud.status.disabled");
            tooltipComponents.add((Component)Component.m_237110_((String)"metaarmor.hud.engine_enabled", (Object[])new Object[]{state}));
            boolean hover = data.m_128441_("hover") && data.m_128471_("hover");
            state = hover ? Component.m_237115_((String)"metaarmor.hud.status.enabled") : Component.m_237115_((String)"metaarmor.hud.status.disabled");
            tooltipComponents.add((Component)Component.m_237110_((String)"metaarmor.hud.hover_mode", (Object[])new Object[]{state}));
        }

        @Override
        public void fillItemCategory(Item item, CreativeModeTab category, NonNullList<ItemStack> items) {
            ItemStack copy = item.m_7968_();
            IFluidTransfer fluidHandlerItem = FluidTransferHelper.getFluidTransfer((IItemTransfer)new ItemStackTransfer(copy), (int)0);
            if (fluidHandlerItem != null) {
                fluidHandlerItem.fill(GTMaterials.Diesel.getFluid(16000L), true);
                items.add((Object)copy);
            } else {
                items.add((Object)copy);
            }
        }
    }
}

