/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.armor;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.item.armor.ArmorLogicSuite;
import com.gregtechceu.gtceu.utils.input.KeyBind;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class NightvisionGoggles
extends ArmorLogicSuite {
    public NightvisionGoggles(int energyPerUse, long capacity, int voltageTier, ArmorItem.Type slot) {
        super(energyPerUse, capacity, voltageTier, slot);
    }

    @Override
    public void onArmorTick(Level world, @NotNull Player player, @NotNull ItemStack itemStack) {
        IElectricItem item = GTCapabilityHelper.getElectricItem(itemStack);
        if (item == null) {
            return;
        }
        CompoundTag nbtData = itemStack.m_41784_();
        byte toggleTimer = nbtData.m_128445_("toggleTimer");
        if (!player.m_6844_(EquipmentSlot.HEAD).m_150930_(itemStack.m_41720_())) {
            NightvisionGoggles.disableNightVision(world, player, false);
        }
        if (this.type == ArmorItem.Type.HELMET) {
            boolean nightvision = nbtData.m_128471_("nightVision");
            if (toggleTimer == 0 && KeyBind.ARMOR_MODE_SWITCH.isKeyDown(player)) {
                toggleTimer = 5;
                if (!nightvision && item.getCharge() >= (long)this.energyPerUse) {
                    nightvision = true;
                    if (!world.f_46443_) {
                        player.m_5661_((Component)Component.m_237115_((String)"metaarmor.message.nightvision.enabled"), true);
                    }
                } else if (nightvision) {
                    nightvision = false;
                    NightvisionGoggles.disableNightVision(world, player, true);
                } else if (!world.f_46443_) {
                    player.m_5661_((Component)Component.m_237115_((String)"metaarmor.message.nightvision.error"), true);
                }
                if (!world.f_46443_) {
                    nbtData.m_128379_("nightVision", nightvision);
                }
            }
            if (nightvision && !world.f_46443_ && item.getCharge() >= (long)this.energyPerUse) {
                player.m_21195_(MobEffects.f_19610_);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 999999, 0, true, false));
                item.discharge(this.energyPerUse, this.tier, true, false, false);
            }
            if (toggleTimer > 0) {
                toggleTimer = (byte)(toggleTimer - 1);
            }
            nbtData.m_128344_("toggleTimer", toggleTimer);
        }
    }

    public static void disableNightVision(@NotNull Level world, Player player, boolean sendMsg) {
        if (!world.f_46443_) {
            player.m_21195_(MobEffects.f_19611_);
            if (sendMsg) {
                player.m_5661_((Component)Component.m_237115_((String)"metaarmor.message.nightvision.disabled"), true);
            }
        }
    }

    @Override
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return GTCEu.id("textures/armor/nightvision_goggles.png");
    }

    @Override
    public void addInfo(ItemStack itemStack, List<Component> lines) {
        super.addInfo(itemStack, lines);
        if (this.type == ArmorItem.Type.HELMET) {
            CompoundTag nbtData = itemStack.m_41784_();
            boolean nv = nbtData.m_128471_("nightVision");
            if (nv) {
                lines.add((Component)Component.m_237115_((String)"metaarmor.message.nightvision.enabled"));
            } else {
                lines.add((Component)Component.m_237115_((String)"metaarmor.message.nightvision.disabled"));
            }
        }
    }
}

