/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.item.IComponentItem;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public record CoverPlaceBehavior(CoverDefinition coverDefinition) implements IInteractionItem
{
    @Override
    public InteractionResult onItemUseFirst(ItemStack itemStack, UseOnContext context) {
        Direction coverSide;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction face = context.m_43719_();
        Player player = context.m_43723_();
        ICoverable coverable = GTCapabilityHelper.getCoverable(level, pos, face);
        if (coverable != null && (coverSide = ICoverable.rayTraceCoverableSide(coverable, player)) != null && coverable.getCoverAtSide(coverSide) == null && coverable.canPlaceCoverOnSide(this.coverDefinition, coverSide)) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                boolean result = coverable.placeCoverOnSide(coverSide, itemStack, this.coverDefinition, serverPlayer);
                if (result && !player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
                return result ? InteractionResult.SUCCESS : InteractionResult.FAIL;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static boolean isCoverBehaviorItem(ItemStack itemStack, @Nullable BooleanSupplier hasCoverSupplier, @Nullable Predicate<CoverDefinition> canPlaceCover) {
        block4: {
            block5: {
                block3: {
                    Item item = itemStack.m_41720_();
                    if (!(item instanceof IComponentItem)) break block3;
                    IComponentItem componentItem = (IComponentItem)item;
                    for (IItemComponent component : componentItem.getComponents()) {
                        if (!(component instanceof CoverPlaceBehavior)) continue;
                        CoverPlaceBehavior placeBehavior = (CoverPlaceBehavior)component;
                        if (canPlaceCover != null && !canPlaceCover.test(placeBehavior.coverDefinition)) continue;
                        return true;
                    }
                    break block4;
                }
                if (GTToolType.CROWBAR.itemTags.stream().anyMatch(arg_0 -> ((ItemStack)itemStack).m_204117_(arg_0))) break block5;
                if (GTToolType.SOFT_MALLET.itemTags.stream().anyMatch(arg_0 -> ((ItemStack)itemStack).m_204117_(arg_0))) break block5;
                if (!GTToolType.SCREWDRIVER.itemTags.stream().anyMatch(arg_0 -> ((ItemStack)itemStack).m_204117_(arg_0))) break block4;
            }
            return hasCoverSupplier == null || hasCoverSupplier.getAsBoolean();
        }
        return false;
    }
}

