/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data;

import com.gregtechceu.gtceu.api.capability.IParallelHatch;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.data.medicalcondition.MedicalCondition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IOverclockMachine;
import com.gregtechceu.gtceu.api.machine.feature.ITieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.CoilWorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.OverclockingLogic;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.logic.OCParams;
import com.gregtechceu.gtceu.api.recipe.logic.OCResult;
import com.gregtechceu.gtceu.api.recipe.modifier.ParallelLogic;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifier;
import com.gregtechceu.gtceu.common.capability.EnvironmentalHazardSavedData;
import com.gregtechceu.gtceu.common.data.GTMedicalConditions;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTRecipeModifiers {
    public static final Function<OverclockingLogic, RecipeModifier> ELECTRIC_OVERCLOCK = Util.m_143827_(ElectricOverclockModifier::new);
    public static final RecipeModifier PARALLEL_HATCH = (machine, recipe, params, result) -> GTRecipeModifiers.hatchParallel(machine, recipe, false, params, result);
    public static final BiFunction<MedicalCondition, Integer, RecipeModifier> ENVIRONMENT_REQUIREMENT = Util.m_143821_((condition, maxAllowedStrength) -> (machine, recipe, params, result) -> {
        if (!ConfigHolder.INSTANCE.gameplay.environmentalHazards) {
            return recipe;
        }
        Level level = machine.getLevel();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        EnvironmentalHazardSavedData data = EnvironmentalHazardSavedData.getOrCreate(serverLevel);
        BlockPos machinePos = machine.getPos();
        EnvironmentalHazardSavedData.HazardZone zone = data.getZoneByContainedPosAndCondition(machinePos, (MedicalCondition)condition);
        if (zone == null) {
            return recipe;
        }
        float strength = zone.strength();
        if (strength > (float)maxAllowedStrength.intValue()) {
            return null;
        }
        recipe = recipe.copy();
        int originalDuration = recipe.duration;
        recipe.duration *= 1 + (int)(strength * 5.0f / (float)maxAllowedStrength.intValue());
        if (recipe.duration > 5 * originalDuration) {
            return null;
        }
        return recipe;
    });
    public static final RecipeModifier DEFAULT_ENVIRONMENT_REQUIREMENT = ENVIRONMENT_REQUIREMENT.apply(GTMedicalConditions.CARBON_MONOXIDE_POISONING, 1000);

    public static Pair<GTRecipe, Integer> fastParallel(MetaMachine machine, @NotNull GTRecipe recipe, int maxParallel, boolean modifyDuration) {
        if (machine instanceof IRecipeCapabilityHolder) {
            IRecipeCapabilityHolder holder = (IRecipeCapabilityHolder)((Object)machine);
            while (maxParallel > 0) {
                GTRecipe copied = recipe.copy(ContentModifier.multiplier(maxParallel), modifyDuration);
                if (copied.matchRecipe(holder).isSuccess() && copied.matchTickRecipe(holder).isSuccess()) {
                    return Pair.of((Object)copied, (Object)maxParallel);
                }
                maxParallel /= 2;
            }
        }
        return Pair.of((Object)recipe, (Object)1);
    }

    public static Pair<GTRecipe, Integer> accurateParallel(MetaMachine machine, @NotNull GTRecipe recipe, int maxParallel, boolean modifyDuration) {
        if (maxParallel == 1) {
            return Pair.of((Object)recipe, (Object)1);
        }
        return ParallelLogic.applyParallel(machine, recipe, maxParallel, modifyDuration);
    }

    public static GTRecipe hatchParallel(MetaMachine machine, @NotNull GTRecipe recipe, boolean modifyDuration, @NotNull OCParams params, @NotNull OCResult result) {
        IMultiController controller;
        if (machine instanceof IMultiController && (controller = (IMultiController)((Object)machine)).isFormed()) {
            Optional<IParallelHatch> optional = controller.getParts().stream().filter(IParallelHatch.class::isInstance).map(IParallelHatch.class::cast).findAny();
            if (optional.isPresent()) {
                IParallelHatch hatch = optional.get();
                long recipeEU = RecipeHelper.getInputEUt(recipe);
                Pair<GTRecipe, Integer> parallelRecipe = ParallelLogic.applyParallel(machine, recipe, hatch.getCurrentParallel(), modifyDuration);
                if ((Integer)parallelRecipe.getSecond() == 0) {
                    return null;
                }
                result.init(recipeEU, recipe.duration, (Integer)parallelRecipe.getSecond(), params.getOcAmount());
                return (GTRecipe)parallelRecipe.getFirst();
            }
        }
        return recipe;
    }

    public static GTRecipe crackerOverclock(MetaMachine machine, @NotNull GTRecipe recipe, @NotNull OCParams params, @NotNull OCResult result) {
        if (machine instanceof CoilWorkableElectricMultiblockMachine) {
            CoilWorkableElectricMultiblockMachine coilMachine = (CoilWorkableElectricMultiblockMachine)machine;
            if (RecipeHelper.getRecipeEUtTier(recipe) > coilMachine.getTier()) {
                return null;
            }
            GTRecipe re = RecipeHelper.applyOverclock(new OverclockingLogic((p, r, maxVoltage) -> OverclockingLogic.NON_PERFECT_OVERCLOCK.getLogic().runOverclockingLogic(params, result, maxVoltage)), recipe, coilMachine.getOverclockVoltage(), params, result);
            if (coilMachine.getCoilTier() > 0) {
                result.setEut(Math.max(1L, (long)((double)result.getEut() * (1.0 - (double)coilMachine.getCoilTier() * 0.1))));
            }
            return re;
        }
        return null;
    }

    public static GTRecipe ebfOverclock(MetaMachine machine, @NotNull GTRecipe recipe, @NotNull OCParams params, @NotNull OCResult result) {
        if (machine instanceof CoilWorkableElectricMultiblockMachine) {
            CoilWorkableElectricMultiblockMachine coilMachine = (CoilWorkableElectricMultiblockMachine)machine;
            int blastFurnaceTemperature = coilMachine.getCoilType().getCoilTemperature() + 100 * Math.max(0, coilMachine.getTier() - 2);
            if (!recipe.data.m_128441_("ebf_temp") || recipe.data.m_128451_("ebf_temp") > blastFurnaceTemperature) {
                return null;
            }
            if (RecipeHelper.getRecipeEUtTier(recipe) > coilMachine.getTier()) {
                return null;
            }
            return RecipeHelper.applyOverclock(new OverclockingLogic((p, r, maxVoltage) -> OverclockingLogic.heatingCoilOC(params, result, maxVoltage, blastFurnaceTemperature, recipe.data.m_128441_("ebf_temp") ? recipe.data.m_128451_("ebf_temp") : 0)), recipe, coilMachine.getOverclockVoltage(), params, result);
        }
        return null;
    }

    public static GTRecipe pyrolyseOvenOverclock(MetaMachine machine, @NotNull GTRecipe recipe, @NotNull OCParams params, @NotNull OCResult result) {
        if (machine instanceof CoilWorkableElectricMultiblockMachine) {
            CoilWorkableElectricMultiblockMachine coilMachine = (CoilWorkableElectricMultiblockMachine)machine;
            if (RecipeHelper.getRecipeEUtTier(recipe) > coilMachine.getTier()) {
                return null;
            }
            GTRecipe re = RecipeHelper.applyOverclock(new OverclockingLogic((p, r, maxVoltage) -> OverclockingLogic.NON_PERFECT_OVERCLOCK.getLogic().runOverclockingLogic(params, result, maxVoltage)), recipe, coilMachine.getOverclockVoltage(), params, result);
            int tier = coilMachine.getCoilTier();
            if (coilMachine.getCoilTier() == 0) {
                result.setDuration(Math.max(1, result.getDuration() * 4 / 3));
            } else {
                result.setDuration(Math.max(1, (int)((double)result.getDuration() * 2.0 / (double)(tier + 1))));
            }
            return re;
        }
        return null;
    }

    public static GTRecipe multiSmelterParallel(MetaMachine machine, @NotNull GTRecipe recipe, @NotNull OCParams params, @NotNull OCResult result) {
        if (machine instanceof CoilWorkableElectricMultiblockMachine) {
            CoilWorkableElectricMultiblockMachine coilMachine = (CoilWorkableElectricMultiblockMachine)machine;
            int maxParallel = 32 * coilMachine.getCoilType().getLevel();
            int FURNACE_DURATION = 128;
            Pair<GTRecipe, Integer> parallel = GTRecipeModifiers.accurateParallel(machine, recipe, maxParallel, false);
            recipe = parallel.getFirst() == recipe ? ((GTRecipe)parallel.getFirst()).copy() : (GTRecipe)parallel.getFirst();
            int parallelValue = (Integer)parallel.getSecond();
            long eut = 4 * (parallelValue / 8) / coilMachine.getCoilType().getEnergyDiscount();
            result.init(eut, Math.max(1, 256 * parallelValue / maxParallel), parallelValue, params.getOcAmount());
            return recipe;
        }
        return null;
    }

    @MethodsReturnNonnullByDefault
    @ParametersAreNonnullByDefault
    public static class ElectricOverclockModifier
    implements RecipeModifier {
        private final OverclockingLogic overclockingLogic;

        public ElectricOverclockModifier(OverclockingLogic overclockingLogic) {
            this.overclockingLogic = overclockingLogic;
        }

        @Override
        @Nullable
        public GTRecipe apply(MetaMachine machine, @NotNull GTRecipe recipe, @NotNull OCParams params, @NotNull OCResult result) {
            if (machine instanceof IOverclockMachine) {
                IOverclockMachine overclockMachine = (IOverclockMachine)((Object)machine);
                if (RecipeHelper.getRecipeEUtTier(recipe) > overclockMachine.getMaxOverclockTier()) {
                    return null;
                }
                return RecipeHelper.applyOverclock(this.overclockingLogic, recipe, overclockMachine.getOverclockVoltage(), params, result);
            }
            if (machine instanceof ITieredMachine) {
                ITieredMachine tieredMachine = (ITieredMachine)((Object)machine);
                if (result.getEut() > (long)tieredMachine.getTier()) {
                    return null;
                }
            }
            return recipe;
        }
    }
}

