/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover.voiding;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.cover.filter.FluidFilter;
import com.gregtechceu.gtceu.api.cover.filter.SimpleFluidFilter;
import com.gregtechceu.gtceu.api.gui.widget.EnumSelectorWidget;
import com.gregtechceu.gtceu.api.gui.widget.LongInputWidget;
import com.gregtechceu.gtceu.api.gui.widget.NumberInputWidget;
import com.gregtechceu.gtceu.common.cover.PumpCover;
import com.gregtechceu.gtceu.common.cover.data.BucketMode;
import com.gregtechceu.gtceu.common.cover.data.VoidingMode;
import com.gregtechceu.gtceu.common.cover.voiding.FluidVoidingCover;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class AdvancedFluidVoidingCover
extends FluidVoidingCover {
    @Persisted
    @DescSynced
    private VoidingMode voidingMode = VoidingMode.VOID_ANY;
    @Persisted
    @DescSynced
    protected long globalTransferSizeMillibuckets = 1L;
    @Persisted
    @DescSynced
    private BucketMode transferBucketMode = BucketMode.MILLI_BUCKET;
    private NumberInputWidget<Long> stackSizeInput;
    private EnumSelectorWidget<BucketMode> stackSizeBucketModeInput;
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(AdvancedFluidVoidingCover.class, FluidVoidingCover.MANAGED_FIELD_HOLDER);

    public AdvancedFluidVoidingCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        super(definition, coverHolder, attachedSide);
    }

    @Override
    protected void doVoidFluids() {
        IFluidTransfer fluidTransfer = this.getOwnFluidTransfer();
        if (fluidTransfer == null) {
            return;
        }
        switch (this.voidingMode) {
            case VOID_ANY: {
                this.voidAny(fluidTransfer);
                break;
            }
            case VOID_OVERFLOW: {
                this.voidOverflow(fluidTransfer);
            }
        }
    }

    private void voidOverflow(IFluidTransfer fluidTransfer) {
        Map<FluidStack, Long> fluidAmounts = this.enumerateDistinctFluids(fluidTransfer, PumpCover.TransferDirection.EXTRACT);
        for (FluidStack fluidStack : fluidAmounts.keySet()) {
            long presentAmount = fluidAmounts.get(fluidStack);
            long targetAmount = this.getFilteredFluidAmount(fluidStack) * MILLIBUCKET_SIZE;
            if (targetAmount <= 0L || targetAmount > presentAmount) continue;
            FluidStack toDrain = fluidStack.copy();
            toDrain.setAmount(presentAmount - targetAmount);
            fluidTransfer.drain(toDrain, false);
        }
    }

    private long getFilteredFluidAmount(FluidStack fluidStack) {
        if (!this.filterHandler.isFilterPresent()) {
            return this.globalTransferSizeMillibuckets;
        }
        FluidFilter filter = (FluidFilter)this.filterHandler.getFilter();
        return filter.isBlackList() ? this.globalTransferSizeMillibuckets : filter.testFluidAmount(fluidStack);
    }

    public void setVoidingMode(VoidingMode voidingMode) {
        this.voidingMode = voidingMode;
        this.configureStackSizeInput();
        if (!this.isRemote()) {
            this.configureFilter();
        }
    }

    private void setTransferBucketMode(BucketMode transferBucketMode) {
        long oldMultiplier = this.transferBucketMode.multiplier;
        long newMultiplier = transferBucketMode.multiplier;
        this.transferBucketMode = transferBucketMode;
        if (this.stackSizeInput == null) {
            return;
        }
        this.stackSizeInput.setValue(this.getCurrentBucketModeTransferSize());
    }

    @Override
    @NotNull
    protected String getUITitle() {
        return "cover.fluid.voiding.advanced.title";
    }

    @Override
    protected void buildAdditionalUI(WidgetGroup group) {
        group.addWidget((Widget)new EnumSelectorWidget(146, 20, 20, 20, (Enum[])VoidingMode.values(), (Enum)this.voidingMode, this::setVoidingMode));
        this.stackSizeInput = new LongInputWidget(35, 20, 84, 20, this::getCurrentBucketModeTransferSize, this::setCurrentBucketModeTransferSize).setMin(1L).setMax(Long.MAX_VALUE);
        this.configureStackSizeInput();
        group.addWidget(this.stackSizeInput);
        this.stackSizeBucketModeInput = new EnumSelectorWidget(121, 20, 20, 20, (Enum[])BucketMode.values(), (Enum)this.transferBucketMode, this::setTransferBucketMode);
        group.addWidget(this.stackSizeBucketModeInput);
    }

    private long getCurrentBucketModeTransferSize() {
        return this.globalTransferSizeMillibuckets / this.transferBucketMode.multiplier;
    }

    private void setCurrentBucketModeTransferSize(long transferSize) {
        this.globalTransferSizeMillibuckets = Math.max(transferSize * this.transferBucketMode.multiplier, 0L);
    }

    @Override
    protected void configureFilter() {
        Object f = this.filterHandler.getFilter();
        if (f instanceof SimpleFluidFilter) {
            SimpleFluidFilter filter = (SimpleFluidFilter)f;
            filter.setMaxStackSize(this.voidingMode == VoidingMode.VOID_ANY ? 1L : Long.MAX_VALUE);
        }
        this.configureStackSizeInput();
    }

    private void configureStackSizeInput() {
        if (this.stackSizeInput == null || this.stackSizeBucketModeInput == null) {
            return;
        }
        this.stackSizeInput.setVisible(this.shouldShowStackSize());
        this.stackSizeBucketModeInput.setVisible(this.shouldShowStackSize());
    }

    private boolean shouldShowStackSize() {
        if (this.voidingMode == VoidingMode.VOID_ANY) {
            return false;
        }
        if (!this.filterHandler.isFilterPresent()) {
            return true;
        }
        return ((FluidFilter)this.filterHandler.getFilter()).isBlackList();
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public VoidingMode getVoidingMode() {
        return this.voidingMode;
    }

    public long getGlobalTransferSizeMillibuckets() {
        return this.globalTransferSizeMillibuckets;
    }

    public BucketMode getTransferBucketMode() {
        return this.transferBucketMode;
    }
}

