/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover.detector;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.common.cover.detector.DetectorCover;
import com.gregtechceu.gtceu.utils.RedstoneUtil;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;

public class ItemDetectorCover
extends DetectorCover {
    public ItemDetectorCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        super(definition, coverHolder, attachedSide);
    }

    @Override
    public boolean canAttach() {
        return this.getItemTransfer() != null;
    }

    @Override
    protected void update() {
        if (this.coverHolder.getOffsetTimer() % 20L != 0L) {
            return;
        }
        IItemTransfer itemTransfer = this.getItemTransfer();
        if (itemTransfer == null) {
            return;
        }
        int storedItems = 0;
        int itemCapacity = itemTransfer.getSlots() * itemTransfer.getSlotLimit(0);
        if (itemCapacity == 0) {
            return;
        }
        for (int i = 0; i < itemTransfer.getSlots(); ++i) {
            storedItems += itemTransfer.getStackInSlot(i).m_41613_();
        }
        this.setRedstoneSignalOutput(RedstoneUtil.computeRedstoneValue(storedItems, itemCapacity, this.isInverted()));
    }

    protected IItemTransfer getItemTransfer() {
        return ItemTransferHelper.getItemTransfer((Level)this.coverHolder.getLevel(), (BlockPos)this.coverHolder.getPos(), (Direction)this.attachedSide);
    }
}

