/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.blockentity;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.common.machine.KineticMachineDefinition;
import com.gregtechceu.gtceu.common.registry.GTRegistration;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderRegistry;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.syncdata.managed.MultiManagedStorage;
import com.simibubi.create.content.kinetics.KineticNetwork;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticEffectHandler;
import com.simibubi.create.foundation.utility.Lang;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.util.OneTimeEventReceiver;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KineticMachineBlockEntity
extends KineticBlockEntity
implements IMachineBlockEntity {
    public final MultiManagedStorage managedStorage = new MultiManagedStorage();
    public final MetaMachine metaMachine;
    private final long offset = GTValues.RNG.m_188503_(20);
    public float workingSpeed;
    public boolean reActivateSource;

    protected KineticMachineBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.metaMachine = this.getDefinition().createMetaMachine(this);
    }

    public static KineticMachineBlockEntity create(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        return new KineticMachineBlockEntity(typeIn, pos, state);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        LazyOptional result = MetaMachineBlockEntity.getCapability(this.getMetaMachine(), cap, side);
        return result == null ? super.getCapability(cap, side) : result;
    }

    public static void onBlockEntityRegister(BlockEntityType blockEntityType, NonNullSupplier<BiFunction<MaterialManager, KineticMachineBlockEntity, BlockEntityInstance<? super KineticMachineBlockEntity>>> instanceFactory, boolean renderNormally) {
        if (instanceFactory != null && LDLib.isClient()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> OneTimeEventReceiver.addModListener((AbstractRegistrate)GTRegistration.REGISTRATE, FMLClientSetupEvent.class, $ -> InstancedRenderRegistry.configure((BlockEntityType)blockEntityType).factory((BiFunction)instanceFactory.get()).skipRender(be -> !renderNormally).apply()));
        }
    }

    @Override
    public KineticMachineDefinition getDefinition() {
        return (KineticMachineDefinition)IMachineBlockEntity.super.getDefinition();
    }

    public KineticMachineBlockEntity self() {
        return this;
    }

    public boolean m_7531_(int id, int para) {
        if (id == 1) {
            if (this.f_58857_ != null && this.f_58857_.f_46443_) {
                this.scheduleRenderUpdate();
            }
            return true;
        }
        return false;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public MultiManagedStorage getRootStorage() {
        return this.managedStorage;
    }

    public void invalidate() {
        super.invalidate();
        this.metaMachine.onUnload();
    }

    public void m_6339_() {
        super.m_6339_();
        this.metaMachine.onLoad();
    }

    @Override
    public boolean shouldRenderGrid(Player player, BlockPos pos, BlockState state, ItemStack held, Set<GTToolType> toolTypes) {
        return this.metaMachine.shouldRenderGrid(player, pos, state, held, toolTypes);
    }

    @Override
    public ResourceTexture sideTips(Player player, BlockPos pos, BlockState state, Set<GTToolType> toolTypes, Direction side) {
        return this.metaMachine.sideTips(player, pos, state, toolTypes, side);
    }

    public KineticEffectHandler getEffects() {
        return this.effects;
    }

    public float scheduleWorking(float su, boolean simulate) {
        if (this.getDefinition().isSource()) {
            float speed = Math.min(256.0f, su / this.getDefinition().getTorque());
            if (!simulate) {
                this.workingSpeed = speed;
                this.updateGeneratedRotation();
            }
            return speed * this.getDefinition().getTorque();
        }
        return 0.0f;
    }

    public void scheduleWorking(float su) {
        this.scheduleWorking(su, false);
    }

    public void stopWorking() {
        if (this.getDefinition().isSource() && this.getGeneratedSpeed() != 0.0f) {
            this.workingSpeed = 0.0f;
            this.updateGeneratedRotation();
        }
    }

    public float getGeneratedSpeed() {
        return this.workingSpeed;
    }

    protected void notifyStressCapacityChange(float capacity) {
        this.getOrCreateNetwork().updateCapacityFor((KineticBlockEntity)this, capacity);
    }

    public void removeSource() {
        if (this.getDefinition().isSource() && this.hasSource() && this.isSource()) {
            this.reActivateSource = true;
        }
        super.removeSource();
    }

    public void setSource(BlockPos source) {
        super.setSource(source);
        if (!this.getDefinition().isSource()) {
            return;
        }
        BlockEntity tileEntity = this.f_58857_.m_7702_(source);
        if (tileEntity instanceof KineticBlockEntity) {
            KineticBlockEntity sourceTe = (KineticBlockEntity)tileEntity;
            if (this.reActivateSource && Math.abs(sourceTe.getSpeed()) >= Math.abs(this.getGeneratedSpeed())) {
                this.reActivateSource = false;
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.getDefinition().isSource() && this.reActivateSource) {
            this.updateGeneratedRotation();
            this.reActivateSource = false;
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        float stressBase = this.calculateAddedStressCapacity();
        if (stressBase != 0.0f && IRotate.StressImpact.isEnabled()) {
            Lang.translate((String)"gui.goggles.generator_stats", (Object[])new Object[0]).forGoggles(tooltip);
            Lang.translate((String)"tooltip.capacityProvided", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            float speed = this.getTheoreticalSpeed();
            if (speed != this.getGeneratedSpeed() && speed != 0.0f) {
                stressBase *= this.getGeneratedSpeed() / speed;
            }
            speed = Math.abs(speed);
            float stressTotal = stressBase * speed;
            Lang.number((double)stressTotal).translate("generic.unit.stress", new Object[0]).style(ChatFormatting.AQUA).space().add(Lang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
            added = true;
        }
        return added;
    }

    public void updateGeneratedRotation() {
        if (!this.getDefinition().isSource()) {
            return;
        }
        float speed = this.getGeneratedSpeed();
        float prevSpeed = this.speed;
        if (!this.f_58857_.f_46443_) {
            if (prevSpeed != speed) {
                IRotate.SpeedLevel levelafter;
                IRotate.SpeedLevel levelBefore;
                if (!this.hasSource() && (levelBefore = IRotate.SpeedLevel.of((float)this.speed)) != (levelafter = IRotate.SpeedLevel.of((float)speed))) {
                    this.effects.queueRotationIndicators();
                }
                this.applyNewSpeed(prevSpeed, speed);
            }
            if (this.hasNetwork() && speed != 0.0f) {
                KineticNetwork network = this.getOrCreateNetwork();
                this.notifyStressCapacityChange(this.calculateAddedStressCapacity());
                this.getOrCreateNetwork().updateStressFor((KineticBlockEntity)this, this.calculateStressApplied());
                network.updateStress();
            }
            this.onSpeedChanged(prevSpeed);
            this.sendData();
        }
    }

    public void applyNewSpeed(float prevSpeed, float speed) {
        if (speed == 0.0f) {
            if (this.hasSource()) {
                this.notifyStressCapacityChange(0.0f);
                this.getOrCreateNetwork().updateStressFor((KineticBlockEntity)this, this.calculateStressApplied());
            } else {
                this.detachKinetics();
                this.setSpeed(0.0f);
                this.setNetwork(null);
            }
        } else if (prevSpeed == 0.0f) {
            this.setSpeed(speed);
            this.setNetwork(this.createNetworkId());
            this.attachKinetics();
        } else if (this.hasSource()) {
            if (Math.abs(prevSpeed) >= Math.abs(speed)) {
                if (Math.signum(prevSpeed) != Math.signum(speed)) {
                    this.f_58857_.m_46961_(this.f_58858_, true);
                }
            } else {
                this.detachKinetics();
                this.setSpeed(speed);
                this.source = null;
                this.setNetwork(this.createNetworkId());
                this.attachKinetics();
            }
        } else {
            this.detachKinetics();
            this.setSpeed(speed);
            this.attachKinetics();
        }
    }

    public Long createNetworkId() {
        return this.f_58858_.m_121878_();
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128350_("workingSpeed", this.workingSpeed);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.workingSpeed = compound.m_128441_("workingSpeed") ? compound.m_128457_("workingSpeed") : 0.0f;
    }

    @Override
    public MetaMachine getMetaMachine() {
        return this.metaMachine;
    }
}

