/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.util;

import com.lowdragmc.lowdraglib.client.bakedpipeline.FaceQuad;
import com.mojang.math.Transformation;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.FaceInfo;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockMath;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ForgeFaceData;
import net.minecraftforge.client.model.QuadTransformers;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class StaticFaceBakery {
    public static final AABB SLIGHTLY_OVER_BLOCK = new AABB((double)-0.001f, (double)-0.001f, (double)-0.001f, (double)1.001f, (double)1.001f, (double)1.001f);
    public static final int VERTEX_INT_SIZE = 8;
    private static final float RESCALE_22_5 = 1.0f / (float)Math.cos(0.3926991f) - 1.0f;
    private static final float RESCALE_45 = 1.0f / (float)Math.cos(0.7853981852531433) - 1.0f;
    public static final int VERTEX_COUNT = 4;
    private static final int COLOR_INDEX = 3;
    public static final int UV_INDEX = 4;

    public static BakedQuad bakeFace(AABB cube, Direction face, TextureAtlasSprite sprite, ModelState rotation, int tintIndex, int emissivity, boolean cull, boolean shade) {
        return StaticFaceBakery.bakeQuad(new Vector3f((float)cube.f_82288_ * 16.0f, (float)cube.f_82289_ * 16.0f, (float)cube.f_82290_ * 16.0f), new Vector3f((float)cube.f_82291_ * 16.0f, (float)cube.f_82292_ * 16.0f, (float)cube.f_82293_ * 16.0f), new BlockElementFace((Direction)(cull ? face : null), tintIndex, "", new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0)), sprite, face, rotation, null, shade, emissivity);
    }

    public static BakedQuad bakeFace(Direction face, TextureAtlasSprite sprite, ModelState rotation, int tintIndex, int emissivity, boolean cull, boolean shade) {
        return StaticFaceBakery.bakeFace(FaceQuad.BLOCK, face, sprite, rotation, tintIndex, emissivity, cull, shade);
    }

    public static BakedQuad bakeFace(Direction face, TextureAtlasSprite sprite, ModelState rotation, int tintIndex, int emissivity) {
        return StaticFaceBakery.bakeFace(face, sprite, rotation, tintIndex, emissivity, true, true);
    }

    public static BakedQuad bakeFace(Direction face, TextureAtlasSprite sprite, ModelState rotation, int tintIndex) {
        return StaticFaceBakery.bakeFace(face, sprite, rotation, tintIndex, 0);
    }

    public static BakedQuad bakeFace(Direction face, TextureAtlasSprite sprite, ModelState rotation) {
        return StaticFaceBakery.bakeFace(face, sprite, rotation, -1);
    }

    public static BakedQuad bakeFace(Direction face, TextureAtlasSprite sprite) {
        return StaticFaceBakery.bakeFace(face, sprite, (ModelState)BlockModelRotation.X0_Y0);
    }

    public static BakedQuad bakeQuad(Vector3f posFrom, Vector3f posTo, BlockElementFace face, TextureAtlasSprite sprite, Direction facing, ModelState transform, @Nullable BlockElementRotation partRotation, boolean shade, int emissivity) {
        BlockFaceUV blockfaceuv = face.f_111357_;
        if (transform.m_7538_()) {
            blockfaceuv = StaticFaceBakery.recomputeUVs(face.f_111357_, facing, transform.m_6189_());
        }
        float[] afloat = new float[blockfaceuv.f_111387_.length];
        System.arraycopy(blockfaceuv.f_111387_, 0, afloat, 0, afloat.length);
        float f = sprite.m_118417_();
        float f1 = (blockfaceuv.f_111387_[0] + blockfaceuv.f_111387_[0] + blockfaceuv.f_111387_[2] + blockfaceuv.f_111387_[2]) / 4.0f;
        float f2 = (blockfaceuv.f_111387_[1] + blockfaceuv.f_111387_[1] + blockfaceuv.f_111387_[3] + blockfaceuv.f_111387_[3]) / 4.0f;
        blockfaceuv.f_111387_[0] = Mth.m_14179_((float)f, (float)blockfaceuv.f_111387_[0], (float)f1);
        blockfaceuv.f_111387_[2] = Mth.m_14179_((float)f, (float)blockfaceuv.f_111387_[2], (float)f1);
        blockfaceuv.f_111387_[1] = Mth.m_14179_((float)f, (float)blockfaceuv.f_111387_[1], (float)f2);
        blockfaceuv.f_111387_[3] = Mth.m_14179_((float)f, (float)blockfaceuv.f_111387_[3], (float)f2);
        int[] aint = StaticFaceBakery.makeVertices(blockfaceuv, sprite, facing, StaticFaceBakery.setupShape(posFrom, posTo), transform.m_6189_(), partRotation, shade);
        Direction direction = FaceBakery.m_111612_((int[])aint);
        System.arraycopy(afloat, 0, blockfaceuv.f_111387_, 0, afloat.length);
        if (partRotation == null) {
            StaticFaceBakery.recalculateWinding(aint, direction);
        }
        ForgeHooksClient.fillNormal((int[])aint, (Direction)direction);
        ForgeFaceData data = face.getFaceData();
        BakedQuad quad = new BakedQuad(aint, face.f_111355_, direction, sprite, shade, data.ambientOcclusion());
        if (!ForgeFaceData.DEFAULT.equals((Object)data)) {
            QuadTransformers.applyingLightmap((int)data.blockLight(), (int)data.skyLight()).processInPlace(quad);
            QuadTransformers.applyingColor((int)data.color()).processInPlace(quad);
        }
        com.lowdragmc.lowdraglib.client.bakedpipeline.QuadTransformers.settingEmissivity((int)emissivity).processInPlace(quad);
        return quad;
    }

    public static BlockFaceUV recomputeUVs(BlockFaceUV uv, Direction facing, Transformation modelRotation) {
        float f11;
        float f10;
        float f9;
        float f8;
        Matrix4f matrix4f = BlockMath.m_121844_((Transformation)modelRotation, (Direction)facing, () -> "Unable to resolve UVLock for model").m_252783_();
        float f = uv.m_111392_(uv.m_111398_(0));
        float f1 = uv.m_111396_(uv.m_111398_(0));
        Vector4f vector4f = matrix4f.transform(new Vector4f(f / 16.0f, f1 / 16.0f, 0.0f, 1.0f));
        float f2 = 16.0f * vector4f.x();
        float f3 = 16.0f * vector4f.y();
        float f4 = uv.m_111392_(uv.m_111398_(2));
        float f5 = uv.m_111396_(uv.m_111398_(2));
        Vector4f vector4f1 = matrix4f.transform(new Vector4f(f4 / 16.0f, f5 / 16.0f, 0.0f, 1.0f));
        float f6 = 16.0f * vector4f1.x();
        float f7 = 16.0f * vector4f1.y();
        if (Math.signum(f4 - f) == Math.signum(f6 - f2)) {
            f8 = f2;
            f9 = f6;
        } else {
            f8 = f6;
            f9 = f2;
        }
        if (Math.signum(f5 - f1) == Math.signum(f7 - f3)) {
            f10 = f3;
            f11 = f7;
        } else {
            f10 = f7;
            f11 = f3;
        }
        float f12 = (float)Math.toRadians(uv.f_111388_);
        Matrix3f matrix3f = new Matrix3f((Matrix4fc)matrix4f);
        Vector3f vector3f = matrix3f.transform(new Vector3f(Mth.m_14089_((float)f12), Mth.m_14031_((float)f12), 0.0f));
        int i = Math.floorMod(-((int)Math.round(Math.toDegrees(Math.atan2(vector3f.y(), vector3f.x())) / 90.0)) * 90, 360);
        return new BlockFaceUV(new float[]{f8, f10, f9, f11}, i);
    }

    private static int[] makeVertices(BlockFaceUV uvs, TextureAtlasSprite sprite, Direction orientation, float[] posDiv16, Transformation rotation, @Nullable BlockElementRotation partRotation, boolean shade) {
        int[] aint = new int[32];
        for (int i = 0; i < 4; ++i) {
            StaticFaceBakery.bakeVertex(aint, i, orientation, uvs, posDiv16, sprite, rotation, partRotation, shade);
        }
        return aint;
    }

    private static void bakeVertex(int[] vertexData, int vertexIndex, Direction facing, BlockFaceUV blockFaceUV, float[] posDiv16, TextureAtlasSprite sprite, Transformation rotation, @Nullable BlockElementRotation partRotation, boolean shade) {
        FaceInfo.VertexInfo faceinfo$vertexinfo = FaceInfo.m_108984_((Direction)facing).m_108982_(vertexIndex);
        Vector3f vector3f = new Vector3f(posDiv16[faceinfo$vertexinfo.f_108998_], posDiv16[faceinfo$vertexinfo.f_108999_], posDiv16[faceinfo$vertexinfo.f_109000_]);
        StaticFaceBakery.applyElementRotation(vector3f, partRotation);
        StaticFaceBakery.applyModelRotation(vector3f, rotation);
        StaticFaceBakery.fillVertex(vertexData, vertexIndex, vector3f, sprite, blockFaceUV);
    }

    private static void fillVertex(int[] vertexData, int vertexIndex, Vector3f vector, TextureAtlasSprite sprite, BlockFaceUV blockFaceUV) {
        int i = vertexIndex * 8;
        vertexData[i] = Float.floatToRawIntBits(vector.x());
        vertexData[i + 1] = Float.floatToRawIntBits(vector.y());
        vertexData[i + 2] = Float.floatToRawIntBits(vector.z());
        vertexData[i + 3] = -1;
        vertexData[i + 4] = Float.floatToRawIntBits(sprite.m_118367_((double)blockFaceUV.m_111392_(vertexIndex) * 0.999 + (double)blockFaceUV.m_111392_((vertexIndex + 2) % 4) * 0.001));
        vertexData[i + 4 + 1] = Float.floatToRawIntBits(sprite.m_118393_((double)blockFaceUV.m_111396_(vertexIndex) * 0.999 + (double)blockFaceUV.m_111396_((vertexIndex + 2) % 4) * 0.001));
    }

    private static float[] setupShape(Vector3f min, Vector3f max) {
        float[] afloat = new float[Direction.values().length];
        afloat[FaceInfo.Constants.f_108996_] = min.x() / 16.0f;
        afloat[FaceInfo.Constants.f_108995_] = min.y() / 16.0f;
        afloat[FaceInfo.Constants.f_108994_] = min.z() / 16.0f;
        afloat[FaceInfo.Constants.f_108993_] = max.x() / 16.0f;
        afloat[FaceInfo.Constants.f_108992_] = max.y() / 16.0f;
        afloat[FaceInfo.Constants.f_108991_] = max.z() / 16.0f;
        return afloat;
    }

    private static void applyElementRotation(Vector3f vec, @Nullable BlockElementRotation partRotation) {
        if (partRotation != null) {
            Vector3f vector3f;
            Vector3f vector3f1 = switch (partRotation.f_111379_()) {
                case Direction.Axis.X -> {
                    vector3f = new Vector3f(1.0f, 0.0f, 0.0f);
                    yield new Vector3f(0.0f, 1.0f, 1.0f);
                }
                case Direction.Axis.Y -> {
                    vector3f = new Vector3f(0.0f, 1.0f, 0.0f);
                    yield new Vector3f(1.0f, 0.0f, 1.0f);
                }
                case Direction.Axis.Z -> {
                    vector3f = new Vector3f(0.0f, 0.0f, 1.0f);
                    yield new Vector3f(1.0f, 1.0f, 0.0f);
                }
                default -> throw new IllegalArgumentException("There are only 3 axes");
            };
            Quaternionf quaternionf = new Quaternionf().rotationAxis(partRotation.f_111380_() * ((float)Math.PI / 180), (Vector3fc)vector3f);
            if (partRotation.f_111381_()) {
                if (Math.abs(partRotation.f_111380_()) == 22.5f) {
                    vector3f1.mul(RESCALE_22_5);
                } else {
                    vector3f1.mul(RESCALE_45);
                }
                vector3f1.add(1.0f, 1.0f, 1.0f);
            } else {
                vector3f1.set(1.0f, 1.0f, 1.0f);
            }
            StaticFaceBakery.rotateVertexBy(vec, new Vector3f((Vector3fc)partRotation.f_111378_()), new Matrix4f().rotation((Quaternionfc)quaternionf), vector3f1);
        }
    }

    public static void applyModelRotation(Vector3f pos, Transformation transform) {
        if (transform != Transformation.m_121093_()) {
            StaticFaceBakery.rotateVertexBy(pos, new Vector3f(0.5f, 0.5f, 0.5f), transform.m_252783_(), new Vector3f(1.0f, 1.0f, 1.0f));
        }
    }

    private static void rotateVertexBy(Vector3f pos, Vector3f origin, Matrix4f transform, Vector3f scale) {
        Vector4f vector4f = transform.transform(new Vector4f(pos.x() - origin.x(), pos.y() - origin.y(), pos.z() - origin.z(), 1.0f));
        vector4f.mul((Vector4fc)new Vector4f((Vector3fc)scale, 1.0f));
        pos.set(vector4f.x() + origin.x(), vector4f.y() + origin.y(), vector4f.z() + origin.z());
    }

    private static void recalculateWinding(int[] vertices, Direction direction) {
        int[] aint = new int[vertices.length];
        System.arraycopy(vertices, 0, aint, 0, vertices.length);
        float[] afloat = new float[Direction.values().length];
        afloat[FaceInfo.Constants.f_108996_] = 999.0f;
        afloat[FaceInfo.Constants.f_108995_] = 999.0f;
        afloat[FaceInfo.Constants.f_108994_] = 999.0f;
        afloat[FaceInfo.Constants.f_108993_] = -999.0f;
        afloat[FaceInfo.Constants.f_108992_] = -999.0f;
        afloat[FaceInfo.Constants.f_108991_] = -999.0f;
        for (int i = 0; i < 4; ++i) {
            int j = 8 * i;
            float f = Float.intBitsToFloat(aint[j]);
            float f1 = Float.intBitsToFloat(aint[j + 1]);
            float f2 = Float.intBitsToFloat(aint[j + 2]);
            if (f < afloat[FaceInfo.Constants.f_108996_]) {
                afloat[FaceInfo.Constants.f_108996_] = f;
            }
            if (f1 < afloat[FaceInfo.Constants.f_108995_]) {
                afloat[FaceInfo.Constants.f_108995_] = f1;
            }
            if (f2 < afloat[FaceInfo.Constants.f_108994_]) {
                afloat[FaceInfo.Constants.f_108994_] = f2;
            }
            if (f > afloat[FaceInfo.Constants.f_108993_]) {
                afloat[FaceInfo.Constants.f_108993_] = f;
            }
            if (f1 > afloat[FaceInfo.Constants.f_108992_]) {
                afloat[FaceInfo.Constants.f_108992_] = f1;
            }
            if (!(f2 > afloat[FaceInfo.Constants.f_108991_])) continue;
            afloat[FaceInfo.Constants.f_108991_] = f2;
        }
        FaceInfo faceinfo = FaceInfo.m_108984_((Direction)direction);
        for (int i1 = 0; i1 < 4; ++i1) {
            int j1 = 8 * i1;
            FaceInfo.VertexInfo faceinfo$vertexinfo = faceinfo.m_108982_(i1);
            float f8 = afloat[faceinfo$vertexinfo.f_108998_];
            float f3 = afloat[faceinfo$vertexinfo.f_108999_];
            float f4 = afloat[faceinfo$vertexinfo.f_109000_];
            vertices[j1] = Float.floatToRawIntBits(f8);
            vertices[j1 + 1] = Float.floatToRawIntBits(f3);
            vertices[j1 + 2] = Float.floatToRawIntBits(f4);
            for (int k = 0; k < 4; ++k) {
                int l = 8 * k;
                float f5 = Float.intBitsToFloat(aint[l]);
                float f6 = Float.intBitsToFloat(aint[l + 1]);
                float f7 = Float.intBitsToFloat(aint[l + 2]);
                if (!Mth.m_14033_((float)f8, (float)f5) || !Mth.m_14033_((float)f3, (float)f6) || !Mth.m_14033_((float)f4, (float)f7)) continue;
                vertices[j1 + 4] = aint[l + 4];
                vertices[j1 + 4 + 1] = aint[l + 4 + 1];
            }
        }
    }
}

