/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.renderer.machine.TieredHullMachineRenderer;
import com.gregtechceu.gtceu.common.machine.storage.QuantumTankMachine;
import com.gregtechceu.gtceu.core.mixins.GuiGraphicsAccessor;
import com.lowdragmc.lowdraglib.client.utils.RenderBufferUtils;
import com.lowdragmc.lowdraglib.client.utils.RenderUtils;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.TextFormattingUtil;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class QuantumTankRenderer
extends TieredHullMachineRenderer {
    public QuantumTankRenderer(int tier) {
        super(tier, GTCEu.id("block/machine/quantum_tank"));
    }

    public QuantumTankRenderer(int tier, ResourceLocation modelLocation) {
        super(tier, modelLocation);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasTESR(BlockEntity blockEntity) {
        return true;
    }

    @Override
    public void renderItem(ItemStack stack, ItemDisplayContext transformType, boolean leftHand, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, BakedModel model) {
        model = this.getItemBakedModel();
        if (model != null && stack.m_41782_()) {
            poseStack.m_85836_();
            model.m_7442_().m_269404_(transformType).m_111763_(leftHand, poseStack);
            poseStack.m_85837_(-0.5, -0.5, -0.5);
            FluidStack tank = FluidStack.loadFromTag((CompoundTag)stack.m_41698_("stored"));
            this.renderTank(poseStack, buffer, Direction.NORTH, tank, FluidStack.empty());
            poseStack.m_85849_();
        }
        super.renderItem(stack, transformType, leftHand, poseStack, buffer, combinedLight, combinedOverlay, model);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(BlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        IMachineBlockEntity machineBlockEntity;
        MetaMachine metaMachine;
        if (blockEntity instanceof IMachineBlockEntity && (metaMachine = (machineBlockEntity = (IMachineBlockEntity)blockEntity).getMetaMachine()) instanceof QuantumTankMachine) {
            QuantumTankMachine machine = (QuantumTankMachine)metaMachine;
            this.renderTank(poseStack, buffer, machine.getFrontFacing(), machine.getStored(), machine.getCache().getLockedFluid().getFluid());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderTank(PoseStack poseStack, MultiBufferSource buffer, Direction frontFacing, FluidStack stored, FluidStack locked) {
        FluidStack fluid;
        FluidStack fluidStack = fluid = !stored.isEmpty() ? stored : locked;
        if (fluid.isEmpty()) {
            return;
        }
        TextureAtlasSprite fluidTexture = FluidHelper.getStillTexture((FluidStack)fluid);
        if (fluidTexture == null) {
            fluidTexture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(MissingTextureAtlasSprite.m_118071_());
        }
        poseStack.m_85836_();
        VertexConsumer builder = buffer.m_6299_(Sheets.m_110792_());
        RenderBufferUtils.renderCubeFace((PoseStack)poseStack, (VertexConsumer)builder, (float)0.15625f, (float)0.15625f, (float)0.15625f, (float)0.84375f, (float)0.84375f, (float)0.84375f, (int)(FluidHelper.getColor((FluidStack)fluid) | 0xFF000000), (int)0xF000F0, (TextureAtlasSprite)fluidTexture);
        poseStack.m_85849_();
        poseStack.m_85836_();
        RenderSystem.disableDepthTest();
        poseStack.m_252880_((float)(frontFacing.m_122429_() * -1) / 16.0f, (float)(frontFacing.m_122430_() * -1) / 16.0f, (float)(frontFacing.m_122431_() * -1) / 16.0f);
        RenderUtils.moveToFace((PoseStack)poseStack, (double)0.0, (double)0.0, (double)0.0, (Direction)frontFacing);
        if (frontFacing.m_122434_() == Direction.Axis.Y) {
            RenderUtils.rotateToFace((PoseStack)poseStack, (Direction)frontFacing, (Direction)(frontFacing == Direction.UP ? Direction.SOUTH : Direction.NORTH));
        } else {
            RenderUtils.rotateToFace((PoseStack)poseStack, (Direction)frontFacing, null);
        }
        String amount = stored.isEmpty() ? "*" : TextFormattingUtil.formatLongToCompactString((long)(fluid.getAmount() / (FluidHelper.getBucket() / 1000L)), (int)4);
        poseStack.m_85841_(0.015625f, 0.015625f, 0.0f);
        poseStack.m_252880_(-32.0f, -32.0f, 0.0f);
        new TextTexture(amount).draw(GuiGraphicsAccessor.create(Minecraft.m_91087_(), poseStack, MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_())), 0, 0, 0.0f, 24.0f, 64, 28);
        RenderSystem.enableDepthTest();
        poseStack.m_85849_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float reBakeCustomQuadsOffset() {
        return 0.0f;
    }
}

