/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.renderer.machine.TieredHullMachineRenderer;
import com.gregtechceu.gtceu.common.machine.storage.QuantumChestMachine;
import com.gregtechceu.gtceu.core.mixins.GuiGraphicsAccessor;
import com.lowdragmc.lowdraglib.client.utils.RenderUtils;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.TextFormattingUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

public class QuantumChestRenderer
extends TieredHullMachineRenderer {
    public QuantumChestRenderer(int tier) {
        super(tier, GTCEu.id("block/machine/quantum_chest"));
    }

    public QuantumChestRenderer(int tier, ResourceLocation modelLocation) {
        super(tier, modelLocation);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasTESR(BlockEntity blockEntity) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderItem(ItemStack stack, ItemDisplayContext transformType, boolean leftHand, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, BakedModel model) {
        model = this.getItemBakedModel();
        if (model != null && stack.m_41782_()) {
            poseStack.m_85836_();
            model.m_7442_().m_269404_(transformType).m_111763_(leftHand, poseStack);
            poseStack.m_85837_(-0.5, -0.5, -0.5);
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)stack.m_41698_("stored"));
            int storedAmount = stack.m_41784_().m_128451_("storedAmount");
            float tick = (float)Minecraft.m_91087_().f_91073_.m_46467_() + Minecraft.m_91087_().m_91296_();
            this.renderChest(poseStack, buffer, Direction.NORTH, itemStack, storedAmount, tick, ItemStack.f_41583_);
            poseStack.m_85849_();
        }
        super.renderItem(stack, transformType, leftHand, poseStack, buffer, combinedLight, combinedOverlay, model);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(BlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        IMachineBlockEntity machineBlockEntity;
        MetaMachine metaMachine;
        if (blockEntity instanceof IMachineBlockEntity && (metaMachine = (machineBlockEntity = (IMachineBlockEntity)blockEntity).getMetaMachine()) instanceof QuantumChestMachine) {
            QuantumChestMachine machine = (QuantumChestMachine)metaMachine;
            Level level = machine.getLevel();
            Direction frontFacing = machine.getFrontFacing();
            float tick = (float)level.m_46467_() + partialTicks;
            this.renderChest(poseStack, buffer, frontFacing, machine.getStored(), machine.getStoredAmount(), tick, machine.getLockedItem().getStackInSlot(0));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderChest(PoseStack poseStack, MultiBufferSource buffer, Direction frontFacing, ItemStack stored, int storedAmount, float tick, ItemStack locked) {
        ItemStack itemStack;
        ItemStack itemStack2 = itemStack = !stored.m_41619_() ? stored : locked;
        if (itemStack.m_41619_()) {
            return;
        }
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        poseStack.m_85836_();
        BakedModel bakedmodel = itemRenderer.m_174264_(itemStack, (Level)Minecraft.m_91087_().f_91073_, null, Item.m_41393_((Item)itemStack.m_41720_()) + itemStack.m_41773_());
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_252781_(new Quaternionf().rotateAxis(tick * ((float)Math.PI * 2) / 80.0f, 0.0f, 1.0f, 0.0f));
        poseStack.m_85841_(0.6f, 0.6f, 0.6f);
        itemRenderer.m_115143_(itemStack, ItemDisplayContext.FIXED, false, poseStack, buffer, 0xF000F0, OverlayTexture.f_118083_, bakedmodel);
        poseStack.m_85849_();
        poseStack.m_85836_();
        RenderSystem.disableDepthTest();
        poseStack.m_252880_((float)(frontFacing.m_122429_() * -1) / 16.0f, (float)(frontFacing.m_122430_() * -1) / 16.0f, (float)(frontFacing.m_122431_() * -1) / 16.0f);
        RenderUtils.moveToFace((PoseStack)poseStack, (double)0.0, (double)0.0, (double)0.0, (Direction)frontFacing);
        if (frontFacing.m_122434_() == Direction.Axis.Y) {
            RenderUtils.rotateToFace((PoseStack)poseStack, (Direction)frontFacing, (Direction)(frontFacing == Direction.UP ? Direction.SOUTH : Direction.NORTH));
        } else {
            RenderUtils.rotateToFace((PoseStack)poseStack, (Direction)frontFacing, null);
        }
        String amount = stored.m_41619_() ? "*" : TextFormattingUtil.formatLongToCompactString((long)storedAmount, (int)4);
        poseStack.m_85841_(0.015625f, 0.015625f, 0.0f);
        poseStack.m_252880_(-32.0f, -32.0f, 0.0f);
        new TextTexture(amount).draw(GuiGraphicsAccessor.create(Minecraft.m_91087_(), poseStack, MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_())), 0, 0, 0.0f, 24.0f, 64, 28);
        RenderSystem.enableDepthTest();
        poseStack.m_85849_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float reBakeCustomQuadsOffset() {
        return 0.0f;
    }
}

