/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.client.renderer.machine.TieredHullMachineRenderer;
import com.lowdragmc.lowdraglib.client.renderer.impl.IModelRenderer;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class OverlayTieredActiveMachineRenderer
extends TieredHullMachineRenderer {
    protected IModelRenderer activeOverlayModel;
    protected IModelRenderer overlayModel;

    public OverlayTieredActiveMachineRenderer(int tier, ResourceLocation overlayModel, ResourceLocation activeOverlayModel) {
        super(tier, GTCEu.id("block/machine/hull_machine"));
        this.overlayModel = new IModelRenderer(overlayModel);
        this.activeOverlayModel = new IModelRenderer(activeOverlayModel);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderMachine(List<BakedQuad> quads, MachineDefinition definition, @Nullable MetaMachine machine, Direction frontFacing, @Nullable Direction side, RandomSource rand, Direction modelFacing, ModelState modelState) {
        IMultiPart part;
        super.renderMachine(quads, definition, machine, frontFacing, side, rand, modelFacing, modelState);
        if (machine instanceof IRecipeLogicMachine) {
            IRecipeLogicMachine rlm = (IRecipeLogicMachine)((Object)machine);
            if (rlm.isActive()) {
                quads.addAll(this.activeOverlayModel.getRotatedModel(frontFacing).m_213637_(definition.defaultBlockState(), side, rand));
                return;
            }
        } else if (machine instanceof IMultiPart && (part = (IMultiPart)((Object)machine)).getControllers().stream().anyMatch(controller -> {
            IRecipeLogicMachine rlm;
            return controller instanceof IRecipeLogicMachine && (rlm = (IRecipeLogicMachine)((Object)controller)).isActive();
        })) {
            quads.addAll(this.activeOverlayModel.getRotatedModel(frontFacing).m_213637_(definition.defaultBlockState(), side, rand));
            return;
        }
        quads.addAll(this.overlayModel.getRotatedModel(frontFacing).m_213637_(definition.defaultBlockState(), side, rand));
    }
}

