/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputFluid;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputItem;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.client.model.ItemBakedModel;
import com.gregtechceu.gtceu.client.renderer.block.TextureOverrideRenderer;
import com.gregtechceu.gtceu.client.renderer.cover.ICoverableRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.IPartRenderer;
import com.gregtechceu.gtceu.client.util.StaticFaceBakery;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import com.lowdragmc.lowdraglib.client.model.custommodel.ICTMPredicate;
import com.lowdragmc.lowdraglib.client.renderer.IItemRendererProvider;
import com.lowdragmc.lowdraglib.utils.FacadeBlockAndTintGetter;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class MachineRenderer
extends TextureOverrideRenderer
implements ICoverableRenderer,
IPartRenderer,
ICTMPredicate {
    public static final ResourceLocation PIPE_OVERLAY = GTCEu.id("block/overlay/machine/overlay_pipe");
    public static final ResourceLocation FLUID_OUTPUT_OVERLAY = GTCEu.id("block/overlay/machine/overlay_fluid_output");
    public static final ResourceLocation ITEM_OUTPUT_OVERLAY = GTCEu.id("block/overlay/machine/overlay_item_output");

    public MachineRenderer(ResourceLocation modelLocation) {
        super(modelLocation);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean useBlockLight(ItemStack stack) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean useAO() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderItem(ItemStack stack, ItemDisplayContext transformType, boolean leftHand, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, BakedModel model) {
        Item item = stack.m_41720_();
        if (item instanceof MetaMachineItem) {
            final MetaMachineItem machineItem = (MetaMachineItem)item;
            IItemRendererProvider.disabled.set(true);
            Minecraft.m_91087_().m_91291_().m_115143_(stack, transformType, leftHand, matrixStack, buffer, combinedLight, combinedOverlay, (BakedModel)new ItemBakedModel(){

                @OnlyIn(value=Dist.CLIENT)
                public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction direction, RandomSource random) {
                    LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
                    MachineRenderer.this.renderMachine(quads, machineItem.getDefinition(), null, Direction.NORTH, direction, random, direction, (ModelState)BlockModelRotation.X0_Y0);
                    return quads;
                }
            });
            IItemRendererProvider.disabled.set(false);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public final List<BakedQuad> renderModel(@Nullable BlockAndTintGetter level, @Nullable BlockPos pos, @Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        Block block;
        if (state != null && (block = state.m_60734_()) instanceof MetaMachineBlock) {
            MetaMachine machine;
            MetaMachineBlock machineBlock = (MetaMachineBlock)block;
            Direction frontFacing = machineBlock.getFrontFacing(state);
            MetaMachine metaMachine = machine = level == null || pos == null ? null : machineBlock.getMachine((BlockGetter)level, pos);
            if (machine != null) {
                IAutoOutputFluid autoOutputFluid;
                Direction fluidFace;
                IAutoOutputItem autoOutputItem;
                Direction itemFace;
                MachineDefinition definition = machine.getDefinition();
                ModelState modelState = ModelFactory.getRotation((Direction)frontFacing);
                Direction modelFacing = side == null ? null : ModelFactory.modelFacing((Direction)side, (Direction)frontFacing);
                LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
                this.renderMachine(quads, definition, machine, frontFacing, side, rand, modelFacing, modelState);
                if (machine instanceof IAutoOutputItem && (itemFace = (autoOutputItem = (IAutoOutputItem)((Object)machine)).getOutputFacingItems()) != null && side == itemFace) {
                    quads.add(StaticFaceBakery.bakeFace(StaticFaceBakery.SLIGHTLY_OVER_BLOCK, modelFacing, ModelFactory.getBlockSprite((ResourceLocation)PIPE_OVERLAY), modelState, -1, 0, true, true));
                }
                if (machine instanceof IAutoOutputFluid && (fluidFace = (autoOutputFluid = (IAutoOutputFluid)((Object)machine)).getOutputFacingFluids()) != null && side == fluidFace) {
                    quads.add(StaticFaceBakery.bakeFace(StaticFaceBakery.SLIGHTLY_OVER_BLOCK, modelFacing, ModelFactory.getBlockSprite((ResourceLocation)PIPE_OVERLAY), modelState, -1, 0, true, true));
                }
                if (machine instanceof IAutoOutputItem && (itemFace = (autoOutputItem = (IAutoOutputItem)((Object)machine)).getOutputFacingItems()) != null && side == itemFace && autoOutputItem.isAutoOutputItems()) {
                    quads.add(StaticFaceBakery.bakeFace(StaticFaceBakery.SLIGHTLY_OVER_BLOCK, modelFacing, ModelFactory.getBlockSprite((ResourceLocation)ITEM_OUTPUT_OVERLAY), modelState, -101, 15, true, true));
                }
                if (machine instanceof IAutoOutputFluid && (fluidFace = (autoOutputFluid = (IAutoOutputFluid)((Object)machine)).getOutputFacingFluids()) != null && side == fluidFace && autoOutputFluid.isAutoOutputFluids()) {
                    quads.add(StaticFaceBakery.bakeFace(StaticFaceBakery.SLIGHTLY_OVER_BLOCK, modelFacing, ModelFactory.getBlockSprite((ResourceLocation)FLUID_OUTPUT_OVERLAY), modelState, -101, 15, true, true));
                }
                ICoverableRenderer.super.renderCovers(quads, side, rand, machine.getCoverContainer(), modelFacing, pos, level, modelState);
                return quads;
            }
        }
        return Collections.emptyList();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderBaseModel(List<BakedQuad> quads, MachineDefinition definition, @Nullable MetaMachine machine, Direction frontFacing, @Nullable Direction side, RandomSource rand) {
        quads.addAll(this.getRotatedModel(frontFacing).m_213637_(definition.defaultBlockState(), side, rand));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderMachine(List<BakedQuad> quads, MachineDefinition definition, @Nullable MetaMachine machine, Direction frontFacing, @Nullable Direction side, RandomSource rand, @Nullable Direction modelFacing, ModelState modelState) {
        IMultiPart part;
        if (!(machine instanceof IMultiPart && (part = (IMultiPart)((Object)machine)).replacePartModelWhenFormed() && this.renderReplacedPartMachine(quads, part, frontFacing, side, rand, modelFacing, modelState))) {
            this.renderBaseModel(quads, definition, machine, frontFacing, side, rand);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onPrepareTextureAtlas(ResourceLocation atlasName, Consumer<ResourceLocation> register) {
        super.onPrepareTextureAtlas(atlasName, register);
        if (atlasName.equals((Object)TextureAtlas.f_118259_)) {
            register.accept(PIPE_OVERLAY);
            register.accept(FLUID_OUTPUT_OVERLAY);
            register.accept(ITEM_OUTPUT_OVERLAY);
        }
    }

    public boolean isConnected(BlockAndTintGetter level, BlockState state, BlockPos pos, BlockState sourceState, BlockPos sourcePos, Direction side) {
        BlockState sourceStateAppearance;
        BlockState stateAppearance = FacadeBlockAndTintGetter.getAppearance((BlockState)state, (BlockAndTintGetter)level, (BlockPos)pos, (Direction)side, (BlockState)sourceState, (BlockPos)sourcePos);
        return stateAppearance == (sourceStateAppearance = FacadeBlockAndTintGetter.getAppearance((BlockState)sourceState, (BlockAndTintGetter)level, (BlockPos)sourcePos, (Direction)side, (BlockState)state, (BlockPos)pos));
    }
}

