/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.renderer.machine.OverlayEnergyIORenderer;
import com.gregtechceu.gtceu.client.renderer.machine.TieredHullMachineRenderer;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class BatteryBufferRenderer
extends TieredHullMachineRenderer {
    private final int inventorySize;

    public BatteryBufferRenderer(int tier, int inventorySize) {
        super(tier, GTCEu.id("block/machine/hull_machine"));
        this.inventorySize = inventorySize;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderMachine(List<BakedQuad> quads, MachineDefinition definition, @Nullable MetaMachine machine, Direction frontFacing, @Nullable Direction side, RandomSource rand, Direction modelFacing, ModelState modelState) {
        super.renderMachine(quads, definition, machine, frontFacing, side, rand, modelFacing, modelState);
        if (side == frontFacing && modelFacing != null) {
            OverlayEnergyIORenderer texture = this.inventorySize <= 4 ? OverlayEnergyIORenderer.ENERGY_OUT_4A : (this.inventorySize <= 8 ? OverlayEnergyIORenderer.ENERGY_OUT_8A : OverlayEnergyIORenderer.ENERGY_OUT_16A);
            texture.renderOverlay(quads, modelFacing, modelState, 2);
        }
    }
}

