/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.item;

import com.google.gson.JsonElement;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconSet;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconType;
import com.gregtechceu.gtceu.api.item.TagPrefixItem;
import com.gregtechceu.gtceu.data.pack.GTDynamicResourcePack;
import com.gregtechceu.gtceu.utils.GradientUtil;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.item.Item;

public class TagPrefixItemRenderer {
    private static final Set<TagPrefixItemRenderer> MODELS = new HashSet<TagPrefixItemRenderer>();
    private final Item item;
    private final MaterialIconType type;
    private final MaterialIconSet iconSet;

    public static void create(Item item, MaterialIconType type, MaterialIconSet iconSet) {
        MODELS.add(new TagPrefixItemRenderer(item, type, iconSet));
    }

    public static void reinitModels() {
        for (TagPrefixItemRenderer model : MODELS) {
            ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)model.item);
            GTDynamicResourcePack.addItemModel(itemId, (Supplier<JsonElement>)new DelegatedModel(model.type.getItemModelPath(model.iconSet, true)));
        }
    }

    public static void initTextures() {
        for (TagPrefixItemRenderer model : MODELS) {
            ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)model.item);
            Resource file1 = Minecraft.m_91087_().m_91098_().m_213713_(GTDynamicResourcePack.getTextureLocation(null, model.type.getItemTexturePath(model.iconSet, true))).orElse(null);
            if (file1 == null) continue;
            try {
                InputStream stream1 = file1.m_215507_();
                try {
                    Item item = model.item;
                    if (!(item instanceof TagPrefixItem)) continue;
                    TagPrefixItem prefixItem = (TagPrefixItem)item;
                    int materialRGBA = GradientUtil.argbToRgba(prefixItem.material.getMaterialARGB());
                    int materialSecondaryRGBA = GradientUtil.argbToRgba(prefixItem.material.getMaterialSecondaryARGB());
                    NativeImage image1 = NativeImage.m_85058_((InputStream)stream1);
                    try (NativeImage result = new NativeImage(image1.m_84982_(), image1.m_85084_(), true);){
                        Resource file2;
                        for (int x = 0; x < image1.m_84982_(); ++x) {
                            for (int y = 0; y < image1.m_85084_(); ++y) {
                                int color = image1.m_84985_(x, y);
                                result.m_84988_(x, y, GradientUtil.multiplyBlendRGBA(color, materialRGBA));
                            }
                        }
                        if (prefixItem.material.getMaterialSecondaryARGB() != -1 && (file2 = (Resource)Minecraft.m_91087_().m_91098_().m_213713_(GTDynamicResourcePack.getTextureLocation(null, model.type.getItemTexturePath(model.iconSet, true).m_266382_("_layer2"))).orElse(null)) != null) {
                            try (InputStream stream2 = file2.m_215507_();){
                                NativeImage image2 = NativeImage.m_85058_((InputStream)stream2);
                                for (int x = 0; x < image1.m_84982_(); ++x) {
                                    for (int y = 0; y < image1.m_85084_(); ++y) {
                                        int color = image2.m_84985_(x, y);
                                        result.m_166411_(x, y, GradientUtil.multiplyBlendRGBA(color, materialSecondaryRGBA));
                                    }
                                }
                            }
                        }
                        GTDynamicResourcePack.addItemTexture(itemId, result.m_85121_());
                    }
                }
                finally {
                    if (stream1 == null) continue;
                    stream1.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private TagPrefixItemRenderer(Item item, MaterialIconType type, MaterialIconSet iconSet) {
        this.item = item;
        this.type = type;
        this.iconSet = iconSet;
    }
}

