/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.block;

import com.google.gson.JsonElement;
import com.gregtechceu.gtceu.api.block.MaterialBlock;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconSet;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconType;
import com.gregtechceu.gtceu.data.pack.GTDynamicResourcePack;
import com.gregtechceu.gtceu.utils.GradientUtil;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.level.block.Block;

public class MaterialBlockRenderer {
    public static final String LAYER_2_SUFFIX = "_layer2";
    private static final Set<MaterialBlockRenderer> MODELS = new HashSet<MaterialBlockRenderer>();
    private final Block block;
    private final MaterialIconType type;
    private final MaterialIconSet iconSet;

    public static void create(Block block, MaterialIconType type, MaterialIconSet iconSet) {
        MODELS.add(new MaterialBlockRenderer(block, type, iconSet));
    }

    public static void reinitModels() {
        for (MaterialBlockRenderer model : MODELS) {
            ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)model.block);
            ResourceLocation modelId = blockId.m_246208_("block/");
            GTDynamicResourcePack.addBlockModel(modelId, (Supplier<JsonElement>)new DelegatedModel(model.type.getBlockModelPath(model.iconSet, true)));
            GTDynamicResourcePack.addBlockState(blockId, (Supplier<JsonElement>)BlockModelGenerators.m_124859_((Block)model.block, (ResourceLocation)modelId));
            GTDynamicResourcePack.addItemModel(BuiltInRegistries.f_257033_.m_7981_((Object)model.block.m_5456_()), (Supplier<JsonElement>)new DelegatedModel(ModelLocationUtils.m_125576_((Block)model.block)));
        }
    }

    public static void initTextures() {
        for (MaterialBlockRenderer model : MODELS) {
            ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)model.block);
            Resource file1 = Minecraft.m_91087_().m_91098_().m_213713_(GTDynamicResourcePack.getTextureLocation(null, model.type.getBlockTexturePath(model.iconSet, true))).orElse(null);
            if (file1 == null) continue;
            try {
                InputStream stream1 = file1.m_215507_();
                try {
                    Block block = model.block;
                    if (!(block instanceof MaterialBlock)) continue;
                    MaterialBlock materialBlock = (MaterialBlock)block;
                    int materialRGBA = GradientUtil.argbToRgba(materialBlock.material.getMaterialARGB());
                    NativeImage image1 = NativeImage.m_85058_((InputStream)stream1);
                    try (NativeImage result = new NativeImage(image1.m_84982_(), image1.m_85084_(), true);){
                        for (int x = 0; x < image1.m_84982_(); ++x) {
                            for (int y = 0; y < image1.m_85084_(); ++y) {
                                int color = image1.m_84985_(x, y);
                                result.m_84988_(x, y, GradientUtil.multiplyBlendRGBA(color, materialRGBA));
                            }
                        }
                        if (materialBlock.material.getMaterialSecondaryARGB() != -1) {
                            int materialSecondaryRGBA = GradientUtil.argbToRgba(materialBlock.material.getMaterialSecondaryARGB());
                            Resource file2 = Minecraft.m_91087_().m_91098_().m_213713_(GTDynamicResourcePack.getTextureLocation(null, model.type.getBlockTexturePath(model.iconSet, true).m_266382_(LAYER_2_SUFFIX))).orElse(null);
                            if (file2 != null) {
                                try (InputStream stream2 = file2.m_215507_();){
                                    NativeImage image2 = NativeImage.m_85058_((InputStream)stream2);
                                    for (int x = 0; x < image1.m_84982_(); ++x) {
                                        for (int y = 0; y < image1.m_85084_(); ++y) {
                                            int color = image2.m_84985_(x, y);
                                            result.m_166411_(x, y, GradientUtil.multiplyBlendRGBA(color, materialSecondaryRGBA));
                                        }
                                    }
                                }
                            }
                        }
                        GTDynamicResourcePack.addBlockTexture(blockId, result.m_85121_());
                    }
                }
                finally {
                    if (stream1 == null) continue;
                    stream1.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected MaterialBlockRenderer(Block block, MaterialIconType type, MaterialIconSet iconSet) {
        this.block = block;
        this.type = type;
        this.iconSet = iconSet;
    }
}

