/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.HazardProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.fluids.FluidState;
import com.gregtechceu.gtceu.api.fluids.GTFluid;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidType;

@OnlyIn(value=Dist.CLIENT)
public class TooltipsHandler {
    private static final String ITEM_PREFIX = "item.gtceu";
    private static final String BLOCK_PREFIX = "block.gtceu";

    public static void appendTooltips(ItemStack stack, TooltipFlag flag, List<Component> tooltips) {
        Material material;
        String translationKey;
        Item item;
        UnificationEntry unificationEntry = ChemicalHelper.getUnificationEntry((ItemLike)stack.m_41720_());
        if (unificationEntry != null && unificationEntry.material != null && unificationEntry.material.getChemicalFormula() != null && !unificationEntry.material.getChemicalFormula().isEmpty()) {
            tooltips.add(1, (Component)Component.m_237113_((String)unificationEntry.material.getChemicalFormula()).m_130940_(ChatFormatting.YELLOW));
        }
        if ((item = stack.m_41720_()) instanceof BucketItem) {
            BucketItem bucket = (BucketItem)item;
            TooltipsHandler.appendFluidTooltips(bucket.getFluid(), FluidHelper.getBucket(), tooltips::add, flag);
        }
        if ((translationKey = stack.m_41778_()).startsWith(ITEM_PREFIX) || translationKey.startsWith(BLOCK_PREFIX)) {
            String tooltipKey = translationKey + ".tooltip";
            if (I18n.m_118936_((String)tooltipKey)) {
                tooltips.add(1, (Component)Component.m_237115_((String)tooltipKey));
            } else {
                List<MutableComponent> multiLang = LangHandler.getMultiLang(tooltipKey);
                if (multiLang != null && !multiLang.isEmpty()) {
                    tooltips.addAll(1, multiLang);
                }
            }
        }
        if ((material = HazardProperty.getValidHazardMaterial(stack)) == null) {
            return;
        }
        GTUtil.appendHazardTooltips(material, tooltips);
    }

    public static void appendFluidTooltips(Fluid fluid, long amount, Consumer<Component> tooltips, TooltipFlag flag) {
        FluidType fluidType = fluid.getFluidType();
        Material material = ChemicalHelper.getMaterial(fluid);
        if (material != null) {
            if (material.getChemicalFormula() != null && !material.getChemicalFormula().isEmpty()) {
                tooltips.accept((Component)Component.m_237113_((String)material.getChemicalFormula()).m_130940_(ChatFormatting.YELLOW));
            }
            if (material.hasProperty(PropertyKey.INGOT) && GTUtil.isShiftDown() && amount >= 144L) {
                long ingots = amount / 144L;
                long remainder = amount % 144L;
                Object fluidAmount = String.format(" %,d mB = %,d * %d mB", amount, ingots, 144);
                if (remainder != 0L) {
                    fluidAmount = (String)fluidAmount + String.format(" + %d mB", remainder);
                }
                tooltips.accept((Component)Component.m_237115_((String)"gtceu.gui.fluid_amount").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)fluidAmount)));
            }
            if (fluid instanceof GTFluid) {
                GTFluid attributedFluid = (GTFluid)fluid;
                FluidState state = attributedFluid.getState();
                switch (state) {
                    case LIQUID: {
                        tooltips.accept((Component)Component.m_237115_((String)"gtceu.fluid.state_liquid"));
                        break;
                    }
                    case GAS: {
                        tooltips.accept((Component)Component.m_237115_((String)"gtceu.fluid.state_gas"));
                        break;
                    }
                    case PLASMA: {
                        tooltips.accept((Component)Component.m_237115_((String)"gtceu.fluid.state_plasma"));
                    }
                }
                attributedFluid.getAttributes().forEach(a -> a.appendFluidTooltips(tooltips));
            }
            tooltips.accept((Component)Component.m_237110_((String)"gtceu.fluid.temperature", (Object[])new Object[]{fluidType.getTemperature()}));
            if (fluidType.getTemperature() < 120) {
                tooltips.accept((Component)Component.m_237115_((String)"gtceu.fluid.temperature.cryogenic"));
            }
        }
    }
}

