/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.registry.registrate;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.IMachineBlock;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.gui.editor.EditableMachineUI;
import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.OverclockingLogic;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifier;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifierList;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.registry.registrate.BuilderBase;
import com.gregtechceu.gtceu.api.registry.registrate.CompassNode;
import com.gregtechceu.gtceu.api.registry.registrate.CompassSection;
import com.gregtechceu.gtceu.client.renderer.GTRendererProvider;
import com.gregtechceu.gtceu.client.renderer.machine.MachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.OverlaySteamMachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.OverlayTieredMachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.TieredHullMachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableCasingMachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableSidedCasingMachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableSteamMachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableTieredHullMachineRenderer;
import com.gregtechceu.gtceu.common.data.GTCompassSections;
import com.gregtechceu.gtceu.common.data.GTRecipeModifiers;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.BlockEntityBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MachineBuilder<DEFINITION extends MachineDefinition>
extends BuilderBase<DEFINITION> {
    protected final Registrate registrate;
    protected final String name;
    protected final BiFunction<BlockBehaviour.Properties, DEFINITION, IMachineBlock> blockFactory;
    protected final BiFunction<IMachineBlock, Item.Properties, MetaMachineItem> itemFactory;
    protected final TriFunction<BlockEntityType<?>, BlockPos, BlockState, IMachineBlockEntity> blockEntityFactory;
    protected Function<ResourceLocation, DEFINITION> definitionFactory;
    protected Function<IMachineBlockEntity, MetaMachine> metaMachine;
    @Nullable
    private Supplier<IRenderer> renderer;
    private VoxelShape shape = Shapes.m_83144_();
    private RotationState rotationState = RotationState.NONE;
    private boolean hasTESR;
    private boolean renderMultiblockWorldPreview = true;
    private boolean renderMultiblockXEIPreview = true;
    private NonNullUnaryOperator<BlockBehaviour.Properties> blockProp = p -> p;
    private NonNullUnaryOperator<Item.Properties> itemProp = p -> p;
    private Consumer<BlockBuilder<? extends Block, ?>> blockBuilder;
    private Consumer<ItemBuilder<? extends MetaMachineItem, ?>> itemBuilder;
    private NonNullConsumer<BlockEntityType<BlockEntity>> onBlockEntityRegister = MetaMachineBlockEntity::onBlockEntityRegister;
    private GTRecipeType[] recipeTypes;
    private int tier;
    private Object2IntMap<RecipeCapability<?>> recipeOutputLimits = new Object2IntOpenHashMap();
    private int paintingColor;
    private BiFunction<ItemStack, Integer, Integer> itemColor;
    private PartAbility[] abilities;
    private final List<Component> tooltips;
    private BiConsumer<ItemStack, List<Component>> tooltipBuilder;
    private RecipeModifier recipeModifier;
    private boolean alwaysTryModifyRecipe;
    @NotNull
    private BiPredicate<IRecipeLogicMachine, GTRecipe> beforeWorking;
    @NotNull
    private Predicate<IRecipeLogicMachine> onWorking;
    @NotNull
    private Consumer<IRecipeLogicMachine> onWaiting;
    @NotNull
    private Consumer<IRecipeLogicMachine> afterWorking;
    private Supplier<BlockState> appearance;
    @Nullable
    private EditableMachineUI editableUI;
    private String langValue;
    private final Set<CompassSection> compassSections;
    @Nullable
    private String compassNode;
    @Nullable
    private ResourceLocation compassPage;
    private final List<ResourceLocation> preNodes;

    protected MachineBuilder(Registrate registrate, String name, Function<ResourceLocation, DEFINITION> definitionFactory, Function<IMachineBlockEntity, MetaMachine> metaMachine, BiFunction<BlockBehaviour.Properties, DEFINITION, IMachineBlock> blockFactory, BiFunction<IMachineBlock, Item.Properties, MetaMachineItem> itemFactory, TriFunction<BlockEntityType<?>, BlockPos, BlockState, IMachineBlockEntity> blockEntityFactory) {
        super(new ResourceLocation(registrate.getModid(), name), new Object[0]);
        this.paintingColor = Long.decode(ConfigHolder.INSTANCE.client.defaultPaintingColor).intValue();
        this.itemColor = (itemStack, tintIndex) -> tintIndex == 2 ? GTValues.VC[this.tier] : (tintIndex == 1 ? this.paintingColor : -1);
        this.abilities = new PartAbility[0];
        this.tooltips = new ArrayList<Component>();
        this.recipeModifier = new RecipeModifierList(GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK));
        this.beforeWorking = (machine, recipe) -> true;
        this.onWorking = machine -> true;
        this.onWaiting = machine -> {};
        this.afterWorking = machine -> {};
        this.langValue = null;
        this.compassSections = new HashSet<CompassSection>();
        this.compassNode = null;
        this.compassPage = null;
        this.preNodes = new ArrayList<ResourceLocation>();
        this.registrate = registrate;
        this.name = name;
        this.metaMachine = metaMachine;
        this.blockFactory = blockFactory;
        this.itemFactory = itemFactory;
        this.blockEntityFactory = blockEntityFactory;
        this.definitionFactory = definitionFactory;
    }

    public MachineBuilder<DEFINITION> recipeType(GTRecipeType type) {
        this.recipeTypes = (GTRecipeType[])ArrayUtils.add((Object[])this.recipeTypes, (Object)type);
        return this;
    }

    public MachineBuilder<DEFINITION> recipeTypes(GTRecipeType ... types) {
        for (GTRecipeType type : types) {
            this.recipeTypes = (GTRecipeType[])ArrayUtils.add((Object[])this.recipeTypes, (Object)type);
        }
        return this;
    }

    public static <DEFINITION extends MachineDefinition> MachineBuilder<DEFINITION> create(Registrate registrate, String name, Function<ResourceLocation, DEFINITION> definitionFactory, Function<IMachineBlockEntity, MetaMachine> metaMachine, BiFunction<BlockBehaviour.Properties, DEFINITION, IMachineBlock> blockFactory, BiFunction<IMachineBlock, Item.Properties, MetaMachineItem> itemFactory, TriFunction<BlockEntityType<?>, BlockPos, BlockState, IMachineBlockEntity> blockEntityFactory) {
        return new MachineBuilder<DEFINITION>(registrate, name, definitionFactory, metaMachine, blockFactory, itemFactory, blockEntityFactory);
    }

    public MachineBuilder<DEFINITION> modelRenderer(Supplier<ResourceLocation> model) {
        this.renderer = () -> new MachineRenderer((ResourceLocation)model.get());
        return this;
    }

    public MachineBuilder<DEFINITION> defaultModelRenderer() {
        return this.modelRenderer(() -> new ResourceLocation(this.registrate.getModid(), "block/" + this.name));
    }

    public MachineBuilder<DEFINITION> tieredHullRenderer(ResourceLocation model) {
        return this.renderer(() -> new TieredHullMachineRenderer(this.tier, model));
    }

    public MachineBuilder<DEFINITION> overlayTieredHullRenderer(String name) {
        return this.renderer(() -> new OverlayTieredMachineRenderer(this.tier, new ResourceLocation(this.registrate.getModid(), "block/machine/part/" + name)));
    }

    public MachineBuilder<DEFINITION> overlaySteamHullRenderer(String name) {
        return this.renderer(() -> new OverlaySteamMachineRenderer(new ResourceLocation(this.registrate.getModid(), "block/machine/part/" + name)));
    }

    public MachineBuilder<DEFINITION> workableTieredHullRenderer(ResourceLocation workableModel) {
        return this.renderer(() -> new WorkableTieredHullMachineRenderer(this.tier, workableModel));
    }

    public MachineBuilder<DEFINITION> workableSteamHullRenderer(boolean isHighPressure, ResourceLocation workableModel) {
        return this.renderer(() -> new WorkableSteamMachineRenderer(isHighPressure, workableModel));
    }

    public MachineBuilder<DEFINITION> workableCasingRenderer(ResourceLocation baseCasing, ResourceLocation workableModel) {
        return this.renderer(() -> new WorkableCasingMachineRenderer(baseCasing, workableModel));
    }

    public MachineBuilder<DEFINITION> workableCasingRenderer(ResourceLocation baseCasing, ResourceLocation workableModel, boolean tint) {
        return this.renderer(() -> new WorkableCasingMachineRenderer(baseCasing, workableModel, tint));
    }

    public MachineBuilder<DEFINITION> sidedWorkableCasingRenderer(String basePath, ResourceLocation overlayModel, boolean tint) {
        return this.renderer(() -> new WorkableSidedCasingMachineRenderer(basePath, overlayModel, tint));
    }

    public MachineBuilder<DEFINITION> sidedWorkableCasingRenderer(String basePath, ResourceLocation overlayModel) {
        return this.renderer(() -> new WorkableSidedCasingMachineRenderer(basePath, overlayModel));
    }

    public MachineBuilder<DEFINITION> appearanceBlock(Supplier<? extends Block> block) {
        this.appearance = () -> ((Block)block.get()).m_49966_();
        return this;
    }

    public MachineBuilder<DEFINITION> tooltips(Component ... components) {
        this.tooltips.addAll(Arrays.stream(components).filter(Objects::nonNull).toList());
        return this;
    }

    public MachineBuilder<DEFINITION> abilities(PartAbility ... abilities) {
        this.abilities = abilities;
        this.compassSections(GTCompassSections.PARTS);
        return this;
    }

    public MachineBuilder<DEFINITION> recipeModifier(RecipeModifier recipeModifier) {
        RecipeModifierList list;
        this.recipeModifier = recipeModifier instanceof RecipeModifierList ? (list = (RecipeModifierList)recipeModifier) : new RecipeModifierList(recipeModifier);
        return this;
    }

    public MachineBuilder<DEFINITION> recipeModifier(RecipeModifier recipeModifier, boolean alwaysTryModifyRecipe) {
        this.alwaysTryModifyRecipe = alwaysTryModifyRecipe;
        return this.recipeModifier(recipeModifier);
    }

    public MachineBuilder<DEFINITION> recipeModifiers(RecipeModifier ... recipeModifiers) {
        this.recipeModifier = new RecipeModifierList(recipeModifiers);
        return this;
    }

    public MachineBuilder<DEFINITION> recipeModifiers(boolean alwaysTryModifyRecipe, RecipeModifier ... recipeModifiers) {
        return this.recipeModifier(new RecipeModifierList(recipeModifiers), alwaysTryModifyRecipe);
    }

    public MachineBuilder<DEFINITION> noRecipeModifier() {
        this.recipeModifier = new RecipeModifierList((machine, recipe, params, result) -> recipe);
        this.alwaysTryModifyRecipe = false;
        return this;
    }

    public MachineBuilder<DEFINITION> addOutputLimit(RecipeCapability<?> capability, int limit) {
        this.recipeOutputLimits.put(capability, limit);
        return this;
    }

    public MachineBuilder<DEFINITION> multiblockPreviewRenderer(boolean multiBlockWorldPreview, boolean multiBlockXEIPreview) {
        this.renderMultiblockWorldPreview = multiBlockWorldPreview;
        this.renderMultiblockXEIPreview = multiBlockXEIPreview;
        return this;
    }

    public MachineBuilder<DEFINITION> compassSections(CompassSection ... sections) {
        this.compassSections.addAll(Arrays.stream(sections).toList());
        return this;
    }

    public MachineBuilder<DEFINITION> compassNodeSelf() {
        this.compassNode = this.name;
        return this;
    }

    public MachineBuilder<DEFINITION> compassNode(String compassNode) {
        this.compassNode = compassNode;
        return this;
    }

    public MachineBuilder<DEFINITION> compassPreNodes(CompassSection section, String ... compassNodes) {
        for (String nodeID : compassNodes) {
            this.preNodes.add(GTCEu.id(section.sectionID().m_135815_() + "/" + nodeID));
        }
        return this;
    }

    public MachineBuilder<DEFINITION> compassPreNodes(ResourceLocation ... compassNodes) {
        this.preNodes.addAll(Arrays.asList(compassNodes));
        return this;
    }

    public MachineBuilder<DEFINITION> compassPreNodes(CompassNode ... compassNodes) {
        this.preNodes.addAll(Arrays.stream(compassNodes).map(CompassNode::nodeID).toList());
        return this;
    }

    protected DEFINITION createDefinition() {
        return (DEFINITION)((MachineDefinition)this.definitionFactory.apply(new ResourceLocation(this.registrate.getModid(), this.name)));
    }

    @Override
    public DEFINITION register() {
        DEFINITION definition = this.createDefinition();
        BlockBuilder blockBuilder = (BlockBuilder)this.registrate.block(this.name, properties -> {
            RotationState.set(this.rotationState);
            MachineDefinition.setBuilt(definition);
            IMachineBlock b = this.blockFactory.apply((BlockBehaviour.Properties)properties, definition);
            RotationState.clear();
            MachineDefinition.clearBuilt();
            return b.self();
        }).color(() -> () -> IMachineBlock::colorTinted).initialProperties(() -> Blocks.f_50061_).properties(BlockBehaviour.Properties::m_222994_).addLayer(() -> RenderType::m_110457_).blockstate(NonNullBiConsumer.noop()).properties(this.blockProp).onRegister(b -> Arrays.stream(this.abilities).forEach(a -> a.register(this.tier, (Block)b)));
        if (this.langValue != null) {
            blockBuilder.lang(this.langValue);
        }
        if (this.blockBuilder != null) {
            this.blockBuilder.accept(blockBuilder);
        }
        BlockEntry block = blockBuilder.register();
        ItemBuilder itemBuilder = ((ItemBuilder)this.registrate.item(this.name, properties -> this.itemFactory.apply((IMachineBlock)block.get(), (Item.Properties)properties)).setData(ProviderType.LANG, NonNullBiConsumer.noop())).model(NonNullBiConsumer.noop()).color(() -> () -> this.itemColor::apply).properties(this.itemProp);
        if (this.itemBuilder != null) {
            this.itemBuilder.accept(itemBuilder);
        }
        if (this.compassNode != null) {
            if (this.compassSections.isEmpty()) {
                this.compassSections.add(GTCompassSections.MACHINES);
            }
            for (CompassSection section : this.compassSections) {
                itemBuilder.onRegister(item -> {
                    CompassNode node = CompassNode.getOrCreate(section, this.compassNode).addItem(() -> ((MetaMachineItem)((Object)item)).m_5456_()).addPreNode((ResourceLocation[])this.preNodes.toArray(ResourceLocation[]::new));
                    if (this.compassPage != null) {
                        node.page(this.compassPage);
                    }
                });
            }
        }
        ItemEntry item2 = itemBuilder.register();
        BlockEntityBuilder blockEntityBuilder = ((BlockEntityBuilder)this.registrate.blockEntity(this.name, (type, pos, state) -> ((IMachineBlockEntity)this.blockEntityFactory.apply((Object)type, (Object)pos, (Object)state)).self()).onRegister(this.onBlockEntityRegister)).validBlock((NonNullSupplier)block);
        if (this.hasTESR) {
            blockEntityBuilder = blockEntityBuilder.renderer(() -> GTRendererProvider::getOrCreate);
        }
        BlockEntityEntry blockEntity = blockEntityBuilder.register();
        ((MachineDefinition)definition).setRecipeTypes(this.recipeTypes);
        ((MachineDefinition)definition).setBlockSupplier((Supplier<Block>)block);
        ((MachineDefinition)definition).setItemSupplier((Supplier<MetaMachineItem>)item2);
        ((MachineDefinition)definition).setTier(this.tier);
        ((MachineDefinition)definition).setRecipeOutputLimits(this.recipeOutputLimits);
        ((MachineDefinition)definition).setBlockEntityTypeSupplier(() -> ((BlockEntityEntry)blockEntity).get());
        ((MachineDefinition)definition).setMachineSupplier(this.metaMachine);
        ((MachineDefinition)definition).setTooltipBuilder((itemStack, components) -> {
            components.addAll(this.tooltips);
            if (this.tooltipBuilder != null) {
                this.tooltipBuilder.accept((ItemStack)itemStack, (List<Component>)components);
            }
        });
        ((MachineDefinition)definition).setRecipeModifier(this.recipeModifier);
        ((MachineDefinition)definition).setAlwaysTryModifyRecipe(this.alwaysTryModifyRecipe);
        ((MachineDefinition)definition).setBeforeWorking(this.beforeWorking);
        ((MachineDefinition)definition).setOnWorking(this.onWorking);
        ((MachineDefinition)definition).setOnWaiting(this.onWaiting);
        ((MachineDefinition)definition).setAfterWorking(this.afterWorking);
        if (this.renderer == null) {
            this.renderer = () -> new MachineRenderer(new ResourceLocation(this.registrate.getModid(), "block/machine/" + this.name));
        }
        if (this.recipeTypes != null) {
            for (GTRecipeType type2 : this.recipeTypes) {
                if (type2 == null || type2.getIconSupplier() != null) continue;
                type2.setIconSupplier(() -> definition.asStack());
            }
        }
        if (this.appearance == null) {
            this.appearance = () -> ((BlockEntry)block).getDefaultState();
        }
        if (this.editableUI != null) {
            ((MachineDefinition)definition).setEditableUI(this.editableUI);
        }
        ((MachineDefinition)definition).setAppearance(this.appearance);
        ((MachineDefinition)definition).setRenderer(LDLib.isClient() ? this.renderer.get() : IRenderer.EMPTY);
        ((MachineDefinition)definition).setShape(this.shape);
        ((MachineDefinition)definition).setDefaultPaintingColor(this.paintingColor);
        ((MachineDefinition)definition).setRenderXEIPreview(this.renderMultiblockXEIPreview);
        ((MachineDefinition)definition).setRenderWorldPreview(this.renderMultiblockWorldPreview);
        GTRegistries.MACHINES.register(((MachineDefinition)definition).getId(), (MachineDefinition)definition);
        return definition;
    }

    public MachineBuilder<DEFINITION> definitionFactory(Function<ResourceLocation, DEFINITION> definitionFactory) {
        this.definitionFactory = definitionFactory;
        return this;
    }

    public MachineBuilder<DEFINITION> metaMachine(Function<IMachineBlockEntity, MetaMachine> metaMachine) {
        this.metaMachine = metaMachine;
        return this;
    }

    public MachineBuilder<DEFINITION> renderer(@Nullable Supplier<IRenderer> renderer) {
        this.renderer = renderer;
        return this;
    }

    public MachineBuilder<DEFINITION> shape(VoxelShape shape) {
        this.shape = shape;
        return this;
    }

    public MachineBuilder<DEFINITION> rotationState(RotationState rotationState) {
        this.rotationState = rotationState;
        return this;
    }

    public MachineBuilder<DEFINITION> hasTESR(boolean hasTESR) {
        this.hasTESR = hasTESR;
        return this;
    }

    public MachineBuilder<DEFINITION> renderMultiblockWorldPreview(boolean renderMultiblockWorldPreview) {
        this.renderMultiblockWorldPreview = renderMultiblockWorldPreview;
        return this;
    }

    public MachineBuilder<DEFINITION> renderMultiblockXEIPreview(boolean renderMultiblockXEIPreview) {
        this.renderMultiblockXEIPreview = renderMultiblockXEIPreview;
        return this;
    }

    public MachineBuilder<DEFINITION> blockProp(NonNullUnaryOperator<BlockBehaviour.Properties> blockProp) {
        this.blockProp = blockProp;
        return this;
    }

    public MachineBuilder<DEFINITION> itemProp(NonNullUnaryOperator<Item.Properties> itemProp) {
        this.itemProp = itemProp;
        return this;
    }

    public MachineBuilder<DEFINITION> blockBuilder(Consumer<BlockBuilder<? extends Block, ?>> blockBuilder) {
        this.blockBuilder = blockBuilder;
        return this;
    }

    public MachineBuilder<DEFINITION> itemBuilder(Consumer<ItemBuilder<? extends MetaMachineItem, ?>> itemBuilder) {
        this.itemBuilder = itemBuilder;
        return this;
    }

    public MachineBuilder<DEFINITION> onBlockEntityRegister(NonNullConsumer<BlockEntityType<BlockEntity>> onBlockEntityRegister) {
        this.onBlockEntityRegister = onBlockEntityRegister;
        return this;
    }

    public int tier() {
        return this.tier;
    }

    public MachineBuilder<DEFINITION> tier(int tier) {
        this.tier = tier;
        return this;
    }

    public MachineBuilder<DEFINITION> recipeOutputLimits(Object2IntMap<RecipeCapability<?>> recipeOutputLimits) {
        this.recipeOutputLimits = recipeOutputLimits;
        return this;
    }

    public MachineBuilder<DEFINITION> paintingColor(int paintingColor) {
        this.paintingColor = paintingColor;
        return this;
    }

    public MachineBuilder<DEFINITION> itemColor(BiFunction<ItemStack, Integer, Integer> itemColor) {
        this.itemColor = itemColor;
        return this;
    }

    public MachineBuilder<DEFINITION> tooltipBuilder(BiConsumer<ItemStack, List<Component>> tooltipBuilder) {
        this.tooltipBuilder = tooltipBuilder;
        return this;
    }

    public MachineBuilder<DEFINITION> alwaysTryModifyRecipe(boolean alwaysTryModifyRecipe) {
        this.alwaysTryModifyRecipe = alwaysTryModifyRecipe;
        return this;
    }

    @NotNull
    public BiPredicate<IRecipeLogicMachine, GTRecipe> beforeWorking() {
        return this.beforeWorking;
    }

    public MachineBuilder<DEFINITION> beforeWorking(@NotNull BiPredicate<IRecipeLogicMachine, GTRecipe> beforeWorking) {
        if (beforeWorking == null) {
            throw new NullPointerException("beforeWorking is marked non-null but is null");
        }
        this.beforeWorking = beforeWorking;
        return this;
    }

    @NotNull
    public Predicate<IRecipeLogicMachine> onWorking() {
        return this.onWorking;
    }

    public MachineBuilder<DEFINITION> onWorking(@NotNull Predicate<IRecipeLogicMachine> onWorking) {
        if (onWorking == null) {
            throw new NullPointerException("onWorking is marked non-null but is null");
        }
        this.onWorking = onWorking;
        return this;
    }

    @NotNull
    public Consumer<IRecipeLogicMachine> onWaiting() {
        return this.onWaiting;
    }

    public MachineBuilder<DEFINITION> onWaiting(@NotNull Consumer<IRecipeLogicMachine> onWaiting) {
        if (onWaiting == null) {
            throw new NullPointerException("onWaiting is marked non-null but is null");
        }
        this.onWaiting = onWaiting;
        return this;
    }

    @NotNull
    public Consumer<IRecipeLogicMachine> afterWorking() {
        return this.afterWorking;
    }

    public MachineBuilder<DEFINITION> afterWorking(@NotNull Consumer<IRecipeLogicMachine> afterWorking) {
        if (afterWorking == null) {
            throw new NullPointerException("afterWorking is marked non-null but is null");
        }
        this.afterWorking = afterWorking;
        return this;
    }

    public MachineBuilder<DEFINITION> appearance(Supplier<BlockState> appearance) {
        this.appearance = appearance;
        return this;
    }

    public MachineBuilder<DEFINITION> editableUI(@Nullable EditableMachineUI editableUI) {
        this.editableUI = editableUI;
        return this;
    }

    public MachineBuilder<DEFINITION> langValue(String langValue) {
        this.langValue = langValue;
        return this;
    }

    public MachineBuilder<DEFINITION> compassPage(@Nullable ResourceLocation compassPage) {
        this.compassPage = compassPage;
        return this;
    }
}

