/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class ResearchData
implements Iterable<ResearchEntry> {
    private final Collection<ResearchEntry> entries;

    public ResearchData() {
        this.entries = new ArrayList<ResearchEntry>();
    }

    public void add(@NotNull ResearchEntry entry) {
        this.entries.add(entry);
    }

    @Override
    @NotNull
    public Iterator<ResearchEntry> iterator() {
        return this.entries.iterator();
    }

    public static ResearchData fromJson(JsonArray array) {
        ArrayList<ResearchEntry> entries = new ArrayList<ResearchEntry>();
        for (int i = 0; i < array.size(); ++i) {
            entries.add(ResearchEntry.fromJson(array.get(i).getAsJsonObject()));
        }
        return new ResearchData(entries);
    }

    public JsonArray toJson() {
        JsonArray json = new JsonArray();
        this.entries.forEach(entry -> json.add((JsonElement)entry.toJson()));
        return json;
    }

    public static ResearchData fromNetwork(FriendlyByteBuf buf) {
        ArrayList<ResearchEntry> entries = new ArrayList<ResearchEntry>();
        int size = buf.m_130242_();
        for (int i = 0; i < size; ++i) {
            entries.add(ResearchEntry.fromNetwork(buf));
        }
        return new ResearchData(entries);
    }

    public void toNetwork(FriendlyByteBuf buf) {
        buf.m_130130_(this.entries.size());
        this.entries.forEach(entry -> entry.toNetwork(buf));
    }

    public ResearchData(Collection<ResearchEntry> entries) {
        this.entries = entries;
    }

    public static final class ResearchEntry {
        @NotNull
        private final String researchId;
        @NotNull
        private final ItemStack dataItem;

        public ResearchEntry(@NotNull String researchId, @NotNull ItemStack dataItem) {
            this.researchId = researchId;
            this.dataItem = dataItem;
        }

        public static ResearchEntry fromJson(JsonObject tag) {
            return new ResearchEntry(tag.get("researchId").getAsString(), (ItemStack)ItemStack.f_41582_.parse((DynamicOps)JsonOps.INSTANCE, (Object)tag.get("dataItem")).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0)));
        }

        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("researchId", this.researchId);
            json.add("dataItem", (JsonElement)ItemStack.f_41582_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.dataItem).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0)));
            return json;
        }

        public static ResearchEntry fromNetwork(FriendlyByteBuf buf) {
            String researchId = buf.m_130277_();
            ItemStack dataItem = buf.m_130267_();
            return new ResearchEntry(researchId, dataItem);
        }

        public void toNetwork(FriendlyByteBuf buf) {
            buf.m_130070_(this.researchId);
            buf.m_130055_(this.dataItem);
        }

        @NotNull
        public String getResearchId() {
            return this.researchId;
        }

        @NotNull
        public ItemStack getDataItem() {
            return this.dataItem;
        }
    }
}

