/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipeSerializer;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.RecipeRunner;
import com.gregtechceu.gtceu.api.recipe.chance.logic.ChanceLogic;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GTRecipe
implements Recipe<Container> {
    public final GTRecipeType recipeType;
    public final ResourceLocation id;
    public final Map<RecipeCapability<?>, List<Content>> inputs;
    public final Map<RecipeCapability<?>, List<Content>> outputs;
    public final Map<RecipeCapability<?>, List<Content>> tickInputs;
    public final Map<RecipeCapability<?>, List<Content>> tickOutputs;
    public final Map<RecipeCapability<?>, ChanceLogic> inputChanceLogics;
    public final Map<RecipeCapability<?>, ChanceLogic> outputChanceLogics;
    public final Map<RecipeCapability<?>, ChanceLogic> tickInputChanceLogics;
    public final Map<RecipeCapability<?>, ChanceLogic> tickOutputChanceLogics;
    public final List<RecipeCondition> conditions;
    public final List<?> ingredientActions;
    @NotNull
    public CompoundTag data;
    public int duration;
    public int parallels = 1;
    public int ocTier = 0;
    public boolean isFuel;

    public GTRecipe(GTRecipeType recipeType, ResourceLocation id, Map<RecipeCapability<?>, List<Content>> inputs, Map<RecipeCapability<?>, List<Content>> outputs, Map<RecipeCapability<?>, List<Content>> tickInputs, Map<RecipeCapability<?>, List<Content>> tickOutputs, Map<RecipeCapability<?>, ChanceLogic> inputChanceLogics, Map<RecipeCapability<?>, ChanceLogic> outputChanceLogics, Map<RecipeCapability<?>, ChanceLogic> tickInputChanceLogics, Map<RecipeCapability<?>, ChanceLogic> tickOutputChanceLogics, List<RecipeCondition> conditions, List<?> ingredientActions, @NotNull CompoundTag data, int duration, boolean isFuel) {
        this.recipeType = recipeType;
        this.id = id;
        this.inputs = inputs;
        this.outputs = outputs;
        this.tickInputs = tickInputs;
        this.tickOutputs = tickOutputs;
        this.inputChanceLogics = inputChanceLogics;
        this.outputChanceLogics = outputChanceLogics;
        this.tickInputChanceLogics = tickInputChanceLogics;
        this.tickOutputChanceLogics = tickOutputChanceLogics;
        this.conditions = conditions;
        this.ingredientActions = ingredientActions;
        this.data = data;
        this.duration = duration;
        this.isFuel = isFuel;
    }

    public Map<RecipeCapability<?>, List<Content>> copyContents(Map<RecipeCapability<?>, List<Content>> contents, @Nullable ContentModifier modifier) {
        HashMap copyContents = new HashMap();
        for (Map.Entry<RecipeCapability<?>, List<Content>> entry : contents.entrySet()) {
            List<Content> contentList = entry.getValue();
            RecipeCapability<?> cap = entry.getKey();
            if (contentList == null || contentList.isEmpty()) continue;
            ArrayList<Content> contentsCopy = new ArrayList<Content>();
            for (Content content : contentList) {
                contentsCopy.add(content.copy(cap, modifier));
            }
            copyContents.put(entry.getKey(), contentsCopy);
        }
        return copyContents;
    }

    public GTRecipe copy() {
        return new GTRecipe(this.recipeType, this.id, this.copyContents(this.inputs, null), this.copyContents(this.outputs, null), this.copyContents(this.tickInputs, null), this.copyContents(this.tickOutputs, null), new HashMap(this.inputChanceLogics), new HashMap(this.outputChanceLogics), new HashMap(this.tickInputChanceLogics), new HashMap(this.tickOutputChanceLogics), new ArrayList<RecipeCondition>(this.conditions), new ArrayList(this.ingredientActions), this.data, this.duration, this.isFuel);
    }

    public GTRecipe copy(ContentModifier modifier) {
        return this.copy(modifier, true);
    }

    public GTRecipe copy(ContentModifier modifier, boolean modifyDuration) {
        GTRecipe copied = new GTRecipe(this.recipeType, this.id, this.copyContents(this.inputs, modifier), this.copyContents(this.outputs, modifier), this.copyContents(this.tickInputs, modifier), this.copyContents(this.tickOutputs, modifier), new HashMap(this.inputChanceLogics), new HashMap(this.outputChanceLogics), new HashMap(this.tickInputChanceLogics), new HashMap(this.tickOutputChanceLogics), new ArrayList<RecipeCondition>(this.conditions), new ArrayList(this.ingredientActions), this.data, this.duration, this.isFuel);
        if (modifyDuration) {
            copied.duration = modifier.apply(this.duration).intValue();
        }
        return copied;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return GTRecipeSerializer.SERIALIZER;
    }

    @NotNull
    public GTRecipeType getType() {
        return this.recipeType;
    }

    public boolean m_5818_(@NotNull Container pContainer, @NotNull Level pLevel) {
        return false;
    }

    public ItemStack m_5874_(Container inventory, RegistryAccess registryManager) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess registryManager) {
        return ItemStack.f_41583_;
    }

    public List<Content> getInputContents(RecipeCapability<?> capability) {
        return this.inputs.getOrDefault(capability, Collections.emptyList());
    }

    public List<Content> getOutputContents(RecipeCapability<?> capability) {
        return this.outputs.getOrDefault(capability, Collections.emptyList());
    }

    public List<Content> getTickInputContents(RecipeCapability<?> capability) {
        return this.tickInputs.getOrDefault(capability, Collections.emptyList());
    }

    public List<Content> getTickOutputContents(RecipeCapability<?> capability) {
        return this.tickOutputs.getOrDefault(capability, Collections.emptyList());
    }

    public ActionResult matchRecipe(IRecipeCapabilityHolder holder) {
        return this.matchRecipe(holder, false);
    }

    public ActionResult matchTickRecipe(IRecipeCapabilityHolder holder) {
        return this.hasTick() ? this.matchRecipe(holder, true) : ActionResult.SUCCESS;
    }

    private ActionResult matchRecipe(IRecipeCapabilityHolder holder, boolean tick) {
        if (!holder.hasProxies()) {
            return ActionResult.FAIL_NO_REASON;
        }
        ActionResult result = this.matchRecipeContents(IO.IN, holder, tick ? this.tickInputs : this.inputs, tick);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.matchRecipeContents(IO.OUT, holder, tick ? this.tickOutputs : this.outputs, tick);
        if (!result.isSuccess()) {
            return result;
        }
        return ActionResult.SUCCESS;
    }

    public ActionResult matchRecipeContents(IO io, IRecipeCapabilityHolder holder, Map<RecipeCapability<?>, List<Content>> contents, boolean isTick) {
        RecipeRunner runner = new RecipeRunner(this, io, isTick, holder, Collections.emptyMap(), true);
        for (Map.Entry<RecipeCapability<?>, List<Content>> entry : contents.entrySet()) {
            RecipeRunner.RecipeHandlingResult result = runner.handle(entry);
            if (result == null || result.result().content == null && result.result().slots.isEmpty()) continue;
            if (io == IO.IN) {
                return ActionResult.fail(() -> Component.m_237115_((String)"gtceu.recipe_logic.insufficient_in").m_130946_(": ").m_7220_(result.capability().getName()), 0.0f);
            }
            if (io == IO.OUT) {
                return ActionResult.fail(() -> Component.m_237115_((String)"gtceu.recipe_logic.insufficient_out").m_130946_(": ").m_7220_(result.capability().getName()), 0.0f);
            }
            return ActionResult.FAIL_NO_REASON;
        }
        return ActionResult.SUCCESS;
    }

    public boolean handleTickRecipeIO(IO io, IRecipeCapabilityHolder holder, Map<RecipeCapability<?>, Object2IntMap<?>> chanceCaches) {
        if (!holder.hasProxies() || io == IO.BOTH) {
            return false;
        }
        return this.handleRecipe(io, holder, true, io == IO.IN ? this.tickInputs : this.tickOutputs, chanceCaches);
    }

    public boolean handleRecipeIO(IO io, IRecipeCapabilityHolder holder, Map<RecipeCapability<?>, Object2IntMap<?>> chanceCaches) {
        if (!holder.hasProxies() || io == IO.BOTH) {
            return false;
        }
        return this.handleRecipe(io, holder, false, io == IO.IN ? this.inputs : this.outputs, chanceCaches);
    }

    public boolean handleRecipe(IO io, IRecipeCapabilityHolder holder, boolean isTick, Map<RecipeCapability<?>, List<Content>> contents, Map<RecipeCapability<?>, Object2IntMap<?>> chanceCaches) {
        RecipeRunner runner = new RecipeRunner(this, io, isTick, holder, chanceCaches, false);
        for (Map.Entry<RecipeCapability<?>, List<Content>> entry : contents.entrySet()) {
            RecipeRunner.RecipeHandlingResult handled = runner.handle(entry);
            if (handled == null || handled.result().content == null && handled.result().slots.isEmpty()) continue;
            GTCEu.LOGGER.warn("io error while handling a recipe {} outputs. holder: {}", (Object)this.id, (Object)holder);
            return false;
        }
        return true;
    }

    public boolean hasTick() {
        return !this.tickInputs.isEmpty() || !this.tickOutputs.isEmpty();
    }

    public void preWorking(IRecipeCapabilityHolder holder) {
        this.handlePre(this.inputs, holder, IO.IN);
        this.handlePre(this.outputs, holder, IO.OUT);
    }

    public void postWorking(IRecipeCapabilityHolder holder) {
        this.handlePost(this.inputs, holder, IO.IN);
        this.handlePost(this.outputs, holder, IO.OUT);
    }

    public void handlePre(Map<RecipeCapability<?>, List<Content>> contents, IRecipeCapabilityHolder holder, IO io) {
        contents.forEach((capability, tuples) -> {
            block3: {
                block2: {
                    if (!holder.getCapabilitiesProxy().contains((Object)io, capability)) break block2;
                    for (IRecipeHandler capabilityProxy : (List)holder.getCapabilitiesProxy().get((Object)io, capability)) {
                        capabilityProxy.preWorking(holder, io, this);
                    }
                    break block3;
                }
                if (!holder.getCapabilitiesProxy().contains((Object)IO.BOTH, capability)) break block3;
                for (IRecipeHandler capabilityProxy : (List)holder.getCapabilitiesProxy().get((Object)IO.BOTH, capability)) {
                    capabilityProxy.preWorking(holder, io, this);
                }
            }
        });
    }

    public void handlePost(Map<RecipeCapability<?>, List<Content>> contents, IRecipeCapabilityHolder holder, IO io) {
        contents.forEach((capability, tuples) -> {
            block3: {
                block2: {
                    if (!holder.getCapabilitiesProxy().contains((Object)io, capability)) break block2;
                    for (IRecipeHandler capabilityProxy : (List)holder.getCapabilitiesProxy().get((Object)io, capability)) {
                        capabilityProxy.postWorking(holder, io, this);
                    }
                    break block3;
                }
                if (!holder.getCapabilitiesProxy().contains((Object)IO.BOTH, capability)) break block3;
                for (IRecipeHandler capabilityProxy : (List)holder.getCapabilitiesProxy().get((Object)IO.BOTH, capability)) {
                    capabilityProxy.postWorking(holder, io, this);
                }
            }
        });
    }

    public ActionResult checkConditions(@NotNull RecipeLogic recipeLogic) {
        if (this.conditions.isEmpty()) {
            return ActionResult.SUCCESS;
        }
        HashMap<String, List> or = new HashMap<String, List>();
        for (RecipeCondition condition2 : this.conditions) {
            if (condition2.isOr()) {
                or.computeIfAbsent(condition2.getType(), type -> new ArrayList()).add(condition2);
                continue;
            }
            if (condition2.test(this, recipeLogic) != condition2.isReverse()) continue;
            return ActionResult.fail(() -> Component.m_237115_((String)"gtceu.recipe_logic.condition_fails").m_130946_(": ").m_7220_(condition2.getTooltips()));
        }
        for (List conditions : or.values()) {
            if (!conditions.stream().allMatch(condition -> condition.test(this, recipeLogic) == condition.isReverse())) continue;
            return ActionResult.fail(() -> Component.m_237115_((String)"gtceu.recipe_logic.condition_fails"));
        }
        return ActionResult.SUCCESS;
    }

    public GTRecipe trimRecipeOutputs(Map<RecipeCapability<?>, Integer> trimLimits) {
        if (trimLimits.isEmpty() || trimLimits.values().stream().allMatch(integer -> integer == -1)) {
            return this;
        }
        GTRecipe current = this.copy();
        GTRecipeBuilder builder = new GTRecipeBuilder(current, this.recipeType);
        builder.output.clear();
        builder.tickOutput.clear();
        Map<RecipeCapability<?>, List<Content>> recipeOutputs = this.doTrim(current.outputs, trimLimits);
        Map<RecipeCapability<?>, List<Content>> recipeTickOutputs = this.doTrim(current.tickOutputs, trimLimits);
        builder.output.putAll(recipeOutputs);
        builder.tickOutput.putAll(recipeTickOutputs);
        return builder.buildRawRecipe();
    }

    public Map<RecipeCapability<?>, List<Content>> doTrim(Map<RecipeCapability<?>, List<Content>> current, Map<RecipeCapability<?>, Integer> trimLimits) {
        HashMap outputs = new HashMap();
        HashSet trimmed = new HashSet();
        for (Map.Entry<RecipeCapability<?>, Integer> entry : trimLimits.entrySet()) {
            RecipeCapability<?> key = entry.getKey();
            if (!current.containsKey(key)) continue;
            ArrayList<Content> nonChanced = new ArrayList<Content>();
            List chanced = new ArrayList<Content>();
            for (Content content : current.getOrDefault(key, List.of())) {
                if (content.chance <= 0 || content.chance >= content.maxChance) {
                    nonChanced.add(content);
                    continue;
                }
                chanced.add(content);
            }
            int outputLimit = entry.getValue();
            if (outputLimit == -1) {
                outputs.computeIfAbsent(key, $ -> new ArrayList()).addAll(nonChanced);
            } else if (nonChanced.size() >= outputLimit) {
                outputs.computeIfAbsent(key, $ -> new ArrayList()).addAll(nonChanced.stream().map(cont -> cont.copy(key, null)).toList().subList(0, outputLimit));
                chanced.clear();
            } else if (!nonChanced.isEmpty() && nonChanced.size() + chanced.size() >= outputLimit) {
                outputs.computeIfAbsent(key, $ -> new ArrayList()).addAll(nonChanced.stream().map(cont -> cont.copy(key, null)).toList());
                int numChanced = outputLimit - nonChanced.size();
                chanced = chanced.subList(0, Math.min(numChanced, chanced.size()));
            } else if (nonChanced.isEmpty()) {
                chanced = chanced.subList(0, Math.min(outputLimit, chanced.size()));
            } else {
                outputs.computeIfAbsent(key, $ -> new ArrayList()).addAll(nonChanced.stream().map(cont -> cont.copy(key, null)).toList());
            }
            if (!chanced.isEmpty()) {
                outputs.computeIfAbsent(key, $ -> new ArrayList()).addAll(chanced.stream().map(cont -> cont.copy(key, null)).toList());
            }
            trimmed.add(key);
        }
        for (Map.Entry<RecipeCapability<?>, Object> entry : current.entrySet()) {
            if (trimmed.contains(entry.getKey())) continue;
            outputs.computeIfAbsent(entry.getKey(), $ -> new ArrayList()).addAll((Collection)entry.getValue());
        }
        return outputs;
    }

    public ChanceLogic getChanceLogicForCapability(RecipeCapability<?> cap, IO io, boolean isTick) {
        if (io == IO.OUT) {
            if (isTick) {
                return this.tickOutputChanceLogics.getOrDefault(cap, ChanceLogic.OR);
            }
            return this.outputChanceLogics.getOrDefault(cap, ChanceLogic.OR);
        }
        if (io == IO.IN) {
            if (isTick) {
                return this.tickInputChanceLogics.getOrDefault(cap, ChanceLogic.OR);
            }
            return this.inputChanceLogics.getOrDefault(cap, ChanceLogic.OR);
        }
        return ChanceLogic.OR;
    }

    public boolean checkRecipeValid() {
        return this.checkItemValid(this.inputs, "input") && this.checkItemValid(this.outputs, "output") && this.checkItemValid(this.tickInputs, "tickInput") && this.checkItemValid(this.tickOutputs, "tickOutput");
    }

    private boolean checkItemValid(Map<RecipeCapability<?>, List<Content>> contents, String name) {
        for (Content content : contents.getOrDefault(ItemRecipeCapability.CAP, Collections.emptyList())) {
            ItemStack[] items = ((Ingredient)ItemRecipeCapability.CAP.of(content.content)).m_43908_();
            if (items.length == 0) {
                GTCEu.LOGGER.error("recipe {} {} item length is 0", (Object)this.id, (Object)name);
                return false;
            }
            if (!Arrays.stream(items).anyMatch(ItemStack::m_41619_)) continue;
            GTCEu.LOGGER.error("recipe {} {} item is empty", (Object)this.id, (Object)name);
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GTRecipe)) {
            return false;
        }
        GTRecipe recipe = (GTRecipe)obj;
        return this.id.equals((Object)recipe.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean isFuel() {
        return this.isFuel;
    }

    public record ActionResult(boolean isSuccess, @Nullable Supplier<Component> reason, float expectingRate) {
        public static final ActionResult SUCCESS = new ActionResult(true, null, 0.0f);
        public static final ActionResult FAIL_NO_REASON = new ActionResult(true, null, 0.0f);

        public static ActionResult fail(@Nullable Supplier<Component> component) {
            return new ActionResult(false, component, 0.0f);
        }

        public static ActionResult fail(@Nullable Supplier<Component> component, float expectingRate) {
            return new ActionResult(false, component, expectingRate);
        }
    }
}

