/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.misc.forge;

import com.lowdragmc.lowdraglib.side.fluid.forge.FluidHelperImpl;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.jetbrains.annotations.NotNull;

public class FilteredFluidHandlerItemStack
extends FluidHandlerItemStack {
    Predicate<com.lowdragmc.lowdraglib.side.fluid.FluidStack> filter;

    public FilteredFluidHandlerItemStack(@NotNull ItemStack container, int capacity, Predicate<com.lowdragmc.lowdraglib.side.fluid.FluidStack> filter) {
        super(container, capacity);
        this.filter = filter;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack drained = super.drain(resource, action);
        this.removeTagWhenEmpty(action);
        return drained;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack drained = super.drain(maxDrain, action);
        this.removeTagWhenEmpty(action);
        return drained;
    }

    private void removeTagWhenEmpty(IFluidHandler.FluidAction action) {
        if (this.getFluid() == FluidStack.EMPTY && action == IFluidHandler.FluidAction.EXECUTE) {
            this.container.m_41751_(null);
        }
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return this.filter.test(FluidHelperImpl.toFluidStack((FluidStack)fluid));
    }
}

