/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.trait;

import com.gregtechceu.gtceu.api.capability.IWorkable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyTooltip;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.MachineTrait;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.logic.OCParams;
import com.gregtechceu.gtceu.api.recipe.logic.OCResult;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.sound.AutoReleasedSound;
import com.gregtechceu.gtceu.api.sound.SoundEntry;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.syncdata.IEnhancedManaged;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.UpdateListener;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class RecipeLogic
extends MachineTrait
implements IEnhancedManaged,
IWorkable,
IFancyTooltip {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(RecipeLogic.class);
    public final IRecipeLogicMachine machine;
    public List<GTRecipe> lastFailedMatches;
    @Persisted
    @DescSynced
    @UpdateListener(methodName="onStatusSynced")
    private Status status = Status.IDLE;
    @Persisted
    @DescSynced
    @UpdateListener(methodName="onActiveSynced")
    private boolean isActive;
    @Persisted
    @DescSynced
    @Nullable
    private Component waitingReason = null;
    @Persisted
    @Nullable
    protected GTRecipe lastRecipe;
    @Persisted
    @Nullable
    protected GTRecipe lastOriginRecipe;
    protected OCParams ocParams = new OCParams();
    protected OCResult ocResult = new OCResult();
    @Persisted
    protected int progress;
    @Persisted
    protected int duration;
    @Persisted
    protected int fuelTime;
    @Persisted
    protected int fuelMaxTime;
    protected boolean recipeDirty;
    @Persisted
    protected long totalContinuousRunningTime;
    protected final Map<RecipeCapability<?>, Object2IntMap<?>> chanceCaches = this.makeChanceCaches();
    protected TickableSubscription subscription;
    protected Object workingSound;

    public RecipeLogic(IRecipeLogicMachine machine) {
        super(machine.self());
        this.machine = machine;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void onStatusSynced(Status newValue, Status oldValue) {
        this.getMachine().scheduleRenderUpdate();
        this.updateSound();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void onActiveSynced(boolean newActive, boolean oldActive) {
        this.getMachine().scheduleRenderUpdate();
    }

    @Override
    public void scheduleRenderUpdate() {
        this.getMachine().scheduleRenderUpdate();
    }

    public void resetRecipeLogic() {
        this.recipeDirty = false;
        this.lastRecipe = null;
        this.lastOriginRecipe = null;
        this.progress = 0;
        this.duration = 0;
        this.isActive = false;
        this.fuelTime = 0;
        this.lastFailedMatches = null;
        this.status = Status.IDLE;
        this.ocResult.reset();
        this.updateTickSubscription();
    }

    @Override
    public void onMachineLoad() {
        super.onMachineLoad();
        this.updateTickSubscription();
    }

    public void updateTickSubscription() {
        if (this.isSuspend() && this.fuelTime == 0 || !this.machine.isRecipeLogicAvailable()) {
            if (this.subscription != null) {
                this.subscription.unsubscribe();
                this.subscription = null;
            }
        } else {
            this.subscription = this.getMachine().subscribeServerTick(this.subscription, this::serverTick);
        }
    }

    public double getProgressPercent() {
        return this.duration == 0 ? 0.0 : (double)this.progress / ((double)this.duration * 1.0);
    }

    public boolean needFuel() {
        return this.machine.getRecipeType().isFuelRecipeType();
    }

    public RecipeManager getRecipeManager() {
        return Platform.getMinecraftServer().m_129894_();
    }

    public void serverTick() {
        if (!this.isSuspend()) {
            if (!this.isIdle() && this.lastRecipe != null) {
                if (this.progress < this.duration) {
                    this.handleRecipeWorking();
                }
                if (this.progress >= this.duration) {
                    this.onRecipeFinish();
                }
            } else if (this.lastRecipe != null) {
                this.findAndHandleRecipe();
            } else if (!this.machine.keepSubscribing() || this.getMachine().getOffsetTimer() % 5L == 0L) {
                this.findAndHandleRecipe();
                if (this.lastFailedMatches != null) {
                    for (GTRecipe match : this.lastFailedMatches) {
                        if (this.checkMatchedRecipeAvailable(match)) break;
                    }
                }
            }
        }
        if (this.fuelTime > 0) {
            --this.fuelTime;
        } else {
            boolean unsubscribe = false;
            if (this.isSuspend()) {
                unsubscribe = true;
            } else if (this.lastRecipe == null && this.isIdle() && !this.machine.keepSubscribing() && !this.recipeDirty && this.lastFailedMatches == null) {
                unsubscribe = true;
            }
            if (unsubscribe && this.subscription != null) {
                this.subscription.unsubscribe();
                this.subscription = null;
            }
        }
    }

    public boolean checkMatchedRecipeAvailable(GTRecipe match) {
        GTRecipe matchCopy = match.copy();
        GTRecipe modified = this.machine.fullModifyRecipe(matchCopy, this.ocParams, this.ocResult);
        if (modified != null) {
            if (modified.checkConditions(this).isSuccess() && modified.matchRecipe(this.machine).isSuccess() && modified.matchTickRecipe(this.machine).isSuccess()) {
                this.setupRecipe(modified);
            }
            if (this.lastRecipe != null && this.getStatus() == Status.WORKING) {
                this.lastOriginRecipe = match;
                this.lastFailedMatches = null;
                return true;
            }
        }
        return false;
    }

    public void handleRecipeWorking() {
        Status last = this.status;
        assert (this.lastRecipe != null);
        GTRecipe.ActionResult result = this.lastRecipe.checkConditions(this);
        if (result.isSuccess()) {
            if (this.handleFuelRecipe()) {
                result = this.handleTickRecipe(this.lastRecipe);
                if (result.isSuccess()) {
                    this.setStatus(Status.WORKING);
                    if (!this.machine.onWorking()) {
                        this.interruptRecipe();
                        return;
                    }
                    ++this.progress;
                    ++this.totalContinuousRunningTime;
                } else {
                    this.setWaiting(result.reason().get());
                }
            } else {
                this.setWaiting((Component)Component.m_237115_((String)"gtceu.recipe_logic.insufficient_fuel"));
            }
        } else {
            this.setWaiting(result.reason().get());
        }
        if (this.isWaiting()) {
            this.doDamping();
        }
        if (last == Status.WORKING && this.getStatus() != Status.WORKING) {
            this.lastRecipe.postWorking(this.machine);
        } else if (last != Status.WORKING && this.getStatus() == Status.WORKING) {
            this.lastRecipe.preWorking(this.machine);
        }
    }

    protected void doDamping() {
        if (this.progress > 0 && this.machine.dampingWhenWaiting()) {
            this.progress = ConfigHolder.INSTANCE.machines.recipeProgressLowEnergy ? 1 : Math.max(1, this.progress - 2);
        }
    }

    protected Iterator<GTRecipe> searchRecipe() {
        return this.machine.getRecipeType().searchRecipe(this.machine);
    }

    public void findAndHandleRecipe() {
        this.lastFailedMatches = null;
        if (!this.recipeDirty && this.lastRecipe != null && this.lastRecipe.matchRecipe(this.machine).isSuccess() && this.lastRecipe.matchTickRecipe(this.machine).isSuccess() && this.lastRecipe.checkConditions(this).isSuccess()) {
            GTRecipe recipe = this.lastRecipe;
            this.lastRecipe = null;
            this.lastOriginRecipe = null;
            this.setupRecipe(recipe);
        } else {
            this.lastRecipe = null;
            this.lastOriginRecipe = null;
            this.handleSearchingRecipes(this.searchRecipe());
        }
        this.recipeDirty = false;
    }

    private void handleSearchingRecipes(Iterator<GTRecipe> matches) {
        while (matches != null && matches.hasNext()) {
            GTRecipe match = matches.next();
            if (match == null) continue;
            if (this.checkMatchedRecipeAvailable(match)) {
                return;
            }
            if (this.lastFailedMatches == null) {
                this.lastFailedMatches = new ArrayList<GTRecipe>();
            }
            this.lastFailedMatches.add(match);
        }
    }

    public boolean handleFuelRecipe() {
        if (!this.needFuel() || this.fuelTime > 0) {
            return true;
        }
        Iterator<GTRecipe> iterator = this.machine.getRecipeType().searchFuelRecipe(this.machine);
        while (iterator != null && iterator.hasNext()) {
            GTRecipe recipe = iterator.next();
            if (recipe == null) continue;
            if (recipe.checkConditions(this).isSuccess() && this.handleRecipeIO(recipe, IO.IN)) {
                this.fuelTime = this.fuelMaxTime = recipe.duration;
            }
            if (this.fuelTime <= 0) continue;
            return true;
        }
        return false;
    }

    public GTRecipe.ActionResult handleTickRecipe(GTRecipe recipe) {
        if (recipe.hasTick()) {
            GTRecipe.ActionResult result = recipe.matchTickRecipe(this.machine);
            if (result.isSuccess()) {
                this.handleTickRecipeIO(recipe, IO.IN);
                this.handleTickRecipeIO(recipe, IO.OUT);
            } else {
                return result;
            }
        }
        return GTRecipe.ActionResult.SUCCESS;
    }

    public void setupRecipe(GTRecipe recipe) {
        if (this.handleFuelRecipe()) {
            if (!this.machine.beforeWorking(recipe)) {
                this.setStatus(Status.IDLE);
                this.progress = 0;
                this.duration = 0;
                this.isActive = false;
                return;
            }
            recipe.preWorking(this.machine);
            if (this.handleRecipeIO(recipe, IO.IN)) {
                if (this.lastRecipe != null && !recipe.equals(this.lastRecipe)) {
                    this.chanceCaches.clear();
                }
                this.recipeDirty = false;
                this.lastRecipe = recipe;
                this.setStatus(Status.WORKING);
                this.progress = 0;
                this.duration = recipe.duration;
                this.isActive = true;
            }
        }
    }

    public void setStatus(Status status) {
        if (this.status != status) {
            if (this.status == Status.WORKING) {
                this.totalContinuousRunningTime = 0L;
            }
            this.machine.notifyStatusChanged(this.status, status);
            this.status = status;
            this.updateTickSubscription();
            if (this.status != Status.WAITING) {
                this.waitingReason = null;
            }
        }
    }

    public void setWaiting(@Nullable Component reason) {
        this.setStatus(Status.WAITING);
        this.waitingReason = reason;
        this.machine.onWaiting();
    }

    public void markLastRecipeDirty() {
        this.recipeDirty = true;
    }

    public boolean isWorking() {
        return this.status == Status.WORKING;
    }

    public boolean isIdle() {
        return this.status == Status.IDLE;
    }

    public boolean isWaiting() {
        return this.status == Status.WAITING;
    }

    public boolean isSuspend() {
        return this.status == Status.SUSPEND;
    }

    @Override
    public boolean isWorkingEnabled() {
        return !this.isSuspend();
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingAllowed) {
        if (!isWorkingAllowed) {
            this.setStatus(Status.SUSPEND);
        } else if (this.lastRecipe != null && this.duration > 0) {
            this.setStatus(Status.WORKING);
        } else {
            this.setStatus(Status.IDLE);
        }
    }

    @Override
    public int getMaxProgress() {
        return this.duration;
    }

    @Override
    public boolean isActive() {
        return this.isWorking() || this.isWaiting() || this.isSuspend() && this.isActive;
    }

    @Deprecated
    public boolean isHasNotEnoughEnergy() {
        return this.isWaiting();
    }

    public void onRecipeFinish() {
        this.machine.afterWorking();
        if (this.lastRecipe != null) {
            this.lastRecipe.postWorking(this.machine);
            this.handleRecipeIO(this.lastRecipe, IO.OUT);
            if (this.machine.alwaysTryModifyRecipe()) {
                if (this.lastOriginRecipe != null) {
                    GTRecipe modified = this.machine.fullModifyRecipe(this.lastOriginRecipe.copy(), this.ocParams, this.ocResult);
                    if (modified == null) {
                        this.markLastRecipeDirty();
                    } else {
                        this.lastRecipe = modified;
                    }
                } else {
                    this.markLastRecipeDirty();
                }
            }
            if (!this.recipeDirty && this.lastRecipe.matchRecipe(this.machine).isSuccess() && this.lastRecipe.matchTickRecipe(this.machine).isSuccess() && this.lastRecipe.checkConditions(this).isSuccess()) {
                this.setupRecipe(this.lastRecipe);
            } else {
                this.setStatus(Status.IDLE);
                this.progress = 0;
                this.duration = 0;
                this.isActive = false;
            }
        }
    }

    protected boolean handleRecipeIO(GTRecipe recipe, IO io) {
        return recipe.handleRecipeIO(io, this.machine, this.chanceCaches);
    }

    protected boolean handleTickRecipeIO(GTRecipe recipe, IO io) {
        return recipe.handleTickRecipeIO(io, this.machine, this.chanceCaches);
    }

    public void interruptRecipe() {
        this.machine.afterWorking();
        if (this.lastRecipe != null) {
            this.lastRecipe.postWorking(this.machine);
            this.setStatus(Status.IDLE);
            this.progress = 0;
            this.duration = 0;
            this.ocResult.reset();
        }
    }

    public void inValid() {
        if (this.lastRecipe != null && this.isWorking()) {
            this.lastRecipe.postWorking(this.machine);
        }
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateSound() {
        if (this.isWorking() && this.machine.shouldWorkingPlaySound()) {
            SoundEntry sound = this.machine.getRecipeType().getSound();
            Object object = this.workingSound;
            if (object instanceof AutoReleasedSound) {
                AutoReleasedSound soundEntry = (AutoReleasedSound)((Object)object);
                if (soundEntry.soundEntry == sound && !soundEntry.m_7801_()) {
                    return;
                }
                soundEntry.release();
                this.workingSound = null;
            }
            if (sound != null) {
                this.workingSound = sound.playAutoReleasedSound(() -> this.machine.shouldWorkingPlaySound() && this.isWorking() && !this.getMachine().isInValid() && this.getMachine().getLevel().m_46749_(this.getMachine().getPos()) && MetaMachine.getMachine((BlockGetter)this.getMachine().getLevel(), this.getMachine().getPos()) == this.getMachine(), this.getMachine().getPos(), true, 0, 1.0f, 1.0f);
            }
        } else {
            Object object = this.workingSound;
            if (object instanceof AutoReleasedSound) {
                AutoReleasedSound soundEntry = (AutoReleasedSound)((Object)object);
                soundEntry.release();
                this.workingSound = null;
            }
        }
    }

    @Override
    public IGuiTexture getFancyTooltipIcon() {
        if (this.isWaiting()) {
            return GuiTextures.INSUFFICIENT_INPUT;
        }
        return IGuiTexture.EMPTY;
    }

    @Override
    public List<Component> getFancyTooltip() {
        if (this.isWaiting() && this.waitingReason != null) {
            return List.of(this.waitingReason);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean showFancyTooltip() {
        return this.isWaiting();
    }

    protected Map<RecipeCapability<?>, Object2IntMap<?>> makeChanceCaches() {
        IdentityHashMap map = new IdentityHashMap();
        for (RecipeCapability cap : GTRegistries.RECIPE_CAPABILITIES.values()) {
            map.put(cap, cap.makeChanceCache());
        }
        return map;
    }

    @Override
    public void saveCustomPersistedData(@NotNull CompoundTag tag, boolean forDrop) {
        super.saveCustomPersistedData(tag, forDrop);
        CompoundTag chanceCache = new CompoundTag();
        this.chanceCaches.forEach((cap, cache) -> {
            ListTag cacheTag = new ListTag();
            for (Object2IntMap.Entry entry : cache.object2IntEntrySet()) {
                CompoundTag compoundTag = new CompoundTag();
                Tag obj = cap.serializer.toNbtGeneric(cap.of(entry.getKey()));
                compoundTag.m_128365_("entry", obj);
                compoundTag.m_128405_("cached_chance", entry.getIntValue());
                cacheTag.add((Object)compoundTag);
            }
            chanceCache.m_128365_(cap.name, (Tag)cacheTag);
        });
        tag.m_128365_("chance_cache", (Tag)chanceCache);
    }

    @Override
    public void loadCustomPersistedData(@NotNull CompoundTag tag) {
        super.loadCustomPersistedData(tag);
        CompoundTag chanceCache = tag.m_128469_("chance_cache");
        for (String key : chanceCache.m_128431_()) {
            RecipeCapability cap2 = (RecipeCapability)GTRegistries.RECIPE_CAPABILITIES.get(key);
            Object2IntMap map = this.chanceCaches.computeIfAbsent(cap2, val -> val.makeChanceCache());
            ListTag chanceTag = chanceCache.m_128437_(key, 10);
            for (int i = 0; i < chanceTag.size(); ++i) {
                CompoundTag chanceKey = chanceTag.m_128728_(i);
                Object entry = cap2.serializer.fromNbt(chanceKey.m_128423_("entry"));
                int value = chanceKey.m_128451_("cached_chance");
                map.put(entry, value);
            }
        }
        this.chanceCaches.forEach((cap, cache) -> {
            ListTag cacheTag = new ListTag();
            for (Object2IntMap.Entry entry : cache.object2IntEntrySet()) {
                CompoundTag compoundTag = new CompoundTag();
                Tag obj = cap.serializer.toNbtGeneric(cap.of(entry.getKey()));
                compoundTag.m_128365_("entry", obj);
                compoundTag.m_128405_("cached_chance", entry.getIntValue());
                cacheTag.add((Object)compoundTag);
            }
            chanceCache.m_128365_(cap.name, (Tag)cacheTag);
        });
        tag.m_128365_("chance_cache", (Tag)chanceCache);
    }

    public Status getStatus() {
        return this.status;
    }

    @Nullable
    public GTRecipe getLastRecipe() {
        return this.lastRecipe;
    }

    @Nullable
    public GTRecipe getLastOriginRecipe() {
        return this.lastOriginRecipe;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getFuelTime() {
        return this.fuelTime;
    }

    public int getFuelMaxTime() {
        return this.fuelMaxTime;
    }

    @VisibleForTesting
    public boolean isRecipeDirty() {
        return this.recipeDirty;
    }

    public long getTotalContinuousRunningTime() {
        return this.totalContinuousRunningTime;
    }

    public Map<RecipeCapability<?>, Object2IntMap<?>> getChanceCaches() {
        return this.chanceCaches;
    }

    public static enum Status {
        IDLE,
        WORKING,
        WAITING,
        SUSPEND;

    }
}

