/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.fancyconfigurator;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.gregtechceu.gtceu.api.gui.widget.PredicatedButtonWidget;
import com.gregtechceu.gtceu.api.machine.feature.IOverclockMachine;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;

public class OverclockFancyConfigurator
implements IFancyConfigurator {
    protected IOverclockMachine overclockMachine;
    protected int currentTier;

    public OverclockFancyConfigurator(IOverclockMachine overclockMachine) {
        this.overclockMachine = overclockMachine;
    }

    @Override
    public Component getTitle() {
        return Component.m_237115_((String)"gtceu.gui.overclock.title");
    }

    @Override
    public IGuiTexture getIcon() {
        return this.currentTier <= 8 ? GuiTextures.TIER[this.currentTier].copy().scale(1.2f) : new TextTexture(GTValues.VNF[this.currentTier]).setDropShadow(false);
    }

    @Override
    public void writeInitialData(FriendlyByteBuf buffer) {
        this.currentTier = this.overclockMachine.getOverclockTier();
        buffer.m_130130_(this.currentTier);
    }

    @Override
    public void readInitialData(FriendlyByteBuf buffer) {
        this.currentTier = buffer.m_130242_();
    }

    @Override
    public void detectAndSendChange(BiConsumer<Integer, Consumer<FriendlyByteBuf>> sender) {
        int newTier = this.overclockMachine.getOverclockTier();
        if (newTier != this.currentTier) {
            this.currentTier = newTier;
            sender.accept(0, buf -> buf.m_130130_(newTier));
        }
    }

    @Override
    public void readUpdateInfo(int id, FriendlyByteBuf buf) {
        if (id == 0) {
            this.currentTier = buf.m_130242_();
        }
    }

    @Override
    public Widget createConfigurator() {
        return new WidgetGroup(0, 0, 120, 40){
            final Map<Integer, WidgetGroup> lightGroups;
            {
                this.lightGroups = new HashMap<Integer, WidgetGroup>();
            }

            public void initWidget() {
                super.initWidget();
                this.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
                this.addWidget((Widget)new PredicatedButtonWidget(5, 5, 10, 20, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, Icons.LEFT.copy().scale(0.7f)}), cd -> {
                    if (!cd.isRemote) {
                        OverclockFancyConfigurator.this.overclockMachine.setOverclockTier(OverclockFancyConfigurator.this.currentTier - 1);
                    }
                }, () -> OverclockFancyConfigurator.this.currentTier > OverclockFancyConfigurator.this.overclockMachine.getMinOverclockTier()));
                this.addWidget((Widget)new ImageWidget(20, 5, 80, 20, () -> new GuiTextureGroup(new IGuiTexture[]{GuiTextures.DISPLAY_FRAME, new TextTexture(GTValues.VNF[OverclockFancyConfigurator.this.currentTier])})));
                this.addWidget((Widget)new PredicatedButtonWidget(105, 5, 10, 20, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, Icons.RIGHT.copy().scale(0.7f)}), cd -> {
                    if (!cd.isRemote) {
                        OverclockFancyConfigurator.this.overclockMachine.setOverclockTier(OverclockFancyConfigurator.this.currentTier + 1);
                    }
                }, () -> OverclockFancyConfigurator.this.currentTier < OverclockFancyConfigurator.this.overclockMachine.getMaxOverclockTier()));
            }

            public void writeInitialData(FriendlyByteBuf buffer) {
                int min = OverclockFancyConfigurator.this.overclockMachine.getMinOverclockTier();
                int max = OverclockFancyConfigurator.this.overclockMachine.getMaxOverclockTier();
                buffer.m_130130_(min);
                buffer.m_130130_(max);
                buffer.m_130130_(OverclockFancyConfigurator.this.currentTier);
                this.updateLightButton(min, max);
                super.writeInitialData(buffer);
            }

            public void readInitialData(FriendlyByteBuf buffer) {
                int min = buffer.m_130242_();
                int max = buffer.m_130242_();
                OverclockFancyConfigurator.this.currentTier = buffer.m_130242_();
                this.updateLightButton(min, max);
                super.readInitialData(buffer);
            }

            private void updateLightButton(int min, int max) {
                for (WidgetGroup light : this.lightGroups.values()) {
                    this.removeWidget((Widget)light);
                }
                this.lightGroups.clear();
                int x = 5;
                for (int tier = min; tier <= max; ++tier) {
                    int finalTier = tier;
                    WidgetGroup lightGroup = new WidgetGroup(x, 27, 8, 8);
                    lightGroup.addWidget((Widget)new ButtonWidget(0, 0, 8, 8, null, cd -> {
                        if (!cd.isRemote) {
                            OverclockFancyConfigurator.this.overclockMachine.setOverclockTier(finalTier);
                        }
                    }));
                    lightGroup.addWidget((Widget)new ImageWidget(0, 0, 8, 8, () -> OverclockFancyConfigurator.this.currentTier >= finalTier ? GuiTextures.LIGHT_ON : GuiTextures.LIGHT_OFF));
                    this.lightGroups.put(tier, lightGroup);
                    this.addWidget((Widget)lightGroup);
                    x += 10;
                }
            }

            public void detectAndSendChanges() {
                super.detectAndSendChanges();
                int min = OverclockFancyConfigurator.this.overclockMachine.getMinOverclockTier();
                int max = OverclockFancyConfigurator.this.overclockMachine.getMaxOverclockTier();
                if (this.lightGroups.size() != max - min + 1) {
                    this.updateLightButton(min, max);
                    this.writeUpdateInfo(0, buf -> {
                        buf.m_130130_(min);
                        buf.m_130130_(max);
                    });
                } else {
                    for (int i = min; i <= max; ++i) {
                        if (this.lightGroups.containsKey(i)) continue;
                        this.updateLightButton(min, max);
                        this.writeUpdateInfo(0, buf -> {
                            buf.m_130130_(min);
                            buf.m_130130_(max);
                        });
                        return;
                    }
                }
            }

            public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
                if (id == 0) {
                    int min = buffer.m_130242_();
                    int max = buffer.m_130242_();
                    this.updateLightButton(min, max);
                } else {
                    super.readUpdateInfo(id, buffer);
                }
            }
        };
    }

    @Override
    public List<Component> getTooltips() {
        return List.of(this.getTitle(), Component.m_237110_((String)"gtceu.gui.overclock.range", (Object[])new Object[]{GTValues.VNF[this.overclockMachine.getMinOverclockTier()], GTValues.VNF[this.overclockMachine.getMaxOverclockTier()]}));
    }
}

