/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.fancyconfigurator;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;

public class FancyInvConfigurator
implements IFancyConfigurator {
    private final ItemStackTransfer inventory;
    private final Component title;
    private List<Component> tooltips = Collections.emptyList();

    public FancyInvConfigurator(ItemStackTransfer inventory, Component title) {
        this.inventory = inventory;
        this.title = title;
    }

    @Override
    public IGuiTexture getIcon() {
        return GuiTextures.BUTTON_ITEM_OUTPUT;
    }

    @Override
    public Widget createConfigurator() {
        int rowSize;
        int colSize = rowSize = (int)Math.sqrt(this.inventory.getSlots());
        if (this.inventory.getSlots() == 8) {
            rowSize = 4;
            colSize = 2;
        }
        WidgetGroup group = new WidgetGroup(0, 0, 18 * rowSize + 16, 18 * colSize + 16);
        WidgetGroup container = new WidgetGroup(4, 4, 18 * rowSize + 8, 18 * colSize + 8);
        int index = 0;
        for (int y = 0; y < colSize; ++y) {
            for (int x = 0; x < rowSize; ++x) {
                container.addWidget((Widget)new SlotWidget((IItemTransfer)this.inventory, index++, 4 + x * 18, 4 + y * 18, true, true).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT).setIngredientIO(IngredientIO.INPUT));
            }
        }
        container.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        group.addWidget((Widget)container);
        return group;
    }

    @Override
    public Component getTitle() {
        return this.title;
    }

    @Override
    public List<Component> getTooltips() {
        return this.tooltips;
    }

    public FancyInvConfigurator setTooltips(List<Component> tooltips) {
        this.tooltips = tooltips;
        return this;
    }
}

