/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.tool;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ToolProperty;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.aoe.AoESymmetrical;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.SizedIngredient;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.DummyMachineBlockEntity;
import com.gregtechceu.gtceu.utils.InfiniteEnergyContainer;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.DigDurabilityEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolHelper {
    public static final String TOOL_TAG_KEY = "GT.Tool";
    public static final String BEHAVIOURS_TAG_KEY = "GT.Behaviours";
    public static final String MAX_CHARGE_KEY = "MaxCharge";
    public static final String CHARGE_KEY = "Charge";
    public static final String UNBREAKABLE_KEY = "Unbreakable";
    public static final String HIDE_FLAGS = "HideFlags";
    public static final String DISALLOW_CONTAINER_ITEM_KEY = "DisallowContainerItem";
    public static final String TINT_COLOR_KEY = "TintColor";
    public static final String DURABILITY_KEY = "Damage";
    public static final String MAX_DURABILITY_KEY = "MaxDamage";
    public static final String TOOL_SPEED_KEY = "ToolSpeed";
    public static final String ATTACK_DAMAGE_KEY = "AttackDamage";
    public static final String ATTACK_SPEED_KEY = "AttackSpeed";
    public static final String ENCHANTABILITY_KEY = "Enchantability";
    public static final String HARVEST_LEVEL_KEY = "HarvestLevel";
    public static final String LAST_CRAFTING_USE_KEY = "LastCraftingUse";
    public static final String MAX_AOE_COLUMN_KEY = "MaxAoEColumn";
    public static final String MAX_AOE_ROW_KEY = "MaxAoERow";
    public static final String MAX_AOE_LAYER_KEY = "MaxAoELayer";
    public static final String AOE_COLUMN_KEY = "AoEColumn";
    public static final String AOE_ROW_KEY = "AoERow";
    public static final String AOE_LAYER_KEY = "AoELayer";
    public static final String HARVEST_ICE_KEY = "HarvestIce";
    public static final String TORCH_PLACING_KEY = "TorchPlacing";
    public static final String TORCH_PLACING_CACHE_SLOT_KEY = "TorchPlacing$Slot";
    public static final String TREE_FELLING_KEY = "TreeFelling";
    public static final String DISABLE_SHIELDS_KEY = "DisableShields";
    public static final String RELOCATE_MINED_BLOCKS_KEY = "RelocateMinedBlocks";
    private static final BiMap<Character, GTToolType> symbols = HashBiMap.create();
    public static final Supplier<ItemStack> SUPPLY_POWER_UNIT_LV = () -> ((ComponentItem)GTItems.POWER_UNIT_LV.get()).m_7968_();
    public static final Supplier<ItemStack> SUPPLY_POWER_UNIT_MV = () -> ((ComponentItem)GTItems.POWER_UNIT_MV.get()).m_7968_();
    public static final Supplier<ItemStack> SUPPLY_POWER_UNIT_HV = () -> ((ComponentItem)GTItems.POWER_UNIT_HV.get()).m_7968_();
    public static final Supplier<ItemStack> SUPPLY_POWER_UNIT_EV = () -> ((ComponentItem)GTItems.POWER_UNIT_EV.get()).m_7968_();
    public static final Supplier<ItemStack> SUPPLY_POWER_UNIT_IV = () -> ((ComponentItem)GTItems.POWER_UNIT_IV.get()).m_7968_();

    private ToolHelper() {
    }

    public static Character getSymbolFromTool(GTToolType tool) {
        return (Character)symbols.inverse().get((Object)tool);
    }

    public static GTToolType getToolFromSymbol(Character symbol) {
        return (GTToolType)symbols.get((Object)symbol);
    }

    public static Set<Character> getToolSymbols() {
        return symbols.keySet();
    }

    public static void registerToolSymbol(Character symbol, GTToolType tool) {
        symbols.put((Object)symbol, (Object)tool);
    }

    public static CompoundTag getToolTag(ItemStack stack) {
        return stack.m_41698_(TOOL_TAG_KEY);
    }

    public static CompoundTag getBehaviorsTag(ItemStack stack) {
        return stack.m_41698_(BEHAVIOURS_TAG_KEY);
    }

    public static boolean hasBehaviorsTag(ItemStack stack) {
        return stack.m_41737_(BEHAVIOURS_TAG_KEY) != null;
    }

    public static ItemStack get(GTToolType toolType, Material material) {
        ItemProviderEntry entry;
        if (material.hasProperty(PropertyKey.TOOL) && (entry = (ItemProviderEntry)GTItems.TOOL_ITEMS.get((Object)material, (Object)toolType)) != null) {
            return ((IGTTool)entry.get()).get();
        }
        return ItemStack.f_41583_;
    }

    public static boolean is(ItemStack stack, GTToolType toolType) {
        return ToolHelper.getToolTypes(stack).contains(toolType);
    }

    public static boolean canUse(ItemStack stack) {
        return stack.m_41773_() <= stack.m_41776_();
    }

    public static void damageItem(@NotNull ItemStack stack, @Nullable LivingEntity user, int damage) {
        Item item = stack.m_41720_();
        if (!(item instanceof IGTTool)) {
            if (user != null) {
                stack.m_41622_(damage, user, p -> {});
            }
        } else {
            Player player;
            IGTTool tool = (IGTTool)item;
            if (stack.m_41783_() != null && stack.m_41783_().m_128471_(UNBREAKABLE_KEY)) {
                return;
            }
            if (!(user instanceof Player) || !(player = (Player)user).m_7500_()) {
                RandomSource random;
                RandomSource randomSource = random = user == null ? GTValues.RNG : user.m_217043_();
                if (tool.isElectric()) {
                    int electricDamage = damage * ConfigHolder.INSTANCE.machines.energyUsageMultiplier;
                    IElectricItem electricItem = GTCapabilityHelper.getElectricItem(stack);
                    if (electricItem != null) {
                        electricItem.discharge(electricDamage, tool.getElectricTier(), true, false, false);
                        if (electricItem.getCharge() > 0L && random.m_188503_(100) >= ConfigHolder.INSTANCE.tools.rngDamageElectricTools) {
                            return;
                        }
                    } else {
                        throw new IllegalStateException("Electric tool does not have an attached electric item capability.");
                    }
                }
                int unbreakingLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)stack);
                int negated = 0;
                for (int k = 0; unbreakingLevel > 0 && k < damage; ++k) {
                    if (!DigDurabilityEnchantment.m_220282_((ItemStack)stack, (int)unbreakingLevel, (RandomSource)random)) continue;
                    ++negated;
                }
                if ((damage -= negated) <= 0) {
                    return;
                }
                int newDurability = stack.m_41773_() + damage;
                if (user instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)user;
                    CriteriaTriggers.f_10586_.m_43669_(serverPlayer, stack, newDurability);
                }
                stack.m_41721_(newDurability);
                if (newDurability > stack.m_41776_()) {
                    if (user instanceof Player) {
                        Player player2 = (Player)user;
                        Stat stat = Stats.f_12983_.m_12902_((Object)stack.m_41720_());
                        player2.m_36246_(stat);
                    }
                    if (user != null) {
                        user.m_21278_(stack);
                    }
                    stack.m_41774_(1);
                }
            }
        }
    }

    public static void playToolSound(GTToolType toolType, ServerPlayer player) {
        if (toolType.soundEntry != null) {
            toolType.soundEntry.playOnServer(player.m_9236_(), (Vec3i)player.m_20183_());
        }
    }

    public static ItemStack getAndSetToolData(GTToolType toolType, Material material, int maxDurability, int harvestLevel, float toolSpeed, float attackDamage) {
        ItemProviderEntry entry = (ItemProviderEntry)GTItems.TOOL_ITEMS.get((Object)material, (Object)toolType);
        if (entry == null) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = ((IGTTool)entry.get()).getRaw();
        stack.m_41784_().m_128405_(HIDE_FLAGS, 2);
        CompoundTag toolTag = ToolHelper.getToolTag(stack);
        toolTag.m_128405_(MAX_DURABILITY_KEY, maxDurability);
        toolTag.m_128405_(HARVEST_LEVEL_KEY, harvestLevel);
        toolTag.m_128350_(TOOL_SPEED_KEY, toolSpeed);
        toolTag.m_128350_(ATTACK_DAMAGE_KEY, attackDamage);
        ToolProperty toolProperty = material.getProperty(PropertyKey.TOOL);
        if (toolProperty != null) {
            toolProperty.getEnchantments().forEach((enchantment, level) -> {
                if (((IGTTool)entry.get()).definition$canApplyAtEnchantingTable(stack, (Enchantment)enchantment)) {
                    stack.m_41663_(enchantment, level.intValue());
                }
            });
        }
        return stack;
    }

    public static boolean areaOfEffectBlockBreakRoutine(ItemStack stack, ServerPlayer player) {
        int currentDurability = stack.m_41773_();
        int maximumDurability = stack.m_41776_();
        int remainingUses = maximumDurability - currentDurability;
        Set<BlockPos> harvestableBlocks = ToolHelper.getHarvestableBlocks(stack, (Player)player);
        if (!harvestableBlocks.isEmpty()) {
            int blocksBroken = 0;
            for (BlockPos pos : harvestableBlocks) {
                IGTTool gtTool;
                if (!ToolHelper.breakBlockRoutine(player, stack, pos, blocksBroken++ == 0)) {
                    return true;
                }
                Item item = stack.m_41720_();
                if (item instanceof IGTTool && !(gtTool = (IGTTool)item).isElectric() && --remainingUses == 0) {
                    return true;
                }
                if (ItemStack.m_41656_((ItemStack)player.m_21205_(), (ItemStack)stack)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public static AoESymmetrical getMaxAoEDefinition(ItemStack stack) {
        return AoESymmetrical.readMax(ToolHelper.getBehaviorsTag(stack));
    }

    public static AoESymmetrical getAoEDefinition(ItemStack stack) {
        return AoESymmetrical.read(ToolHelper.getBehaviorsTag(stack), ToolHelper.getMaxAoEDefinition(stack));
    }

    public static Set<BlockPos> iterateAoE(ItemStack stack, AoESymmetrical aoeDefinition, Level world, Player player, HitResult rayTraceResult, AOEFunction function) {
        BlockHitResult blockHit;
        if (aoeDefinition != AoESymmetrical.none() && rayTraceResult instanceof BlockHitResult && (blockHit = (BlockHitResult)rayTraceResult).m_82434_() != null) {
            int column = aoeDefinition.column;
            int row = aoeDefinition.row;
            int layer = aoeDefinition.layer;
            Direction playerFacing = player.m_6350_();
            Direction.Axis playerAxis = playerFacing.m_122434_();
            Direction.Axis sideHitAxis = blockHit.m_82434_().m_122434_();
            Direction.AxisDirection sideHitAxisDir = blockHit.m_82434_().m_122421_();
            ObjectOpenHashSet validPositions = new ObjectOpenHashSet();
            if (sideHitAxis.m_122478_()) {
                boolean isX = playerAxis == Direction.Axis.X;
                boolean isDown = sideHitAxisDir == Direction.AxisDirection.NEGATIVE;
                for (int y = 0; y <= layer; ++y) {
                    for (int x = isX ? -row : -column; x <= (isX ? row : column); ++x) {
                        for (int z = isX ? -column : -row; z <= (isX ? column : row); ++z) {
                            BlockPos pos;
                            if (x == 0 && y == 0 && z == 0 || !player.m_36204_((pos = blockHit.m_82425_().m_7918_(x, isDown ? y : -y, z)).m_121945_(blockHit.m_82434_()), blockHit.m_82434_(), stack) || !function.apply(stack, world, player, pos, new UseOnContext(player.m_9236_(), player, player.m_7655_(), stack, blockHit))) continue;
                            validPositions.add(pos);
                        }
                    }
                }
            } else {
                boolean isX = sideHitAxis == Direction.Axis.X;
                boolean isNegative = sideHitAxisDir == Direction.AxisDirection.NEGATIVE;
                for (int x = 0; x <= layer; ++x) {
                    for (int y = row == 0 ? 0 : -1; y <= (row == 0 ? 0 : row * 2 - 1); ++y) {
                        for (int z = -column; z <= column; ++z) {
                            if (x == 0 && y == 0 && z == 0) continue;
                            BlockPos pos = blockHit.m_82425_().m_7918_(isX ? (isNegative ? x : -x) : (isNegative ? z : -z), y, isX ? (isNegative ? z : -z) : (isNegative ? x : -x));
                            if (!function.apply(stack, world, player, pos, new UseOnContext(player.m_9236_(), player, player.m_7655_(), stack, blockHit))) continue;
                            validPositions.add(pos);
                        }
                    }
                }
            }
            return validPositions;
        }
        return Collections.emptySet();
    }

    public static Set<BlockPos> getHarvestableBlocks(ItemStack stack, AoESymmetrical aoeDefinition, Level world, Player player, HitResult rayTraceResult) {
        return ToolHelper.iterateAoE(stack, aoeDefinition, world, player, rayTraceResult, ToolHelper::isBlockAoEHarvestable);
    }

    private static boolean isBlockAoEHarvestable(ItemStack stack, Level world, Player player, BlockPos pos, UseOnContext context) {
        if (world.m_8055_(pos).m_60795_()) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() instanceof LiquidBlock) {
            return false;
        }
        BlockPos hitBlockPos = context.m_8083_();
        BlockState hitBlockState = world.m_8055_(hitBlockPos);
        if (state.m_60800_((BlockGetter)world, pos) < 0.0f || state.m_60800_((BlockGetter)world, pos) - hitBlockState.m_60800_((BlockGetter)world, hitBlockPos) > 8.0f) {
            return false;
        }
        return stack.m_41720_().isCorrectToolForDrops(stack, state);
    }

    public static void applyHammerDropConversion(ServerLevel world, BlockPos pos, ItemStack tool, BlockState state, List<ItemStack> drops, int fortune, float dropChance, RandomSource random) {
        if (ToolHelper.is(tool, GTToolType.HARD_HAMMER)) {
            List<ItemStack> silktouchDrops = ToolHelper.getSilkTouchDrop(world, pos, state);
            for (ItemStack silktouchDrop : silktouchDrops) {
                if (silktouchDrop.m_41619_()) continue;
                Table caps = Tables.newCustomTable(new EnumMap(IO.class), IdentityHashMap::new);
                DummyMachineBlockEntity be = new DummyMachineBlockEntity(1, GTRecipeTypes.FORGE_HAMMER_RECIPES, GTMachines.defaultTankSizeFunction, caps, new Object[0]);
                caps.put((Object)IO.IN, (Object)EURecipeCapability.CAP, List.of(new InfiniteEnergyContainer(be.getMetaMachine(), GTValues.V[1], GTValues.V[1], 1L, GTValues.V[1], 1L)));
                caps.put((Object)IO.IN, (Object)ItemRecipeCapability.CAP, List.of(new NotifiableItemStackHandler(be.getMetaMachine(), 1, IO.IN, IO.IN, slots -> new ItemStackTransfer(silktouchDrop))));
                caps.put((Object)IO.OUT, (Object)ItemRecipeCapability.CAP, List.of(new NotifiableItemStackHandler(be.getMetaMachine(), 2, IO.OUT)));
                be.getMetaMachine().reinitializeCapabilities(caps);
                Iterator<GTRecipe> hammerRecipes = GTRecipeTypes.FORGE_HAMMER_RECIPES.searchRecipe(be.metaMachine);
                GTRecipe hammerRecipe = hammerRecipes == null || !hammerRecipes.hasNext() ? null : hammerRecipes.next();
                if (hammerRecipe == null || !hammerRecipe.handleRecipeIO(IO.IN, be.metaMachine, be.getMetaMachine().recipeLogic.getChanceCaches())) continue;
                drops.clear();
                TagPrefix prefix = ChemicalHelper.getPrefix((ItemLike)silktouchDrop.m_41720_());
                if (prefix == null) {
                    for (Content output : hammerRecipe.getOutputContents(ItemRecipeCapability.CAP)) {
                        if (!(dropChance >= 1.0f) && !(random.m_188501_() <= dropChance)) continue;
                        drops.add(SizedIngredient.copy((Ingredient)ItemRecipeCapability.CAP.of(output.content)).m_43908_()[0]);
                    }
                    continue;
                }
                if (!TagPrefix.ORES.containsKey(prefix)) continue;
                for (Content content : hammerRecipe.getOutputContents(ItemRecipeCapability.CAP)) {
                    ItemStack output;
                    if (!(dropChance >= 1.0f) && !(random.m_188501_() <= dropChance) || ChemicalHelper.getPrefix((ItemLike)(output = ((Ingredient)ItemRecipeCapability.CAP.of(content.content)).m_43908_()[0]).m_41720_()) != TagPrefix.crushed) continue;
                    output = output.m_41777_();
                    if (fortune > 0) {
                        output.m_41769_(random.m_188503_(fortune));
                    }
                    drops.add(output);
                }
            }
        }
    }

    public static boolean breakBlockRoutine(ServerPlayer player, ItemStack tool, BlockPos pos, boolean playSound) {
        if (ToolHelper.isTool(tool, GTToolType.SHEARS) && ToolHelper.shearBlockRoutine(player, tool, pos) == 0) {
            return false;
        }
        Level world = player.m_9236_();
        boolean canBreak = ToolHelper.onBlockBreakEvent(world, player.f_8941_.m_9290_(), player, pos);
        if (!canBreak) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        BlockEntity tile = world.m_7702_(pos);
        if (block instanceof GameMasterBlock && !player.m_36337_()) {
            world.m_7260_(pos, state, state, 3);
            return false;
        }
        if (player.m_36187_(world, pos, player.f_8941_.m_9290_())) {
            return false;
        }
        if (player.m_7500_()) {
            return ToolHelper.removeBlockRoutine(state, world, player, pos, playSound);
        }
        world.m_5898_((Player)player, 2001, pos, Block.m_49956_((BlockState)state));
        boolean successful = ToolHelper.removeBlockRoutine(state, world, player, pos, playSound);
        ItemStack copiedTool = tool.m_41777_();
        boolean canHarvest = player.m_36298_(state);
        tool.m_41686_(world, state, pos, (Player)player);
        if (tool.m_41619_() && !copiedTool.m_41619_()) {
            ToolHelper.onPlayerDestroyItem((Player)player, copiedTool, InteractionHand.MAIN_HAND);
        }
        if (successful && canHarvest) {
            block.m_6240_(world, (Player)player, pos, state, tile, copiedTool);
        }
        return successful;
    }

    public static boolean onBlockBreakEvent(Level level, GameType gameType, ServerPlayer player, BlockPos pos) {
        return ForgeHooks.onBlockBreakEvent((Level)level, (GameType)gameType, (ServerPlayer)player, (BlockPos)pos) != -1;
    }

    public static void onPlayerDestroyItem(Player player, ItemStack stack, InteractionHand hand) {
        ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)stack, (InteractionHand)hand);
    }

    public static double getPlayerBlockReach(@NotNull Player player) {
        return player.getBlockReach();
    }

    public static boolean isCorrectTierForDrops(BlockState state, int tier) {
        return TierSortingRegistry.isCorrectTierForDrops((Tier)ToolHelper.getTier(tier), (BlockState)state);
    }

    private static Tier getTier(int harvestLevel) {
        List<Tier> tiers = TierSortingRegistry.getSortedTiers().stream().filter(tier -> tier.m_6604_() == harvestLevel).toList();
        return !tiers.isEmpty() ? tiers.get(tiers.size() - 1) : Tiers.WOOD;
    }

    public static boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, Player player) {
        return itemstack.onBlockStartBreak(pos, player);
    }

    public static boolean removeBlockRoutine(@Nullable BlockState state, Level world, ServerPlayer player, BlockPos pos, boolean playSound) {
        state = state == null ? world.m_8055_(pos) : state;
        state.m_60734_().m_5707_(world, pos, state, (Player)player);
        boolean successful = world.m_7471_(pos, false);
        if (playSound) {
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        }
        if (successful) {
            state.m_60734_().m_6786_((LevelAccessor)world, pos, state);
        }
        return successful;
    }

    public static Set<BlockPos> getHarvestableBlocks(ItemStack stack, Level world, Player player, HitResult rayTraceResult) {
        return ToolHelper.getHarvestableBlocks(stack, ToolHelper.getAoEDefinition(stack), world, player, rayTraceResult);
    }

    public static Set<BlockPos> getHarvestableBlocks(ItemStack stack, Player player) {
        if (!ToolHelper.hasBehaviorsTag(stack)) {
            return Collections.emptySet();
        }
        AoESymmetrical aoeDefiniton = ToolHelper.getAoEDefinition(stack);
        if (aoeDefiniton == AoESymmetrical.none()) {
            return Collections.emptySet();
        }
        HitResult rayTraceResult = ToolHelper.getPlayerDefaultRaytrace(player);
        return ToolHelper.getHarvestableBlocks(stack, aoeDefiniton, player.m_9236_(), player, rayTraceResult);
    }

    public static HitResult getPlayerDefaultRaytrace(@NotNull Player player) {
        return player.m_19907_(ToolHelper.getPlayerBlockReach(player), 1.0f, false);
    }

    public static void onActionDone(@NotNull Player player, @NotNull Level world, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        IGTTool tool = (IGTTool)stack.m_41720_();
        ToolHelper.damageItem(stack, (LivingEntity)player);
        if (tool.getSound() != null) {
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), tool.getSound().getMainEvent(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        player.m_6674_(hand);
    }

    @NotNull
    public static Set<GTToolType> getToolTypes(ItemStack tool) {
        HashSet<GTToolType> types = new HashSet<GTToolType>();
        Item item = tool.m_41720_();
        if (item instanceof IGTTool) {
            IGTTool gtTool = (IGTTool)item;
            return gtTool.getToolClasses(tool);
        }
        for (GTToolType toolType : GTToolType.getTypes().values()) {
            if (!toolType.itemTags.stream().anyMatch(arg_0 -> ((ItemStack)tool).m_204117_(arg_0))) continue;
            types.add(toolType);
        }
        return types;
    }

    public static boolean isTool(ItemStack tool, GTToolType ... toolClasses) {
        for (GTToolType toolType : toolClasses) {
            if (!toolType.itemTags.stream().anyMatch(arg_0 -> ((ItemStack)tool).m_204117_(arg_0))) continue;
            return true;
        }
        Item item = tool.m_41720_();
        if (item instanceof IGTTool) {
            IGTTool igtTool = (IGTTool)item;
            if (toolClasses.length == 1) {
                return igtTool.getToolClasses(tool).contains(toolClasses[0]);
            }
            for (GTToolType toolClass : igtTool.getToolClasses(tool)) {
                for (GTToolType specified : toolClasses) {
                    if (!toolClass.equals(specified)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isToolEffective(BlockState state, Set<GTToolType> toolClasses, int harvestLevel) {
        Block block = state.m_60734_();
        if (toolClasses.stream().anyMatch(type -> type.harvestTags.stream().anyMatch(arg_0 -> ((BlockState)state).m_204336_(arg_0)))) {
            return ToolHelper.isCorrectTierForDrops(state, harvestLevel);
        }
        if (toolClasses.contains(GTToolType.PICKAXE)) {
            if (Blocks.f_50080_ == block && harvestLevel >= 3) {
                return true;
            }
            if (state.m_204336_(BlockTags.f_144285_) && harvestLevel >= 2) {
                return true;
            }
            if (state.m_204336_(BlockTags.f_144286_) && harvestLevel >= 1) {
                return true;
            }
            if (state.m_204336_(BlockTags.f_144282_)) {
                return true;
            }
        }
        if (toolClasses.contains(GTToolType.SHOVEL)) {
            if (state.m_204336_(BlockTags.f_144283_)) {
                return true;
            }
            if (block == Blocks.f_50127_ || block == Blocks.f_50125_) {
                return true;
            }
        }
        if (toolClasses.contains(GTToolType.AXE) && state.m_204336_(BlockTags.f_144280_)) {
            return true;
        }
        if (toolClasses.contains(GTToolType.SWORD) && block instanceof WebBlock) {
            return true;
        }
        if (toolClasses.contains(GTToolType.SCYTHE)) {
            // empty if block
        }
        if (toolClasses.contains(GTToolType.FILE) && block instanceof IronBarsBlock) {
            return true;
        }
        if (toolClasses.contains(GTToolType.CROWBAR)) {
            return block instanceof BaseRailBlock;
        }
        return false;
    }

    public static void damageItemWhenCrafting(@NotNull ItemStack stack, @Nullable LivingEntity entity) {
        int damage = 2;
        if (stack.m_41720_() instanceof IGTTool) {
            damage = ((IGTTool)stack.m_41720_()).getToolStats().getToolDamagePerCraft(stack);
        } else if (stack.m_204131_().anyMatch(s -> s.f_203868_().m_135815_().startsWith("tool") || s.f_203868_().m_135815_().startsWith("crafting_tool"))) {
            damage = 1;
        }
        ToolHelper.damageItem(stack, entity, damage);
    }

    public static void damageItem(@NotNull ItemStack stack, @Nullable LivingEntity entity) {
        ToolHelper.damageItem(stack, entity, 1);
    }

    public static float getDestroySpeed(BlockState state, Set<GTToolType> toolClasses) {
        Block block;
        if (toolClasses.contains(GTToolType.SWORD) && (block = state.m_60734_()) instanceof WebBlock) {
            return 15.0f;
        }
        return -1.0f;
    }

    public static int shearBlockRoutine(ServerPlayer player, ItemStack tool, BlockPos pos) {
        IForgeShearable shearable;
        ServerLevel world;
        BlockState state;
        Block block;
        if (!player.m_7500_() && (block = (state = (world = player.m_284548_()).m_8055_(pos)).m_60734_()) instanceof IForgeShearable && (shearable = (IForgeShearable)block).isShearable(tool, (Level)world, pos)) {
            List shearedDrops = shearable.onSheared((Player)player, tool, (Level)world, pos, tool.getEnchantmentLevel(Enchantments.f_44987_));
            boolean relocateMinedBlocks = ToolHelper.getBehaviorsTag(tool).m_128471_(RELOCATE_MINED_BLOCKS_KEY);
            Iterator iter = shearedDrops.iterator();
            while (iter.hasNext()) {
                ItemStack stack = (ItemStack)iter.next();
                if (relocateMinedBlocks && player.m_36356_(stack)) {
                    iter.remove();
                    continue;
                }
                float f = 0.7f;
                double xo = (double)(world.f_46441_.m_188501_() * f) + 0.15;
                double yo = (double)(world.f_46441_.m_188501_() * f) + 0.15;
                double zo = (double)(world.f_46441_.m_188501_() * f) + 0.15;
                ItemEntity entityItem = new ItemEntity((Level)world, (double)pos.m_123341_() + xo, (double)pos.m_123342_() + yo, (double)pos.m_123343_() + zo, stack);
                entityItem.m_32060_();
                world.m_7967_((Entity)entityItem);
            }
            ToolHelper.damageItem(tool, (LivingEntity)player, 1);
            player.m_36246_(Stats.f_12949_.m_12902_((Object)((Block)shearable)));
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
            return tool.m_41619_() ? 0 : 1;
        }
        return -1;
    }

    @NotNull
    public static List<ItemStack> getSilkTouchDrop(ServerLevel world, BlockPos origin, @NotNull BlockState state) {
        ItemStack tool = ((IGTTool)((ItemProviderEntry)GTItems.TOOL_ITEMS.get((Object)GTMaterials.Neutronium, (Object)GTToolType.PICKAXE)).get()).get();
        tool.m_41663_(Enchantments.f_44985_, 1);
        return state.m_287290_(new LootParams.Builder(world).m_287286_(LootContextParams.f_81461_, (Object)state).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)origin)).m_287286_(LootContextParams.f_81463_, (Object)tool));
    }

    @FunctionalInterface
    public static interface AOEFunction {
        public boolean apply(ItemStack var1, Level var2, Player var3, BlockPos var4, UseOnContext var5);
    }
}

