/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.tool;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.tool.GTAxeItem;
import com.gregtechceu.gtceu.api.item.tool.GTHoeItem;
import com.gregtechceu.gtceu.api.item.tool.GTShovelItem;
import com.gregtechceu.gtceu.api.item.tool.GTSwordItem;
import com.gregtechceu.gtceu.api.item.tool.GTToolItem;
import com.gregtechceu.gtceu.api.item.tool.IGTToolDefinition;
import com.gregtechceu.gtceu.api.item.tool.MaterialToolTier;
import com.gregtechceu.gtceu.api.item.tool.ToolDefinitionBuilder;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.sound.ExistingSoundEntry;
import com.gregtechceu.gtceu.api.sound.SoundEntry;
import com.gregtechceu.gtceu.common.data.GTSoundEntries;
import com.gregtechceu.gtceu.common.item.tool.behavior.BlockRotatingBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.DisableShieldBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.EntityDamageBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.GrassPathBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.HarvestCropsBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.HarvestIceBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.HoeGroundBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.LogStripBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.PlungerBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.RotateRailBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.ScrapeBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.ToolModeSwitchBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.TreeFellingBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.WaxOffBehavior;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class GTToolType {
    private static final Map<String, GTToolType> types = new HashMap<String, GTToolType>();
    public static final GTToolType SWORD = GTToolType.builder("sword").toolTag(TagUtil.createItemTag("swords", true)).harvestTag(TagUtil.createBlockTag("mineable/sword")).toolStats(b -> b.attacking().attackDamage(3.0f).attackSpeed(-2.4f)).constructor(GTSwordItem::create).toolClassNames("sword").build();
    public static final GTToolType PICKAXE = GTToolType.builder("pickaxe").toolTag(TagUtil.createItemTag("pickaxes", true)).toolTag(ItemTags.f_144323_).harvestTag(TagUtil.createBlockTag("mineable/pickaxe", true)).toolStats(b -> b.blockBreaking().attackDamage(1.0f).attackSpeed(-2.8f)).toolClassNames("pickaxe").build();
    public static final GTToolType SHOVEL = GTToolType.builder("shovel").toolTag(TagUtil.createItemTag("shovels", true)).harvestTag(TagUtil.createBlockTag("mineable/shovel", true)).toolStats(b -> b.blockBreaking().attackDamage(1.5f).attackSpeed(-3.0f).behaviors(GrassPathBehavior.INSTANCE)).constructor(GTShovelItem::create).toolClassNames("shovel").build();
    public static final GTToolType AXE = GTToolType.builder("axe").toolTag(TagUtil.createItemTag("axes", true)).harvestTag(TagUtil.createBlockTag("mineable/axe", true)).toolStats(b -> b.blockBreaking().attackDamage(5.0f).attackSpeed(-3.2f).baseEfficiency(2.0f).behaviors(DisableShieldBehavior.INSTANCE, TreeFellingBehavior.INSTANCE, LogStripBehavior.INSTANCE, ScrapeBehavior.INSTANCE, WaxOffBehavior.INSTANCE)).constructor(GTAxeItem::create).toolClassNames("axe").build();
    public static final GTToolType HOE = GTToolType.builder("hoe").toolTag(TagUtil.createItemTag("hoes", true)).harvestTag(TagUtil.createBlockTag("mineable/hoe", true)).toolStats(b -> b.cannotAttack().attackSpeed(-1.0f).behaviors(HoeGroundBehavior.INSTANCE)).constructor(GTHoeItem::create).toolClassNames("hoe").build();
    public static final GTToolType MINING_HAMMER = GTToolType.builder("mining_hammer").toolTag(TagUtil.createItemTag("tools/mining_hammers", false)).harvestTag(TagUtil.createBlockTag("mineable/pickaxe", true)).toolStats(b -> b.blockBreaking().aoe(1, 1, 0).efficiencyMultiplier(0.4f).attackDamage(1.5f).attackSpeed(-3.2f).durabilityMultiplier(3.0f)).toolClasses(PICKAXE).build();
    public static final GTToolType SPADE = GTToolType.builder("spade").toolTag(TagUtil.createItemTag("tools/spades", false)).harvestTag(TagUtil.createBlockTag("mineable/shovel", true)).toolStats(b -> b.blockBreaking().aoe(1, 1, 0).efficiencyMultiplier(0.4f).attackDamage(1.5f).attackSpeed(-3.2f).durabilityMultiplier(3.0f).behaviors(GrassPathBehavior.INSTANCE)).toolClasses(SHOVEL).build();
    public static final GTToolType SCYTHE = GTToolType.builder("scythe").toolTag(TagUtil.createItemTag("tools/scythes", false)).harvestTag(TagUtil.createBlockTag("mineable/hoe", true)).toolStats(b -> b.blockBreaking().attacking().attackDamage(5.0f).attackSpeed(-3.0f).durabilityMultiplier(3.0f).aoe(2, 2, 2).behaviors(HoeGroundBehavior.INSTANCE, HarvestCropsBehavior.INSTANCE).canApplyEnchantment(EnchantmentCategory.DIGGER)).constructor(GTHoeItem::create).toolClassNames("scythe").toolClasses(HOE).build();
    public static final GTToolType SAW = GTToolType.builder("saw").toolTag(TagUtil.createItemTag("tools/saws", false)).harvestTag(TagUtil.createBlockTag("mineable/saw", false)).toolStats(b -> b.crafting().damagePerCraftingAction(2).attackDamage(-1.0f).attackSpeed(-2.6f).behaviors(HarvestIceBehavior.INSTANCE)).sound(GTSoundEntries.SAW_TOOL).symbol(Character.valueOf('s')).build();
    public static final GTToolType HARD_HAMMER = GTToolType.builder("hammer").toolTag(TagUtil.createItemTag("tools/hammers", false)).harvestTag(TagUtil.createBlockTag("mineable/hammer", false)).harvestTag(TagUtil.createBlockTag("mineable/pickaxe", true)).toolStats(b -> b.blockBreaking().crafting().damagePerCraftingAction(2).attackDamage(1.0f).attackSpeed(-2.8f).behaviors(new EntityDamageBehavior(2.0f, IronGolem.class))).sound(GTSoundEntries.FORGE_HAMMER).symbol(Character.valueOf('h')).toolClasses(PICKAXE).build();
    public static final GTToolType SOFT_MALLET = GTToolType.builder("mallet").toolTag(TagUtil.createItemTag("tools/mallets", false)).toolStats(b -> b.crafting().cannotAttack().attackSpeed(-2.4f)).sound(GTSoundEntries.SOFT_MALLET_TOOL).symbol(Character.valueOf('r')).build();
    public static final GTToolType WRENCH = GTToolType.builder("wrench").toolTag(TagUtil.createItemTag("tools/wrenches", false)).toolTag(TagUtil.createItemTag("tools/wrench", false)).harvestTag(TagUtil.createBlockTag("mineable/wrench", false)).toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().attackDamage(1.0f).attackSpeed(-2.8f).behaviors(BlockRotatingBehavior.INSTANCE, new EntityDamageBehavior(3.0f, IronGolem.class), ToolModeSwitchBehavior.INSTANCE)).sound(GTSoundEntries.WRENCH_TOOL).symbol(Character.valueOf('w')).build();
    public static final GTToolType FILE = GTToolType.builder("file").toolTag(TagUtil.createItemTag("tools/files", false)).toolStats(b -> b.crafting().damagePerCraftingAction(4).cannotAttack().attackSpeed(-2.4f)).sound(GTSoundEntries.FILE_TOOL).symbol(Character.valueOf('f')).build();
    public static final GTToolType CROWBAR = GTToolType.builder("crowbar").toolTag(TagUtil.createItemTag("tools/crowbars", false)).harvestTag(TagUtil.createBlockTag("mineable/crowbar", false)).toolStats(b -> b.blockBreaking().crafting().attackDamage(2.0f).attackSpeed(-2.4f).sneakBypassUse().behaviors(RotateRailBehavior.INSTANCE)).sound(new ExistingSoundEntry(SoundEvents.f_12018_, SoundSource.BLOCKS)).symbol(Character.valueOf('c')).build();
    public static final GTToolType SCREWDRIVER = GTToolType.builder("screwdriver").toolTag(TagUtil.createItemTag("tools/screwdrivers", false)).toolStats(b -> b.crafting().damagePerCraftingAction(4).sneakBypassUse().attackDamage(-1.0f).attackSpeed(3.0f).behaviors(new EntityDamageBehavior(3.0f, Spider.class))).sound(GTSoundEntries.SCREWDRIVER_TOOL).symbol(Character.valueOf('d')).build();
    public static final GTToolType MORTAR = GTToolType.builder("mortar").toolTag(TagUtil.createItemTag("tools/mortars", false)).toolStats(b -> b.crafting().damagePerCraftingAction(2).cannotAttack().attackSpeed(-2.4f)).sound(GTSoundEntries.MORTAR_TOOL).symbol(Character.valueOf('m')).build();
    public static final GTToolType WIRE_CUTTER = GTToolType.builder("wire_cutter").toolTag(TagUtil.createItemTag("tools/wire_cutters", false)).harvestTag(TagUtil.createBlockTag("mineable/wire_cutter", false)).toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().damagePerCraftingAction(4).attackDamage(-1.0f).attackSpeed(-2.4f)).sound(GTSoundEntries.WIRECUTTER_TOOL).symbol(Character.valueOf('x')).build();
    public static final GTToolType KNIFE = GTToolType.builder("knife").toolTag(TagUtil.createItemTag("tools/knives", false)).harvestTag(TagUtil.createBlockTag("mineable/knife", false)).toolStats(b -> b.crafting().attacking().attackSpeed(3.0f)).constructor(GTSwordItem::create).symbol(Character.valueOf('k')).toolClasses(SWORD).build();
    public static final GTToolType BUTCHERY_KNIFE = GTToolType.builder("butchery_knife").toolTag(TagUtil.createItemTag("tools/butchery_knives", false)).toolStats(b -> b.attacking().attackDamage(1.5f).attackSpeed(-1.3f).defaultEnchantment(Enchantments.f_44982_, 3)).constructor(GTSwordItem::create).build();
    public static final GTToolType PLUNGER = GTToolType.builder("plunger").toolTag(TagUtil.createItemTag("tools/plungers", false)).toolStats(b -> b.cannotAttack().attackSpeed(-2.4f).sneakBypassUse().behaviors(PlungerBehavior.INSTANCE)).sound(GTSoundEntries.PLUNGER_TOOL).build();
    public static final GTToolType SHEARS = GTToolType.builder("shears").toolTag(TagUtil.createItemTag("tools/shears", false)).harvestTag(TagUtil.createBlockTag("mineable/shears", false)).toolStats(b -> b).build();
    public static final GTToolType DRILL_LV = GTToolType.builder("lv_drill").idFormat("lv_%s_drill").toolTag(TagUtil.createItemTag("tools/drills", false)).toolTag(TagUtil.createItemTag("pickaxes", true)).toolTag(TagUtil.createItemTag("shovels", true)).toolTag(ItemTags.f_144323_).harvestTag(TagUtil.createBlockTag("mineable/pickaxe", true)).harvestTag(TagUtil.createBlockTag("mineable/shovel", true)).toolStats(b -> b.blockBreaking().aoe(1, 1, 0).attackDamage(1.0f).attackSpeed(-3.2f).durabilityMultiplier(3.0f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_LV)).sound(GTSoundEntries.DRILL_TOOL, true).electric(1).toolClassNames("drill").build();
    public static final GTToolType DRILL_MV = GTToolType.builder("mv_drill").idFormat("mv_%s_drill").toolTag(TagUtil.createItemTag("tools/drills", false)).toolTag(TagUtil.createItemTag("pickaxes", true)).toolTag(TagUtil.createItemTag("shovels", true)).toolTag(ItemTags.f_144323_).harvestTag(TagUtil.createBlockTag("mineable/pickaxe", true)).harvestTag(TagUtil.createBlockTag("mineable/shovel", true)).toolStats(b -> b.blockBreaking().aoe(1, 1, 2).attackDamage(1.0f).attackSpeed(-3.2f).durabilityMultiplier(4.0f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_MV)).sound(GTSoundEntries.DRILL_TOOL, true).electric(2).toolClassNames("drill").build();
    public static final GTToolType DRILL_HV = GTToolType.builder("hv_drill").idFormat("hv_%s_drill").toolTag(TagUtil.createItemTag("tools/drills", false)).toolTag(TagUtil.createItemTag("pickaxes", true)).toolTag(TagUtil.createItemTag("shovels", true)).toolTag(ItemTags.f_144323_).harvestTag(TagUtil.createBlockTag("mineable/pickaxe", true)).harvestTag(TagUtil.createBlockTag("mineable/shovel", true)).toolStats(b -> b.blockBreaking().aoe(2, 2, 4).attackDamage(1.0f).attackSpeed(-3.2f).durabilityMultiplier(5.0f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_HV)).sound(GTSoundEntries.DRILL_TOOL, true).electric(3).toolClassNames("drill").build();
    public static final GTToolType DRILL_EV = GTToolType.builder("ev_drill").idFormat("ev_%s_drill").toolTag(TagUtil.createItemTag("tools/drills", false)).toolTag(TagUtil.createItemTag("pickaxes", true)).toolTag(TagUtil.createItemTag("shovels", true)).toolTag(ItemTags.f_144323_).harvestTag(TagUtil.createBlockTag("mineable/pickaxe", true)).harvestTag(TagUtil.createBlockTag("mineable/shovel", true)).toolStats(b -> b.blockBreaking().aoe(3, 3, 6).attackDamage(1.0f).attackSpeed(-3.2f).durabilityMultiplier(6.0f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_EV)).sound(GTSoundEntries.DRILL_TOOL, true).electric(4).toolClassNames("drill").build();
    public static final GTToolType DRILL_IV = GTToolType.builder("iv_drill").idFormat("iv_%s_drill").toolTag(TagUtil.createItemTag("tools/drills", false)).toolTag(TagUtil.createItemTag("pickaxes", true)).toolTag(TagUtil.createItemTag("shovels", true)).toolTag(ItemTags.f_144323_).harvestTag(TagUtil.createBlockTag("mineable/pickaxe", true)).harvestTag(TagUtil.createBlockTag("mineable/shovel", true)).toolStats(b -> b.blockBreaking().aoe(4, 4, 8).attackDamage(1.0f).attackSpeed(-3.2f).durabilityMultiplier(7.0f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_IV)).sound(GTSoundEntries.DRILL_TOOL, true).electric(5).toolClassNames("drill").build();
    public static final GTToolType CHAINSAW_LV = GTToolType.builder("lv_chainsaw").idFormat("lv_%s_chainsaw").toolTag(TagUtil.createItemTag("axes", true)).toolTag(TagUtil.createItemTag("tools/chainsaws", false)).harvestTag(TagUtil.createBlockTag("mineable/axe", true)).toolStats(b -> b.blockBreaking().efficiencyMultiplier(2.0f).attackDamage(5.0f).attackSpeed(-3.2f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_LV).behaviors(HarvestIceBehavior.INSTANCE, DisableShieldBehavior.INSTANCE, TreeFellingBehavior.INSTANCE)).sound(GTSoundEntries.CHAINSAW_TOOL, true).electric(1).toolClasses(AXE).build();
    public static final GTToolType WRENCH_LV = GTToolType.builder("lv_wrench").idFormat("lv_%s_wrench").toolTag(TagUtil.createItemTag("tools/wrenches", false)).toolTag(TagUtil.createItemTag("tools/wrench", false)).harvestTag(TagUtil.createBlockTag("mineable/wrench", false)).toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().efficiencyMultiplier(2.0f).attackDamage(1.0f).attackSpeed(-2.8f).behaviors(BlockRotatingBehavior.INSTANCE, new EntityDamageBehavior(3.0f, IronGolem.class), ToolModeSwitchBehavior.INSTANCE).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_LV)).sound(GTSoundEntries.WRENCH_TOOL, true).electric(1).toolClasses(WRENCH).build();
    public static final GTToolType WRENCH_HV = GTToolType.builder("hv_wrench").idFormat("hv_%s_wrench").toolTag(TagUtil.createItemTag("tools/wrenches", false)).toolTag(TagUtil.createItemTag("tools/wrench", false)).harvestTag(TagUtil.createBlockTag("mineable/wrench", false)).toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().efficiencyMultiplier(3.0f).attackDamage(1.0f).attackSpeed(-2.8f).behaviors(BlockRotatingBehavior.INSTANCE, new EntityDamageBehavior(3.0f, IronGolem.class), ToolModeSwitchBehavior.INSTANCE).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_HV)).sound(GTSoundEntries.WRENCH_TOOL, true).electric(3).toolClasses(WRENCH).build();
    public static final GTToolType WRENCH_IV = GTToolType.builder("iv_wrench").idFormat("iv_%s_wrench").toolTag(TagUtil.createItemTag("tools/wrenches", false)).toolTag(TagUtil.createItemTag("tools/wrench", false)).harvestTag(TagUtil.createBlockTag("mineable/wrench", false)).toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().efficiencyMultiplier(4.0f).attackDamage(1.0f).attackSpeed(-2.8f).behaviors(BlockRotatingBehavior.INSTANCE, new EntityDamageBehavior(3.0f, IronGolem.class), ToolModeSwitchBehavior.INSTANCE).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_IV)).sound(GTSoundEntries.WRENCH_TOOL, true).electric(5).toolClasses(WRENCH).build();
    public static final GTToolType WIRE_CUTTER_LV = GTToolType.builder("lv_wirecutter").idFormat("lv_%s_wirecutter").toolTag(TagUtil.createItemTag("tools/wire_cutters", false)).harvestTag(TagUtil.createBlockTag("mineable/wire_cutter", false)).toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().damagePerCraftingAction(4).attackDamage(-1.0f).attackSpeed(-2.4f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_LV)).sound(GTSoundEntries.WIRECUTTER_TOOL, true).electric(1).toolClasses(WIRE_CUTTER).build();
    public static final GTToolType WIRE_CUTTER_HV = GTToolType.builder("hv_wirecutter").idFormat("hv_%s_wirecutter").toolTag(TagUtil.createItemTag("tools/wire_cutters", false)).harvestTag(TagUtil.createBlockTag("mineable/wire_cutter", false)).toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().damagePerCraftingAction(4).attackDamage(-1.0f).attackSpeed(-2.4f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_HV)).sound(GTSoundEntries.WIRECUTTER_TOOL, true).electric(3).toolClasses(WIRE_CUTTER).build();
    public static final GTToolType WIRE_CUTTER_IV = GTToolType.builder("iv_wirecutter").idFormat("iv_%s_wirecutter").toolTag(TagUtil.createItemTag("tools/wire_cutters", false)).harvestTag(TagUtil.createBlockTag("mineable/wire_cutter", false)).toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().damagePerCraftingAction(4).attackDamage(-1.0f).attackSpeed(-2.4f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_IV)).sound(GTSoundEntries.WIRECUTTER_TOOL, true).electric(5).toolClasses(WIRE_CUTTER).build();
    public static final GTToolType BUZZSAW = GTToolType.builder("buzzsaw").toolTag(TagUtil.createItemTag("tools/saws", false)).toolTag(TagUtil.createItemTag("tools/buzzsaws", false)).toolStats(b -> b.crafting().attackDamage(1.5f).attackSpeed(-3.2f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_LV)).sound(GTSoundEntries.CHAINSAW_TOOL, true).electric(1).toolClasses(SAW).build();
    public static final GTToolType SCREWDRIVER_LV = GTToolType.builder("lv_screwdriver").idFormat("lv_%s_screwdriver").toolTag(TagUtil.createItemTag("tools/screwdrivers", false)).toolStats(b -> b.crafting().sneakBypassUse().attackDamage(-1.0f).attackSpeed(3.0f).behaviors(new EntityDamageBehavior(3.0f, Spider.class)).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_LV)).sound(GTSoundEntries.SCREWDRIVER_TOOL).electric(1).toolClasses(SCREWDRIVER).build();
    public final String name;
    public final String idFormat;
    public final List<TagKey<Item>> itemTags;
    public final List<TagKey<Block>> harvestTags;
    public final ResourceLocation modelLocation;
    public final Set<String> toolClassNames;
    public final Set<GTToolType> toolClasses;
    @Nullable
    public final SoundEntry soundEntry;
    public final boolean playSoundOnBlockDestroy;
    public final Character symbol;
    public final IGTToolDefinition toolDefinition;
    public final ToolConstructor constructor;
    public final int electricTier;

    public GTToolType(String name, String idFormat, Character symbol, Set<GTToolType> toolClasses, IGTToolDefinition toolDefinition, ToolConstructor constructor, List<TagKey<Block>> harvestTags, List<TagKey<Item>> itemTags, ResourceLocation modelLocation, Set<String> toolClassNames, @Nullable SoundEntry soundEntry, boolean playSoundOnBlockDestroy, int electricTier) {
        this.name = name;
        this.idFormat = idFormat;
        this.symbol = symbol;
        toolClasses.add(this);
        this.toolClasses = toolClasses;
        this.toolDefinition = toolDefinition;
        this.constructor = constructor;
        this.itemTags = itemTags;
        this.harvestTags = harvestTags;
        this.modelLocation = modelLocation;
        this.toolClassNames = toolClassNames;
        this.soundEntry = soundEntry;
        this.playSoundOnBlockDestroy = playSoundOnBlockDestroy;
        this.electricTier = electricTier;
        types.put(name, this);
    }

    public boolean is(ItemStack itemStack) {
        return ToolHelper.is(itemStack, this);
    }

    public String getUnlocalizedName() {
        return "item.gtceu.tool." + this.name;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static Map<String, GTToolType> getTypes() {
        return types;
    }

    @FunctionalInterface
    public static interface ToolConstructor {
        public IGTTool apply(GTToolType var1, MaterialToolTier var2, Material var3, IGTToolDefinition var4, Item.Properties var5);
    }

    public static class Builder {
        private final String name;
        private String idFormat;
        private final List<TagKey<Item>> itemTags = new ArrayList<TagKey<Item>>();
        private final List<TagKey<Block>> harvestTags = new ArrayList<TagKey<Block>>();
        private Set<String> toolClassNames = new HashSet<String>();
        private Set<GTToolType> toolClasses = new HashSet<GTToolType>();
        private IGTToolDefinition toolStats;
        private int tier = -1;
        private Character symbol = null;
        private ToolConstructor constructor = GTToolItem::create;
        private ResourceLocation modelLocation;
        private SoundEntry sound;
        private boolean playSoundOnBlockDestroy;

        public Builder(String name) {
            this.name = name;
            this.idFormat = "%s_" + name;
            this.modelLocation = GTCEu.id("item/tools/" + name);
        }

        @SafeVarargs
        public final Builder toolTag(TagKey<Item> ... tags) {
            this.itemTags.addAll(Arrays.stream(tags).toList());
            return this;
        }

        @SafeVarargs
        public final Builder harvestTag(TagKey<Block> ... tags) {
            this.harvestTags.addAll(Arrays.stream(tags).toList());
            return this;
        }

        public Builder toolClasses(GTToolType ... classes) {
            this.toolClasses.addAll(Arrays.stream(classes).toList());
            this.toolClassNames.addAll(Arrays.stream(classes).map(type -> type.name).toList());
            return this;
        }

        public Builder toolClassNames(String ... classes) {
            this.toolClassNames.addAll(Arrays.stream(classes).toList());
            return this;
        }

        public Builder toolStats(UnaryOperator<ToolDefinitionBuilder> builder) {
            this.toolStats = ((ToolDefinitionBuilder)builder.apply(new ToolDefinitionBuilder())).build();
            return this;
        }

        public Builder sound(SoundEntry sound) {
            return this.sound(sound, false);
        }

        public Builder sound(SoundEntry sound, boolean playSoundOnBlockDestroy) {
            this.sound = sound;
            this.playSoundOnBlockDestroy = playSoundOnBlockDestroy;
            return this;
        }

        public Builder electric(int tier) {
            return this.tier(tier);
        }

        private GTToolType get() {
            return new GTToolType(this.name, this.idFormat, this.symbol, this.toolClasses, this.toolStats, this.constructor, this.harvestTags, this.itemTags, this.modelLocation, this.toolClassNames, this.sound, this.playSoundOnBlockDestroy, this.tier);
        }

        public GTToolType build() {
            if (this.toolClassNames.isEmpty()) {
                this.toolClassNames.add(this.name);
            }
            if (this.symbol == null) {
                return this.get();
            }
            GTToolType existing = ToolHelper.getToolFromSymbol(this.symbol);
            if (existing != null) {
                throw new IllegalArgumentException(String.format("Symbol %s has been taken by %s already!", this.symbol, existing));
            }
            GTToolType supplied = this.get();
            ToolHelper.registerToolSymbol(this.symbol, supplied);
            return supplied;
        }

        public Builder idFormat(String idFormat) {
            this.idFormat = idFormat;
            return this;
        }

        public Builder toolClassNames(Set<String> toolClassNames) {
            this.toolClassNames = toolClassNames;
            return this;
        }

        public Builder toolStats(IGTToolDefinition toolStats) {
            this.toolStats = toolStats;
            return this;
        }

        public Builder tier(int tier) {
            this.tier = tier;
            return this;
        }

        public Builder symbol(Character symbol) {
            this.symbol = symbol;
            return this;
        }

        public Builder constructor(ToolConstructor constructor) {
            this.constructor = constructor;
            return this;
        }

        public Builder modelLocation(ResourceLocation modelLocation) {
            this.modelLocation = modelLocation;
            return this;
        }
    }
}

