/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.component;

import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.IEdibleItem;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FoodStats
implements IEdibleItem,
IInteractionItem,
IAddInformation {
    protected final FoodProperties properties;
    protected final boolean isDrink;
    @Nullable
    protected final Supplier<ItemStack> containerItem;

    public FoodStats(FoodProperties properties, boolean isDrink, @Nullable Supplier<ItemStack> containerItem) {
        this.properties = properties;
        this.isDrink = isDrink;
        this.containerItem = containerItem;
    }

    @Override
    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        return this.properties;
    }

    @Override
    public boolean isEdible() {
        return true;
    }

    @Override
    public SoundEvent getEatingSound() {
        return this.isDrink ? this.getDrinkingSound() : IEdibleItem.super.getEatingSound();
    }

    @Override
    public UseAnim getUseAnimation(ItemStack stack) {
        return this.isDrink ? UseAnim.DRINK : UseAnim.EAT;
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        GTUtil.addPotionTooltip(this.properties.m_38749_(), tooltipComponents);
    }

    @Override
    public ItemStack finishUsingItem(ItemStack food, Level level, LivingEntity livingEntity) {
        Player player = livingEntity instanceof Player ? (Player)livingEntity : null;
        ItemStack stack = livingEntity.m_5584_(level, food);
        if (!(this.containerItem == null || player != null && player.m_150110_().f_35937_)) {
            ItemStack container = this.containerItem.get();
            if (stack.m_41619_()) {
                return container;
            }
            if (player != null && !player.m_150109_().m_36054_(container)) {
                player.m_36176_(container, true);
            }
        }
        return stack;
    }
}

