/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.widget;

import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import java.util.function.BooleanSupplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class PredicatedImageWidget
extends ImageWidget {
    private BooleanSupplier predicate;
    private boolean isVisible = true;

    public PredicatedImageWidget(int xPosition, int yPosition, int width, int height, IGuiTexture area) {
        super(xPosition, yPosition, width, height, area);
    }

    public void writeInitialData(FriendlyByteBuf buffer) {
        super.writeInitialData(buffer);
        this.isVisible = this.predicate == null || this.predicate.getAsBoolean();
        buffer.writeBoolean(this.isVisible);
    }

    public void readInitialData(FriendlyByteBuf buffer) {
        super.readInitialData(buffer);
        this.isVisible = buffer.readBoolean();
    }

    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.predicate != null && this.isVisible != this.predicate.getAsBoolean()) {
            this.isVisible = !this.isVisible;
            this.writeUpdateInfo(1, buf -> buf.writeBoolean(this.isVisible));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
        if (id == 1) {
            this.isVisible = buffer.readBoolean();
        } else {
            super.readUpdateInfo(id, buffer);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible) {
            super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public PredicatedImageWidget setPredicate(BooleanSupplier predicate) {
        this.predicate = predicate;
        return this;
    }
}

