/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.misc;

import com.google.common.collect.Lists;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.ingredient.IGhostIngredientTarget;
import com.lowdragmc.lowdraglib.gui.ingredient.Target;
import com.lowdragmc.lowdraglib.gui.widget.PhantomFluidWidget;
import dev.architectury.fluid.FluidStack;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public interface IGhostFluidTarget
extends IGhostIngredientTarget {
    @OnlyIn(value=Dist.CLIENT)
    public Rect2i getRectangleBox();

    @OnlyIn(value=Dist.CLIENT)
    public void acceptFluid(com.lowdragmc.lowdraglib.side.fluid.FluidStack var1);

    @OnlyIn(value=Dist.CLIENT)
    default public List<Target> getPhantomTargets(Object ingredient) {
        if (!((ingredient = this.convertIngredient(ingredient)) instanceof com.lowdragmc.lowdraglib.side.fluid.FluidStack) && PhantomFluidWidget.drainFrom((Object)ingredient) == null) {
            return Collections.emptyList();
        }
        final Rect2i rectangle = this.getRectangleBox();
        return Lists.newArrayList((Object[])new Target[]{new Target(){

            @NotNull
            public Rect2i getArea() {
                return rectangle;
            }

            public void accept(@NotNull Object ingredient) {
                com.lowdragmc.lowdraglib.side.fluid.FluidStack fluidStack;
                com.lowdragmc.lowdraglib.side.fluid.FluidStack ingredientStack = (ingredient = IGhostFluidTarget.this.convertIngredient(ingredient)) instanceof com.lowdragmc.lowdraglib.side.fluid.FluidStack ? (fluidStack = (com.lowdragmc.lowdraglib.side.fluid.FluidStack)ingredient) : PhantomFluidWidget.drainFrom((Object)ingredient);
                if (ingredientStack != null) {
                    IGhostFluidTarget.this.acceptFluid(ingredientStack);
                }
            }
        }});
    }

    default public Object convertIngredient(Object ingredient) {
        if (LDLib.isReiLoaded() && ingredient instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)ingredient;
            ingredient = com.lowdragmc.lowdraglib.side.fluid.FluidStack.create((Fluid)fluidStack.getFluid(), (long)fluidStack.getAmount(), (CompoundTag)fluidStack.getTag());
        }
        if (LDLib.isEmiLoaded() && ingredient instanceof EmiStack) {
            EmiStack fluidEmiStack = (EmiStack)ingredient;
            Fluid fluid = (Fluid)fluidEmiStack.getKeyOfType(Fluid.class);
            ingredient = fluid == null ? com.lowdragmc.lowdraglib.side.fluid.FluidStack.empty() : com.lowdragmc.lowdraglib.side.fluid.FluidStack.create((Fluid)fluid, (long)fluidEmiStack.getAmount(), (CompoundTag)fluidEmiStack.getNbt());
        }
        return ingredient;
    }
}

