/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.tag;

import com.google.common.base.Preconditions;
import com.google.common.collect.Table;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.addon.AddonFinder;
import com.gregtechceu.gtceu.api.addon.IGTAddon;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconType;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IMaterialProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagType;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.integration.GTOreByProduct;
import com.gregtechceu.gtceu.integration.kjs.GTRegistryInfo;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.SupplierMemoizer;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TagPrefix {
    public static final Map<String, TagPrefix> PREFIXES = new HashMap<String, TagPrefix>();
    public static final Map<TagPrefix, OreType> ORES = new Object2ObjectLinkedOpenHashMap();
    public static final Codec<TagPrefix> CODEC = Codec.STRING.flatXmap(str -> Optional.ofNullable(TagPrefix.get(str)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "invalid TagPrefix: " + str)), prefix -> DataResult.success((Object)prefix.name));
    public static final TagPrefix ore = TagPrefix.oreTagPrefix("stone", (TagKey<Block>)BlockTags.f_144282_).langValue("%s Ore").registerOre(() -> ((Block)Blocks.f_50069_).m_49966_(), () -> GTMaterials.Stone, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60999_().m_60913_(3.0f, 3.0f), new ResourceLocation("block/stone"), false, false, true);
    public static final TagPrefix oreGranite = TagPrefix.oreTagPrefix("granite", (TagKey<Block>)BlockTags.f_144282_).langValue("Granite %s Ore").registerOre(() -> ((Block)Blocks.f_50122_).m_49966_(), () -> GTMaterials.Granite, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283762_).m_60999_().m_60913_(3.0f, 3.0f), new ResourceLocation("block/granite"));
    public static final TagPrefix oreDiorite = TagPrefix.oreTagPrefix("diorite", (TagKey<Block>)BlockTags.f_144282_).langValue("Diorite %s Ore").registerOre(() -> ((Block)Blocks.f_50228_).m_49966_(), () -> GTMaterials.Diorite, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283942_).m_60999_().m_60913_(3.0f, 3.0f), new ResourceLocation("block/diorite"));
    public static final TagPrefix oreAndesite = TagPrefix.oreTagPrefix("andesite", (TagKey<Block>)BlockTags.f_144282_).langValue("Andesite %s Ore").registerOre(() -> ((Block)Blocks.f_50334_).m_49966_(), () -> GTMaterials.Andesite, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283762_).m_60999_().m_60913_(3.0f, 3.0f), new ResourceLocation("block/andesite"));
    public static final TagPrefix oreRedGranite = TagPrefix.oreTagPrefix("red_granite", (TagKey<Block>)BlockTags.f_144282_).langValue("Red Granite %s Ore").registerOre(() -> GTBlocks.RED_GRANITE.getDefaultState(), () -> GTMaterials.GraniteRed, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283798_).m_60999_().m_60913_(3.0f, 3.0f), GTCEu.id("block/red_granite"));
    public static final TagPrefix oreMarble = TagPrefix.oreTagPrefix("marble", (TagKey<Block>)BlockTags.f_144282_).langValue("Marble %s Ore").registerOre(() -> GTBlocks.MARBLE.getDefaultState(), () -> GTMaterials.Marble, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283942_).m_60999_().m_60913_(3.0f, 3.0f), GTCEu.id("block/marble"));
    public static final TagPrefix oreDeepslate = TagPrefix.oreTagPrefix("deepslate", (TagKey<Block>)BlockTags.f_144282_).langValue("Deepslate %s Ore").registerOre(() -> ((Block)Blocks.f_152550_).m_49966_(), () -> GTMaterials.Deepslate, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283875_).m_60999_().m_60913_(4.5f, 3.0f), new ResourceLocation("block/deepslate"), false, false, true);
    public static final TagPrefix oreTuff = TagPrefix.oreTagPrefix("tuff", (TagKey<Block>)BlockTags.f_144282_).langValue("Tuff %s Ore").registerOre(() -> ((Block)Blocks.f_152496_).m_49966_(), null, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283861_).m_60999_().m_60913_(3.0f, 3.0f), new ResourceLocation("block/tuff"));
    public static final TagPrefix oreSand = TagPrefix.oreTagPrefix("sand", (TagKey<Block>)BlockTags.f_144283_).langValue("Sand %s Ore").registerOre(() -> ((Block)Blocks.f_49992_).m_49966_(), () -> GTMaterials.SiliconDioxide, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283761_).m_280658_(NoteBlockInstrument.SNARE).m_60978_(0.5f).m_60918_(SoundType.f_56746_), new ResourceLocation("block/sand"), false, true, false);
    public static final TagPrefix oreRedSand = TagPrefix.oreTagPrefix("redSand", (TagKey<Block>)BlockTags.f_144283_).langValue("Red Sand %s Ore").registerOre(() -> ((Block)Blocks.f_49993_).m_49966_(), () -> GTMaterials.SiliconDioxide, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283750_).m_280658_(NoteBlockInstrument.SNARE).m_60978_(0.5f).m_60918_(SoundType.f_56746_), new ResourceLocation("block/red_sand"), false, true, false);
    public static final TagPrefix oreGravel = TagPrefix.oreTagPrefix("gravel", (TagKey<Block>)BlockTags.f_144283_).langValue("Gravel %s Ore").registerOre(() -> ((Block)Blocks.f_49994_).m_49966_(), () -> GTMaterials.Flint, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.SNARE).m_60978_(0.6f).m_60918_(SoundType.f_56739_), new ResourceLocation("block/gravel"), false, true, false);
    public static final TagPrefix oreBasalt = TagPrefix.oreTagPrefix("basalt", (TagKey<Block>)BlockTags.f_144282_).langValue("Basalt %s Ore").registerOre(() -> ((Block)Blocks.f_50137_).m_49966_(), () -> GTMaterials.Basalt, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283927_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60913_(2.5f, 4.2f).m_60918_(SoundType.f_56718_), new ResourceLocation("block/basalt"), true);
    public static final TagPrefix oreNetherrack = TagPrefix.oreTagPrefix("netherrack", (TagKey<Block>)BlockTags.f_144282_).langValue("Nether %s Ore").registerOre(() -> ((Block)Blocks.f_50134_).m_49966_(), () -> GTMaterials.Netherrack, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283820_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60913_(3.0f, 3.0f).m_60918_(SoundType.f_56723_), new ResourceLocation("block/netherrack"), true, false, true);
    public static final TagPrefix oreBlackstone = TagPrefix.oreTagPrefix("blackstone", (TagKey<Block>)BlockTags.f_144282_).langValue("Blackstone %s Ore").registerOre(() -> ((Block)Blocks.f_50730_).m_49966_(), null, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283927_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60913_(3.0f, 3.0f), new ResourceLocation("block/blackstone"), true, false, false);
    public static final TagPrefix oreEndstone = TagPrefix.oreTagPrefix("endstone", (TagKey<Block>)BlockTags.f_144282_).langValue("End %s Ore").registerOre(() -> ((Block)Blocks.f_50259_).m_49966_(), () -> GTMaterials.Endstone, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283761_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60913_(4.5f, 9.0f), new ResourceLocation("block/end_stone"), true, false, true);
    public static final TagPrefix rawOre = new TagPrefix("raw", true).idPattern("raw_%s").defaultTagPath("raw_materials/%s").unformattedTagPath("raw_materials").langValue("Raw %s").materialIconType(MaterialIconType.rawOre).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasOreProperty);
    public static final TagPrefix rawOreBlock = new TagPrefix("rawOreBlock").idPattern("raw_%s_block").defaultTagPath("storage_blocks/raw_%s").unformattedTagPath("storage_blocks").langValue("Block of Raw %s").materialIconType(MaterialIconType.rawOreBlock).miningToolTag((TagKey<Block>)BlockTags.f_144282_).unificationEnabled(true).generateBlock(true).generationCondition(Conditions.hasOreProperty);
    public static final TagPrefix crushedRefined = new TagPrefix("refinedOre").idPattern("refined_%s_ore").defaultTagPath("refined_ores/%s").defaultTagPath("refined_ores").langValue("Refined %s Ore").materialIconType(MaterialIconType.crushedRefined).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasOreProperty);
    public static final TagPrefix crushedPurified = new TagPrefix("purifiedOre").idPattern("purified_%s_ore").defaultTagPath("purified_ores/%s").defaultTagPath("purified_ores").customTagPredicate("siftables", false, m -> m.hasProperty(PropertyKey.GEM)).langValue("Purified %s Ore").materialIconType(MaterialIconType.crushedPurified).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasOreProperty);
    public static final TagPrefix crushed = new TagPrefix("crushedOre").idPattern("crushed_%s_ore").defaultTagPath("crushed_ores/%s").unformattedTagPath("crushed_ores").langValue("Crushed %s Ore").materialIconType(MaterialIconType.crushed).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasOreProperty).tooltip((mat, tooltips) -> tooltips.add(Component.m_237115_((String)"metaitem.crushed.tooltip.purify")));
    public static final TagPrefix ingotHot = new TagPrefix("hotIngot").idPattern("hot_%s_ingot").defaultTagPath("hot_ingots/%s").unformattedTagPath("hot_ingots").langValue("Hot %s Ingot").materialAmount(3628800L).materialIconType(MaterialIconType.ingotHot).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasBlastProperty.and(mat -> mat.getProperty(PropertyKey.BLAST).getBlastTemperature() > 1750));
    public static final TagPrefix ingot = new TagPrefix("ingot").defaultTagPath("ingots/%s").unformattedTagPath("ingots").materialAmount(3628800L).materialIconType(MaterialIconType.ingot).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasIngotProperty);
    public static final TagPrefix gem = new TagPrefix("gem").defaultTagPath("gems/%s").unformattedTagPath("gems").langValue("%s").materialAmount(3628800L).materialIconType(MaterialIconType.gem).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasGemProperty);
    public static final TagPrefix gemChipped = new TagPrefix("chippedGem").idPattern("chipped_%s_gem").defaultTagPath("chipped_gems/%s").unformattedTagPath("chipped_gems").langValue("Chipped %s").materialAmount(907200L).materialIconType(MaterialIconType.gemChipped).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasGemProperty.and(unused -> ConfigHolder.INSTANCE.recipes.generateLowQualityGems));
    public static final TagPrefix gemFlawed = new TagPrefix("flawedGem").idPattern("flawed_%s_gem").defaultTagPath("flawed_gems/%s").unformattedTagPath("flawed_gems").langValue("Flawed %s").materialAmount(1814400L).materialIconType(MaterialIconType.gemFlawed).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasGemProperty.and(unused -> ConfigHolder.INSTANCE.recipes.generateLowQualityGems));
    public static final TagPrefix gemFlawless = new TagPrefix("flawlessGem").idPattern("flawless_%s_gem").defaultTagPath("flawless_gems/%s").unformattedTagPath("flawless_gems").langValue("Flawless %s").materialAmount(7257600L).maxStackSize(32).materialIconType(MaterialIconType.gemFlawless).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasGemProperty);
    public static final TagPrefix gemExquisite = new TagPrefix("exquisiteGem").idPattern("exquisite_%s_gem").defaultTagPath("exquisite_gems/%s").unformattedTagPath("exquisite_gems").langValue("Exquisite %s").materialAmount(14515200L).maxStackSize(16).materialIconType(MaterialIconType.gemExquisite).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasGemProperty);
    public static final TagPrefix dustSmall = new TagPrefix("smallDust").idPattern("small_%s_dust").defaultTagPath("small_dusts/%s").unformattedTagPath("small_dusts").langValue("Small Pile of %s Dust").materialAmount(907200L).materialIconType(MaterialIconType.dustSmall).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasDustProperty);
    public static final TagPrefix dustTiny = new TagPrefix("tinyDust").idPattern("tiny_%s_dust").defaultTagPath("tiny_dusts/%s").unformattedTagPath("tiny_dusts").langValue("Tiny Pile of %s Dust").materialAmount(403200L).materialIconType(MaterialIconType.dustTiny).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasDustProperty);
    public static final TagPrefix dustImpure = new TagPrefix("impureDust").idPattern("impure_%s_dust").defaultTagPath("impure_dusts/%s").unformattedTagPath("impure_dusts").langValue("Impure Pile of %s Dust").materialAmount(3628800L).materialIconType(MaterialIconType.dustImpure).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasOreProperty).tooltip((mat, tooltips) -> tooltips.add(Component.m_237115_((String)"metaitem.dust.tooltip.purify")));
    public static final TagPrefix dustPure = new TagPrefix("pureDust").idPattern("pure_%s_dust").defaultTagPath("pure_dusts/%s").unformattedTagPath("pure_dusts").langValue("Purified Pile of %s Dust").materialAmount(3628800L).materialIconType(MaterialIconType.dustPure).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasOreProperty).tooltip((mat, tooltips) -> tooltips.add(Component.m_237115_((String)"metaitem.dust.tooltip.purify")));
    public static final TagPrefix dust = new TagPrefix("dust").defaultTagPath("dusts/%s").unformattedTagPath("dusts").materialAmount(3628800L).materialIconType(MaterialIconType.dust).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasDustProperty);
    public static final TagPrefix nugget = new TagPrefix("nugget").defaultTagPath("nuggets/%s").unformattedTagPath("nuggets").materialAmount(403200L).materialIconType(MaterialIconType.nugget).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasIngotProperty);
    public static final TagPrefix plateDense = new TagPrefix("densePlate").idPattern("dense_%s_plate").defaultTagPath("dense_plates/%s").unformattedTagPath("dense_plates").langValue("Dense %s Plate").materialAmount(32659200L).maxStackSize(7).materialIconType(MaterialIconType.plateDense).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_DENSE));
    public static final TagPrefix plateDouble = new TagPrefix("doublePlate").idPattern("double_%s_plate").defaultTagPath("double_plates/%s").unformattedTagPath("double_plates").langValue("Double %s Plate").materialAmount(7257600L).maxStackSize(32).materialIconType(MaterialIconType.plateDouble).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasIngotProperty.and(mat -> mat.hasFlag(MaterialFlags.GENERATE_PLATE) && !mat.hasFlag(MaterialFlags.NO_SMASHING)));
    public static final TagPrefix plate = new TagPrefix("plate").defaultTagPath("plates/%s").unformattedTagPath("plates").materialAmount(3628800L).materialIconType(MaterialIconType.plate).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_PLATE));
    public static final TagPrefix round = new TagPrefix("round").defaultTagPath("rounds/%s").unformattedTagPath("rounds").materialAmount(403200L).materialIconType(MaterialIconType.round).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_ROUND));
    public static final TagPrefix foil = new TagPrefix("foil").defaultTagPath("foils/%s").unformattedTagPath("foils").materialAmount(907200L).materialIconType(MaterialIconType.foil).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_FOIL));
    public static final TagPrefix rodLong = new TagPrefix("longRod").idPattern("long_%s_rod").defaultTagPath("rods/long/%s").unformattedTagPath("rods/long").langValue("Long %s Rod").materialAmount(3628800L).materialIconType(MaterialIconType.stickLong).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_LONG_ROD));
    public static final TagPrefix rod = new TagPrefix("rod").defaultTagPath("rods/%s").unformattedTagPath("rods").langValue("%s Rod").materialAmount(1814400L).materialIconType(MaterialIconType.stick).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_ROD));
    public static final TagPrefix bolt = new TagPrefix("bolt").defaultTagPath("bolts/%s").unformattedTagPath("bolts").materialAmount(453600L).materialIconType(MaterialIconType.bolt).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_BOLT_SCREW));
    public static final TagPrefix screw = new TagPrefix("screw").defaultTagPath("screws/%s").unformattedTagPath("screws").materialAmount(403200L).materialIconType(MaterialIconType.screw).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_BOLT_SCREW));
    public static final TagPrefix ring = new TagPrefix("ring").defaultTagPath("rings/%s").unformattedTagPath("rings").materialAmount(907200L).materialIconType(MaterialIconType.ring).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_RING));
    public static final TagPrefix springSmall = new TagPrefix("smallSpring").idPattern("small_%s_spring").defaultTagPath("small_springs/%s").unformattedTagPath("small_springs").langValue("Small %s Spring").materialAmount(907200L).materialIconType(MaterialIconType.springSmall).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_SPRING_SMALL) && !mat.hasFlag(MaterialFlags.NO_SMASHING));
    public static final TagPrefix spring = new TagPrefix("spring").defaultTagPath("springs/%s").unformattedTagPath("springs").materialAmount(3628800L).materialIconType(MaterialIconType.spring).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_SPRING) && !mat.hasFlag(MaterialFlags.NO_SMASHING));
    public static final TagPrefix wireFine = new TagPrefix("fineWire").idPattern("fine_%s_wire").defaultTagPath("fine_wires/%s").unformattedTagPath("fine_wires").langValue("Fine %s Wire").materialAmount(453600L).materialIconType(MaterialIconType.wireFine).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_FINE_WIRE));
    public static final TagPrefix rotor = new TagPrefix("rotor").defaultTagPath("rotors/%s").unformattedTagPath("rotors").materialAmount(14515200L).maxStackSize(16).materialIconType(MaterialIconType.rotor).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_ROTOR));
    public static final TagPrefix gearSmall = new TagPrefix("smallGear").idPattern("small_%s_gear").defaultTagPath("small_gears/%s").unformattedTagPath("small_gears").langValue("Small %s Gear").materialAmount(3628800L).materialIconType(MaterialIconType.gearSmall).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_SMALL_GEAR));
    public static final TagPrefix gear = new TagPrefix("gear").defaultTagPath("gears/%s").unformattedTagPath("gears").materialAmount(14515200L).maxStackSize(16).materialIconType(MaterialIconType.gear).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_GEAR));
    public static final TagPrefix lens = new TagPrefix("lens").defaultTagPath("lenses/%s").unformattedTagPath("lenses").materialAmount(2721600L).materialIconType(MaterialIconType.lens).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_LENS));
    public static final TagPrefix dye = new TagPrefix("dye").defaultTagPath("dyes/%s").unformattedTagPath("dyes").materialAmount(-1L);
    public static final TagPrefix toolHeadBuzzSaw = new TagPrefix("buzzSawBlade").itemTable(() -> GTItems.MATERIAL_ITEMS).langValue("%s Buzzsaw Blade").materialAmount(14515200L).maxStackSize(16).materialIconType(MaterialIconType.toolHeadBuzzSaw).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasNoCraftingToolProperty.and(mat -> mat.hasFlag(MaterialFlags.GENERATE_PLATE)).and(mat -> mat.getProperty(PropertyKey.TOOL).hasType(GTToolType.BUZZSAW)));
    public static final TagPrefix toolHeadScrewdriver = new TagPrefix("screwdriverTip").itemTable(() -> GTItems.MATERIAL_ITEMS).langValue("%s Screwdriver Tip").materialAmount(3628800L).maxStackSize(16).materialIconType(MaterialIconType.toolHeadScrewdriver).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasNoCraftingToolProperty.and(mat -> mat.hasFlag(MaterialFlags.GENERATE_LONG_ROD)).and(mat -> mat.getProperty(PropertyKey.TOOL).hasType(GTToolType.SCREWDRIVER_LV)));
    public static final TagPrefix toolHeadDrill = new TagPrefix("drillHead").itemTable(() -> GTItems.MATERIAL_ITEMS).langValue("%s Drill Head").materialAmount(14515200L).maxStackSize(16).materialIconType(MaterialIconType.toolHeadDrill).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasToolProperty.and(mat -> mat.hasFlag(MaterialFlags.GENERATE_PLATE)).and(mat -> mat.getProperty(PropertyKey.TOOL).hasType(GTToolType.DRILL_LV)));
    public static final TagPrefix toolHeadChainsaw = new TagPrefix("chainsawHead").itemTable(() -> GTItems.MATERIAL_ITEMS).langValue("%s Chainsaw Head").materialAmount(7257600L).maxStackSize(16).materialIconType(MaterialIconType.toolHeadChainsaw).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasToolProperty.and(mat -> mat.hasFlag(MaterialFlags.GENERATE_PLATE)).and(mat -> mat.getProperty(PropertyKey.TOOL).hasType(GTToolType.CHAINSAW_LV)));
    public static final TagPrefix toolHeadWrench = new TagPrefix("wrenchTip").itemTable(() -> GTItems.MATERIAL_ITEMS).langValue("%s Wrench Tip").materialAmount(14515200L).maxStackSize(16).materialIconType(MaterialIconType.toolHeadWrench).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasNoCraftingToolProperty.and(mat -> mat.hasFlag(MaterialFlags.GENERATE_PLATE)).and(mat -> mat.getProperty(PropertyKey.TOOL).hasType(GTToolType.WRENCH_LV)));
    public static final TagPrefix toolHeadWireCutter = new TagPrefix("wireCutterHead").itemTable(() -> GTItems.MATERIAL_ITEMS).langValue("%s Wire Cutter Head").materialAmount(14515200L).maxStackSize(16).materialIconType(MaterialIconType.toolHeadWireCutter).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasNoCraftingToolProperty.and(mat -> mat.hasFlag(MaterialFlags.GENERATE_PLATE)).and(mat -> mat.getProperty(PropertyKey.TOOL).hasType(GTToolType.WIRE_CUTTER_LV)));
    public static final TagPrefix turbineBlade = new TagPrefix("turbineBlade").itemTable(() -> GTItems.MATERIAL_ITEMS).langValue("%s Turbine Blade").materialAmount(36288000L).materialIconType(MaterialIconType.turbineBlade).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasRotorProperty.and(m -> m.hasFlags(MaterialFlags.GENERATE_BOLT_SCREW, MaterialFlags.GENERATE_PLATE) && !m.hasProperty(PropertyKey.GEM)));
    public static final TagPrefix block = new TagPrefix("block").defaultTagPath("storage_blocks/%s").unformattedTagPath("storage_blocks").langValue("Block of %s").materialAmount(32659200L).materialIconType(MaterialIconType.block).miningToolTag((TagKey<Block>)BlockTags.f_144282_).generateBlock(true).generationCondition(material -> material.hasProperty(PropertyKey.INGOT) || material.hasProperty(PropertyKey.GEM) || material.hasFlag(MaterialFlags.FORCE_GENERATE_BLOCK)).unificationEnabled(true);
    public static final TagPrefix log = new TagPrefix("log").unformattedTagPath("logs", true);
    public static final TagPrefix planks = new TagPrefix("planks").unformattedTagPath("planks", true);
    public static final TagPrefix slab = new TagPrefix("slab").unformattedTagPath("slabs", true);
    public static final TagPrefix stairs = new TagPrefix("stairs").unformattedTagPath("stairs", true);
    public static final TagPrefix fence = new TagPrefix("fence").unformattedTagPath("fences");
    public static final TagPrefix fenceGate = new TagPrefix("fenceGate").unformattedTagPath("fence_gates");
    public static final TagPrefix door = new TagPrefix("door").unformattedTagPath("doors", true);
    public static final TagPrefix rock = new TagPrefix("rock").defaultTagPath("%s").langValue("%s").miningToolTag((TagKey<Block>)BlockTags.f_144282_).unificationEnabled(true).generateBlock(true).generationCondition(material -> false);
    public static final TagPrefix frameGt = new TagPrefix("frame").defaultTagPath("frames/%s").unformattedTagPath("frames").unformattedTagPath("climbable", true).langValue("%s Frame").materialAmount(7257600L).materialIconType(MaterialIconType.frameGt).miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).unificationEnabled(true).generateBlock(true).blockProperties(() -> RenderType::m_110466_, p -> p.m_60955_()).generationCondition(material -> material.hasProperty(PropertyKey.DUST) && material.hasFlag(MaterialFlags.GENERATE_FRAME));
    public static final TagPrefix pipeTinyFluid = new TagPrefix("pipeTinyFluid").itemTable(() -> GTBlocks.FLUID_PIPE_BLOCKS).langValue("Tiny %s Fluid Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(1814400L).unificationEnabled(true);
    public static final TagPrefix pipeSmallFluid = new TagPrefix("pipeSmallFluid").itemTable(() -> GTBlocks.FLUID_PIPE_BLOCKS).langValue("Small %s Fluid Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(3628800L).unificationEnabled(true);
    public static final TagPrefix pipeNormalFluid = new TagPrefix("pipeNormalFluid").itemTable(() -> GTBlocks.FLUID_PIPE_BLOCKS).langValue("Normal %s Fluid Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(10886400L).unificationEnabled(true);
    public static final TagPrefix pipeLargeFluid = new TagPrefix("pipeLargeFluid").itemTable(() -> GTBlocks.FLUID_PIPE_BLOCKS).langValue("Large %s Fluid Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(21772800L).unificationEnabled(true);
    public static final TagPrefix pipeHugeFluid = new TagPrefix("pipeHugeFluid").itemTable(() -> GTBlocks.FLUID_PIPE_BLOCKS).langValue("Huge %s Fluid Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(43545600L).unificationEnabled(true);
    public static final TagPrefix pipeQuadrupleFluid = new TagPrefix("pipeQuadrupleFluid").itemTable(() -> GTBlocks.FLUID_PIPE_BLOCKS).langValue("Quadruple %s Fluid Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(14515200L).unificationEnabled(true);
    public static final TagPrefix pipeNonupleFluid = new TagPrefix("pipeNonupleFluid").itemTable(() -> GTBlocks.FLUID_PIPE_BLOCKS).langValue("Nonuple %s Fluid Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(32659200L).unificationEnabled(true);
    public static final TagPrefix pipeSmallItem = new TagPrefix("pipeSmallItem").itemTable(() -> GTBlocks.ITEM_PIPE_BLOCKS).langValue("Small %s Item Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(3628800L).unificationEnabled(true);
    public static final TagPrefix pipeNormalItem = new TagPrefix("pipeNormalItem").itemTable(() -> GTBlocks.ITEM_PIPE_BLOCKS).langValue("Normal %s Item Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(10886400L).unificationEnabled(true);
    public static final TagPrefix pipeLargeItem = new TagPrefix("pipeLargeItem").itemTable(() -> GTBlocks.ITEM_PIPE_BLOCKS).langValue("Large %s Item Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(21772800L).unificationEnabled(true);
    public static final TagPrefix pipeHugeItem = new TagPrefix("pipeHugeItem").itemTable(() -> GTBlocks.ITEM_PIPE_BLOCKS).langValue("Huge %s Item Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(43545600L).unificationEnabled(true);
    public static final TagPrefix pipeSmallRestrictive = new TagPrefix("pipeSmallRestrictive").itemTable(() -> GTBlocks.ITEM_PIPE_BLOCKS).langValue("Small Restrictive %s Item Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(3628800L).unificationEnabled(true);
    public static final TagPrefix pipeNormalRestrictive = new TagPrefix("pipeNormalRestrictive").itemTable(() -> GTBlocks.ITEM_PIPE_BLOCKS).langValue("Normal Restrictive %s Item Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(10886400L).unificationEnabled(true);
    public static final TagPrefix pipeLargeRestrictive = new TagPrefix("pipeLargeRestrictive").itemTable(() -> GTBlocks.ITEM_PIPE_BLOCKS).langValue("Large Restrictive %s Item Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(21772800L).unificationEnabled(true);
    public static final TagPrefix pipeHugeRestrictive = new TagPrefix("pipeHugeRestrictive").itemTable(() -> GTBlocks.ITEM_PIPE_BLOCKS).langValue("Huge Restrictive %s Item Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(43545600L).unificationEnabled(true);
    public static final TagPrefix wireGtHex = new TagPrefix("wireGtHex").itemTable(() -> GTBlocks.CABLE_BLOCKS).langValue("16x %s Wire").miningToolTag(GTToolType.WIRE_CUTTER.harvestTags.get(0)).materialAmount(29030400L).materialIconType(MaterialIconType.wire).unificationEnabled(true);
    public static final TagPrefix wireGtOctal = new TagPrefix("wireGtOctal").itemTable(() -> GTBlocks.CABLE_BLOCKS).langValue("8x %s Wire").miningToolTag(GTToolType.WIRE_CUTTER.harvestTags.get(0)).materialAmount(14515200L).materialIconType(MaterialIconType.wire).unificationEnabled(true);
    public static final TagPrefix wireGtQuadruple = new TagPrefix("wireGtQuadruple").itemTable(() -> GTBlocks.CABLE_BLOCKS).langValue("4x %s Wire").miningToolTag(GTToolType.WIRE_CUTTER.harvestTags.get(0)).materialAmount(7257600L).materialIconType(MaterialIconType.wire).unificationEnabled(true);
    public static final TagPrefix wireGtDouble = new TagPrefix("wireGtDouble").itemTable(() -> GTBlocks.CABLE_BLOCKS).langValue("2x %s Wire").miningToolTag(GTToolType.WIRE_CUTTER.harvestTags.get(0)).materialAmount(3628800L).materialIconType(MaterialIconType.wire).unificationEnabled(true);
    public static final TagPrefix wireGtSingle = new TagPrefix("wireGtSingle").itemTable(() -> GTBlocks.CABLE_BLOCKS).langValue("1x %s Wire").miningToolTag(GTToolType.WIRE_CUTTER.harvestTags.get(0)).materialAmount(1814400L).materialIconType(MaterialIconType.wire).unificationEnabled(true);
    public static final TagPrefix cableGtHex = new TagPrefix("cableGtHex").itemTable(() -> GTBlocks.CABLE_BLOCKS).langValue("16x %s Cable").miningToolTag(GTToolType.WIRE_CUTTER.harvestTags.get(0)).materialAmount(29030400L).unificationEnabled(true);
    public static final TagPrefix cableGtOctal = new TagPrefix("cableGtOctal").itemTable(() -> GTBlocks.CABLE_BLOCKS).langValue("8x %s Cable").miningToolTag(GTToolType.WIRE_CUTTER.harvestTags.get(0)).materialAmount(14515200L).unificationEnabled(true);
    public static final TagPrefix cableGtQuadruple = new TagPrefix("cableGtQuadruple").itemTable(() -> GTBlocks.CABLE_BLOCKS).langValue("4x %s Cable").miningToolTag(GTToolType.WIRE_CUTTER.harvestTags.get(0)).materialAmount(7257600L).unificationEnabled(true);
    public static final TagPrefix cableGtDouble = new TagPrefix("cableGtDouble").itemTable(() -> GTBlocks.CABLE_BLOCKS).langValue("2x %s Cable").miningToolTag(GTToolType.WIRE_CUTTER.harvestTags.get(0)).materialAmount(3628800L).unificationEnabled(true);
    public static final TagPrefix cableGtSingle = new TagPrefix("cableGtSingle").itemTable(() -> GTBlocks.CABLE_BLOCKS).langValue("1x %s Cable").miningToolTag(GTToolType.WIRE_CUTTER.harvestTags.get(0)).materialAmount(1814400L).unificationEnabled(true);
    public final String name;
    private String idPattern;
    public final boolean invertedName;
    protected final List<TagType> tags = new ArrayList<TagType>();
    public String langValue;
    private long materialAmount = -1L;
    private boolean unificationEnabled;
    private boolean generateItem;
    private boolean generateBlock;
    private BlockProperties blockProperties = new BlockProperties(() -> RenderType::m_110466_, UnaryOperator.identity());
    @Nullable
    private Predicate<Material> generationCondition;
    @Nullable
    private MaterialIconType materialIconType;
    private Supplier<Table<TagPrefix, Material, ? extends Supplier<? extends ItemLike>>> itemTable;
    @Nullable
    private BiConsumer<Material, List<Component>> tooltip;
    private final Map<Material, Supplier<? extends ItemLike>[]> ignoredMaterials = new HashMap<Material, Supplier<? extends ItemLike>[]>();
    private final Object2FloatMap<Material> materialAmounts = new Object2FloatOpenHashMap();
    private int maxStackSize = 64;
    private final List<MaterialStack> secondaryMaterials = new ArrayList<MaterialStack>();
    protected final Set<TagKey<Block>> miningToolTag = new HashSet<TagKey<Block>>();

    public static void init() {
        AddonFinder.getAddons().forEach(IGTAddon::registerTagPrefixes);
        if (GTCEu.isKubeJSLoaded()) {
            GTRegistryInfo.registerFor(GTRegistryInfo.TAG_PREFIX.registryKey);
        }
    }

    public static TagPrefix get(String name) {
        return PREFIXES.get(name);
    }

    public TagPrefix(String name) {
        this(name, false);
    }

    public TagPrefix(String name, boolean invertedName) {
        this.name = name;
        this.idPattern = "%s_" + FormattingUtil.toLowerCaseUnder(name);
        this.invertedName = invertedName;
        this.langValue = "%s " + FormattingUtil.toEnglishName(FormattingUtil.toLowerCaseUnder(name));
        PREFIXES.put(name, this);
    }

    public static TagPrefix oreTagPrefix(String name, TagKey<Block> miningToolTag) {
        return new TagPrefix(name).defaultTagPath("ores/%s").prefixOnlyTagPath("ores_in_ground/%s").unformattedTagPath("ores").materialIconType(MaterialIconType.ore).miningToolTag(miningToolTag).unificationEnabled(true).generationCondition(Conditions.hasOreProperty);
    }

    public void addSecondaryMaterial(MaterialStack secondaryMaterial) {
        Preconditions.checkNotNull((Object)secondaryMaterial, (Object)"secondaryMaterial");
        this.secondaryMaterials.add(secondaryMaterial);
    }

    public TagPrefix registerOre(Supplier<BlockState> stoneType, Supplier<Material> material, BlockBehaviour.Properties properties, ResourceLocation baseModelLocation) {
        return this.registerOre(stoneType, material, properties, baseModelLocation, false);
    }

    public TagPrefix registerOre(Supplier<BlockState> stoneType, Supplier<Material> material, BlockBehaviour.Properties properties, ResourceLocation baseModelLocation, boolean doubleDrops) {
        return this.registerOre(stoneType, material, properties, baseModelLocation, doubleDrops, false, false);
    }

    public TagPrefix registerOre(Supplier<BlockState> stoneType, Supplier<Material> material, BlockBehaviour.Properties properties, ResourceLocation baseModelLocation, boolean doubleDrops, boolean isSand, boolean shouldDropAsItem) {
        return this.registerOre(stoneType, material, () -> properties, baseModelLocation, doubleDrops, isSand, shouldDropAsItem);
    }

    public TagPrefix registerOre(Supplier<BlockState> stoneType, Supplier<Material> material, Supplier<BlockBehaviour.Properties> properties, ResourceLocation baseModelLocation, boolean doubleDrops, boolean isSand, boolean shouldDropAsItem) {
        ORES.put(this, new OreType(stoneType, material, properties, baseModelLocation, doubleDrops, isSand, shouldDropAsItem));
        if (shouldDropAsItem) {
            GTOreByProduct.addOreByProductPrefix(this);
        }
        return this;
    }

    public TagPrefix defaultTagPath(String path) {
        return this.defaultTagPath(path, false);
    }

    public TagPrefix defaultTagPath(String path, boolean isVanilla) {
        this.tags.add(TagType.withDefaultFormatter(path, isVanilla));
        return this;
    }

    public TagPrefix prefixTagPath(String path) {
        this.tags.add(TagType.withPrefixFormatter(path));
        return this;
    }

    public TagPrefix prefixOnlyTagPath(String path) {
        this.tags.add(TagType.withPrefixOnlyFormatter(path));
        return this;
    }

    public TagPrefix unformattedTagPath(String path) {
        return this.unformattedTagPath(path, false);
    }

    public TagPrefix unformattedTagPath(String path, boolean isVanilla) {
        this.tags.add(TagType.withNoFormatter(path, isVanilla));
        return this;
    }

    public TagPrefix customTagPath(String path, BiFunction<TagPrefix, Material, TagKey<Item>> formatter) {
        this.tags.add(TagType.withCustomFormatter(path, formatter));
        return this;
    }

    public TagPrefix customTagPredicate(String path, boolean isVanilla, Predicate<Material> materialPredicate) {
        this.tags.add(TagType.withCustomFilter(path, isVanilla, materialPredicate));
        return this;
    }

    public TagPrefix miningToolTag(TagKey<Block> tag) {
        this.miningToolTag.add(tag);
        return this;
    }

    public TagPrefix blockProperties(Supplier<Supplier<RenderType>> renderType, UnaryOperator<BlockBehaviour.Properties> properties) {
        return this.blockProperties(new BlockProperties(renderType, properties));
    }

    public long getMaterialAmount(@Nullable Material material) {
        if (material == null || !this.isAmountModified(material)) {
            return this.materialAmount;
        }
        return (long)(3628800.0f * this.materialAmounts.getFloat((Object)material));
    }

    public static TagPrefix getPrefix(String prefixName) {
        return TagPrefix.getPrefix(prefixName, null);
    }

    public static TagPrefix getPrefix(String prefixName, @Nullable TagPrefix replacement) {
        return PREFIXES.getOrDefault(prefixName, replacement);
    }

    public TagKey<Item>[] getItemParentTags() {
        return (TagKey[])this.tags.stream().filter(TagType::isParentTag).map(type -> type.getTag(this, null)).toArray(TagKey[]::new);
    }

    public TagKey<Item>[] getItemTags(@NotNull Material mat) {
        return (TagKey[])this.tags.stream().filter(type -> !type.isParentTag()).map(type -> type.getTag(this, mat)).filter(Objects::nonNull).toArray(TagKey[]::new);
    }

    public TagKey<Item>[] getAllItemTags(@NotNull Material mat) {
        return (TagKey[])this.tags.stream().map(type -> type.getTag(this, mat)).filter(Objects::nonNull).toArray(TagKey[]::new);
    }

    public TagKey<Block>[] getBlockTags(@NotNull Material mat) {
        return (TagKey[])this.tags.stream().filter(type -> !type.isParentTag()).map(type -> type.getTag(this, mat)).map(itemTagKey -> TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)itemTagKey.f_203868_())).toArray(TagKey[]::new);
    }

    public TagKey<Block>[] getAllBlockTags(@NotNull Material mat) {
        return (TagKey[])this.tags.stream().map(type -> type.getTag(this, mat)).map(itemTagKey -> TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)itemTagKey.f_203868_())).toArray(TagKey[]::new);
    }

    public boolean hasItemTable() {
        return this.itemTable != null;
    }

    public Supplier<ItemLike> getItemFromTable(Material material) {
        return (Supplier)this.itemTable.get().get((Object)this, (Object)material);
    }

    public boolean doGenerateItem() {
        return this.generateItem;
    }

    public boolean doGenerateItem(Material material) {
        return this.generateItem && !this.isIgnored(material) && (this.generationCondition == null || this.generationCondition.test(material)) || this.hasItemTable() && this.itemTable.get() != null && this.getItemFromTable(material) != null;
    }

    public boolean doGenerateBlock() {
        return this.generateBlock;
    }

    public boolean doGenerateBlock(Material material) {
        return this.generateBlock && !this.isIgnored(material) && (this.generationCondition == null || this.generationCondition.test(material)) || this.hasItemTable() && this.itemTable.get() != null && this.getItemFromTable(material) != null;
    }

    public <T extends IMaterialProperty<T>> void executeHandler(Consumer<FinishedRecipe> provider, PropertyKey<T> propertyKey, MaterialRecipeHandler<T> handler) {
        for (Material material : GTCEuAPI.materialManager.getRegisteredMaterials()) {
            if (!material.hasProperty(propertyKey) || material.hasFlag(MaterialFlags.NO_UNIFICATION) || ChemicalHelper.get(this, material).m_41619_()) continue;
            handler.accept(this, material, material.getProperty(propertyKey), provider);
        }
    }

    public String getUnlocalizedName() {
        return "tagprefix." + FormattingUtil.toLowerCaseUnderscore(this.name);
    }

    public MutableComponent getLocalizedName(Material material) {
        return Component.m_237110_((String)this.getUnlocalizedName(material), (Object[])new Object[]{material.getLocalizedName()});
    }

    public String getUnlocalizedName(Material material) {
        String localizationKey;
        String formattedPrefix = FormattingUtil.toLowerCaseUnderscore(this.name);
        String matSpecificKey = String.format("item.%s.%s", material.getModid(), this.idPattern.formatted(material.getName()));
        if (LocalizationUtils.exist((String)matSpecificKey)) {
            return matSpecificKey;
        }
        if (material.hasProperty(PropertyKey.POLYMER) && LocalizationUtils.exist((String)(localizationKey = String.format("tagprefix.polymer.%s", formattedPrefix)))) {
            return localizationKey;
        }
        return this.getUnlocalizedName();
    }

    public boolean isIgnored(Material material) {
        return this.ignoredMaterials.containsKey(material);
    }

    @SafeVarargs
    public final void setIgnored(Material material, Supplier<? extends ItemLike> ... items) {
        this.ignoredMaterials.put(material, items);
        if (items.length > 0) {
            ChemicalHelper.registerUnificationItems(this, material, items);
        }
    }

    public void setIgnored(Material material, ItemLike ... items) {
        if (this.doGenerateBlock()) {
            this.setIgnoredBlock(material, (Block[])Arrays.stream(items).filter(Block.class::isInstance).map(Block.class::cast).toArray(Block[]::new));
        } else {
            this.setIgnored(material, (Supplier[])Arrays.stream(items).map(item -> () -> item).toArray(Supplier[]::new));
        }
    }

    public void setIgnoredBlock(Material material, Block ... items) {
        this.setIgnored(material, (Supplier[])Arrays.stream(items).map(block -> SupplierMemoizer.memoizeBlockSupplier(() -> block)).toArray(Supplier[]::new));
    }

    public void setIgnored(Material material) {
        this.ignoredMaterials.put(material, new Supplier[0]);
    }

    public void removeIgnored(Material material) {
        this.ignoredMaterials.remove(material);
    }

    public Map<Material, Supplier<? extends ItemLike>[]> getIgnored() {
        return new HashMap<Material, Supplier<? extends ItemLike>[]>(this.ignoredMaterials);
    }

    public boolean isAmountModified(Material material) {
        return this.materialAmounts.containsKey((Object)material);
    }

    public void modifyMaterialAmount(@NotNull Material material, float amount) {
        this.materialAmounts.put((Object)material, amount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagPrefix tagPrefix = (TagPrefix)o;
        return this.name.equals(tagPrefix.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static Collection<TagPrefix> values() {
        return PREFIXES.values();
    }

    public String toString() {
        return this.name;
    }

    public String name() {
        return this.name;
    }

    public String idPattern() {
        return this.idPattern;
    }

    public TagPrefix idPattern(String idPattern) {
        this.idPattern = idPattern;
        return this;
    }

    public boolean invertedName() {
        return this.invertedName;
    }

    public TagPrefix langValue(String langValue) {
        this.langValue = langValue;
        return this;
    }

    public String langValue() {
        return this.langValue;
    }

    public long materialAmount() {
        return this.materialAmount;
    }

    public TagPrefix materialAmount(long materialAmount) {
        this.materialAmount = materialAmount;
        return this;
    }

    public TagPrefix unificationEnabled(boolean unificationEnabled) {
        this.unificationEnabled = unificationEnabled;
        return this;
    }

    public TagPrefix generateItem(boolean generateItem) {
        this.generateItem = generateItem;
        return this;
    }

    public TagPrefix generateBlock(boolean generateBlock) {
        this.generateBlock = generateBlock;
        return this;
    }

    public BlockProperties blockProperties() {
        return this.blockProperties;
    }

    public TagPrefix blockProperties(BlockProperties blockProperties) {
        this.blockProperties = blockProperties;
        return this;
    }

    @Nullable
    public Predicate<Material> generationCondition() {
        return this.generationCondition;
    }

    public TagPrefix generationCondition(@Nullable Predicate<Material> generationCondition) {
        this.generationCondition = generationCondition;
        return this;
    }

    @Nullable
    public MaterialIconType materialIconType() {
        return this.materialIconType;
    }

    public TagPrefix materialIconType(@Nullable MaterialIconType materialIconType) {
        this.materialIconType = materialIconType;
        return this;
    }

    public TagPrefix itemTable(Supplier<Table<TagPrefix, Material, ? extends Supplier<? extends ItemLike>>> itemTable) {
        this.itemTable = itemTable;
        return this;
    }

    @Nullable
    public BiConsumer<Material, List<Component>> tooltip() {
        return this.tooltip;
    }

    public TagPrefix tooltip(@Nullable BiConsumer<Material, List<Component>> tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public int maxStackSize() {
        return this.maxStackSize;
    }

    public TagPrefix maxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
        return this;
    }

    public List<MaterialStack> secondaryMaterials() {
        return this.secondaryMaterials;
    }

    public Set<TagKey<Block>> miningToolTag() {
        return this.miningToolTag;
    }

    public record BlockProperties(Supplier<Supplier<RenderType>> renderType, UnaryOperator<BlockBehaviour.Properties> properties) {
    }

    public static class Conditions {
        public static final Predicate<Material> hasToolProperty = mat -> mat.hasProperty(PropertyKey.TOOL);
        public static final Predicate<Material> hasNoCraftingToolProperty = hasToolProperty.and(mat -> !mat.getProperty(PropertyKey.TOOL).isIgnoreCraftingTools());
        public static final Predicate<Material> hasOreProperty = mat -> mat.hasProperty(PropertyKey.ORE);
        public static final Predicate<Material> hasGemProperty = mat -> mat.hasProperty(PropertyKey.GEM);
        public static final Predicate<Material> hasDustProperty = mat -> mat.hasProperty(PropertyKey.DUST);
        public static final Predicate<Material> hasIngotProperty = mat -> mat.hasProperty(PropertyKey.INGOT);
        public static final Predicate<Material> hasBlastProperty = mat -> mat.hasProperty(PropertyKey.BLAST);
        public static final Predicate<Material> hasRotorProperty = mat -> mat.hasProperty(PropertyKey.ROTOR);
    }

    public record OreType(Supplier<BlockState> stoneType, Supplier<Material> material, Supplier<BlockBehaviour.Properties> template, ResourceLocation baseModelLocation, boolean isDoubleDrops, boolean isSand, boolean shouldDropAsItem) {
    }

    @FunctionalInterface
    public static interface MaterialRecipeHandler<T extends IMaterialProperty<T>> {
        public void accept(TagPrefix var1, Material var2, T var3, Consumer<FinishedRecipe> var4);
    }
}

