/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.chemical.material.properties;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IMaterialProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.MaterialProperties;
import com.gregtechceu.gtceu.api.fluids.FluidBuilder;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorage;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageImpl;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKey;
import com.gregtechceu.gtceu.api.registry.registrate.GTRegistrate;
import java.util.function.Supplier;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidProperty
implements IMaterialProperty<FluidProperty>,
FluidStorage {
    private final FluidStorageImpl storage = new FluidStorageImpl();
    private FluidStorageKey primaryKey = null;

    public FluidProperty(@NotNull FluidStorageKey key, @NotNull FluidBuilder builder) {
        this.enqueueRegistration(key, builder);
    }

    @NotNull
    public FluidStorage getStorage() {
        return this;
    }

    @ApiStatus.Internal
    public void registerFluids(@NotNull Material material, @NotNull GTRegistrate registrate) {
        this.storage.registerFluids(material, registrate);
    }

    @Override
    public void enqueueRegistration(@NotNull FluidStorageKey key, @NotNull FluidBuilder builder) {
        this.storage.enqueueRegistration(key, builder);
        if (this.primaryKey == null) {
            this.primaryKey = key;
        }
    }

    @Override
    public void store(@NotNull FluidStorageKey key, @NotNull Supplier<? extends Fluid> fluid, @Nullable FluidBuilder builder) {
        this.storage.store(key, fluid, builder);
        if (this.primaryKey == null) {
            this.primaryKey = key;
        }
    }

    @Override
    @Nullable
    public Fluid get(@NotNull FluidStorageKey key) {
        return this.storage.get(key);
    }

    @Override
    @Nullable
    public FluidStorage.FluidEntry getEntry(@NotNull FluidStorageKey key) {
        return this.storage.getEntry(key);
    }

    @Override
    @Nullable
    public FluidBuilder getQueuedBuilder(@NotNull FluidStorageKey key) {
        return this.storage.getQueuedBuilder(key);
    }

    @Override
    public void verifyProperty(MaterialProperties properties) {
        if (this.primaryKey == null) {
            throw new IllegalStateException("FluidProperty cannot be empty!");
        }
    }

    public FluidProperty() {
    }

    public FluidStorageKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(FluidStorageKey primaryKey) {
        this.primaryKey = primaryKey;
    }
}

