/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.client.ClientProxy;
import com.gregtechceu.gtceu.common.CommonProxy;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.Platform;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="gtceu")
public class GTCEu {
    public static final String MOD_ID = "gtceu";
    public static final String NAME = "GregTechCEu";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"GregTechCEu");

    public GTCEu() {
        GTCEu.init();
        GTCEuAPI.instance = this;
        DistExecutor.unsafeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    }

    public static void init() {
        LOGGER.info("{} is initializing on platform: {}", (Object)NAME, (Object)Platform.platformName());
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, FormattingUtil.toLowerCaseUnder(path));
    }

    public static String appendIdString(String id) {
        return id.indexOf(58) == -1 ? "gtceu:" + id : id;
    }

    public static ResourceLocation appendId(String id) {
        String[] strings = new String[]{MOD_ID, id};
        int i = id.indexOf(58);
        if (i >= 0) {
            strings[1] = id.substring(i + 1);
            if (i >= 1) {
                strings[0] = id.substring(0, i);
            }
        }
        return new ResourceLocation(strings[0], strings[1]);
    }

    public static boolean isKubeJSLoaded() {
        return LDLib.isModLoaded((String)"kubejs");
    }

    public static boolean isCreateLoaded() {
        return LDLib.isModLoaded((String)"create");
    }

    public static boolean isIrisOculusLoaded() {
        return LDLib.isModLoaded((String)"iris") || LDLib.isModLoaded((String)"oculus");
    }

    public static boolean isSodiumRubidiumEmbeddiumLoaded() {
        return LDLib.isModLoaded((String)"sodium") || LDLib.isModLoaded((String)"rubidium") || LDLib.isModLoaded((String)"embeddium");
    }

    public static boolean isAE2Loaded() {
        return LDLib.isModLoaded((String)"ae2");
    }

    public static boolean isCuriosLoaded() {
        return LDLib.isModLoaded((String)"curios");
    }

    public static boolean isShimmerLoaded() {
        return LDLib.isModLoaded((String)"shimmer");
    }

    public static boolean isJAVDLoaded() {
        return LDLib.isModLoaded((String)"javd");
    }

    @Deprecated(forRemoval=true, since="1.0.21")
    public static boolean isHighTier() {
        return GTCEuAPI.isHighTier();
    }
}

