/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.common.recipe.type;

import argent_matter.gcyr.common.data.GCYRItems;
import argent_matter.gcyr.common.data.GCYRVanillaRecipeTypes;
import argent_matter.gcyr.common.item.armor.trim.GCYRTrimMaterials;
import argent_matter.gcyr.common.item.armor.trim.GCYRTrimPatterns;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;

public class SmithingSpaceSuitRecipe
implements SmithingRecipe {
    public static final String SPACE_SUIT_ARMOR_KEY = "gcyr:spacesuit";
    private final ResourceLocation id;
    final Ingredient template;
    final Ingredient base;
    final Ingredient addition;

    public SmithingSpaceSuitRecipe(ResourceLocation id, Ingredient template, Ingredient base, Ingredient addition) {
        this.id = id;
        this.template = template;
        this.base = base;
        this.addition = addition;
    }

    public boolean m_5818_(Container container, Level level) {
        return this.template.test(container.m_8020_(0)) && this.base.test(container.m_8020_(1)) && this.addition.test(container.m_8020_(2));
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        ItemStack baseItem = container.m_8020_(1);
        ItemStack additionItem = container.m_8020_(2);
        if (!(baseItem.m_41782_() && baseItem.m_41783_().m_128471_(SPACE_SUIT_ARMOR_KEY) || !this.base.test(baseItem))) {
            Optional trimMaterial = registryAccess.m_175515_(Registries.f_266076_).m_203636_(GCYRTrimMaterials.SPACE);
            Optional trimPattern = TrimPatterns.m_266468_((RegistryAccess)registryAccess, (ItemStack)container.m_8020_(0));
            ItemStack trimCopied = baseItem.m_41777_();
            trimCopied.m_41764_(1);
            ArmorTrim trim = new ArmorTrim((Holder)trimMaterial.get(), (Holder)trimPattern.get());
            SmithingSpaceSuitRecipe.setTrim(registryAccess, trimCopied, additionItem, trim);
            return trimCopied;
        }
        return ItemStack.f_41583_;
    }

    public static void setTrim(RegistryAccess registryAccess, ItemStack armor, ItemStack addition, ArmorTrim trim) {
        armor.m_41784_().m_128379_(SPACE_SUIT_ARMOR_KEY, true);
        if (armor.m_204117_(Tags.Items.ARMORS_CHESTPLATES)) {
            addition.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(cap -> {
                FluidStack stack = cap.getFluidInTank(0);
                if (!stack.isEmpty()) {
                    CompoundTag fluidTag = new CompoundTag();
                    stack.writeToNBT(fluidTag);
                    armor.m_41784_().m_128365_("Fluid", (Tag)fluidTag);
                }
            });
        }
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        Optional material;
        ItemStack itemstack = new ItemStack((ItemLike)Items.f_42473_);
        Optional pattern = registryAccess.m_175515_(Registries.f_266063_).m_203636_(GCYRTrimPatterns.SPACE);
        if (pattern.isPresent() && (material = registryAccess.m_175515_(Registries.f_266076_).m_203636_(GCYRTrimMaterials.SPACE)).isPresent()) {
            ArmorTrim armortrim = new ArmorTrim((Holder)material.get(), (Holder)pattern.get());
            SmithingSpaceSuitRecipe.setTrim(registryAccess, itemstack, new ItemStack((ItemLike)GCYRItems.SPACE_SUIT_CHEST.get()), armortrim);
        }
        return itemstack;
    }

    public boolean m_266166_(ItemStack stack) {
        return this.template.test(stack);
    }

    public boolean m_266343_(ItemStack stack) {
        return this.base.test(stack);
    }

    public boolean m_266253_(ItemStack stack) {
        return this.addition.test(stack);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)GCYRVanillaRecipeTypes.SMITHING_SPACESUIT_SERIALIZER.get();
    }

    public boolean m_142505_() {
        return Stream.of(this.template, this.base, this.addition).anyMatch(ForgeHooks::hasNoElements);
    }

    public static class Serializer
    implements RecipeSerializer<SmithingSpaceSuitRecipe> {
        public SmithingSpaceSuitRecipe fromJson(ResourceLocation arg, JsonObject jsonObject) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)jsonObject, (String)"template"));
            Ingredient ingredient1 = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)jsonObject, (String)"base"));
            Ingredient ingredient2 = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)jsonObject, (String)"addition"));
            return new SmithingSpaceSuitRecipe(arg, ingredient, ingredient1, ingredient2);
        }

        public SmithingSpaceSuitRecipe fromNetwork(ResourceLocation arg, FriendlyByteBuf arg2) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)arg2);
            Ingredient ingredient1 = Ingredient.m_43940_((FriendlyByteBuf)arg2);
            Ingredient ingredient2 = Ingredient.m_43940_((FriendlyByteBuf)arg2);
            return new SmithingSpaceSuitRecipe(arg, ingredient, ingredient1, ingredient2);
        }

        public void toNetwork(FriendlyByteBuf arg, SmithingSpaceSuitRecipe arg2) {
            arg2.template.m_43923_(arg);
            arg2.base.m_43923_(arg);
            arg2.addition.m_43923_(arg);
        }
    }
}

