/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.common.recipe.condition;

import argent_matter.gcyr.api.capability.GCYRCapabilityHelper;
import argent_matter.gcyr.api.capability.IDysonSystem;
import argent_matter.gcyr.common.data.GCYRRecipeConditions;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.condition.RecipeConditionType;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class DysonSphereCondition
extends RecipeCondition {
    public static final Codec<DysonSphereCondition> CODEC = RecordCodecBuilder.create(instance -> RecipeCondition.isReverse((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, DysonSphereCondition::new));
    public static final DysonSphereCondition INSTANCE = new DysonSphereCondition();

    public DysonSphereCondition(boolean isReverse) {
        super(isReverse);
    }

    public RecipeConditionType<?> getType() {
        return GCYRRecipeConditions.DYSON_SPHERE;
    }

    public Component getTooltips() {
        return Component.m_237115_((String)(this.isReverse ? "gcyr.condition.requires_dyson_sphere.false" : "gcyr.condition.requires_dyson_sphere.true"));
    }

    public boolean test(@NotNull GTRecipe recipe, @NotNull RecipeLogic recipeLogic) {
        Level level = recipeLogic.getMachine().getLevel();
        if (!level.f_46443_) {
            IDysonSystem system = GCYRCapabilityHelper.getDysonSystem((ServerLevel)level);
            if (system == null) {
                return false;
            }
            return system.isDysonSphereActive() && !system.activeDysonSphere().isCollapsed();
        }
        return false;
    }

    public RecipeCondition createTemplate() {
        return new DysonSphereCondition();
    }

    public DysonSphereCondition() {
    }
}

