/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.common.machine.multiblock;

import argent_matter.gcyr.api.capability.GCYRCapabilityHelper;
import argent_matter.gcyr.api.capability.ISpaceStationHolder;
import argent_matter.gcyr.api.space.planet.Planet;
import argent_matter.gcyr.common.data.GCYRItems;
import argent_matter.gcyr.common.item.KeyCardBehaviour;
import argent_matter.gcyr.common.item.PlanetIdChipBehaviour;
import argent_matter.gcyr.common.item.StationContainerBehaviour;
import argent_matter.gcyr.common.machine.multiblock.PlatformMultiblockMachine;
import argent_matter.gcyr.util.PosWithState;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.mojang.datafixers.util.Pair;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class SpaceStationPackagerMachine
extends PlatformMultiblockMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(SpaceStationPackagerMachine.class, PlatformMultiblockMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    private final ItemStackTransfer packageSlot = new ItemStackTransfer(1);
    @Persisted
    private final ItemStackTransfer keycardSlot;
    @Persisted
    private final ItemStackTransfer outputSlots;

    public SpaceStationPackagerMachine(IMachineBlockEntity holder) {
        super(holder);
        this.packageSlot.setFilter(arg_0 -> GCYRItems.SPACE_STATION_PACKAGE.isIn(arg_0));
        this.keycardSlot = new ItemStackTransfer(1);
        this.outputSlots = new ItemStackTransfer(2);
    }

    public ModularUI createUI(Player entityPlayer) {
        ModularUI modularUI = new ModularUI(176, 166, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND});
        modularUI.widget((Widget)new LabelWidget(4, 5, this.self().getBlockState().m_60734_().m_7705_()));
        WidgetGroup buttons = new WidgetGroup(7, 16, 0, 0);
        buttons.addWidget((Widget)new ButtonWidget(0, 42, 80, 24, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON.copy().setColor(-5636096), new TextTexture("gcyr.multiblock.space_station.pack")}), this::onBuildButtonClick));
        modularUI.widget((Widget)buttons);
        WidgetGroup slots = new WidgetGroup(128, 24, 0, 0);
        slots.addWidget(new SlotWidget((IItemTransfer)this.packageSlot, 0, 0, 0).setHoverTooltips(new Component[]{Component.m_237115_((String)"gcyr.multiblock.space_station.package_slot.tooltip")}));
        slots.addWidget(new SlotWidget((IItemTransfer)this.keycardSlot, 0, 18, 0).setHoverTooltips(new Component[]{Component.m_237115_((String)"gcyr.multiblock.space_station.keycard_slot.tooltip")}));
        slots.addWidget((Widget)new SlotWidget((IItemTransfer)this.outputSlots, 0, 0, 22, true, false));
        slots.addWidget((Widget)new SlotWidget((IItemTransfer)this.outputSlots, 1, 18, 22, true, false));
        modularUI.widget((Widget)slots);
        modularUI.widget((Widget)UITemplate.bindPlayerInventory((Inventory)entityPlayer.m_150109_(), (IGuiTexture)GuiTextures.SLOT, (int)7, (int)86, (boolean)true));
        return modularUI;
    }

    private void onBuildButtonClick(ClickData data) {
        if (this.getLevel().f_46443_ || !this.isFormed) {
            return;
        }
        if (!(this.outputSlots.getStackInSlot(0).m_41619_() && this.outputSlots.getStackInSlot(1).m_41619_() && GCYRItems.SPACE_STATION_PACKAGE.isIn(this.packageSlot.getStackInSlot(0)) && GCYRItems.ID_CHIP.isIn(this.keycardSlot.getStackInSlot(0)))) {
            return;
        }
        ISpaceStationHolder spaceStationHolder = GCYRCapabilityHelper.getSpaceStations((ServerLevel)this.getLevel());
        if (spaceStationHolder == null) {
            return;
        }
        ItemStack idChip = this.keycardSlot.getStackInSlot(0);
        Planet targetPlanet = PlanetIdChipBehaviour.getPlanetFromStack(idChip);
        if (targetPlanet == null) {
            return;
        }
        Direction back = this.getFrontFacing().m_122424_();
        Direction left = this.getFrontFacing().m_122428_();
        Direction right = left.m_122424_();
        BlockPos current = this.getPos().m_5484_(back, 1);
        int startX = current.m_123304_(back.m_122434_());
        int endX = current.m_5484_(back, this.bDist - 1).m_123304_(back.m_122434_());
        int startZ = current.m_5484_(left, this.lDist).m_123304_(left.m_122434_());
        int endZ = current.m_5484_(right, this.rDist).m_123304_(right.m_122434_());
        int startY = current.m_123342_();
        int endY = current.m_7918_(0, this.hDist, 0).m_123342_();
        if (this.getFrontFacing().m_122434_() == Direction.Axis.Z) {
            int temp = startX;
            startX = startZ;
            startZ = temp;
            temp = endX;
            endX = endZ;
            endZ = temp;
        }
        AABB bounds = new AABB((double)startX, (double)startY, (double)startZ, (double)endX, (double)endY, (double)endZ);
        startX = (int)bounds.f_82288_;
        endX = (int)bounds.f_82291_;
        startY = (int)bounds.f_82289_;
        endY = (int)bounds.f_82292_;
        startZ = (int)bounds.f_82290_;
        endZ = (int)bounds.f_82293_;
        boolean allAir = true;
        BlockPos startPos = BlockPos.f_121853_;
        HashSet<PosWithState> blocks = new HashSet<PosWithState>();
        LinkedHashMap<BlockPos, Pair> states = new LinkedHashMap<BlockPos, Pair>();
        for (BlockPos blockPos : BlockPos.m_121976_((int)startX, (int)startY, (int)startZ, (int)endX, (int)endY, (int)endZ)) {
            BlockState state = this.getLevel().m_8055_(blockPos);
            if (state.m_60795_()) continue;
            if (allAir) {
                startPos = blockPos.m_7949_();
            }
            allAir = false;
            CompoundTag entityTag = null;
            BlockEntity entity = this.getLevel().m_7702_(blockPos);
            if (entity != null) {
                entityTag = entity.m_187481_();
            }
            states.put(blockPos.m_7949_(), Pair.of((Object)state, (Object)entityTag));
            if (startPos.compareTo((Vec3i)blockPos) >= 0) continue;
            startPos = new BlockPos(Math.min(startPos.m_123341_(), blockPos.m_123341_()), Math.min(startPos.m_123342_(), blockPos.m_123342_()), Math.min(startPos.m_123343_(), blockPos.m_123343_()));
        }
        if (allAir) {
            return;
        }
        for (Map.Entry entry : states.entrySet()) {
            BlockPos pos = (BlockPos)entry.getKey();
            BlockState state = (BlockState)((Pair)entry.getValue()).getFirst();
            @Nullable CompoundTag entityTag = (CompoundTag)((Pair)entry.getValue()).getSecond();
            blocks.add(new PosWithState(pos.m_121996_((Vec3i)startPos), state, entityTag));
            this.getLevel().m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
        this.packageSlot.setStackInSlot(0, ItemStack.f_41583_);
        ItemStack packageStack = GCYRItems.SPACE_STATION_PACKAGE.asStack();
        StationContainerBehaviour.setStationBlocks(packageStack, blocks);
        this.outputSlots.setStackInSlot(0, packageStack);
        ItemStack itemStack = GCYRItems.KEYCARD.asStack();
        KeyCardBehaviour.setSavedStation(itemStack, (Integer)spaceStationHolder.allocateStation(targetPlanet).getFirst(), targetPlanet);
        this.outputSlots.setStackInSlot(1, itemStack);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public ItemStackTransfer getPackageSlot() {
        return this.packageSlot;
    }

    public ItemStackTransfer getKeycardSlot() {
        return this.keycardSlot;
    }

    public ItemStackTransfer getOutputSlots() {
        return this.outputSlots;
    }
}

