/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.common.machine.multiblock;

import argent_matter.gcyr.common.data.GCYREntities;
import argent_matter.gcyr.common.data.GCYRItems;
import argent_matter.gcyr.common.entity.RocketEntity;
import argent_matter.gcyr.common.item.PlanetIdChipBehaviour;
import argent_matter.gcyr.common.machine.multiblock.PlatformMultiblockMachine;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IDisplayUIMachine;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RocketScannerMachine
extends PlatformMultiblockMachine
implements IDisplayUIMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(RocketScannerMachine.class, PlatformMultiblockMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    @DescSynced
    private boolean rocketBuilt;
    private final ItemStackTransfer posSaveSlot = new ItemStackTransfer(1);

    public RocketScannerMachine(IMachineBlockEntity holder) {
        super(holder);
        this.posSaveSlot.setFilter(arg_0 -> GCYRItems.ID_CHIP.isIn(arg_0));
    }

    public ModularUI createUI(Player entityPlayer) {
        ModularUI modularUI = super.createUI(entityPlayer);
        modularUI.registerCloseListener(() -> Block.m_49840_((Level)this.getLevel(), (BlockPos)this.getPos(), (ItemStack)this.posSaveSlot.getStackInSlot(0)));
        modularUI.widget((Widget)new SlotWidget((IItemTransfer)this.posSaveSlot, 0, 149, 105));
        modularUI.widget(new ButtonWidget(129, 105, 18, 18, this::onSaveButtonClick).setButtonTexture(new IGuiTexture[]{GuiTextures.BUTTON}).setHoverTooltips(new Component[]{Component.m_237115_((String)"menu.gcyr.save_destination_position")}));
        return modularUI;
    }

    public void addDisplayText(List<Component> textList) {
        super.addDisplayText(textList);
        if (!this.isFormed) {
            MutableComponent base = Component.m_237115_((String)"gtceu.multiblock.invalid_structure").m_130940_(ChatFormatting.RED);
            MutableComponent hover = Component.m_237115_((String)"gtceu.multiblock.invalid_structure.tooltip").m_130940_(ChatFormatting.GRAY);
            textList.add((Component)base.m_130938_(arg_0 -> RocketScannerMachine.lambda$addDisplayText$1((Component)hover, arg_0)));
            return;
        }
        textList.add(ComponentPanelWidget.withButton((Component)Component.m_237115_((String)"gcyr.multiblock.rocket.build").m_130940_(ChatFormatting.GREEN), (String)"build_rocket"));
    }

    public void handleDisplayClick(String componentData, ClickData clickData) {
        if (!clickData.isRemote && componentData.equals("build_rocket")) {
            this.setRocketBuilt(true);
        }
    }

    private void onSaveButtonClick(ClickData data) {
        if (data.isRemote) {
            return;
        }
        ItemStack saveStack = this.posSaveSlot.getStackInSlot(0);
        if (GCYRItems.ID_CHIP.isIn(saveStack)) {
            Direction back = this.getFrontFacing().m_122424_();
            BlockPos landPos = this.getPos().m_5484_(back, this.bDist / 2);
            ResourceKey level = this.getLevel().m_46472_();
            PlanetIdChipBehaviour.setSavedPosition(saveStack, (ResourceKey<Level>)level, landPos);
        }
    }

    public void setRocketBuilt(boolean rocketBuilt) {
        boolean bl = this.rocketBuilt = rocketBuilt && this.isFormed;
        if (this.getLevel().f_46443_ || !this.isFormed) {
            return;
        }
        Direction back = this.getFrontFacing().m_122424_();
        Direction left = this.getFrontFacing().m_122428_();
        Direction right = left.m_122424_();
        BlockPos current = this.getPos().m_5484_(back, 1);
        int startX = current.m_123304_(back.m_122434_());
        int endX = current.m_5484_(back, this.bDist - 1).m_123304_(back.m_122434_());
        int startZ = current.m_5484_(left, this.lDist).m_123304_(left.m_122434_());
        int endZ = current.m_5484_(right, this.rDist).m_123304_(right.m_122434_());
        int startY = current.m_123342_();
        int endY = current.m_7918_(0, this.hDist, 0).m_123342_();
        if (this.getFrontFacing().m_122434_() == Direction.Axis.Z) {
            int temp = startX;
            startX = startZ;
            startZ = temp;
            temp = endX;
            endX = endZ;
            endZ = temp;
        }
        AABB bounds = new AABB((double)startX, (double)startY, (double)startZ, (double)endX, (double)endY, (double)endZ);
        startX = (int)bounds.f_82288_;
        endX = (int)bounds.f_82291_;
        startY = (int)bounds.f_82289_;
        endY = (int)bounds.f_82292_;
        startZ = (int)bounds.f_82290_;
        endZ = (int)bounds.f_82293_;
        if (this.rocketBuilt) {
            List rockets = this.getLevel().m_45976_(RocketEntity.class, bounds);
            if (!rockets.isEmpty()) {
                return;
            }
            boolean allAir = true;
            BlockPos startPos = new BlockPos(startX, startY, startZ);
            RocketEntity rocket = (RocketEntity)GCYREntities.ROCKET.create(this.getLevel());
            LinkedHashMap states = new LinkedHashMap();
            for (BlockPos blockPos : BlockPos.m_121976_((int)startX, (int)startY, (int)startZ, (int)endX, (int)endY, (int)endZ)) {
                BlockState state = this.getLevel().m_8055_(blockPos);
                if (state.m_60795_()) continue;
                if (allAir) {
                    startPos = blockPos.m_7949_();
                }
                allAir = false;
                CompoundTag entityTag = null;
                BlockEntity entity = this.getLevel().m_7702_(blockPos);
                if (entity != null) {
                    entityTag = entity.m_187481_();
                }
                states.put(blockPos.m_7949_(), Pair.of((Object)state, (Object)entityTag));
                if (startPos.compareTo((Vec3i)blockPos) >= 0) continue;
                startPos = new BlockPos(Math.min(startPos.m_123341_(), blockPos.m_123341_()), Math.min(startPos.m_123342_(), blockPos.m_123342_()), Math.min(startPos.m_123343_(), blockPos.m_123343_()));
            }
            if (allAir) {
                return;
            }
            states = states.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e2, LinkedHashMap::new));
            for (Map.Entry entry : states.entrySet()) {
                BlockPos pos = (BlockPos)entry.getKey();
                BlockState state = (BlockState)((Pair)entry.getValue()).getFirst();
                CompoundTag entityTag = (CompoundTag)((Pair)entry.getValue()).getSecond();
                rocket.addBlock(pos.m_121996_((Vec3i)startPos), state, entityTag);
                this.getLevel().m_46597_(pos, Blocks.f_50016_.m_49966_());
            }
            rocket.m_6034_(startPos.m_123341_(), startPos.m_123342_(), startPos.m_123343_());
            this.getLevel().m_7967_((Entity)rocket);
        }
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public boolean isRocketBuilt() {
        return this.rocketBuilt;
    }

    public ItemStackTransfer getPosSaveSlot() {
        return this.posSaveSlot;
    }

    private static /* synthetic */ Style lambda$addDisplayText$1(Component hover, Style style) {
        return style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)hover));
    }
}

