/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.common.machine.electric;

import argent_matter.gcyr.api.capability.GCYRCapabilityHelper;
import argent_matter.gcyr.api.gui.widget.GCYRGuiTextures;
import argent_matter.gcyr.api.space.satellite.Satellite;
import argent_matter.gcyr.util.Vec2i;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TieredEnergyMachine;
import com.gregtechceu.gtceu.api.machine.feature.IUIMachine;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;

public class SatelliteJammerMachine
extends TieredEnergyMachine
implements IControllable,
IUIMachine {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(SatelliteJammerMachine.class);
    public static final int MACHINE_RANGE_MULTIPLIER = 24;
    @Persisted
    private boolean isWorkingEnabled;
    private final int range;
    @DescSynced
    private int lastJammedCount;
    @DescSynced
    private final List<Satellite> lastJammed = new ArrayList<Satellite>();

    public SatelliteJammerMachine(IMachineBlockEntity holder, int tier, Object ... args) {
        super(holder, tier, args);
        this.range = this.tier * 24;
    }

    public int tintColor(int index) {
        if (index == 2) {
            return GTValues.VC[this.getTier()];
        }
        return super.tintColor(index);
    }

    public void onLoad() {
        super.onLoad();
        if (!this.getLevel().m_6042_().f_63856_()) {
            this.subscribeServerTick(this::jamSatellites);
        } else {
            this.setWorkingEnabled(false);
        }
    }

    public void onUnload() {
        super.onUnload();
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected void jamSatellites() {
        if (!this.getLevel().f_46443_) {
            BlockPos myPos = this.getPos();
            List<Satellite> toJam = GCYRCapabilityHelper.getSatellites((ServerLevel)this.getLevel()).getSatellitesNearPos(new Vec2i(myPos.m_123341_(), myPos.m_123343_()), this.range);
            if (toJam.size() > 0) {
                ArrayList<Satellite> copy = new ArrayList<Satellite>(this.lastJammed);
                copy.removeAll(toJam);
                copy.forEach(satellite -> satellite.setJammed(false));
                toJam.removeAll(this.lastJammed);
                if (!this.isWorkingEnabled) {
                    return;
                }
                this.lastJammed.clear();
                this.lastJammedCount = toJam.size();
                for (Satellite satellite2 : toJam) {
                    satellite2.setJammed(true);
                    this.lastJammed.add(satellite2);
                }
            }
        }
    }

    private void addDisplayText(List<Component> textList) {
        if (!this.isWorkingEnabled()) {
            textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.work_paused"));
        } else {
            textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.running"));
            for (Satellite sat : this.lastJammed.subList(0, this.lastJammedCount >= 10 ? 10 : this.lastJammedCount)) {
                textList.add((Component)Component.m_237110_((String)"gcyr.machine.satellite_jammer.jammed", (Object[])new Object[]{Component.m_237115_((String)sat.getType().toLangString())}).m_7220_((Component)Component.m_237110_((String)"gcyr.machine.satellite_jammer.position", (Object[])new Object[]{this.vec2ToString(sat.getData().locationInWorld())})).m_130940_(ChatFormatting.GREEN));
            }
        }
    }

    private String vec2ToString(Vec2i vector) {
        return "x=" + vector.x() + ",z=" + vector.y();
    }

    public ModularUI createUI(Player entityPlayer) {
        DraggableScrollableWidgetGroup screen = new DraggableScrollableWidgetGroup(7, 4, 162, 121).setBackground((IGuiTexture)GuiTextures.DISPLAY);
        screen.addWidget((Widget)new LabelWidget(4, 5, this.self().getBlockState().m_60734_().m_7705_()));
        screen.addWidget((Widget)new ComponentPanelWidget(4, 17, this::addDisplayText).setMaxWidthLimit(156));
        return new ModularUI(176, 216, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND}).widget((Widget)screen).widget((Widget)new ToggleButtonWidget(7, 113, 18, 18, (IGuiTexture)GCYRGuiTextures.BUTTON_ENABLED, this::isWorkingEnabled, this::setWorkingEnabled).setShouldUseBaseBackground().setTooltipText("behaviour.soft_hammer")).widget((Widget)UITemplate.bindPlayerInventory((Inventory)entityPlayer.m_150109_(), (IGuiTexture)GuiTextures.SLOT, (int)7, (int)84, (boolean)true));
    }

    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }

    public void setWorkingEnabled(boolean isWorkingEnabled) {
        this.isWorkingEnabled = isWorkingEnabled;
    }

    public int getLastJammedCount() {
        return this.lastJammedCount;
    }

    public List<Satellite> getLastJammed() {
        return this.lastJammed;
    }
}

